type token =
  | VAL of (float)
  | VAR of (string)
  | PLUS
  | UPLUS
  | MINUS
  | UMINUS
  | TIMES
  | DIV
  | POW
  | SQRT
  | FLOOR
  | CEIL
  | ROUND
  | COS
  | SIN
  | SINH
  | COSH
  | TAN
  | TANH
  | EXP
  | LOG
  | ACOS
  | ASIN
  | ATAN
  | LN
  | DEG
  | LOGB
  | ABS
  | MODULO
  | FACTORIAL
  | LPAR
  | RPAR
  | ABSDEL
  | LBRA
  | RBRA
  | LCUR
  | RCUR
  | END
  | PI
  | ENOT
  | RANDOM
  | TRUE
  | FALSE
  | DECSEP
  | DECXPSEP
  | ASSIGN
  | LET
  | LEQUALS
  | LDIFF
  | LSUP
  | LINF
  | LSSUP
  | LSINF
  | LAND
  | LOR
  | LNOT
  | LTERN
  | LTERNSEP
  | LIF
  | LELSE
  | LTHEN
  | LXOR
  | INCR
  | DECR
  | CMD
  | COMMENT
  | UNIT
  | PRINT

open Parsing;;
# 1 "mathparser.mly"


(*
 * m.E.M.E - Minimalist Evaluator for Mathematical Expressions
 * 
 * by Gamall Wednesday Ida
 * 
 * gamall-ida.com
 * gamall.ida@gmail.com
 * 
 * Copyright 2007, 2008 Gamall Wednesday Ida
 * 
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *)

  (** Parser for mathematical expressions *)
  open Toolkit;;

  (** Prepare the random generator *)
  Random.self_init()

  (** The trigonometric constant *)
  let pi = 3.14159265358979323846

  (** Convert a angle in degrees to radian *)
  let deg_to_rad r = r*.(pi/.180.)

  (** Log in arbitrary base. Not too good precision *)
  let logb base x = (log x) /. (log base)
 
  (** Get the integer closest to x, or 'nearest integer' *)
  let round x = let fx = floor x in let diff = x -. fx in
    if diff <= 0.5 then fx else fx +. 1.
    
  (** Table for local variables *)
  let (local_vars : (string, float) Hashtbl.t) = Hashtbl.create 10
  
  (** Bind a local variable to a value *)
  let bind_local_var id valu = (Hashtbl.remove local_vars id; Hashtbl.add local_vars id valu)
  
  (** Get a floating-point 0 or 1 from a boolean *)
  let fob b = if b then 1. else 0.

  (** Get a bool from a float *)
  let bof f = if f = 0. then false else true
  
  (** Normalise a floating point boolean, ie get a 0 or a 1 *)
  let nfb f = if f = 0. then 0. else 1.

  (** floating point xor logical operator *)
  let fxor a b = let x, y = nfb a, nfb b in fob (x+.y = 1.)

  (** Display a binding cleanly *)
  let disp_bind k v = Printf.printf "%20s = %s\n" k (soff v) 

  (** Display all bindings *)
  let display_bindings () = 
    pl "Bound variables:"; 
    Hashtbl.iter disp_bind local_vars;
    let n = Hashtbl.length local_vars in
    pf "Total: %d %s\n" n (pluralise "variable" n)

  (** The factorial function. A classic. *) 
  let rec factorial = function
    | 0 -> 1
    | n -> assert (n > 0); n * factorial(n - 1)

  (** Factorial for floating-point numbers *)
  let factorial_f f = let n = iof f in assert (foi n = f);
    if n > 21 then 
      failwith "Factorial: Too big!" 
    else 
      foi (factorial n)

  (** Behaviour flags in case of parsing error *)
  let _se, _pe, _sl = Mathcommon._show_error, Mathcommon._print_errors, Mathcommon._show_lexbuf
  
  (** React to an error during parsing *)
  let complain_soft () = 
    let ss, se = symbol_start (), symbol_end () in
    let the_string = (Global.get Mathcommon.lexbuf).Lexing.lex_buffer in
    if !_sl && !_se && !_pe then pe the_string;
    if !_pe then begin
      (* the error message *)
      let snip = snippet (try subb the_string ss se with _ -> "BUG!") 15 in
      if se > succ ss then begin
        if !_se then Mathcommon.show_error ss se;
        epf "{Parsing failed on pos %d-%d: `%s'}\n%!" ss (pred se) snip
      end else begin
        if !_se then Mathcommon.show_error ss (ss+1); 
        let nsnip = if snip = "" then "" else va ": `%s'" snip in
        epf "{Parsing failed on pos %d%s}\n%!" ss nsnip
      end;

      (* display some help to the hapless user.... *)
      begin match snip with 
        | "=" -> pe "{Perhaps you are trying to bind a variable with a reserved name, such as `pi', `log' etc.}"
        | _ -> ()
      end;
    end
    
  (** React to error and fail *)
  let complain () = complain_soft(); failwith "Bad expression" 

  (** Get the value of a local variable *)
  let eval_local_var x = 
    try Hashtbl.find local_vars x 
    with _ -> 
      complain_soft(); 
      if !_pe then epf "{Unbound variable: `%s'}\n%!" (snippet x 15);
      failwith "Unbound variable"
# 197 "mathparser.ml"
let yytransl_const = [|
  259 (* PLUS *);
  260 (* UPLUS *);
  261 (* MINUS *);
  262 (* UMINUS *);
  263 (* TIMES *);
  264 (* DIV *);
  265 (* POW *);
  266 (* SQRT *);
  267 (* FLOOR *);
  268 (* CEIL *);
  269 (* ROUND *);
  270 (* COS *);
  271 (* SIN *);
  272 (* SINH *);
  273 (* COSH *);
  274 (* TAN *);
  275 (* TANH *);
  276 (* EXP *);
  277 (* LOG *);
  278 (* ACOS *);
  279 (* ASIN *);
  280 (* ATAN *);
  281 (* LN *);
  282 (* DEG *);
  283 (* LOGB *);
  284 (* ABS *);
  285 (* MODULO *);
  286 (* FACTORIAL *);
  287 (* LPAR *);
  288 (* RPAR *);
  289 (* ABSDEL *);
  290 (* LBRA *);
  291 (* RBRA *);
  292 (* LCUR *);
  293 (* RCUR *);
  294 (* END *);
  295 (* PI *);
  296 (* ENOT *);
  297 (* RANDOM *);
  298 (* TRUE *);
  299 (* FALSE *);
  300 (* DECSEP *);
  301 (* DECXPSEP *);
  302 (* ASSIGN *);
  303 (* LET *);
  304 (* LEQUALS *);
  305 (* LDIFF *);
  306 (* LSUP *);
  307 (* LINF *);
  308 (* LSSUP *);
  309 (* LSINF *);
  310 (* LAND *);
  311 (* LOR *);
  312 (* LNOT *);
  313 (* LTERN *);
  314 (* LTERNSEP *);
  315 (* LIF *);
  316 (* LELSE *);
  317 (* LTHEN *);
  318 (* LXOR *);
  319 (* INCR *);
  320 (* DECR *);
  321 (* CMD *);
  322 (* COMMENT *);
  323 (* UNIT *);
  324 (* PRINT *);
    0|]

let yytransl_block = [|
  257 (* VAL *);
  258 (* VAR *);
    0|]

let yylhs = "\255\255\
\001\000\001\000\001\000\001\000\001\000\002\000\004\000\004\000\
\005\000\005\000\005\000\005\000\005\000\006\000\006\000\006\000\
\003\000\003\000\003\000\003\000\003\000\003\000\003\000\003\000\
\003\000\003\000\003\000\003\000\003\000\003\000\003\000\003\000\
\003\000\003\000\003\000\003\000\003\000\003\000\003\000\003\000\
\003\000\003\000\003\000\003\000\003\000\003\000\003\000\003\000\
\003\000\003\000\003\000\003\000\003\000\003\000\003\000\003\000\
\003\000\003\000\003\000\003\000\003\000\003\000\003\000\003\000\
\003\000\003\000\003\000\003\000\003\000\003\000\003\000\003\000\
\000\000"

let yylen = "\002\000\
\001\000\002\000\003\000\002\000\001\000\001\000\003\000\001\000\
\003\000\002\000\002\000\002\000\002\000\003\000\003\000\003\000\
\004\000\003\000\003\000\002\000\001\000\001\000\001\000\001\000\
\003\000\001\000\001\000\001\000\002\000\003\000\003\000\003\000\
\003\000\003\000\003\000\003\000\002\000\002\000\002\000\002\000\
\002\000\002\000\002\000\002\000\002\000\002\000\002\000\002\000\
\002\000\002\000\002\000\002\000\002\000\002\000\003\000\002\000\
\002\000\003\000\003\000\003\000\003\000\003\000\003\000\003\000\
\003\000\002\000\003\000\005\000\006\000\002\000\002\000\002\000\
\002\000"

let yydefred = "\000\000\
\000\000\000\000\005\000\022\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\
\026\000\000\000\000\000\027\000\028\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\021\000\000\000\073\000\000\000\
\000\000\000\000\023\000\000\000\010\000\012\000\071\000\070\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\029\000\037\000\000\000\000\000\000\000\000\000\011\000\013\000\
\006\000\000\000\002\000\072\000\000\000\000\000\000\000\000\000\
\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\000\
\000\000\000\000\055\000\014\000\025\000\015\000\016\000\018\000\
\000\000\000\000\003\000\000\000\000\000\000\000\000\000\000\000\
\000\000\030\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\007\000\000\000\000\000\
\000\000\000\000\000\000\000\000"

let yydgoto = "\002\000\
\047\000\090\000\048\000\049\000\050\000\051\000"

let yysindex = "\026\000\
\131\255\000\000\000\000\000\000\047\255\199\255\199\255\199\255\
\199\255\199\255\199\255\199\255\199\255\199\255\199\255\199\255\
\199\255\199\255\199\255\199\255\199\255\199\255\199\255\199\255\
\199\255\199\255\199\255\199\255\199\255\199\255\199\255\000\000\
\000\000\199\255\199\255\000\000\000\000\045\255\199\255\199\255\
\024\255\030\255\060\255\249\254\000\000\199\255\000\000\054\005\
\023\255\247\254\000\000\199\255\000\000\000\000\000\000\000\000\
\029\255\034\255\034\255\034\255\029\255\029\255\029\255\029\255\
\029\255\029\255\029\255\029\255\029\255\029\255\029\255\029\255\
\029\255\036\005\029\255\029\255\092\005\122\005\156\005\185\005\
\000\000\000\000\047\255\027\255\034\255\212\005\000\000\000\000\
\000\000\254\254\000\000\000\000\199\255\199\255\199\255\199\255\
\199\255\199\255\000\000\199\255\199\255\199\255\199\255\199\255\
\199\255\199\255\199\255\199\255\199\255\199\255\000\000\199\255\
\045\255\046\006\000\000\000\000\000\000\000\000\000\000\000\000\
\199\255\199\255\000\000\041\255\041\255\035\255\035\255\046\255\
\029\255\000\000\136\006\136\006\034\255\034\255\034\255\034\255\
\109\006\102\006\241\005\102\006\046\006\000\000\046\006\019\006\
\199\255\199\255\075\006\075\006"

let yyrindex = "\000\000\
\000\000\000\000\000\000\000\000\240\255\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\033\255\000\000\000\000\000\000\000\000\000\000\000\000\
\104\000\146\006\178\006\210\006\164\000\224\000\028\001\088\001\
\148\001\208\001\012\002\072\002\132\002\192\002\252\002\056\003\
\116\003\000\000\176\003\236\003\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\242\006\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\007\255\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\196\004\232\004\100\004\160\004\044\000\
\040\004\000\000\146\007\178\007\018\007\050\007\082\007\114\007\
\022\255\210\007\000\000\242\007\025\000\000\000\085\000\000\000\
\000\000\000\000\145\000\205\000"

let yygindex = "\000\000\
\000\000\000\000\250\255\248\255\000\000\255\255"

let yytablesize = 2352
let yytable = "\055\000\
\056\000\057\000\058\000\059\000\060\000\061\000\062\000\063\000\
\064\000\065\000\066\000\067\000\068\000\069\000\070\000\071\000\
\072\000\073\000\074\000\075\000\076\000\077\000\078\000\079\000\
\080\000\087\000\001\000\081\000\082\000\084\000\091\000\088\000\
\085\000\086\000\113\000\123\000\093\000\097\000\094\000\092\000\
\095\000\096\000\097\000\097\000\009\000\114\000\083\000\095\000\
\096\000\097\000\009\000\009\000\063\000\063\000\063\000\063\000\
\063\000\063\000\063\000\063\000\111\000\089\000\098\000\098\000\
\120\000\063\000\063\000\112\000\100\000\098\000\008\000\121\000\
\115\000\100\000\100\000\063\000\063\000\008\000\063\000\063\000\
\100\000\063\000\063\000\063\000\000\000\100\000\124\000\125\000\
\126\000\127\000\128\000\129\000\052\000\130\000\131\000\132\000\
\133\000\134\000\135\000\136\000\137\000\138\000\139\000\140\000\
\142\000\141\000\000\000\041\000\042\000\053\000\054\000\000\000\
\000\000\000\000\143\000\144\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\003\000\004\000\005\000\006\000\000\000\007\000\
\000\000\000\000\147\000\148\000\008\000\009\000\010\000\011\000\
\012\000\013\000\014\000\015\000\016\000\017\000\018\000\019\000\
\020\000\021\000\022\000\023\000\024\000\025\000\026\000\000\000\
\027\000\028\000\000\000\029\000\030\000\000\000\031\000\000\000\
\032\000\033\000\034\000\035\000\036\000\037\000\000\000\000\000\
\000\000\038\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\039\000\000\000\000\000\040\000\000\000\000\000\
\000\000\041\000\042\000\043\000\044\000\045\000\046\000\004\000\
\005\000\006\000\000\000\007\000\000\000\000\000\000\000\000\000\
\008\000\009\000\010\000\011\000\012\000\013\000\014\000\015\000\
\016\000\017\000\018\000\019\000\020\000\021\000\022\000\023\000\
\024\000\025\000\026\000\000\000\027\000\028\000\000\000\029\000\
\030\000\000\000\031\000\000\000\000\000\033\000\034\000\035\000\
\036\000\037\000\024\000\000\000\024\000\038\000\024\000\024\000\
\024\000\000\000\000\000\000\000\000\000\000\000\039\000\000\000\
\000\000\040\000\000\000\000\000\000\000\041\000\042\000\000\000\
\000\000\045\000\046\000\000\000\024\000\000\000\024\000\024\000\
\024\000\024\000\024\000\024\000\024\000\024\000\000\000\024\000\
\000\000\000\000\000\000\024\000\024\000\000\000\000\000\024\000\
\024\000\024\000\024\000\024\000\024\000\024\000\024\000\000\000\
\024\000\024\000\000\000\024\000\024\000\024\000\036\000\000\000\
\036\000\000\000\036\000\036\000\036\000\000\000\000\000\019\000\
\019\000\019\000\019\000\019\000\019\000\019\000\019\000\000\000\
\000\000\000\000\000\000\000\000\019\000\019\000\000\000\000\000\
\036\000\000\000\036\000\036\000\036\000\036\000\036\000\036\000\
\036\000\036\000\019\000\000\000\019\000\019\000\000\000\036\000\
\036\000\000\000\000\000\036\000\036\000\036\000\036\000\036\000\
\036\000\036\000\036\000\000\000\036\000\036\000\000\000\036\000\
\036\000\036\000\038\000\000\000\038\000\000\000\038\000\038\000\
\000\000\000\000\000\000\017\000\017\000\017\000\017\000\017\000\
\017\000\017\000\017\000\000\000\000\000\000\000\000\000\000\000\
\017\000\017\000\000\000\000\000\038\000\000\000\038\000\038\000\
\038\000\038\000\038\000\038\000\038\000\038\000\017\000\000\000\
\017\000\017\000\000\000\038\000\038\000\000\000\000\000\038\000\
\038\000\038\000\038\000\038\000\038\000\038\000\038\000\000\000\
\038\000\038\000\000\000\038\000\038\000\038\000\043\000\000\000\
\043\000\000\000\043\000\043\000\000\000\000\000\000\000\068\000\
\068\000\068\000\068\000\068\000\068\000\068\000\068\000\000\000\
\000\000\000\000\000\000\000\000\068\000\068\000\000\000\000\000\
\043\000\000\000\043\000\043\000\043\000\043\000\043\000\043\000\
\043\000\043\000\068\000\000\000\068\000\068\000\000\000\043\000\
\043\000\000\000\000\000\043\000\043\000\043\000\043\000\043\000\
\043\000\043\000\043\000\000\000\043\000\043\000\000\000\043\000\
\043\000\043\000\044\000\000\000\044\000\000\000\044\000\044\000\
\000\000\000\000\000\000\069\000\069\000\069\000\069\000\069\000\
\069\000\069\000\069\000\000\000\000\000\000\000\000\000\000\000\
\069\000\069\000\000\000\000\000\044\000\000\000\044\000\044\000\
\044\000\044\000\044\000\044\000\044\000\044\000\069\000\000\000\
\069\000\069\000\000\000\044\000\044\000\000\000\000\000\044\000\
\044\000\044\000\044\000\044\000\044\000\044\000\044\000\000\000\
\044\000\044\000\000\000\044\000\044\000\044\000\050\000\000\000\
\050\000\000\000\050\000\050\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\050\000\000\000\050\000\050\000\050\000\050\000\050\000\050\000\
\050\000\050\000\000\000\000\000\000\000\000\000\000\000\050\000\
\050\000\000\000\000\000\050\000\050\000\050\000\050\000\050\000\
\050\000\050\000\050\000\000\000\050\000\050\000\000\000\050\000\
\050\000\050\000\049\000\000\000\049\000\000\000\049\000\049\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\049\000\000\000\049\000\049\000\
\049\000\049\000\049\000\049\000\049\000\049\000\000\000\000\000\
\000\000\000\000\000\000\049\000\049\000\000\000\000\000\049\000\
\049\000\049\000\049\000\049\000\049\000\049\000\049\000\000\000\
\049\000\049\000\000\000\049\000\049\000\049\000\045\000\000\000\
\045\000\000\000\045\000\045\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\045\000\000\000\045\000\045\000\045\000\045\000\045\000\045\000\
\045\000\045\000\000\000\000\000\000\000\000\000\000\000\045\000\
\045\000\000\000\000\000\045\000\045\000\045\000\045\000\045\000\
\045\000\045\000\045\000\000\000\045\000\045\000\000\000\045\000\
\045\000\045\000\051\000\000\000\051\000\000\000\051\000\051\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\051\000\000\000\051\000\051\000\
\051\000\051\000\051\000\051\000\051\000\051\000\000\000\000\000\
\000\000\000\000\000\000\051\000\051\000\000\000\000\000\051\000\
\051\000\051\000\051\000\051\000\051\000\051\000\051\000\000\000\
\051\000\051\000\000\000\051\000\051\000\051\000\054\000\000\000\
\054\000\000\000\054\000\054\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\054\000\000\000\054\000\054\000\054\000\054\000\054\000\054\000\
\054\000\054\000\000\000\000\000\000\000\000\000\000\000\054\000\
\054\000\000\000\000\000\054\000\054\000\054\000\054\000\054\000\
\054\000\054\000\054\000\000\000\054\000\054\000\000\000\054\000\
\054\000\054\000\053\000\000\000\053\000\000\000\053\000\053\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\053\000\000\000\053\000\053\000\
\053\000\053\000\053\000\053\000\053\000\053\000\000\000\000\000\
\000\000\000\000\000\000\053\000\053\000\000\000\000\000\053\000\
\053\000\053\000\053\000\053\000\053\000\053\000\053\000\000\000\
\053\000\053\000\000\000\053\000\053\000\053\000\046\000\000\000\
\046\000\000\000\046\000\046\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\046\000\000\000\046\000\046\000\046\000\046\000\046\000\046\000\
\046\000\046\000\000\000\000\000\000\000\000\000\000\000\046\000\
\046\000\000\000\000\000\046\000\046\000\046\000\046\000\046\000\
\046\000\046\000\046\000\000\000\046\000\046\000\000\000\046\000\
\046\000\046\000\047\000\000\000\047\000\000\000\047\000\047\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\047\000\000\000\047\000\047\000\
\047\000\047\000\047\000\047\000\047\000\047\000\000\000\000\000\
\000\000\000\000\000\000\047\000\047\000\000\000\000\000\047\000\
\047\000\047\000\047\000\047\000\047\000\047\000\047\000\000\000\
\047\000\047\000\000\000\047\000\047\000\047\000\048\000\000\000\
\048\000\000\000\048\000\048\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\048\000\000\000\048\000\048\000\048\000\048\000\048\000\048\000\
\048\000\048\000\000\000\000\000\000\000\000\000\000\000\048\000\
\048\000\000\000\000\000\048\000\048\000\048\000\048\000\048\000\
\048\000\048\000\048\000\000\000\048\000\048\000\000\000\048\000\
\048\000\048\000\052\000\000\000\052\000\000\000\052\000\052\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\052\000\000\000\052\000\052\000\
\052\000\052\000\052\000\052\000\052\000\052\000\000\000\000\000\
\000\000\000\000\000\000\052\000\052\000\000\000\000\000\052\000\
\052\000\052\000\052\000\052\000\052\000\052\000\052\000\000\000\
\052\000\052\000\000\000\052\000\052\000\052\000\056\000\000\000\
\056\000\000\000\056\000\056\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\056\000\000\000\056\000\056\000\056\000\056\000\056\000\056\000\
\056\000\056\000\000\000\000\000\000\000\000\000\000\000\056\000\
\056\000\000\000\000\000\056\000\056\000\056\000\056\000\056\000\
\056\000\056\000\056\000\000\000\056\000\056\000\000\000\056\000\
\056\000\056\000\042\000\000\000\042\000\000\000\042\000\042\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\042\000\000\000\042\000\042\000\
\042\000\042\000\042\000\042\000\042\000\042\000\000\000\000\000\
\000\000\000\000\000\000\042\000\042\000\000\000\000\000\042\000\
\042\000\042\000\042\000\042\000\042\000\042\000\042\000\000\000\
\042\000\042\000\000\000\042\000\042\000\042\000\057\000\000\000\
\057\000\000\000\057\000\057\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\057\000\000\000\057\000\057\000\057\000\057\000\057\000\057\000\
\057\000\057\000\000\000\000\000\000\000\000\000\000\000\057\000\
\057\000\000\000\000\000\057\000\057\000\057\000\057\000\057\000\
\057\000\057\000\057\000\000\000\057\000\057\000\000\000\057\000\
\057\000\057\000\035\000\000\000\035\000\000\000\035\000\035\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\035\000\000\000\035\000\035\000\
\035\000\035\000\035\000\035\000\035\000\035\000\000\000\000\000\
\000\000\000\000\000\000\035\000\035\000\000\000\000\000\035\000\
\035\000\035\000\035\000\035\000\035\000\035\000\035\000\000\000\
\035\000\035\000\000\000\035\000\035\000\035\000\033\000\000\000\
\033\000\000\000\033\000\033\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\033\000\033\000\033\000\033\000\033\000\033\000\
\033\000\033\000\000\000\000\000\000\000\000\000\000\000\033\000\
\033\000\000\000\000\000\033\000\033\000\033\000\033\000\033\000\
\033\000\033\000\033\000\000\000\033\000\033\000\000\000\033\000\
\033\000\033\000\034\000\000\000\034\000\000\000\034\000\034\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\034\000\034\000\
\034\000\034\000\034\000\034\000\034\000\034\000\031\000\000\000\
\031\000\000\000\000\000\034\000\034\000\000\000\000\000\034\000\
\034\000\034\000\034\000\034\000\034\000\034\000\034\000\000\000\
\034\000\034\000\000\000\034\000\034\000\034\000\000\000\000\000\
\000\000\000\000\031\000\031\000\031\000\031\000\031\000\031\000\
\031\000\031\000\032\000\000\000\032\000\000\000\000\000\031\000\
\031\000\000\000\000\000\031\000\031\000\031\000\031\000\031\000\
\031\000\031\000\031\000\000\000\031\000\031\000\000\000\031\000\
\031\000\031\000\000\000\000\000\000\000\000\000\032\000\032\000\
\032\000\032\000\032\000\032\000\032\000\032\000\000\000\000\000\
\000\000\000\000\000\000\032\000\032\000\000\000\000\000\032\000\
\032\000\032\000\032\000\032\000\032\000\032\000\032\000\000\000\
\032\000\032\000\000\000\032\000\032\000\032\000\093\000\000\000\
\094\000\000\000\095\000\096\000\097\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\093\000\000\000\094\000\000\000\095\000\096\000\097\000\000\000\
\098\000\000\000\028\000\000\000\000\000\030\000\000\000\031\000\
\000\000\000\000\000\000\100\000\000\000\000\000\000\000\000\000\
\000\000\000\000\098\000\101\000\102\000\103\000\104\000\105\000\
\106\000\107\000\108\000\099\000\109\000\100\000\093\000\000\000\
\094\000\110\000\095\000\096\000\097\000\101\000\102\000\103\000\
\104\000\105\000\106\000\107\000\108\000\000\000\109\000\000\000\
\000\000\000\000\000\000\110\000\000\000\000\000\000\000\000\000\
\098\000\000\000\000\000\116\000\093\000\000\000\094\000\000\000\
\095\000\096\000\097\000\100\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\101\000\102\000\103\000\104\000\105\000\
\106\000\107\000\108\000\000\000\109\000\000\000\098\000\000\000\
\000\000\110\000\117\000\000\000\000\000\000\000\093\000\000\000\
\094\000\100\000\095\000\096\000\097\000\000\000\000\000\000\000\
\000\000\101\000\102\000\103\000\104\000\105\000\106\000\107\000\
\108\000\000\000\109\000\000\000\000\000\000\000\000\000\110\000\
\098\000\000\000\000\000\093\000\000\000\094\000\118\000\095\000\
\096\000\097\000\000\000\100\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\101\000\102\000\103\000\104\000\105\000\
\106\000\107\000\108\000\000\000\109\000\098\000\093\000\000\000\
\094\000\110\000\095\000\096\000\097\000\119\000\000\000\000\000\
\100\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\101\000\102\000\103\000\104\000\105\000\106\000\107\000\108\000\
\098\000\109\000\000\000\093\000\000\000\094\000\110\000\095\000\
\096\000\097\000\000\000\100\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\101\000\102\000\103\000\104\000\105\000\
\106\000\107\000\108\000\000\000\109\000\098\000\000\000\000\000\
\122\000\110\000\000\000\000\000\000\000\093\000\000\000\094\000\
\100\000\095\000\096\000\097\000\000\000\000\000\000\000\000\000\
\101\000\102\000\103\000\104\000\105\000\106\000\107\000\108\000\
\000\000\109\000\145\000\000\000\000\000\000\000\110\000\098\000\
\093\000\000\000\094\000\000\000\095\000\096\000\097\000\000\000\
\000\000\000\000\100\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\101\000\102\000\103\000\104\000\105\000\106\000\
\107\000\108\000\098\000\109\000\000\000\093\000\146\000\094\000\
\110\000\095\000\096\000\097\000\000\000\100\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\101\000\102\000\103\000\
\104\000\105\000\106\000\107\000\108\000\000\000\109\000\098\000\
\093\000\000\000\094\000\110\000\095\000\096\000\097\000\093\000\
\000\000\094\000\100\000\095\000\096\000\097\000\000\000\000\000\
\000\000\000\000\101\000\102\000\103\000\104\000\105\000\106\000\
\107\000\108\000\098\000\000\000\000\000\000\000\000\000\000\000\
\110\000\098\000\093\000\000\000\094\000\100\000\095\000\096\000\
\097\000\000\000\000\000\000\000\100\000\101\000\102\000\103\000\
\104\000\105\000\106\000\107\000\101\000\102\000\103\000\104\000\
\105\000\106\000\000\000\000\000\098\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\100\000\
\039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\
\000\000\103\000\104\000\105\000\106\000\039\000\039\000\000\000\
\000\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\
\039\000\000\000\039\000\039\000\000\000\039\000\039\000\039\000\
\040\000\040\000\040\000\040\000\040\000\040\000\040\000\040\000\
\000\000\000\000\000\000\000\000\000\000\040\000\040\000\000\000\
\000\000\040\000\040\000\040\000\040\000\040\000\040\000\040\000\
\040\000\000\000\040\000\040\000\000\000\040\000\040\000\040\000\
\041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
\000\000\000\000\000\000\000\000\000\000\041\000\041\000\000\000\
\000\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
\041\000\000\000\041\000\041\000\000\000\041\000\041\000\041\000\
\066\000\066\000\066\000\066\000\066\000\066\000\066\000\066\000\
\000\000\000\000\000\000\000\000\000\000\066\000\066\000\000\000\
\000\000\066\000\066\000\066\000\066\000\066\000\066\000\066\000\
\066\000\000\000\066\000\066\000\000\000\066\000\066\000\066\000\
\059\000\059\000\059\000\059\000\059\000\059\000\059\000\059\000\
\000\000\000\000\000\000\000\000\000\000\059\000\059\000\000\000\
\000\000\059\000\059\000\059\000\059\000\059\000\059\000\059\000\
\059\000\000\000\059\000\059\000\000\000\059\000\059\000\059\000\
\060\000\060\000\060\000\060\000\060\000\060\000\060\000\060\000\
\000\000\000\000\000\000\000\000\000\000\060\000\060\000\000\000\
\000\000\060\000\060\000\060\000\060\000\060\000\060\000\060\000\
\060\000\000\000\060\000\060\000\000\000\060\000\060\000\060\000\
\061\000\061\000\061\000\061\000\061\000\061\000\061\000\061\000\
\000\000\000\000\000\000\000\000\000\000\061\000\061\000\000\000\
\000\000\061\000\061\000\061\000\061\000\061\000\061\000\061\000\
\061\000\000\000\061\000\061\000\000\000\061\000\061\000\061\000\
\062\000\062\000\062\000\062\000\062\000\062\000\062\000\062\000\
\000\000\000\000\000\000\000\000\000\000\062\000\062\000\000\000\
\000\000\062\000\062\000\062\000\062\000\062\000\062\000\062\000\
\062\000\000\000\062\000\062\000\000\000\062\000\062\000\062\000\
\058\000\058\000\058\000\058\000\058\000\058\000\058\000\058\000\
\000\000\000\000\000\000\000\000\000\000\058\000\058\000\000\000\
\000\000\058\000\058\000\000\000\000\000\000\000\000\000\058\000\
\058\000\000\000\058\000\058\000\000\000\058\000\058\000\058\000\
\067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
\000\000\000\000\000\000\000\000\000\000\067\000\067\000\000\000\
\000\000\067\000\067\000\000\000\000\000\000\000\000\000\067\000\
\067\000\000\000\067\000\067\000\000\000\067\000\067\000\067\000\
\064\000\064\000\064\000\064\000\064\000\064\000\064\000\064\000\
\000\000\000\000\000\000\000\000\000\000\064\000\064\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\064\000\000\000\064\000\064\000\000\000\064\000\064\000\064\000\
\065\000\065\000\065\000\065\000\065\000\065\000\065\000\065\000\
\000\000\000\000\000\000\000\000\000\000\065\000\065\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\065\000\000\000\065\000\065\000\000\000\065\000\065\000\065\000"

let yycheck = "\006\000\
\007\000\008\000\009\000\010\000\011\000\012\000\013\000\014\000\
\015\000\016\000\017\000\018\000\019\000\020\000\021\000\022\000\
\023\000\024\000\025\000\026\000\027\000\028\000\029\000\030\000\
\031\000\002\001\001\000\034\000\035\000\038\000\038\001\002\001\
\039\000\040\000\044\001\038\001\003\001\009\001\005\001\046\000\
\007\001\008\001\009\001\009\001\038\001\052\000\002\001\007\001\
\008\001\009\001\044\001\045\001\031\001\032\001\033\001\034\001\
\035\001\036\001\037\001\038\001\038\001\002\001\029\001\029\001\
\038\001\044\001\045\001\045\001\040\001\029\001\038\001\045\001\
\074\000\040\001\040\001\054\001\055\001\045\001\057\001\058\001\
\040\001\060\001\061\001\062\001\255\255\040\001\093\000\094\000\
\095\000\096\000\097\000\098\000\046\001\100\000\101\000\102\000\
\103\000\104\000\105\000\106\000\107\000\108\000\109\000\110\000\
\113\000\112\000\255\255\063\001\064\001\063\001\064\001\255\255\
\255\255\255\255\121\000\122\000\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\000\001\001\001\002\001\003\001\255\255\005\001\
\255\255\255\255\145\000\146\000\010\001\011\001\012\001\013\001\
\014\001\015\001\016\001\017\001\018\001\019\001\020\001\021\001\
\022\001\023\001\024\001\025\001\026\001\027\001\028\001\255\255\
\030\001\031\001\255\255\033\001\034\001\255\255\036\001\255\255\
\038\001\039\001\040\001\041\001\042\001\043\001\255\255\255\255\
\255\255\047\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\056\001\255\255\255\255\059\001\255\255\255\255\
\255\255\063\001\064\001\065\001\066\001\067\001\068\001\001\001\
\002\001\003\001\255\255\005\001\255\255\255\255\255\255\255\255\
\010\001\011\001\012\001\013\001\014\001\015\001\016\001\017\001\
\018\001\019\001\020\001\021\001\022\001\023\001\024\001\025\001\
\026\001\027\001\028\001\255\255\030\001\031\001\255\255\033\001\
\034\001\255\255\036\001\255\255\255\255\039\001\040\001\041\001\
\042\001\043\001\003\001\255\255\005\001\047\001\007\001\008\001\
\009\001\255\255\255\255\255\255\255\255\255\255\056\001\255\255\
\255\255\059\001\255\255\255\255\255\255\063\001\064\001\255\255\
\255\255\067\001\068\001\255\255\029\001\255\255\031\001\032\001\
\033\001\034\001\035\001\036\001\037\001\038\001\255\255\040\001\
\255\255\255\255\255\255\044\001\045\001\255\255\255\255\048\001\
\049\001\050\001\051\001\052\001\053\001\054\001\055\001\255\255\
\057\001\058\001\255\255\060\001\061\001\062\001\003\001\255\255\
\005\001\255\255\007\001\008\001\009\001\255\255\255\255\031\001\
\032\001\033\001\034\001\035\001\036\001\037\001\038\001\255\255\
\255\255\255\255\255\255\255\255\044\001\045\001\255\255\255\255\
\029\001\255\255\031\001\032\001\033\001\034\001\035\001\036\001\
\037\001\038\001\058\001\255\255\060\001\061\001\255\255\044\001\
\045\001\255\255\255\255\048\001\049\001\050\001\051\001\052\001\
\053\001\054\001\055\001\255\255\057\001\058\001\255\255\060\001\
\061\001\062\001\003\001\255\255\005\001\255\255\007\001\008\001\
\255\255\255\255\255\255\031\001\032\001\033\001\034\001\035\001\
\036\001\037\001\038\001\255\255\255\255\255\255\255\255\255\255\
\044\001\045\001\255\255\255\255\029\001\255\255\031\001\032\001\
\033\001\034\001\035\001\036\001\037\001\038\001\058\001\255\255\
\060\001\061\001\255\255\044\001\045\001\255\255\255\255\048\001\
\049\001\050\001\051\001\052\001\053\001\054\001\055\001\255\255\
\057\001\058\001\255\255\060\001\061\001\062\001\003\001\255\255\
\005\001\255\255\007\001\008\001\255\255\255\255\255\255\031\001\
\032\001\033\001\034\001\035\001\036\001\037\001\038\001\255\255\
\255\255\255\255\255\255\255\255\044\001\045\001\255\255\255\255\
\029\001\255\255\031\001\032\001\033\001\034\001\035\001\036\001\
\037\001\038\001\058\001\255\255\060\001\061\001\255\255\044\001\
\045\001\255\255\255\255\048\001\049\001\050\001\051\001\052\001\
\053\001\054\001\055\001\255\255\057\001\058\001\255\255\060\001\
\061\001\062\001\003\001\255\255\005\001\255\255\007\001\008\001\
\255\255\255\255\255\255\031\001\032\001\033\001\034\001\035\001\
\036\001\037\001\038\001\255\255\255\255\255\255\255\255\255\255\
\044\001\045\001\255\255\255\255\029\001\255\255\031\001\032\001\
\033\001\034\001\035\001\036\001\037\001\038\001\058\001\255\255\
\060\001\061\001\255\255\044\001\045\001\255\255\255\255\048\001\
\049\001\050\001\051\001\052\001\053\001\054\001\055\001\255\255\
\057\001\058\001\255\255\060\001\061\001\062\001\003\001\255\255\
\005\001\255\255\007\001\008\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\029\001\255\255\031\001\032\001\033\001\034\001\035\001\036\001\
\037\001\038\001\255\255\255\255\255\255\255\255\255\255\044\001\
\045\001\255\255\255\255\048\001\049\001\050\001\051\001\052\001\
\053\001\054\001\055\001\255\255\057\001\058\001\255\255\060\001\
\061\001\062\001\003\001\255\255\005\001\255\255\007\001\008\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\029\001\255\255\031\001\032\001\
\033\001\034\001\035\001\036\001\037\001\038\001\255\255\255\255\
\255\255\255\255\255\255\044\001\045\001\255\255\255\255\048\001\
\049\001\050\001\051\001\052\001\053\001\054\001\055\001\255\255\
\057\001\058\001\255\255\060\001\061\001\062\001\003\001\255\255\
\005\001\255\255\007\001\008\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\029\001\255\255\031\001\032\001\033\001\034\001\035\001\036\001\
\037\001\038\001\255\255\255\255\255\255\255\255\255\255\044\001\
\045\001\255\255\255\255\048\001\049\001\050\001\051\001\052\001\
\053\001\054\001\055\001\255\255\057\001\058\001\255\255\060\001\
\061\001\062\001\003\001\255\255\005\001\255\255\007\001\008\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\029\001\255\255\031\001\032\001\
\033\001\034\001\035\001\036\001\037\001\038\001\255\255\255\255\
\255\255\255\255\255\255\044\001\045\001\255\255\255\255\048\001\
\049\001\050\001\051\001\052\001\053\001\054\001\055\001\255\255\
\057\001\058\001\255\255\060\001\061\001\062\001\003\001\255\255\
\005\001\255\255\007\001\008\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\029\001\255\255\031\001\032\001\033\001\034\001\035\001\036\001\
\037\001\038\001\255\255\255\255\255\255\255\255\255\255\044\001\
\045\001\255\255\255\255\048\001\049\001\050\001\051\001\052\001\
\053\001\054\001\055\001\255\255\057\001\058\001\255\255\060\001\
\061\001\062\001\003\001\255\255\005\001\255\255\007\001\008\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\029\001\255\255\031\001\032\001\
\033\001\034\001\035\001\036\001\037\001\038\001\255\255\255\255\
\255\255\255\255\255\255\044\001\045\001\255\255\255\255\048\001\
\049\001\050\001\051\001\052\001\053\001\054\001\055\001\255\255\
\057\001\058\001\255\255\060\001\061\001\062\001\003\001\255\255\
\005\001\255\255\007\001\008\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\029\001\255\255\031\001\032\001\033\001\034\001\035\001\036\001\
\037\001\038\001\255\255\255\255\255\255\255\255\255\255\044\001\
\045\001\255\255\255\255\048\001\049\001\050\001\051\001\052\001\
\053\001\054\001\055\001\255\255\057\001\058\001\255\255\060\001\
\061\001\062\001\003\001\255\255\005\001\255\255\007\001\008\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\029\001\255\255\031\001\032\001\
\033\001\034\001\035\001\036\001\037\001\038\001\255\255\255\255\
\255\255\255\255\255\255\044\001\045\001\255\255\255\255\048\001\
\049\001\050\001\051\001\052\001\053\001\054\001\055\001\255\255\
\057\001\058\001\255\255\060\001\061\001\062\001\003\001\255\255\
\005\001\255\255\007\001\008\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\029\001\255\255\031\001\032\001\033\001\034\001\035\001\036\001\
\037\001\038\001\255\255\255\255\255\255\255\255\255\255\044\001\
\045\001\255\255\255\255\048\001\049\001\050\001\051\001\052\001\
\053\001\054\001\055\001\255\255\057\001\058\001\255\255\060\001\
\061\001\062\001\003\001\255\255\005\001\255\255\007\001\008\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\029\001\255\255\031\001\032\001\
\033\001\034\001\035\001\036\001\037\001\038\001\255\255\255\255\
\255\255\255\255\255\255\044\001\045\001\255\255\255\255\048\001\
\049\001\050\001\051\001\052\001\053\001\054\001\055\001\255\255\
\057\001\058\001\255\255\060\001\061\001\062\001\003\001\255\255\
\005\001\255\255\007\001\008\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\029\001\255\255\031\001\032\001\033\001\034\001\035\001\036\001\
\037\001\038\001\255\255\255\255\255\255\255\255\255\255\044\001\
\045\001\255\255\255\255\048\001\049\001\050\001\051\001\052\001\
\053\001\054\001\055\001\255\255\057\001\058\001\255\255\060\001\
\061\001\062\001\003\001\255\255\005\001\255\255\007\001\008\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\029\001\255\255\031\001\032\001\
\033\001\034\001\035\001\036\001\037\001\038\001\255\255\255\255\
\255\255\255\255\255\255\044\001\045\001\255\255\255\255\048\001\
\049\001\050\001\051\001\052\001\053\001\054\001\055\001\255\255\
\057\001\058\001\255\255\060\001\061\001\062\001\003\001\255\255\
\005\001\255\255\007\001\008\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\029\001\255\255\031\001\032\001\033\001\034\001\035\001\036\001\
\037\001\038\001\255\255\255\255\255\255\255\255\255\255\044\001\
\045\001\255\255\255\255\048\001\049\001\050\001\051\001\052\001\
\053\001\054\001\055\001\255\255\057\001\058\001\255\255\060\001\
\061\001\062\001\003\001\255\255\005\001\255\255\007\001\008\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\029\001\255\255\031\001\032\001\
\033\001\034\001\035\001\036\001\037\001\038\001\255\255\255\255\
\255\255\255\255\255\255\044\001\045\001\255\255\255\255\048\001\
\049\001\050\001\051\001\052\001\053\001\054\001\055\001\255\255\
\057\001\058\001\255\255\060\001\061\001\062\001\003\001\255\255\
\005\001\255\255\007\001\008\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\031\001\032\001\033\001\034\001\035\001\036\001\
\037\001\038\001\255\255\255\255\255\255\255\255\255\255\044\001\
\045\001\255\255\255\255\048\001\049\001\050\001\051\001\052\001\
\053\001\054\001\055\001\255\255\057\001\058\001\255\255\060\001\
\061\001\062\001\003\001\255\255\005\001\255\255\007\001\008\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\031\001\032\001\
\033\001\034\001\035\001\036\001\037\001\038\001\003\001\255\255\
\005\001\255\255\255\255\044\001\045\001\255\255\255\255\048\001\
\049\001\050\001\051\001\052\001\053\001\054\001\055\001\255\255\
\057\001\058\001\255\255\060\001\061\001\062\001\255\255\255\255\
\255\255\255\255\031\001\032\001\033\001\034\001\035\001\036\001\
\037\001\038\001\003\001\255\255\005\001\255\255\255\255\044\001\
\045\001\255\255\255\255\048\001\049\001\050\001\051\001\052\001\
\053\001\054\001\055\001\255\255\057\001\058\001\255\255\060\001\
\061\001\062\001\255\255\255\255\255\255\255\255\031\001\032\001\
\033\001\034\001\035\001\036\001\037\001\038\001\255\255\255\255\
\255\255\255\255\255\255\044\001\045\001\255\255\255\255\048\001\
\049\001\050\001\051\001\052\001\053\001\054\001\055\001\255\255\
\057\001\058\001\255\255\060\001\061\001\062\001\003\001\255\255\
\005\001\255\255\007\001\008\001\009\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\003\001\255\255\005\001\255\255\007\001\008\001\009\001\255\255\
\029\001\255\255\031\001\255\255\255\255\034\001\255\255\036\001\
\255\255\255\255\255\255\040\001\255\255\255\255\255\255\255\255\
\255\255\255\255\029\001\048\001\049\001\050\001\051\001\052\001\
\053\001\054\001\055\001\038\001\057\001\040\001\003\001\255\255\
\005\001\062\001\007\001\008\001\009\001\048\001\049\001\050\001\
\051\001\052\001\053\001\054\001\055\001\255\255\057\001\255\255\
\255\255\255\255\255\255\062\001\255\255\255\255\255\255\255\255\
\029\001\255\255\255\255\032\001\003\001\255\255\005\001\255\255\
\007\001\008\001\009\001\040\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\048\001\049\001\050\001\051\001\052\001\
\053\001\054\001\055\001\255\255\057\001\255\255\029\001\255\255\
\255\255\062\001\033\001\255\255\255\255\255\255\003\001\255\255\
\005\001\040\001\007\001\008\001\009\001\255\255\255\255\255\255\
\255\255\048\001\049\001\050\001\051\001\052\001\053\001\054\001\
\055\001\255\255\057\001\255\255\255\255\255\255\255\255\062\001\
\029\001\255\255\255\255\003\001\255\255\005\001\035\001\007\001\
\008\001\009\001\255\255\040\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\048\001\049\001\050\001\051\001\052\001\
\053\001\054\001\055\001\255\255\057\001\029\001\003\001\255\255\
\005\001\062\001\007\001\008\001\009\001\037\001\255\255\255\255\
\040\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\048\001\049\001\050\001\051\001\052\001\053\001\054\001\055\001\
\029\001\057\001\255\255\003\001\255\255\005\001\062\001\007\001\
\008\001\009\001\255\255\040\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\048\001\049\001\050\001\051\001\052\001\
\053\001\054\001\055\001\255\255\057\001\029\001\255\255\255\255\
\061\001\062\001\255\255\255\255\255\255\003\001\255\255\005\001\
\040\001\007\001\008\001\009\001\255\255\255\255\255\255\255\255\
\048\001\049\001\050\001\051\001\052\001\053\001\054\001\055\001\
\255\255\057\001\058\001\255\255\255\255\255\255\062\001\029\001\
\003\001\255\255\005\001\255\255\007\001\008\001\009\001\255\255\
\255\255\255\255\040\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\048\001\049\001\050\001\051\001\052\001\053\001\
\054\001\055\001\029\001\057\001\255\255\003\001\060\001\005\001\
\062\001\007\001\008\001\009\001\255\255\040\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\048\001\049\001\050\001\
\051\001\052\001\053\001\054\001\055\001\255\255\057\001\029\001\
\003\001\255\255\005\001\062\001\007\001\008\001\009\001\003\001\
\255\255\005\001\040\001\007\001\008\001\009\001\255\255\255\255\
\255\255\255\255\048\001\049\001\050\001\051\001\052\001\053\001\
\054\001\055\001\029\001\255\255\255\255\255\255\255\255\255\255\
\062\001\029\001\003\001\255\255\005\001\040\001\007\001\008\001\
\009\001\255\255\255\255\255\255\040\001\048\001\049\001\050\001\
\051\001\052\001\053\001\054\001\048\001\049\001\050\001\051\001\
\052\001\053\001\255\255\255\255\029\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\040\001\
\031\001\032\001\033\001\034\001\035\001\036\001\037\001\038\001\
\255\255\050\001\051\001\052\001\053\001\044\001\045\001\255\255\
\255\255\048\001\049\001\050\001\051\001\052\001\053\001\054\001\
\055\001\255\255\057\001\058\001\255\255\060\001\061\001\062\001\
\031\001\032\001\033\001\034\001\035\001\036\001\037\001\038\001\
\255\255\255\255\255\255\255\255\255\255\044\001\045\001\255\255\
\255\255\048\001\049\001\050\001\051\001\052\001\053\001\054\001\
\055\001\255\255\057\001\058\001\255\255\060\001\061\001\062\001\
\031\001\032\001\033\001\034\001\035\001\036\001\037\001\038\001\
\255\255\255\255\255\255\255\255\255\255\044\001\045\001\255\255\
\255\255\048\001\049\001\050\001\051\001\052\001\053\001\054\001\
\055\001\255\255\057\001\058\001\255\255\060\001\061\001\062\001\
\031\001\032\001\033\001\034\001\035\001\036\001\037\001\038\001\
\255\255\255\255\255\255\255\255\255\255\044\001\045\001\255\255\
\255\255\048\001\049\001\050\001\051\001\052\001\053\001\054\001\
\055\001\255\255\057\001\058\001\255\255\060\001\061\001\062\001\
\031\001\032\001\033\001\034\001\035\001\036\001\037\001\038\001\
\255\255\255\255\255\255\255\255\255\255\044\001\045\001\255\255\
\255\255\048\001\049\001\050\001\051\001\052\001\053\001\054\001\
\055\001\255\255\057\001\058\001\255\255\060\001\061\001\062\001\
\031\001\032\001\033\001\034\001\035\001\036\001\037\001\038\001\
\255\255\255\255\255\255\255\255\255\255\044\001\045\001\255\255\
\255\255\048\001\049\001\050\001\051\001\052\001\053\001\054\001\
\055\001\255\255\057\001\058\001\255\255\060\001\061\001\062\001\
\031\001\032\001\033\001\034\001\035\001\036\001\037\001\038\001\
\255\255\255\255\255\255\255\255\255\255\044\001\045\001\255\255\
\255\255\048\001\049\001\050\001\051\001\052\001\053\001\054\001\
\055\001\255\255\057\001\058\001\255\255\060\001\061\001\062\001\
\031\001\032\001\033\001\034\001\035\001\036\001\037\001\038\001\
\255\255\255\255\255\255\255\255\255\255\044\001\045\001\255\255\
\255\255\048\001\049\001\050\001\051\001\052\001\053\001\054\001\
\055\001\255\255\057\001\058\001\255\255\060\001\061\001\062\001\
\031\001\032\001\033\001\034\001\035\001\036\001\037\001\038\001\
\255\255\255\255\255\255\255\255\255\255\044\001\045\001\255\255\
\255\255\048\001\049\001\255\255\255\255\255\255\255\255\054\001\
\055\001\255\255\057\001\058\001\255\255\060\001\061\001\062\001\
\031\001\032\001\033\001\034\001\035\001\036\001\037\001\038\001\
\255\255\255\255\255\255\255\255\255\255\044\001\045\001\255\255\
\255\255\048\001\049\001\255\255\255\255\255\255\255\255\054\001\
\055\001\255\255\057\001\058\001\255\255\060\001\061\001\062\001\
\031\001\032\001\033\001\034\001\035\001\036\001\037\001\038\001\
\255\255\255\255\255\255\255\255\255\255\044\001\045\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\055\001\255\255\057\001\058\001\255\255\060\001\061\001\062\001\
\031\001\032\001\033\001\034\001\035\001\036\001\037\001\038\001\
\255\255\255\255\255\255\255\255\255\255\044\001\045\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\055\001\255\255\057\001\058\001\255\255\060\001\061\001\062\001"

let yynames_const = "\
  PLUS\000\
  UPLUS\000\
  MINUS\000\
  UMINUS\000\
  TIMES\000\
  DIV\000\
  POW\000\
  SQRT\000\
  FLOOR\000\
  CEIL\000\
  ROUND\000\
  COS\000\
  SIN\000\
  SINH\000\
  COSH\000\
  TAN\000\
  TANH\000\
  EXP\000\
  LOG\000\
  ACOS\000\
  ASIN\000\
  ATAN\000\
  LN\000\
  DEG\000\
  LOGB\000\
  ABS\000\
  MODULO\000\
  FACTORIAL\000\
  LPAR\000\
  RPAR\000\
  ABSDEL\000\
  LBRA\000\
  RBRA\000\
  LCUR\000\
  RCUR\000\
  END\000\
  PI\000\
  ENOT\000\
  RANDOM\000\
  TRUE\000\
  FALSE\000\
  DECSEP\000\
  DECXPSEP\000\
  ASSIGN\000\
  LET\000\
  LEQUALS\000\
  LDIFF\000\
  LSUP\000\
  LINF\000\
  LSSUP\000\
  LSINF\000\
  LAND\000\
  LOR\000\
  LNOT\000\
  LTERN\000\
  LTERNSEP\000\
  LIF\000\
  LELSE\000\
  LTHEN\000\
  LXOR\000\
  INCR\000\
  DECR\000\
  CMD\000\
  COMMENT\000\
  UNIT\000\
  PRINT\000\
  "

let yynames_block = "\
  VAL\000\
  VAR\000\
  "

let yyact = [|
  (fun _ -> failwith "parser")
; (fun __caml_parser_env ->
    Obj.repr(
# 176 "mathparser.mly"
                                (raise Mathcommon.Unit)
# 1038 "mathparser.ml"
               : float))
; (fun __caml_parser_env ->
    Obj.repr(
# 177 "mathparser.mly"
                                (raise Mathcommon.Unit)
# 1044 "mathparser.ml"
               : float))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'command) in
    Obj.repr(
# 178 "mathparser.mly"
                                (_2)
# 1051 "mathparser.ml"
               : float))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'xp) in
    Obj.repr(
# 179 "mathparser.mly"
                                (_1)
# 1058 "mathparser.ml"
               : float))
; (fun __caml_parser_env ->
    Obj.repr(
# 181 "mathparser.mly"
                                (complain())
# 1064 "mathparser.ml"
               : float))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 186 "mathparser.mly"
                                (
    begin match _1 with

    | ("vars"|"table") ->  
      display_bindings ()
    | ("clear"|"erase") ->
      Hashtbl.clear local_vars
    | ("exit"|"quit") ->
      print_endline "Bye-bye!"; exit 0
    | ("h"|"help") ->
      print_endline "Commands: vars, clear, exit."
    | _ -> 
      prerr_endline "Unrecognized command!"

    end ; raise Mathcommon.Unit 
                                )
# 1086 "mathparser.ml"
               : 'command))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'dec) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'decs) in
    Obj.repr(
# 206 "mathparser.mly"
                                (_1)
# 1094 "mathparser.ml"
               : 'decs))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'dec) in
    Obj.repr(
# 207 "mathparser.mly"
                                (_1)
# 1101 "mathparser.ml"
               : 'decs))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 212 "mathparser.mly"
                                (bind_local_var _1 _3)
# 1109 "mathparser.ml"
               : 'dec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : string) in
    Obj.repr(
# 213 "mathparser.mly"
                                (bind_local_var _1 ((eval_local_var _1) +. 1.))
# 1116 "mathparser.ml"
               : 'dec))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 214 "mathparser.mly"
                                (bind_local_var _2 ((eval_local_var _2) +. 1.))
# 1123 "mathparser.ml"
               : 'dec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : string) in
    Obj.repr(
# 215 "mathparser.mly"
                                (bind_local_var _1 ((eval_local_var _1) -. 1.))
# 1130 "mathparser.ml"
               : 'dec))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 216 "mathparser.mly"
                                (bind_local_var _2 ((eval_local_var _2) -. 1.))
# 1137 "mathparser.ml"
               : 'dec))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'xp) in
    Obj.repr(
# 221 "mathparser.mly"
                                (_2)
# 1144 "mathparser.ml"
               : 'parxp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'xp) in
    Obj.repr(
# 222 "mathparser.mly"
                                (_2)
# 1151 "mathparser.ml"
               : 'parxp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'xp) in
    Obj.repr(
# 223 "mathparser.mly"
                                (_2)
# 1158 "mathparser.ml"
               : 'parxp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'decs) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 230 "mathparser.mly"
                                (_2;_4)
# 1166 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'decs) in
    Obj.repr(
# 231 "mathparser.mly"
                                (_2; raise Mathcommon.Unit)
# 1173 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'decs) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 232 "mathparser.mly"
                                (_1;_3)
# 1181 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'decs) in
    Obj.repr(
# 233 "mathparser.mly"
                                (_1; raise Mathcommon.Unit)
# 1188 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    Obj.repr(
# 236 "mathparser.mly"
                                (raise Mathcommon.Unit)
# 1194 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : float) in
    Obj.repr(
# 237 "mathparser.mly"
                                (_1)
# 1201 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'parxp) in
    Obj.repr(
# 238 "mathparser.mly"
                                (_1)
# 1208 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 239 "mathparser.mly"
                                (eval_local_var _1)
# 1215 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'xp) in
    Obj.repr(
# 240 "mathparser.mly"
                                (abs_float _2)
# 1222 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    Obj.repr(
# 241 "mathparser.mly"
                                (pi)
# 1228 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    Obj.repr(
# 242 "mathparser.mly"
                                (1.)
# 1234 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    Obj.repr(
# 243 "mathparser.mly"
                                (0.)
# 1240 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 244 "mathparser.mly"
                                (10. ** _2)
# 1247 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'xp) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 247 "mathparser.mly"
                                (_1 *. 10. ** _3)
# 1255 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'xp) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 248 "mathparser.mly"
                                (_1 +. _3)
# 1263 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'xp) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 249 "mathparser.mly"
                                (_1 -. _3)
# 1271 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'xp) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 250 "mathparser.mly"
                                (_1 *. _3)
# 1279 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'xp) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 251 "mathparser.mly"
                                (_1 /. _3)
# 1287 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'xp) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 252 "mathparser.mly"
                                (mod_float _1 _3)
# 1295 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'xp) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 253 "mathparser.mly"
                                (_1 ** _3)
# 1303 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 256 "mathparser.mly"
                                (Random.float _2)
# 1310 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 257 "mathparser.mly"
                                (sqrt _2)
# 1317 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 258 "mathparser.mly"
                                (floor _2)
# 1324 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 259 "mathparser.mly"
                                (ceil _2)
# 1331 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 260 "mathparser.mly"
                                (round _2)
# 1338 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 261 "mathparser.mly"
                                (abs_float _2)
# 1345 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 262 "mathparser.mly"
                                (cos _2)
# 1352 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 263 "mathparser.mly"
                                (sin _2)
# 1359 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 264 "mathparser.mly"
                                (tan _2)
# 1366 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 265 "mathparser.mly"
                                (acos _2)
# 1373 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 266 "mathparser.mly"
                                (asin _2)
# 1380 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 267 "mathparser.mly"
                                (atan _2)
# 1387 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 268 "mathparser.mly"
                                (cosh _2)
# 1394 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 269 "mathparser.mly"
                                (sinh _2)
# 1401 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 270 "mathparser.mly"
                                (tanh _2)
# 1408 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 271 "mathparser.mly"
                                (log _2)
# 1415 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 272 "mathparser.mly"
                                (log10 _2)
# 1422 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 273 "mathparser.mly"
                                (exp _2)
# 1429 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'xp) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'parxp) in
    Obj.repr(
# 274 "mathparser.mly"
                                (logb _2 _3)
# 1437 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 275 "mathparser.mly"
                                (deg_to_rad _2)
# 1444 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 276 "mathparser.mly"
                                (factorial_f _2)
# 1451 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'xp) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 279 "mathparser.mly"
                                (fob (_1 = _3))
# 1459 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'xp) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 280 "mathparser.mly"
                                (fob (_1 >= _3))
# 1467 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'xp) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 281 "mathparser.mly"
                                (fob (_1 <= _3))
# 1475 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'xp) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 282 "mathparser.mly"
                                (fob (_1 > _3))
# 1483 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'xp) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 283 "mathparser.mly"
                                (fob (_1 < _3))
# 1491 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'xp) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 284 "mathparser.mly"
                                (fob (bof _1 && bof _3))
# 1499 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'xp) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 285 "mathparser.mly"
                                (fob (bof _1 || bof _3))
# 1507 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'xp) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 286 "mathparser.mly"
                                (fxor _1 _3)
# 1515 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 287 "mathparser.mly"
                                (if _2 = 0. then 1. else 0.)
# 1522 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'xp) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 288 "mathparser.mly"
                                (fob (_1 <> _3))
# 1530 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : 'xp) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'xp) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 289 "mathparser.mly"
                                (if _1 = 0. then _5 else _3)
# 1539 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'xp) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : 'xp) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 290 "mathparser.mly"
                                (if _2 = 0. then _6 else _4)
# 1548 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 293 "mathparser.mly"
                                (-._2)
# 1555 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 294 "mathparser.mly"
                                (_2)
# 1562 "mathparser.ml"
               : 'xp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'xp) in
    Obj.repr(
# 297 "mathparser.mly"
                                (let v= _2 in Toolkit.pl (soff v); v)
# 1569 "mathparser.ml"
               : 'xp))
(* Entry evalf *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
|]
let yytables =
  { Parsing.actions=yyact;
    Parsing.transl_const=yytransl_const;
    Parsing.transl_block=yytransl_block;
    Parsing.lhs=yylhs;
    Parsing.len=yylen;
    Parsing.defred=yydefred;
    Parsing.dgoto=yydgoto;
    Parsing.sindex=yysindex;
    Parsing.rindex=yyrindex;
    Parsing.gindex=yygindex;
    Parsing.tablesize=yytablesize;
    Parsing.table=yytable;
    Parsing.check=yycheck;
    Parsing.error_function=parse_error;
    Parsing.names_const=yynames_const;
    Parsing.names_block=yynames_block }
let evalf (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 1 lexfun lexbuf : float)
