
(*
 * m.E.M.E - Minimalist Evaluator for Mathematical Expressions
 * 
 * by Gamall Wednesday Ida
 * 
 * gamall-ida.com
 * gamall.ida@gmail.com
 * 
 * Copyright 2007, 2008 Gamall Wednesday Ida
 * 
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *)

(** Mathematical expressions evaluator *)

open Toolkit

(** Compute a mathematical expression, without any attempt to catch exceptions raised
    by the parser *)
let raw s = 
  let lexbuf = Lexing.from_string s in
  Global.set Mathcommon.lexbuf lexbuf;
  Mathparser.evalf Mathlexer.token lexbuf

(** Same as [eval_raw], but converted to string *)
let raw_str = sof % raw 
  
(** Compute a mathematical expression, yielding NaN if there is any error *)
let fail_nan s = try raw s with _ -> nan
  
(** String indicating a Unit evaluation, in other words, evaluation of an expression which merely changes the state by defining variables *)
let _str_unit = ref "()"

(** String indication an error *)
let str_error = "Error."

(** Compute a mathematical expression, returning a string, never failing. Returns 'Error.' if the expression is incorrect *)
let str s = 
  try let res = raw s in if compare res nan = 0 then "NaN" else soff res 
  with 
    | Mathcommon.Unit -> !_str_unit
    | _ -> str_error

let _parse_show_error = Mathcommon._show_error