(*
 * m.E.M.E - Minimalist Evaluator for Mathematical Expressions
 * 
 * by Gamall Wednesday Ida
 * 
 * gamall-ida.com
 * gamall.ida@gmail.com
 * 
 * Copyright 2007, 2008 Gamall Wednesday Ida
 * 
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *)

(** Some declarations which are common to several components *)  

open Toolkit

(** Signal a pure declaration of variables: there is no value to return, but the state
      has been altered. Used by the parser. *)
exception Unit;; 


(** Must the error rule be printed? *)
let _show_error = ref true

(** Print an error rule showing where the syntax error is *)
let show_error ss se = 
  let rp = repeat_pattern in
  let spaces, errs = rp " " ss, rp "^" (se-ss) in
  epf "%s%s\n%!" spaces errs

(** Print error messages on stderr *)
let _print_errors = ref true

(** Must the lexed string be printed if parsing fails ? *)
let _show_lexbuf = ref false

(** The buffer *)
let lexbuf = ((Global.empty "the lexbuf") : Lexing.lexbuf global)