bindCommand tpme cmdTpme

proc teleporterSpawn { ent } {
	global teleporter

	# Place the entity at the default origin and angles.
	entCurrentorigin $ent [entOrigin $ent]
	entCurrentangles $ent [entAngles $ent]

	# Make the entity solid, visible and usable.
	entSolid $ent 1
	entVisible $ent 1
	entUsable $ent 1

	# Set the entity's model.
	entModel $ent "models/map_objects/factory/f_con1.md3"

	# Use that if you don't know the entity's bounding boxes, it finds and sets them automatically.
	entAutoBbox $ent

	# Link the entity to the world.
	entLink $ent

	set teleporter($ent,usetime) 0
}

proc teleporterUse { ent user } {
	global teleporter
	if {$teleporter($ent,usetime) > [gameTime]} { return }
	clPrint $user "^5Teleporter Terminal"
	clPrint $user "^3-------------------"
	clPrint $user "^3Availible locations :"
	clPrint $user "^31 ^7- ^5Left Room"
	clPrint $user "^32 ^7- ^5Forward Room"
	clPrint $user "^33 ^7- ^5Right Room"
	clPrint $user "Aim to this terminal and type /tpme followed by the location's number."
	set teleporter($ent,usetime) [expr [gameTime] + 2000]
}

proc cmdTpme { ent args } {
	set found [find 0 classname teleporter]
	if {[lsearch $found [clAimEnt $ent 40]] == -1} {
		clPrint $ent "You are not aiming at a teleporter terminal."
		return
	}
	if {$args == ""} {
		clPrint $ent "Syntax : /tpme <LOCATION NUMBER>"
		return
	}
	switch $args {
		"1" { clTeleport $ent [entOrigin [quickFind teleportLeft]] [entAngles [quickFind teleportLeft]] }
		"2" { clTeleport $ent [entOrigin [quickFind teleportForward]] [entAngles [quickFind teleportForward]] }
		"3" { clTeleport $ent [entOrigin [quickFind teleportRight]] [entAngles [quickFind teleportRight]] }
		default { clPrint $ent "Unknown location!" }
	}
}