# Register the procedure cmdTellPass to the command "tellpass".
bindCommand tellpass cmdTellPass

# Set the password.
set thepassword "secret"

proc spawnPassword { ent } {
	# Set the entity's origin and angles to it's default origin.
	entCurrentorigin $ent [entOrigin $ent]
	entCurrentangles $ent [entAngles $ent]

	# Make the entity solid, usable and visible.
	entSolid $ent 1
	entVisible $ent 1
	entUsable $ent 1

	# Set the entity's model.
	entModel $ent "models/map_objects/factory/f_con1.md3"

	# Find and set automatically the model's bounding boxes to make it solid.
	entAutoBbox $ent

	# Link it, important.
	entLink $ent
}

proc usePassword { ent user } {
	# Someone used the terminal, print a message in it's chatbox.
	clChat $user "-^5Password Terminal^7- Hey [clName $user]! Enter your password by aiming this terminal and use the command /tellpass"
}

proc cmdTellPass { ent args } {
	global thepassword

	# Find and list every entities who has the classname "terminal_password".
	set found [find 0 classname terminal_password]

	# If the user has typed nothing...
	if {$args == ""} {
		clPrint $ent "Syntax : /tellPass <PASSWORD>"
		return
	}

	# If we can't find the entity's number that the user is currently aiming in the found entities list...
	if {[lsearch $found [clAimEnt $ent 32]] == -1} {
		clPrint $ent "You are not currently aiming at a password terminal."
	} else {
		# If the argument is not the same as the defined password.
		if {$args != $thepassword} {
			clPrint $ent "^1Wrong Password! (Open password.tcl with the notepad to find it!"
		} else {
			# If it's good, use the entity matching targetname "passwordDoor", set the user as the door's activator.
			clPrint $ent "^2Good Password! Congrats!"
			entUse [quickFind passwordDoor] $ent
		}
	}
}