bindCommand getbomb cmdPickBomb

set usetime 0

for {set i 0} {$i < 32} {incr i} {
	set player($i,bomb) -1
}

proc bombSpawn { ent } {
	global bomb

	# Place the entity at the default origin and angles.
	entCurrentorigin $ent [entOrigin $ent]
	entCurrentangles $ent [entAngles $ent]
	entPosTrBase $ent [entOrigin $ent]
	entAPosTrBase $ent [entAngles $ent]

	# Make the entity solid, visible and usable.
	entSolid $ent 1
	entVisible $ent 1
	entUsable $ent 1

	# Set the entity's model.
	entModel $ent "models/map_objects/factory/bomb_new.md3"

	# Use that if you don't know the entity's bounding boxes, it finds and sets them automatically.
	entAutoBbox $ent

	# Link the entity to the world.
	entLink $ent

	set bomb($ent,user) -1
	set bomb($ent,mode) 0
	set bomb($ent,ent) $ent
	set bomb($ent,grabber) -1
	set bomb($ent,timer) 0
	set bomb($ent,count) 0
}

proc bombUse { ent user } {
	global bomb
	global usetime
	if {$usetime > [gameTime]} { return }
	set usetime [expr [gameTime] + 2000]

	if {$bomb($ent,mode) == 0 && $bomb($ent,user) == -1} {
		if {[clHacking $user] == 0} {
			set bomb($ent,user) $user
			clCprint $user "Planting the bomb..."
			clHacking $user $ent
			clHackingAngles $user [clAngles $user]
			clHackingTime $user [expr [gameTime] + 5000]
			clHackingBaseTime $user 5000
		}
	}

	if {$bomb($ent,mode) == 1 && $bomb($ent,user) == -1} {
		if {[clHacking $user] == 0} {
			set bomb($ent,user) $user
			clCprint $user "Defusing the bomb..."
			clHacking $user $ent
			clHackingAngles $user [clAngles $user]
			clHackingTime $user [expr [gameTime] + 15000]
			clHackingBaseTime $user 15000
		}
	}
}

proc cmdPickBomb { ent args } {
	global bomb
	global player

	set found [find 0 classname bomb]
	if {[llength $found] == 0} {
		clPrint $ent "^1> There are no bombs anymore!"
		return
	}

	set bombEnt [clAimEnt $ent 40]
	if {$player($ent,bomb) == -1} {
		set bomb($bombEnt,grabber) $ent
		set player($ent,bomb) $bombEnt
		entUnlink $bombEnt
		clPrint $ent "^3> ^2You are carrying the bomb, type ^5/getbomb^2 to drop it."
	} else {
		set bomb($player($ent,bomb),grabber) -1
		entLink $player($ent,bomb)
		set player($ent,bomb) -1
		clPrint $ent "^3> ^3Bomb dropped."
	}
	return
}

proc bombThink { ent } {
	global bomb
	set time [gameTime]

	if {$bomb($ent,grabber) != -1 && $bomb($ent,mode) == 0} {
		entCurrentorigin $ent [clAimOrigin $bomb($ent,grabber) 100]
		entPosTrBase $ent [entCurrentorigin $ent]
	}

	if {$bomb($ent,mode) == 0} {
		if {$bomb($ent,user) != -1} {
			if {[clHacking $bomb($ent,user)] == $ent} {
				if {[clHackingTime $bomb($ent,user)] < $time} {
					set bomb($ent,mode) 1
					clCprint -1 "^1The bomb has been planted!"
					clHacking $bomb($ent,user) 0
					clHackingTime $bomb($ent,user) 0
					clHackingBaseTime $bomb($ent,user) 0
					set bomb($ent,user) -1
					set bomb($ent,count) 10
					set bomb($ent,timer) [expr $time + 1000]
				}
			} else {
				clHacking $bomb($ent,user) 0
				clHackingTime $bomb($ent,user) 0
				clHackingBaseTime $bomb($ent,user) 0
				set bomb($ent,user) -1
			}
		}
	}

	if {$bomb($ent,mode) == 1} {
		if {$bomb($ent,user) != -1 && [clHacking $bomb($ent,user)] == $ent} {
			if {[clHackingTime $bomb($ent,user)] < $time} {
				set bomb($ent,mode) 0
				clCprint -1 "^3The bomb has been defused!"
				clHacking $bomb($ent,user) 0
				clHackingTime $bomb($ent,user) 0
				clHackingBaseTime $bomb($ent,user) 0
			}
		} else {
			clHacking $bomb($ent,user) 0
			clHackingTime $bomb($ent,user) 0
			clHackingBaseTime $bomb($ent,user) 0
			set bomb($ent,user) -1
		}
		if {$bomb($ent,timer) < $time} {
			incr bomb($ent,count) -1
			if {$bomb($ent,count) == 0} {
				clCprint -1 "^1MU^3HA^1HA^3HA^1HA^3!!"
				set or [entCurrentorigin $ent]
				set ox [lindex $or 0]
				set oy [lindex $or 1]
				set oz [lindex $or 2]
				playEffect "explosions/wedge_explosion1" [entCurrentorigin $ent] {0 0 1}
				radiusDamage [entCurrentorigin $ent] $ent 900 4096 400 0
				set bomb($ent,mode) 0
				set bomb($ent,ent) -1
				entDel $ent
			} else {
				set bomb($ent,timer) [expr $time + 1000]
				clChat -1 $bomb($ent,count)
			}
		}
	}
}