dofile("JKALua/scripts/colors.lua")

function game_init(leveltime, randomsd)
	math.randomseed(randomsd)
	print("^1Instagib gamemode 1.0 on JKALua " .. JKALUA_VERSION)
end

function player_connect(clientno, firsttime, isbot)
	print_all(COLOR_YELLOW .. "Player connected!")
end

function player_disconnect(entity, concheck)
	print_all(entity.playername .. COLOR_BLUE .. " left the battle!")
end

function player_spawn(entity)
	entity:stripweapons()
	entity:giveweapon(4)
	entity:setweapon(4)

	if (tonumber(entity:getvar("deaths"))) then
		local old = tonumber(entity:getvar("deaths"))
		entity:setvar("deaths", tostring(old + 1))
	else
		entity:setvar("deaths", tostring(0))
	end
end

function weapon_fire(entity, weptype, altfire, hitent, hitpos)
	if (hitent.client) then
		hitent:kill()
		print_ply(entity.clientnum, COLOR_RED .. "You fragged '" .. hitent.playername .. COLOR_RED .. "'")
		print(entity:getvar("kills"))
		local old = tonumber(entity:getvar("kills"))
		print("new score: " .. old + 1)
		entity:setvar("kills", tostring(old + 1))
		entity:addscore(1)
	end
end

function player_say(entity, txt, mode)
	if (txt == "/stats") then
		print_all("Stats for " .. entity.playername .. ": " .. entity:getvar("kills") .. " kills, " .. entity:getvar("deaths") .. " deaths.")
	elseif (txt == "/cheats") then
		if (cheats_enabled()) then
			print_ply(entity.clientnum, "Cheats are ON!")
		else
			print_ply(entity.clientnum, "Cheats are OFF!")
		end
	else
		print_all(entity.playername .. COLOR_GREEN .. ": " .. txt)
	end
end

