/* Gamall : Miscellaneous functions */

#include "g_local.h"
//#include "ga_misc.h"
//#include <time.h>


/* short-cuts to write clean, formatted messages */
#define ggn		"^4  ^5"	
/* normal	*/
#define ggt		"^4# ^3"	
/* title	*/
#define ggi		"^4     ^7" 
/* info	*/
#define ggl		"\n"		
/* new line */
#define ggbl	"\n\n"		
/* blank line */

// special connection logs
struct FILE *gaConnectLog;
const char *GA_CONNECT_LOG_FILENAME = "ga_ConnectLog.txt";


// That was just... dumb.... :D
/* Converts a char to lower case */
/*
char gaLowerCase(const unsigned char ch)
{ //
	if (ch >= 'A' && ch <= 'Z')
	{
		return ch + 32;
	}
	else 
	{
		return ch;
	}
}
*/

/* Returns a temporary buffer with the
	lower case string 
*/
char* gaNoCaseString(const char* me)
{
	static char buff[1024];
	int i = 0;

	while(me[i] && i < 1024)
	{
		buff[i++] = tolower(me[i]);
	}
	buff[i] = 0;

	return buff;
}

/* 
   Determines whether a given string appears in a 
   semicolon-separated list. Lower case only.
*/
qboolean gaIsInList(const char* me, const char* list)
{
	char map[20][48];
	int i = 0; /* iter: me */
	int j = 0; /* iter: one name */
	int k = 0; /* iter: name number */
	char ch;

	/* clear the table */
	for(k = 0 ; k < 20 ; k++)
	{
		map[k][0] = 0;
	}
	k = 0 ;

	/* fill the table */
	while(ch = list[i++])
	{
		if (ch == ';')
		{
			map[k++][j] = 0;
			j=0;
		}
		else
		{
			map[k][j++]= tolower(ch);
		}
	}
	map[k][j] = 0;

	/* compare them all */
	for(k = 0 ; k < 20 ; k++)
	{
		if (!strcmp(me, map[k]))
		{
			return qtrue;
		}
	}
	/*if (me[0] == 0) 
		return qtrue;*/

	return qfalse ;
}

/* Is that name black-listed ? */
qboolean gaCheckThatName(const char* me, const char* blacklist)
{
	char		buff[48];
	char		ch;
	int			i		= 0; /* iter: me, black  */
	int			j		= 0; /* iter: buff       */

	while((ch = me[i++]) && i < 48)
	{
		if (ch == ' ' || ch == '_' || ch == '-')
		{ /* ignore */
		}
		else if (ch == Q_COLOR_ESCAPE)
		{ /* ignore that and the next one */
			if(!me[i++]) 
				break;
		}
		else
		{ /* clean char */
			buff[j++] = ch;
		}
	}
	buff[j] = 0;


	/* at this point, the name is clean and colorless */

	return gaIsInList(gaNoCaseString(buff), blacklist);
}

int gaNameColorLessLength(const char* netname)
{
	char ch;
	int i = 0;
	int C = 0;
	int l = strlen(netname);
	
	while(ch = netname[i++])
	{
		if (ch == Q_COLOR_ESCAPE)
			C++;
	}

	return l-(2*C);
}

/*********************************************/

/* returns a temporary entity from a client number */
gentity_t* gaEntity(int clientNum)
{
	static gentity_t* ent;

	ent = g_entities + clientNum;
	if ( !ent->client ) 
	{ /* client not fully in game */
		return NULL;
	}
	return ent;
}

/* shows a console message to selected client */
void gaMsg(const int clientNum, const char* text)
{
	trap_SendServerCommand(clientNum, va("print \"%s\n\"", text));
}

/* displays a message for everyone to see */
void gaDisplay(const char* text)
{
	gaMsg(-1, text);
}

/* execs console command */
void gaCmd(const char* text)
{
	trap_SendConsoleCommand(EXEC_NOW, va("%s\n", text));
}

/* puts spaces to have a perfect text block. Align
-1  left
 0  center NOT IMPLEMENTED!
 1  right
 There may be a native way to do that in C, but I don't know :P
*/
void gaTabulatedText(const char* text, char* buff, int length, int side)
{
	int text_length = strlen(text);
	int diff		= text_length - length;
	int i;
	if (diff >= 0) 
	{ /* text too large... cut it ! */
		for(i = 0 ; i < length ; i++)
		{
			buff[i] = text[i];
		}
		buff[length] = 0;
		return;
	}
	switch (side)
	{
	case -1:
		Q_strncpyz(buff, text, length);
		for(i = text_length ; i < length ; i++)
		{
			buff[i] = ' ';
		}
		buff[length] = 0;
		break;
	case 0:

		break;
	case 1:
		for (i = 0 ; i < -diff ; i++)
		{
			buff[i] = ' ';
		}
		for(i = -diff ; i < length ; i++)
		{
			buff[i] = text[i+diff];
		}
		buff[length] = 0;		
	}
}

/*********************************************/

/* displays help text to client */
void gaCmd_help(gentity_t *ent)
{
	gaMsg(ent->client->pers.clientNum, va
		(
		ggl
		ggt "HELP, INFORMATION ON THE MOD" ggl
		ggt "----------------------------" ggl
		ggl
		ggn "Mod information:" ggl
		ggi "version: " GAMEVERSION ggl
		ggi "build  : " __DATE__ ggl
		ggi "author : ^5G^7amall ^5W^7ednesday ^5I^7da" ggl
		ggn "More information on:" ggl
		ggi "http://gamall-ida.com" ggl
		ggi "Feel free to report bugs and" ggl
		ggi "suggest features there :-)" ggl
		ggn "Client-side commands:" ggl
		ggi "/h(elp): Displays this help screen" ggl
		ggi "/l(ist): Lists connected users" ggl
		ggi "/t(ime): Displays current server time" ggl
		ggi "/info  : Displays server info, rules etc" ggl
		));
}

/* displays list of connected players to client */
void gaCmd_list(gentity_t *ent)
{
	int i;
	gentity_t* o;

	char buffname[64];
	int clnamel, namel;

	gaMsg(ent->client->pers.clientNum, va
		(
		ggt "Listing connected users..." ggl		
		));
	for(i = 0; i < MAX_CLIENTS ; i++)
	{
		if((o = gaEntity(i)) && o->client->pers.connected)
		{
			/* format the netname */
			clnamel = gaNameColorLessLength(o->client->pers.netname);
			namel   = strlen(o->client->pers.netname);
			gaTabulatedText(o->client->pers.netname, buffname, 24 + namel - clnamel, -1);			

			gaMsg(ent->client->pers.clientNum, va
				(
				"%2d: ^7%s^7 score: %2d deaths: %2d ping: %3d time: %3d"
				, o->client->pers.clientNum
				, buffname
				, o->client->ps.persistant[PERS_SCORE]
				, o->client->ps.persistant[PERS_KILLED]
				, o->client->ps.ping < 999 ? 
					o->client->ps.ping : 
					999
				, (level.time - o->client->pers.enterTime)/60000
				));
		}		
	}
}

/* displays current server time to client */
void gaCmd_time(gentity_t *ent)
{
/*
	__int64 rawtime;
	struct tm *timeinfo;

	time ( &rawtime );
	timeinfo = localtime ( &rawtime );
*/
	long long rawtime;
	struct tm * timeinfo;

	time ( &rawtime );
	timeinfo = localtime ( &rawtime );

	gaMsg(ent->client->pers.clientNum, va
		(
		ggt "Server Time:" ggl
		ggn "%s",
		asctime(timeinfo)
		));

}

/* returns a string with current date and time */
char* gaGetCurrentTime()
{
	
/*
	__int64 rawtime;
	struct tm *timeinfo;

	time ( &rawtime );
	timeinfo = localtime ( &rawtime );
*/
	long long rawtime;
	struct tm *timeinfo;

	time ( &rawtime );
	timeinfo = localtime ( &rawtime );
	return asctime(timeinfo);

}

/* displays server custom info to client */
void gaCmd_info(gentity_t *ent)
{
	char gaServerInfo[1024];
	trap_Cvar_VariableStringBuffer("ga_serverInfo", gaServerInfo, 1024);

	gaMsg(ent->client->pers.clientNum, va
		(
		ggt "Server Info:" ggl
		"%s",
		gaServerInfo
		));

}

/* prepare to write on connect log */
void gaInitConnectLog()
{
	gaConnectLog = fopen(GA_CONNECT_LOG_FILENAME, "a");
	if (gaConnectLog == NULL)
	{
		G_Printf("ERROR: Cannot open security log file %s", GA_CONNECT_LOG_FILENAME);
	}
	else 
	{
		G_Printf("Log file %s opened successfully", GA_CONNECT_LOG_FILENAME);
	}
}

/* write line in the connect log. Time will be added */
void gaWriteToConnectLog(const char *log)
{
	char timebuff [255] ;
	int len, i=0;
	char ch;


	if (gaConnectLog != NULL)
	{
		strcpy(timebuff, gaGetCurrentTime());
		while(ch = timebuff[i++])
		{
			if (ch == '\n') timebuff[--i] = 0;
		}

		len = strlen(log) + strlen(timebuff);
		fwrite(
			va("[%s] %s", 
				timebuff, log),
			sizeof(char), len + 3, gaConnectLog);

		fputc('\n', gaConnectLog);
	}
}

/* prints an emlpy line in the connect log */
void gaEmptyLineToConnectLog()
{
	if (gaConnectLog != NULL)
	{
		fputc('\n', gaConnectLog);
	}
}
