' ---------------------------------
'       title:	(SLFC) - Smarsch's LogFile Converter for JKA
'      author:	SMARSCH
'     website:	http://home.tiscali.ch/mbtis/smarsch/
'     version:	1.2
'        date:	17. May 2006
' description:	make "Jedi Knight Academy" game-server-logfile readable.
'		drag&drop "games.log" icon over this script icon.
'		it saves a new converted text-file at the same place, with date & time in filename.
'		works also with logFiles from other games, e.g. JK2_Outcast...
'    argument:	file-path to "games.log"
' ---------------------------------

vbLF2       = vbLF & vbLF
vers        = "1.2"
smaProgName = "SMARSCH's JKA logfile-converter" & " v" & vers

Set fs      = CreateObject("Scripting.FileSystemObject")

' ---------------------------------

if WScript.Arguments.count = 0 then _
 msgbox "make 'Jedi Knight Academy' game-server-logfile readable." & vblf2 & _
         "drag&drop 'games.log' icon over this script icon." & vblf2 & _
          "it saves a new converted text-file at the same place," & vblf & _
           "with date & time in filename.", _
            vbInformation+vbSystemModal, smaProgName _
             : quit() : wscript.quit

if WScript.Arguments.count <> 1 then _
 msgbox "only 1 file allowed.", vbExclamation+vbSystemModal, smaProgName _
  : quit() : wscript.quit

arg = WScript.Arguments.item(0)

if fs.FileExists(arg) = false then _
 msgbox "file not found:" & vbLF2 & arg, vbExclamation+vbSystemModal, smaProgName _
  : quit() : wscript.quit

' ---------------------------------

if fs.GetFileName(arg) = "games.log" then
 convLog(arg)
else
 msgbox "wrong file:" & vbLF2 & arg, vbExclamation+vbSystemModal, smaProgName
end if

quit()

' ---------------------------------

sub quit()
 Set fs = nothing
end sub

sub convLog(strFilePath)
 Set f = fs.OpenTextFile(strFilePath, 1)
  strLog = f.ReadAll
 f.close
 StrLog = rxpRepl2("\n", vbNewLine, StrLog)	' chr(10)
 StrLog = rxpRepl2("\^\d", "", StrLog)		' ^0 - ^9
 nfl = newFileName(strFilePath)
 set f = fs.CreateTextFile(nfl, false)
  f.write StrLog
 f.close
 msgbox "readable logfile saved to:" & vbLF2 & nfl, vbInformation+vbSystemModal, smaProgName
end sub

function newFileName(strFilePath)
 strCurDateTime = Now
 strNewDateTime = addLeadZ(Day(strCurDateTime)) & "." & _
                   addLeadZ(Month(strCurDateTime)) & "." & _
                    Year(strCurDateTime) & "_" & _
                     addLeadZ(Hour(strCurDateTime)) & "~" & _
                      addLeadZ(Minute(strCurDateTime)) & "~" & _
                       addLeadZ(Second(strCurDateTime))
 newFileName = strFilePath & "_" & strNewDateTime & ".txt"
end function

Function addLeadZ(strNum)
 if strNum < 10 and Len(strNum) = 1 then strNum = "0" & strNum
 addLeadZ = strNum
End Function

Function rxpRepl2(strPtrn, strRepl, strVal)
 Set objRxp = New RegExp
 objRxp.Pattern = strPtrn
 objRxp.IgnoreCase = true
 objRxp.Global = true
 rxpRepl2 = objRxp.Replace(strVal, strRepl)
End Function

' ---------------------------------
