;;; Code for the form named :form1 of class dialog.
;;; The code for recreating the window is auto-generated into 
;;; the *.bil file having the same name as this *.cl file.

(in-package :common-graphics-user)

(defclass keydialog (dialog)())

;; the value 1-4 for the modifier (shift,ctrl,..) key, here default ctrl
(defvar *modifierKey* 2)
;; the value charcode for the second key, here default J
(defvar *keyKey* 69)


;; initialization of the key settings happens through this function, called by the main window
(defmethod setHotKey ((dialog keydialog) modifierKey keyKey)
  (let ((keyString (make-string 1 :initial-element (code-char keyKey)))
        (modString ""))
    (cond 
     ((equal modifierKey 1)(setq modString "Alt"))
     ((equal modifierKey 2)(setq modString "Ctrl"))
     ((equal modifierKey 3)(setq modString "Shift"))
     ((equal modifierKey 4)(setq modString "Win")))
    ;; set dialogue
    (setf (value (find-named-object :modifierbox dialog)) modString)
    (initialize-value (find-named-object :keytext dialog) keyString)
    (setf *modifierKey* modifierKey)
    (setf *keyKey* keyKey)))


;; GUI EVENT PROCESSING

;; cancel-button closes the window
(defun keydialog-cancel-button-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (user-close dialog))

;; ok button sets the new keys on the main window an closes the window
(defun keydialog-ok-button-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (let ((owner (owner dialog)))
    (declare (ignore-if-unused dialog widget))
    (user-close dialog)
    (setHotKey owner *modifierKey* *keyKey*)
    ))

;; a modification of the modifier listbox sets the *modifierKey* value
(defun keydialog-modifierbox-on-change (widget new-value old-value)
  (declare (ignore-if-unused widget new-value old-value))
  (cond 
   ((string-equal new-value "Alt")(setq *modifierKey* 1))
   ((string-equal new-value "Ctrl")(setq *modifierKey* 2)))
  t)

;; a modification of the key textbox sets the *keyKey* value
(defun keydialog-keytext-on-change (widget new-value old-value)
  (declare (ignore-if-unused widget new-value old-value))
  (setf *keyKey* (char-code (elt (string-upcase new-value) 0))))
