;;; Code for the form named :consolespawnmain of class dialog.
;;; The code for recreating the window is auto-generated into 
;;; the *.bil file having the same name as this *.cl file.

(in-package :common-graphics-user)

;; keep track of all the properties that will be written to file and read upon initialization
(defvar *properties* (list 'modifierkey 2 'key (char-code #\E) 'basepath (current-directory) 'assocSaberSingle nil 'assocSaberStaff nil 'assocMaps nil 'assocNpcEnemy nil 'assocNpcPlayer nil 'assocNpcFree nil 'assocVehicle nil 'rangeSaberSingle nil 'rangeSaberStaff nil 'rangeMaps nil 'rangeNpcEnemy nil 'rangeNpcPlayer nil 'rangeNpcFree nil 'rangeVehicle nil 'processedPk3s nil))

;; consolespawn main
(defclass consolespawnmain (dialog)())

;; WIN32 USAGE

(load "user32.dll")

(ff:def-foreign-call (userRegisterHotKey "RegisterHotKey") nil)

(ff:def-foreign-call (userAttachThreadInput "AttachThreadInput") nil)

(ff:def-foreign-call (userExitProcess "ExitProcess") nil)

(ff:def-foreign-call (userGetExitCodeProcess "GetExitCodeProcess") nil)

;; force close needed because of hotkey listener
(defmethod user-close ((consolespawn consolespawnmain))
  (let ((exitcode (ff:allocate-fobject 'WIN:LPDWORD)))
  (userGetExitCodeProcess (handle consolespawn) exitcode)
  (userExitProcess (handle consolespawn) exitcode)
))

;; register the global hotkey
(defmethod registerHotkey ((consolespawn consolespawnmain))
  (let ((keyMod (getf *properties* 'modifierkey))
        (key (getf *properties* 'key)))
    (userRegisterHotKey (handle consolespawn) 0 keyMod key)
    (listenForHotKey consolespawn)
    )
  )

;; listen for a hotkey event
(defmethod listenForHotKey ((consolespawn consolespawnmain))
  (let ((msg (ff:allocate-fobject 'WINDOWS:MSG)))
    (do ((ret (win:GetMessage msg 0 0 0)(win:GetMessage msg 0 0 0)))
        ((not ret))
      (win:TranslateMessage msg)
      (cond ((= (ff:fslot-value msg 'message) 786)
             (performHotkey consolespawn))
            )
      (win:DispatchMessage msg)
      )
    ))

;; perform the action bounded to the hotkey; minimize/maximize JKA/ConsoleSpawn main window
(defmethod performHotkey ((consolespawn consolespawnmain))
  (progn 
    ;; different handle detection depending on wether MP or SP JKA is running
    (if (getMp consolespawn)
        (let ((fore (win:getforegroundwindow)))
          (hideSPFeatures consolespawn)          
          (win:setwindowpos fore win:hwnd_notopmost 0 0 0 0 (+ win:swp_nosize win:swp_nomove))
          (userAttachThreadInput (win:getwindowthreadprocessid fore 0) (win:getwindowthreadprocessid (handle consolespawn) 0) win:true)
          (win:setforegroundwindow (handle consolespawn))
          (win:setwindowpos (handle consolespawn) win:hwnd_topmost 0 0 0 0 (+ win:swp_nosize win:swp_nomove))
          (userAttachThreadInput (win:getwindowthreadprocessid fore 0) (win:getwindowthreadprocessid (handle consolespawn) 0) win:false)
          )
        (let ((fore (win:getforegroundwindow)))
          (hideMpFeatures consolespawn)
          (win:setwindowpos fore win:hwnd_notopmost 0 0 0 0 (+ win:swp_nosize win:swp_nomove))
          (userAttachThreadInput (win:getwindowthreadprocessid fore 0) (win:getwindowthreadprocessid (handle consolespawn) 0) win:true)
          (win:setforegroundwindow (handle consolespawn))
          (win:setwindowpos (handle consolespawn) win:hwnd_topmost 0 0 0 0 (+ win:swp_nosize win:swp_nomove))
          (userAttachThreadInput (win:getwindowthreadprocessid fore 0) (win:getwindowthreadprocessid (handle consolespawn) 0) win:false)
                  ))
    ;;(win:ShowWindow (handle consolespawn) win:SW_MAXIMIZE)
    )
  )

;; hide controls showing singleplayer-only features
(defmethod hideSPFeatures ((consolespawn consolespawnmain))
  (when (find-named-object :singlesaberleftlist consolespawn) (setf (available (find-named-object :singlesaberleftlist consolespawn)) nil))
  (when (find-named-object :singlesaberrightlist consolespawn) (setf (available (find-named-object :singlesaberrightlist consolespawn)) nil))
  (when (find-named-object :staffsaberlist consolespawn) (setf (available (find-named-object :staffsaberlist consolespawn)) nil))
  (when (find-named-object :staffsaberbox consolespawn) (setf (available (find-named-object :staffsaberbox consolespawn)) nil))
  (when (find-named-object :singlesaberbox consolespawn) (setf (available (find-named-object :singlesaberbox consolespawn)) nil))
  (when (find-named-object :leftsaberlabel consolespawn) (setf (available (find-named-object :leftsaberlabel consolespawn)) nil))
  (when (find-named-object :rightsaberlabel consolespawn) (setf (available (find-named-object :rightsaberlabel consolespawn)) nil))
  (when (find-named-object :givesaber consolespawn) (setf (available (find-named-object :givesaber consolespawn)) nil))
  (when (find-named-object :restorejkasaber consolespawn) (setf (available (find-named-object :restorejkasaber consolespawn)) nil))
  (when (find-named-object :spcheatsbox consolespawn) (setf (available (find-named-object :spcheatsbox consolespawn)) nil))
  (when (find-named-object :forceleveltext consolespawn) (setf (available (find-named-object :forceleveltext consolespawn)) nil))
  (when (find-named-object :forcelevelcombo consolespawn) (setf (available (find-named-object :forcelevelcombo consolespawn)) nil))
  (when (find-named-object :forcelevelbutton consolespawn) (setf (available (find-named-object :forcelevelbutton consolespawn)) nil))
  (when (find-named-object :sabercolortext consolespawn) (setf (available (find-named-object :sabercolortext consolespawn)) nil))
  (when (find-named-object :saberlocationcombo consolespawn) (setf (available (find-named-object :saberlocationcombo consolespawn)) nil))
  (when (find-named-object :colorcombo1 consolespawn) (setf (available (find-named-object :colorcombo1 consolespawn)) nil))
  (when (find-named-object :colorcombo2 consolespawn) (setf (available (find-named-object :colorcombo2 consolespawn)) nil))
  (when (find-named-object :sabercolorbutton consolespawn) (setf (available (find-named-object :sabercolorbutton consolespawn)) nil))
  (when (find-named-object :abilitieslabel consolespawn) (setf (available (find-named-object :abilitieslabel consolespawn)) nil))
  (when (find-named-object :abilitiescombo consolespawn) (setf (available (find-named-object :abilitiescombo consolespawn)) nil))
  (when (find-named-object :abilitieslevelcombo consolespawn) (setf (available (find-named-object :abilitieslevelcombo consolespawn)) nil))
  (when (find-named-object :abilitiesbutton consolespawn) (setf (available (find-named-object :abilitiesbutton consolespawn)) nil))
  (when (find-named-object :freezebutton consolespawn) (setf (available (find-named-object :freezebutton consolespawn)) nil))
  (when (find-named-object :unfreezebutton consolespawn) (setf (available (find-named-object :unfreezebutton consolespawn)) nil))
  (when (find-named-object :iknowkungfubutton consolespawn) (setf (available (find-named-object :iknowkungfubutton consolespawn)) nil))
  (when (find-named-object :corpsesstayon consolespawn) (setf (available (find-named-object :corpsesstayon consolespawn)) nil))
  (when (find-named-object :corpseshidebutton consolespawn) (setf (available (find-named-object :corpseshidebutton consolespawn)) nil))
  (when (find-named-object :enablecheats consolespawn) (setf (available (find-named-object :enablecheats consolespawn)) nil))
  (when (find-named-object :disablecheats consolespawn) (setf (available (find-named-object :disablecheats consolespawn)) nil))
  (when (find-named-object :becomenpcfree consolespawn) (setf (available (find-named-object :becomenpcfree consolespawn)) nil))
  (when (find-named-object :becomenpcplayer consolespawn) (setf (available (find-named-object :becomenpcplayer consolespawn)) nil))
  (when (find-named-object :becomenpcenemy consolespawn) (setf (available (find-named-object :becomenpcenemy consolespawn)) nil))
  (when (find-named-object :loadmapwithcheats consolespawn) (setf (available (find-named-object :loadmapwithcheats consolespawn)) t))
  )

;; hide controls showing multiplayer-only features
(defmethod hideMPFeatures ((consolespawn consolespawnmain))
  (when (find-named-object :loadmapwithcheats consolespawn) (setf (available (find-named-object :loadmapwithcheats consolespawn)) nil))
  (when (find-named-object :singlesaberleftlist consolespawn) (setf (available (find-named-object :singlesaberleftlist consolespawn)) t))
  (when (find-named-object :singlesaberrightlist consolespawn) (setf (available (find-named-object :singlesaberrightlist consolespawn)) t))
  (when (find-named-object :staffsaberlist  consolespawn) (setf (available (find-named-object :staffsaberlist consolespawn)) t))
  (when (find-named-object :staffsaberbox consolespawn) (setf (available (find-named-object :staffsaberbox consolespawn)) t))
  (when (find-named-object :singlesaberbox  consolespawn) (setf (available (find-named-object :singlesaberbox consolespawn)) t))
  (when (find-named-object :leftsaberlabel consolespawn) (setf (available (find-named-object :leftsaberlabel consolespawn)) t))
  (when (find-named-object :rightsaberlabel consolespawn) (setf (available (find-named-object :rightsaberlabel consolespawn)) t))
  (when (find-named-object :givesaber consolespawn) (setf (available (find-named-object :givesaber consolespawn)) t))
  (when (find-named-object :restorejkasaber consolespawn) (setf (available (find-named-object :restorejkasaber consolespawn)) t))
  (when (find-named-object :spcheatsbox consolespawn) (setf (available (find-named-object :spcheatsbox consolespawn)) t))
  (when (find-named-object :forceleveltext consolespawn) (setf (available (find-named-object :forceleveltext consolespawn)) t))
  (when (find-named-object :forcelevelcombo consolespawn) (setf (available (find-named-object :forcelevelcombo consolespawn)) t))
  (when (find-named-object :forcelevelbutton consolespawn) (setf (available (find-named-object :forcelevelbutton consolespawn)) t))
  (when (find-named-object :sabercolortext consolespawn) (setf (available (find-named-object :sabercolortext consolespawn)) t))
  (when (find-named-object :saberlocationcombo consolespawn) (setf (available (find-named-object :saberlocationcombo consolespawn)) t))
  (when (find-named-object :colorcombo1 consolespawn) (setf (available (find-named-object :colorcombo1 consolespawn)) t))
  (when (find-named-object :colorcombo2 consolespawn) (setf (available (find-named-object :colorcombo2 consolespawn)) t))
  (when (find-named-object :sabercolorbutton consolespawn) (setf (available (find-named-object :sabercolorbutton consolespawn)) t))
  (when (find-named-object :abilitieslabel consolespawn) (setf (available (find-named-object :abilitieslabel consolespawn)) t))
  (when (find-named-object :abilitiescombo consolespawn) (setf (available (find-named-object :abilitiescombo consolespawn)) t))
  (when (find-named-object :abilitieslevelcombo consolespawn) (setf (available (find-named-object :abilitieslevelcombo consolespawn)) t))
  (when (find-named-object :abilitiesbutton consolespawn) (setf (available (find-named-object :abilitiesbutton consolespawn)) t))
  (when (find-named-object :freezebutton consolespawn) (setf (available (find-named-object :freezebutton consolespawn)) t))
  (when (find-named-object :unfreezebutton consolespawn) (setf (available (find-named-object :unfreezebutton consolespawn)) t))
  (when (find-named-object :iknowkungfubutton consolespawn) (setf (available (find-named-object :iknowkungfubutton consolespawn)) t))
  (when (find-named-object :corpsesstayon consolespawn) (setf (available (find-named-object :corpsesstayon consolespawn)) t))
  (when (find-named-object :corpseshidebutton consolespawn) (setf (available (find-named-object :corpseshidebutton consolespawn)) t))
  (when (find-named-object :enablecheats consolespawn) (setf (available (find-named-object :enablecheats consolespawn)) t))
  (when (find-named-object :disablecheats consolespawn) (setf (available (find-named-object :disablecheats consolespawn)) t))
  (when (find-named-object :becomenpcfree consolespawn) (setf (available (find-named-object :becomenpcfree consolespawn)) t))
  (when (find-named-object :becomenpcenemy consolespawn) (setf (available (find-named-object :becomenpcenemy consolespawn)) t))
  (when (find-named-object :becomenpcplayer consolespawn) (setf (available (find-named-object :becomenpcplayer consolespawn)) t))
  )

;; maximize JKA
;;      (win:setforegroundwindow (win:FindWindow (string-to-native "Jedi Knight: Jedi Academy (MP)") 0))
;;      (win:ShowWindow (win:FindWindow (string-to-native "Jedi Knight: Jedi Academy (MP)") 0) win:SW_MAXIMIZE)
;;      (win:setforegroundwindow (win:FindWindow (string-to-native "Jedi Knight: Jedi Academy") 0))
;;      (win:ShowWindow (win:FindWindow (string-to-native "Jedi Knight: Jedi Academy") 0) win:SW_MAXIMIZE)
(defmethod hideWindow ((consolespawn consolespawnmain))
  (progn
    (if (getMp consolespawn)
        (win:setforegroundwindow (win:FindWindow (string-to-native "Jedi Knight: Jedi Academy (MP)") 0))
      (win:setforegroundwindow (win:FindWindow (string-to-native "Jedi Knight: Jedi Academy") 0))
      )
    (listenForHotkey consolespawn)
    ))

;; set wether mp jka is running or not
(defmethod getMp ((consolespawn consolespawnmain))
  (let ((handle (win:FindWindow (string-to-native "JK2MP WinConsole") 0)))
    (if (equalp handle 0) t nil
      )))

;; perform a JKA Command
(defmethod performCommand ((consolespawn consolespawnmain) commandStr)
  (let ((handle (win:FindWindow (string-to-native "JK2MP WinConsole") 0)))
    (progn
      (if (equalp handle 0)
          (setq handle (win:FindWindow (string-to-native "JAMP WinConsole") 0)))
      ;; send the command to the JKA Console + enter
      (win:SendMessage (win:GetWindow handle win:GW_CHILD) win:WM_SETTEXT 0 (string-to-native commandStr))
      (win:SendMessage (win:GetWindow handle win:GW_CHILD) win:WM_CHAR 13 1)
      (listenForHotkey consolespawn)
      )))

(defmethod initialize-instance :after ((consolespawn consolespawnmain) &key &allow-other-keys)
  ;; test for a present properties file
  (if (probe-file (merge-pathnames "ConsoleSpawn.ini"))
          (progn
            (readProperties)
            (fillRanges consolespawn))
        (progn
          ;; no properties file present means first run, get the base folder location from the user and scan its contents
          (displayMsg "Welcome to ConsoleSpawn" "Because this is the first time you run ConsoleSpawn, you'll need to select the base Folder for your installation. That folder will than be scanned for Pk3's. You can modify the Base folder later using the 'Set Base' button.")
          (if (selectBase)(progn (loadPk3s)(fillRanges consolespawn)))))
  (registerHotkey consolespawn))

;; display a message window
(defun displayMsg (title message)
  (with-native-string (msg message)
    (with-native-string (ttl title)
      (win:MessageBox 0 msg ttl win:MB_OK)))
  )

;; RETRIEVE INFORMATION FROM THE HARD DISK

;; read the pk3s, write and read (display to user) the results
(defun loadPk3s ()
  (cg:with-hourglass
    (setf (getf *properties* 'assocSaberSingle) nil)
    (setf (getf *properties* 'assocSaberStaff) nil)
    (setf (getf *properties* 'assocMaps) nil)
    (setf (getf *properties* 'assocNpcEnemy) nil)
    (setf (getf *properties* 'assocNpcPlayer) nil)
    (setf (getf *properties* 'assocNpcFree) nil)
    (setf (getf *properties* 'assocVehicle) nil)
    (setf (getf *properties* 'rangeSaberSingle) nil)
    (setf (getf *properties* 'rangeSaberStaff) nil)
    (setf (getf *properties* 'rangeMaps) nil)
    (setf (getf *properties* 'rangeNpcEnemy) nil)
    (setf (getf *properties* 'rangeNpcPlayer) nil)
    (setf (getf *properties* 'rangeNpcFree) nil)
    (setf (getf *properties* 'rangeVehicle) nil)
    (setf (getf *properties* 'processedPk3s) nil)
    (readPk3s)
    (writeProperties)
    (readProperties)
    ))

;; read the *new* pk3s, write and read (display to user) the results
(defun reloadPk3s ()
  (cg:with-hourglass
    (reReadPk3s)
    (writeProperties)
    (readProperties)
    ))

;; list the Pk3 files present in a certain folder
(defun listPk3s (searchRoot)
  ;; list all pk3's in the directory
  (let* ((files nil))
    (dolist (file (sort
                   (handler-case
                       (directory searchRoot :directories-are-files nil)
                     (error (c)
                       (declare (ignore c))
                       nil))
                   #'(lambda (pathname1 pathname2)
                       (string-lessp (namestring pathname1)
                                     (namestring pathname2)))))
      (let ((fileExtension (pathname-type file)))
        (if (string-equal fileExtension "pk3")
            (push file files))
        ))
    files))
    
;; sort the lists of keys alfabetically for display to the user
(defun sortRanges ()
  (setf (getf *properties* 'rangeSaberSingle)(sort (getf *properties* 'rangeSaberSingle) #'string-lessp))
  (setf (getf *properties* 'rangeSaberStaff)(sort (getf *properties* 'rangeSaberStaff) #'string-lessp))
  (setf (getf *properties* 'rangeMaps)(sort (getf *properties* 'rangeMaps) #'string-lessp))
  (setf (getf *properties* 'rangeNpcEnemy)(sort (getf *properties* 'rangeNpcEnemy) #'string-lessp))
  (setf (getf *properties* 'rangeNpcPlayer)(sort (getf *properties* 'rangeNpcPlayer) #'string-lessp))
  (setf (getf *properties* 'rangeNpcFree)(sort (getf *properties* 'rangeNpcFree) #'string-lessp))
  (setf (getf *properties* 'rangeVehicle)(sort (getf *properties* 'rangeVehicle) #'string-lessp)))

;; get the information from the pk3 files and save into the *properties* variable
(defun readPk3s ()
  (let* ((localPath (getf *properties* 'basePath))
         (pk3List (listPk3s localPath))
         (processedFiles nil))
    ;; go through all pk3s
    (dolist (pk3PathName pk3List)
      (addToRange 'processedPk3s (namestring pk3PathName))
      (zip:with-zipfile (pk3File pk3PathName)
        ;; go through all entries of the zip files        
        (zip:DO-ZIPFILE-ENTRIES (entryName entryHandle pk3File)
          (if (not (member entryName processedFiles :test #'string-equal))
              (let* ((nameLength (length entryName))
                     (entryShortType (subseq entryName (- nameLength 3)))
                     (entryLongType (subseq entryName (- nameLength 5))))
                (if (string-equal entryShortType "npc")
                    (progn
                      (push entryName processedFiles)
                      (parseNpc (toStringStream (zip:ZIPFILE-ENTRY-CONTENTS entryHandle))))
                  (if (string-equal entryShortType "sab")
                      (progn
                        (push entryName processedFiles)
                        (parseSab (toStringStream (zip:ZIPFILE-ENTRY-CONTENTS entryHandle))))
                    (if (string-equal entryLongType "arena")
                        (progn
                          (push entryName processedFiles)
                          (parseArena (toStringStream (zip:ZIPFILE-ENTRY-CONTENTS entryHandle)))
                          ))))
                )
            )
          )))
    (sortRanges)
    )
  )

;; get the information from the *new* pk3 files and save into the *properties* variable

;; filetypes to be parsed by this application;
;; ext_data\sabers\*.sab
;; ext_data\npcs\*.npc
;; scripts\*.arena

(defun reReadPk3s ()
  (let* ((localPath (getf *properties* 'basePath))
         (pk3List (listPk3s localPath))
         (processedFiles nil))
    ;; go through all pk3s
    (dolist (pk3PathName pk3List)
      (if (not (member (namestring pk3PathName) (getf *properties* 'processedPk3s) :test #'string-equal))
      (progn 
      (addToRange 'processedPk3s (namestring pk3PathName))
      (zip:with-zipfile (pk3File pk3PathName)
        ;; go through all entries of the zip files        
        (zip:DO-ZIPFILE-ENTRIES (entryName entryHandle pk3File)
          (if (not (member entryName processedFiles :test #'string-equal))
              (let* ((nameLength (length entryName))
                     (entryShortType (subseq entryName (- nameLength 3)))
                     (entryLongType (subseq entryName (- nameLength 5))))
                (if (string-equal entryShortType "npc")
                    (progn
                      (push entryName processedFiles)
                      (parseNpc (toStringStream (zip:ZIPFILE-ENTRY-CONTENTS entryHandle))))
                  (if (string-equal entryShortType "sab")
                      (progn
                        (push entryName processedFiles)
                        (parseSab (toStringStream (zip:ZIPFILE-ENTRY-CONTENTS entryHandle))))
                    (if (string-equal entryLongType "arena")
                        (progn
                          (push entryName processedFiles)
                          (parseArena (toStringStream (zip:ZIPFILE-ENTRY-CONTENTS entryHandle)))
                          ))))
                ))
          )))
        ))
    (sortRanges)
    )
  )

;; transform the stream of unsignedbytes into a stream of strings
(defun toStringStream (byteVector)
  (make-string-input-stream 
   (map 'string
     #'(lambda (charcode) (code-char charcode))
     byteVector)))

;; add an element to one of the "range" lists in *properties* these are the lists of keys
(defun addToRange (symbol element)
  (setf (getf *properties* symbol) (adjoin element (getf *properties* symbol) :test #'string-equal)))

;; add a key-value pair to the "assoc" lists in *properties* the are the key-value pairs
(defun addToAssoc (symbol key value)
  (let ((assocList (getf *properties* symbol)))
    (if (not (member key assocList :key #'car :test #'string-equal))
        (setf (getf *properties* symbol) (acons key value assocList))))
  )

;; class to contain and determine saber information retained by parsing
(defclass sab ()(identifier name saberType))

;; parse a saber file and transfer the information from sab objects into the assoclist in *properties*
(defun parseSab (stream)
  (let ((objectList (parseConfig 'sab stream)))
    (dolist (object objectList)
      (let* ((type (if (slot-boundp object 'saberType)(slot-value object 'saberType) ""))
             (sab-identifier (if (slot-boundp object 'identifier)(slot-value object 'identifier) nil))
             (sab-name (if (slot-boundp object 'name)(slot-value object 'name) sab-identifier)))
        ;; distinguish between single and staff type sabers
        (cond
         ((string-equal type "SABER_SINGLE") (progn
                                               (addToRange 'rangeSaberSingle sab-name)
                                               (addToAssoc 'assocSaberSingle sab-name sab-identifier)))
         ((string-equal type "SABER_STAFF") (progn
                                              (addToRange 'rangeSaberStaff sab-name)
                                              (addToAssoc 'assocSaberStaff sab-name sab-identifier))))
        ))
    ))

;; class to contain and determine npc information retained by parsing
(defclass npc ()(identifier fullName playerTeam class))

;; parse an npc file and transfer the information from npc objects into the assoclist in *properties*
(defun parseNpc (stream)
  (let ((objectList (parseConfig 'npc stream)))
    (dolist (object objectList)
      (let* ((team (if (slot-boundp object 'playerTeam)(slot-value object 'playerTeam) ""))
             (class (if (slot-boundp object 'class)(slot-value object 'class) ""))
             (npc-identifier (if (slot-boundp object 'identifier)(slot-value object 'identifier) nil))
             (npc-fullName (if (slot-boundp object 'fullName)(slot-value object 'fullName) npc-identifier)))
        ;; distinguish between vehicles and characters
        (if (string-equal class "CLASS_VEHICLE")
            (progn
              (addToRange 'rangeVehicle npc-fullName)
              (addToAssoc 'assocVehicle npc-fullName npc-identifier))
          (cond
           ;; distinguish between the alignment of the characters
           ((string-equal team "TEAM_NEUTRAL") (progn
                                                 (addToRange 'rangeNpcFree npc-fullName)
                                                 (addToAssoc 'assocNpcFree npc-fullName npc-identifier)))
           ((string-equal team "TEAM_FREE") (progn
                                              (addToRange 'rangeNpcFree npc-fullName)
                                              (addToAssoc 'assocNpcFree npc-fullName npc-identifier)))
           ((string-equal team "TEAM_ENEMY") (progn
                                               (addToRange 'rangeNpcEnemy npc-fullName)
                                               (addToAssoc 'assocNpcEnemy npc-fullName npc-identifier)))
           ((string-equal team "TEAM_PLAYER") (progn
                                                (addToRange 'rangeNpcPlayer npc-fullName)
                                                (addToAssoc 'assocNpcPlayer npc-fullName npc-identifier)))
           )
          )))
    ))

;; determine the information retained from parsed arena files
(defclass arena ()(longname map))

;; parse an arena file and transfer the information from arena objects into the assoclist in *properties*
(defun parseArena (stream)
  (let ((objectList (parseConfig 'arena stream)))
    (dolist (object objectList)
      (let* ((map-map (if (slot-boundp object 'map)(slot-value object 'map) nil))
             (map-longname (if (slot-boundp object 'longname)(slot-value object 'longname) map-map)))
        (addToAssoc 'assocMaps map-longname map-map)
        (addToRange 'rangeMaps map-longname)
        ))
    ))

;; utility functions

;; determine if a string contains another
(defun lineContains (lineString findString)
  (search findString lineString))

;; determine if a string is the equivalent of an empty line in a file
(defun lineEmpty (line)
  (let ((trimmedLine (string-trim '(#\Space #\Tab #\Newline #\Return) line)))
    (string-equal trimmedLine "")
    ))

;; remove leading and trailing spaces from a line
(defun trimLine (line)
  (string-trim '(#\Space #\Tab) line))

;; retrieve the first word from a line (determined by spaces)
(defun lineFirstWord (line)
  (let* ((trimmedLine (trimLine line))
         (spacePos (position #\Space trimmedLine))
         (tabPos (position #\Tab trimmedLine))
         (spaceIdx (if spacePos spacePos (if tabPos tabPos 0)))
         (tabIdx (if tabPos tabPos (if spacePos spacePos 0)))
         (wordEnd (if (> tabIdx spaceIdx) spaceIdx tabIdx)))
    ;; if the first word is followed by no spaces/tabs, simply return the line minus linebreaks
    (if (> wordEnd 0)
        (subseq trimmedLine 0 wordEnd)
      (string-trim '(#\Newline #\Return) trimmedLine))))

;; retrieve the first string (delimited by "") from the line
(defun lineFirstString (line)
  (let* ((trimmedLine (trimLine line))
         (stringEnd (position #\" trimmedLine :start 1)))
    (subseq trimmedLine 1 stringEnd)))

;; retrieve the value from a line with an identifier followed by a value, seperated by spaces, tabs
(defun lineValue (line)
  (let* ((trimmedLine (trimLine line))
         (property (lineFirstWord line))
         (rest (subseq trimmedLine (1+ (length property))))
         (trimmedRest (trimLine rest))
         (firstChar (elt trimmedRest 0)))
    ;; values can be strings or identifiers
    (if (char= firstChar #\")
        (lineFirstString trimmedRest)
      (lineFirstWord trimmedRest))
    ))

;; general parse function, parses a stream and returns a list of objects of a certain class

;; if line contains /* remove after and eval forgoing and ingnore next lines until */ remove before and continue
;; if line contains // remove rest and continue with begin
;; if line contains {, process preceding (identifier) remove preceding and start closure, process rest
;; if not inside closure remove left spacing, tabs ,read until spaceor end of line set identifier
;; if inside closure, remove left spacing and tabs read until space for identifier, remove spaces and tabs, if next starts with ", read until ", else read until base for value, process rest of line as new

(defun parseConfig (class stream) 
  ;; go through the lines
  (let ((commentBlock nil)
        (propertyBlock nil)
        (currentObject nil)
        (objectList nil)
        (currentIdentifier nil)
        (line (read-line stream nil :eof)))
    (while (not (eql line :eof))
      (cond ((and (lineContains line "/*") (lineContains line "*/"))
             ;;start and end blockcomment
             (let* ((startEnd (search "/*" line))
                    (endStart (+ (search "*/" line) 2))
                    (startString (subseq line 0 startEnd))
                    (endString (subseq line endStart)))
               ;; contine with block removed from line
               (setq line (trimLine (concatenate 'string startString endString)))))
            ((lineContains line "/*")
             ;;start blockcomment
             (let* ((startEnd (search "/*" line))
                    (startString (subseq line 0 startEnd)))         
               ;; contine with block removed from line
               (setq commentBlock t)
               (setq line (trimLine startString))))
            ((lineContains line "*/")
             ;;end blockcomment
             (let* ((endStart (+ (search "*/" line) 2))
                    (endString (subseq line endStart)))           
               ;; contine with block removed from line
               (setq commentBlock nil)
               (setq line (trimLine endString))))
            ((lineContains line "//")
             ;;commentline
             (let* ((startEnd (search "//" line))
                    (startString (subseq line 0 startEnd)))            
               ;; contine with comment removed from line
               (setq line (trimLine startString))))        
            ((and (not commentBlock)(lineContains line "{"))
             ;; start propertyblock
             (let* ((startEnd (search "{" line))
                    (endStart (1+ startEnd))
                    (identifierString (subseq line 0 startEnd))
                    (endString (subseq line endStart)))            
               ;; process possible identifier
               (if (not (lineEmpty identifierString))
                   (setq currentIdentifier (lineFirstWord identifierString)))
               (setq propertyBlock t)
               ;; create a new object to capture the properties from the property block
               (setq currentObject (make-instance class))
               ;; attempt to add the identifier property
               (if (slot-exists-p currentObject 'identifier)
                   (setf (slot-value currentObject 'identifier) currentIdentifier))
               (setq currentIdentifier nil)
               ;; contine properties removed from line
               (setq line (trimLine endString))))
            ((and (not commentBlock)(lineContains line "}"))
             ;; end propertyblock
             (let* ((startEnd (search "}" line))
                    (endStart (1+ startEnd))
                    (propertyString (subseq line 0 startEnd))
                    (endString (subseq line endStart)))             
               ;; process possible property
               (if (not (lineEmpty propertyString))
                   (let* ((propertyId (lineFirstWord propertyString))
                          (propertyValue (lineValue propertyString))
                          (propertySymbol (find-symbol (string-upcase propertyId) *package*)))
                     (if (slot-exists-p currentObject propertySymbol)
                         (setf (slot-value currentObject propertySymbol) propertyValue))))
               ;; add the completed object for the completed property block to the list of objects
               (setq objectList (push currentObject objectList))
               (setq propertyBlock nil)
               (setq currentObject nil)
               ;; contine properties removed from line
               (setq line (trimLine endString))))
            ((and (not commentBlock)(not propertyBlock)(not (lineEmpty line)))
             ;; identifier
             ;; store the identifier for possible use upon creation of an object
             (setq currentIdentifier (lineFirstWord line))
             ;; ignore rest of line
             (setq line (read-line stream nil :eof)))
            ((and (not commentBlock) propertyBlock (not (lineEmpty line)))
             ;; property
             (let* ((propertyId (lineFirstWord line))
                    (propertyValue (lineValue line))
                    (propertySymbol (find-symbol (string-upcase propertyId) *package*)))
               ;; only store properties that have a matching symbol-slot in the object
               (if (slot-exists-p currentObject propertySymbol)
                   (setf (slot-value currentObject propertySymbol) propertyValue))
               ;;ignore rest of line
               (setq line (read-line stream nil :eof))))
            (t (setq line (read-line stream nil :eof)))
            ))
    objectList))

;; READ AND WRITE PROPERTIES TO INI FILE

;; read the *properties* from the default file and update the gui
(defun readProperties ()
  (setq *properties* (readFile "ConsoleSpawn.ini")))

;; write the *properties* to the default ini file 
(defun writeProperties ()
  (writeFile *properties* "ConsoleSpawn.ini"))

;; read a certain file containing a list
(defun readFile (fileName)
  (let ((file (merge-pathnames fileName)))
    (with-open-file (stream file)
      (read stream))))

;; write a file to list
(defun writeFile (propertyList fileName)
  (let ((file (merge-pathnames fileName)))
    (with-open-file (stream file :direction :output 
                            :if-exists :supersede)
      (format stream "~S" propertyList))))


;; PROCESS GUI EVENTS

;; give the user a possibility to select the JKA Base folder location of his/her choice, return t/nil depending on success
(defun selectBase ()
  (let ((base (cg:ask-user-for-directory :prompt "Please select the Base directory for your JKA installation.")))
    (if (not (equal base nil))
        (let* ((basePath (namestring base))
               (last-char (aref basePath (1- (length basePath)))))
          (unless (member last-char '(#\\ #\/))
            (setq basePath (concatenate 'string basePath "\\")))
          (setf (getf *properties* 'basePath) basePath)
          (writeProperties)
          t)nil)))

;; display the hotkey window and update its contents to the *properties* key settings
(defun showHotKey (consolespawn)
  (let ((keydialog (make-keydialog :owner consolespawn)))
    (setHotKey keyDialog (getf *properties* 'modifierkey) (getf *properties* 'key))
    (select-window keydialog)))

;; receive the updated hotkey settings from the hotkey window
(defmethod setHotKey ((consolespawn consolespawnmain) modifierKey keyKey)
  (setf (getf *properties* 'modifierkey) modifierKey)
  (setf (getf *properties* 'key) keyKey)
  (writeProperties)
  (registerHotkey consolespawn)
  )

;; fill the ranges listsboxes
(defmethod fillRanges ((consolespawn consolespawnmain))
  ;; set the ranges of the gui elements
  (setf (range (find-named-object :npcplayerlist consolespawn)) (getf *properties* 'rangeNpcPlayer))
  (setf (range (find-named-object :npcenemylist consolespawn)) (getf *properties* 'rangeNpcEnemy))
  (setf (range (find-named-object :npcfreelist consolespawn)) (getf *properties* 'rangeNpcFree))
  (setf (range (find-named-object :vehiclelist consolespawn)) (getf *properties* 'rangeVehicle))
  (setf (range (find-named-object :maplist consolespawn)) (getf *properties* 'rangeMaps))
  (setf (range (find-named-object :singlesaberleftlist consolespawn)) (getf *properties* 'rangeSaberSingle))
  (setf (range (find-named-object :singlesaberrightlist consolespawn)) (getf *properties* 'rangeSaberSingle))
  (setf (range (find-named-object :staffsaberlist consolespawn)) (getf *properties* 'rangeSaberStaff))
  )

;; handle menubuttons
(defun consolespawnmain-loadbutton-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (loadPk3s)(fillRanges dialog)
  t)

(defun consolespawnmain-reloadbutton-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (reloadPk3s)(fillRanges dialog)
  t)

(defun consolespawnmain-basebutton-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (selectBase)
  t)

(defun consolespawnmain-hotkeybutton-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (showHotKey dialog)
  t)

(defun consolespawnmain-restorebutton-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (hideWindow dialog)
  t)

;; handle listbox selection/deselection

(defun consolespawnmain-singlesaberleftlist-on-change (widget
                                                       new-value
                                                       old-value)
  (declare (ignore-if-unused widget new-value old-value))
  (setf (value (find-named-object :staffsaberlist (parent widget))) nil)
  (setf (value (find-named-object :singlesaberleftlist (parent widget))) new-value)
  t) ; Accept the new value

(defun consolespawnmain-singlesaberrightlist-on-change (widget
                                                        new-value
                                                        old-value)
  (declare (ignore-if-unused widget new-value old-value))
  (setf (value (find-named-object :staffsaberlist (parent widget))) nil)
  (setf (value (find-named-object :singlesaberrightlist (parent widget))) new-value)
  t) ; Accept the new value

(defun consolespawnmain-staffsaberlist-on-change (widget
                                                  new-value
                                                  old-value)
  (declare (ignore-if-unused widget new-value old-value))
  (setf (value (find-named-object :singlesaberleftlist (parent widget))) nil)
  (setf (value (find-named-object :singlesaberrightlist (parent widget))) nil)
  (setf (value (find-named-object :staffsaberlist (parent widget))) new-value)
  t) ; Accept the new value

;; hide Application buttons
(defun consolespawnmain-restorejkanpc-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (hideWindow dialog)
  t)

(defun consolespawnmain-restorejkavehicle-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (hideWindow dialog)
  t)

(defun consolespawnmain-restorejkamaps-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (hideWindow dialog)
  t)

(defun consolespawnmain-restorejkasaber-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (hideWindow dialog)
  t)

(defun consolespawnmain-restorejkacheats-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (hideWindow dialog)
  t)

;; simple cheat buttons
(defun consolespawnmain-godbutton-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (if (getMp dialog)
      (performCommand dialog "\\god")
    (performCommand dialog "god"))
  t)

(defun consolespawnmain-noclipbutton-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (if (getMp dialog)
      (performCommand dialog "\\noclip")
    (performCommand dialog "noclip"))
  t)

(defun consolespawnmain-notargetbutton-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (if (getMp dialog)
      (performCommand dialog "\\notarget")
    (performCommand dialog "notarget"))
  t)

(defun consolespawnmain-giveallbutton-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (if (getMp dialog)
      (performCommand dialog "\\give all")
    (performCommand dialog "give all"))
  t)

(defun consolespawnmain-getammo-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (if (getMp dialog)
      (performCommand dialog "\\give ammo")
    (performCommand dialog "give ammo"))
  t)

(defun consolespawnmain-enablecheats-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (if (getMp dialog)
      (performCommand dialog "")
    (performCommand dialog "helpusobi 1"))
  t)

(defun consolespawnmain-disablecheats-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (if (getMp dialog)
      (performCommand dialog "")
    (performCommand dialog "helpusobi 0"))
  t)

(defun consolespawnmain-freezebutton-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (if (getMp dialog)
      (performCommand dialog "")
    (performCommand dialog "d_npcfreeze 1"))
  t)

(defun consolespawnmain-unfreezebutton-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (if (getMp dialog)
      (performCommand dialog "")
    (performCommand dialog "d_npcfreeze 0"))
  t)

(defun consolespawnmain-iknowkungfubutton-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (if (getMp dialog)
      (performCommand dialog "")
    (performCommand dialog "iknowkungfu"))
  t)

(defun consolespawnmain-corpsesstayon-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (if (getMp dialog)
      (performCommand dialog "")
    (performCommand dialog "g_corpseRemovalTime 0"))
  t)

(defun consolespawnmain-corpseshidebutton-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (if (getMp dialog)
      (performCommand dialog "")
    (performCommand dialog "g_corpseRemovalTime 10"))
  t)

;; spawn buttons

(defun consolespawnmain-spawnvehicle-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (let* ((vehicle (value (find-named-object :vehiclelist dialog)))
         (cmdvehicle (if vehicle (cdr (assoc vehicle (getf *properties* 'assocVehicle) :test #'string-equal)) ""))
         )
    (if (getMp dialog)
        (performCommand dialog (concatenate 'string "\\npc spawn vehicle " cmdvehicle))
      (performCommand dialog (concatenate 'string "npc spawn vehicle " cmdvehicle)))
    )
  t)

(defun consolespawnmain-loadmapwithcheats-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (let* ((map (value (find-named-object :maplist dialog)))
         (cmdmap (if map (cdr (assoc map (getf *properties* 'assocMaps) :test #'string-equal)) ""))
         )
    (if (getMp dialog)
        (performCommand dialog (concatenate 'string "\\devmap " cmdmap))
      (performCommand dialog ""))
    )
  t)

(defun consolespawnmain-loadmapwithoutcheats-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (declare (ignore-if-unused dialog widget))
  (let* ((map (value (find-named-object :maplist dialog)))
         (cmdmap (if map (cdr (assoc map (getf *properties* 'assocMaps) :test #'string-equal)) ""))
         )
    (if (getMp dialog)
        (performCommand dialog (concatenate 'string "\\map " cmdmap))
      (performCommand dialog (concatenate 'string "map " cmdmap)))
    )
  t)

(defun consolespawnmain-givesaber-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (let* ((singleleftname (value (find-named-object :singlesaberleftlist dialog)))
         (singlerightname (value (find-named-object :singlesaberrightlist dialog)))
         (staffname (value (find-named-object :staffsaberlist dialog)))
         (singleleft (if singleleftname (cdr (assoc singleleftname (getf *properties* 'assocSaberSingle) :test #'string-equal)) ""))
         (singleright (if singlerightname (cdr (assoc singlerightname (getf *properties* 'assocSaberSingle) :test #'string-equal)) ""))
         (staff (if staffname (cdr (assoc staffname (getf *properties* 'assocSaberStaff) :test #'string-equal)) ""))
         (cmdsaber (concatenate 'string singleright " " singleleft " " staff))
         )
    (setf (value (find-named-object :staffsaberlist DIALOG)) nil)
    (setf (value (find-named-object :singlesaberleftlist DIALOG)) nil)
    (setf (value (find-named-object :staffsaberlist DIALOG)) nil)
    (if (getMp dialog)
        (performCommand dialog "")
      (performCommand dialog (concatenate 'string "saber " cmdsaber)))
    )
  t)

(defun consolespawnmain-spawnnpcplayer-on-click (dialog widget)
   (declare (ignore-if-unused dialog widget))
    (let* ((playernpc (value (find-named-object :npcplayerlist dialog)))
         (cmdnpc (if playernpc (cdr (assoc playernpc (getf *properties* 'assocNpcPlayer) :test #'string-equal)) ""))
         )
    (if (getMp dialog)
        (performCommand dialog (concatenate 'string "\\npc spawn " cmdnpc))
      (performCommand dialog (concatenate 'string "npc spawn " cmdnpc)))
    )
  t)

(defun consolespawnmain-spawnnpcenemy-on-click (dialog widget)
   (declare (ignore-if-unused dialog widget))
    (let* ((enemynpc (value (find-named-object :npcenemylist dialog)))
         (cmdnpc (if enemynpc (cdr (assoc enemynpc (getf *properties* 'assocNpcEnemy) :test #'string-equal)) ""))
         )
    (if (getMp dialog)
        (performCommand dialog (concatenate 'string "\\npc spawn " cmdnpc))
      (performCommand dialog (concatenate 'string "npc spawn " cmdnpc)))
    )
  t)

(defun consolespawnmain-spawnnpcfree-on-click (dialog widget)
   (declare (ignore-if-unused dialog widget))
    (let* ((freenpc (value (find-named-object :npcfreelist dialog)))
         (cmdnpc (if freenpc (cdr (assoc freenpc (getf *properties* 'assocNpcFree) :test #'string-equal)) ""))
         )
    (if (getMp dialog)
        (performCommand dialog (concatenate 'string "\\npc spawn " cmdnpc))
      (performCommand dialog (concatenate 'string "npc spawn " cmdnpc)))
    )
  t)

(defun consolespawnmain-becomenpcplayer-on-click (dialog widget)
   (declare (ignore-if-unused dialog widget))
    (let* ((playernpc (value (find-named-object :npcplayerlist dialog)))
         (cmdnpc (if playernpc (cdr (assoc playernpc (getf *properties* 'assocNpcPlayer) :test #'string-equal)) ""))
         )
    (if (getMp dialog)
        (performCommand dialog "")
      (performCommand dialog (concatenate 'string "playerModel " cmdnpc)))
    )
  t)

(defun consolespawnmain-becomenpcenemy-on-click (dialog widget)
   (declare (ignore-if-unused dialog widget))
    (let* (
         (enemynpc (value (find-named-object :npcenemylist dialog)))
         (cmdnpc (if enemynpc (cdr (assoc enemynpc (getf *properties* 'assocNpcEnemy) :test #'string-equal)) ""))
         )
    (if (getMp dialog)
        (performCommand dialog "")
      (performCommand dialog (concatenate 'string "playerModel " cmdnpc)))
    )
  t)

(defun consolespawnmain-becomenpcfree-on-click (dialog widget)
   (declare (ignore-if-unused dialog widget))
    (let* (
         (freenpc (value (find-named-object :npcfreelist dialog)))
         (cmdnpc (if freenpc (cdr (assoc freenpc (getf *properties* 'assocNpcFree) :test #'string-equal)) ""))
         )
    (if (getMp dialog)
        (performCommand dialog "")
      (performCommand dialog (concatenate 'string "playerModel " cmdnpc)))
    )
  t)


;; complexer cheats

(defun consolespawnmain-giveweaponbutton-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (let ((weapon (value (find-named-object :weaponcombo dialog)))
        (cmdweapon "")
        )
    (cond 
     ((string-equal weapon "LightSaber") (setq cmdweapon "1"))
     ((string-equal weapon "BlasTech DL-44") (setq cmdweapon "2"))
     ((string-equal weapon "E-11 Blaster Rifle") (setq cmdweapon "3"))
     ((string-equal weapon "Tenloss Disruptor Rifle") (setq cmdweapon "4"))
     ((string-equal weapon "Wookiee Bowcaster") (setq cmdweapon "5"))
     ((string-equal weapon "Heavy Repeater") (setq cmdweapon "6"))
     ((string-equal weapon "DEMP2") (setq cmdweapon "7"))
     ((string-equal weapon "Golan Arms FC-1") (setq cmdweapon "8"))
     ((string-equal weapon "Merr Sonn PLX-2M") (setq cmdweapon "9"))
     ((string-equal weapon "Thermal Detonator") (setq cmdweapon "10"))
     ((string-equal weapon "Trip Mine") (setq cmdweapon "11"))
     ((string-equal weapon "Detonation Pack") (setq cmdweapon "12"))
     ((string-equal weapon "Melee") (setq cmdweapon "14"))
     ((string-equal weapon "Stouker Concussion Rifle") (setq cmdweapon "15"))
     ((string-equal weapon "ATST Main Cannon") (setq cmdweapon "16"))
     ((string-equal weapon "ATST Side Cannon") (setq cmdweapon "17"))
     ((string-equal weapon "Stun Baton") (setq cmdweapon "18"))
     )
    (if (getMp dialog)
        (performCommand dialog (concatenate 'string "\\give weaponnum " cmdweapon))
      (performCommand dialog (concatenate 'string "give weaponnum " cmdweapon)))
    )  
  t)

(defun consolespawnmain-forcelevelbutton-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (let ((cmdlevel (value (find-named-object :forcelevelcombo dialog)))
        )
    (if (getMp dialog)
        (performCommand dialog "")
      (performCommand dialog (concatenate 'string "setforceall " cmdlevel)))
    )
  t)

(defun consolespawnmain-sabercolorbutton-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (let ((location (value (find-named-object :saberlocationcombo dialog)))
        (cmdlocation "")
        (cmdfirstcolor (value (find-named-object :colorcombo1 dialog)))
        (cmdsecondcolor (value (find-named-object :colorcombo2 dialog)))
        )
    (cond 
     ((string-equal location "left") (setq cmdlocation "2"))
     ((string-equal location "right") (setq cmdlocation "1")))
    (if (getMp dialog)
        (performCommand dialog "")
      (performCommand dialog (concatenate 'string "sabercolor " cmdlocation " " cmdfirstcolor " " cmdsecondcolor)))
    )
  t)

(defun consolespawnmain-abilitiesbutton-on-click (dialog widget)
  (declare (ignore-if-unused dialog widget))
  (let ((ability (value (find-named-object :abilitiescombo dialog)))
        (cmdability "")
        (cmdlevel (value (find-named-object :abilitieslevelcombo dialog)))
        )
    (cond
     ((string-equal ability "Force Grip") (setq cmdability "setforcegrip"))
     ((string-equal ability "Force Mindtrick") (setq cmdability "setforcemindtrick"))
     ((string-equal ability "Force Absorb") (setq cmdability "setforceabsorb"))
     ((string-equal ability "Force Heal") (setq cmdability "setforceheal"))
     ((string-equal ability "Force Sight") (setq cmdability "setforcesight"))
     ((string-equal ability "Force Speed") (setq cmdability "setforcespeed"))
     ((string-equal ability "Force Protect") (setq cmdability "setforceprotect"))
     ((string-equal ability "Force Lightning") (setq cmdability "setforcelightning"))
     ((string-equal ability "Force Drain") (setq cmdability "setforcedrain"))
     ((string-equal ability "Force Rage") (setq cmdability "setforcerage"))
     ((string-equal ability "Force Pull") (setq cmdability "setforcepull"))
     ((string-equal ability "Force Push") (setq cmdability "setforcepush"))
     ((string-equal ability "Force Jump") (setq cmdability "setforcejump"))
     ((string-equal ability "Force Levitate") (setq cmdability "setforcelevitate"))
     ((string-equal ability "Saber Defense") (setq cmdability "setsaberdefense"))
     ((string-equal ability "Saber Offense") (setq cmdability "setsaberoffense"))
     ((string-equal ability "Saber Throw") (setq cmdability "setsaberthrow"))
     )
    (if (getMp dialog)
        (performCommand dialog "")
      (performCommand dialog (concatenate 'string cmdability " " cmdlevel)))
    )
  t)