#!/usr/bin/perl
#Jedi Knight Log Backup
#Made for the Jedi Academy Mod(TM)
#(c) 2003 - neotericE

#set the path to the game logs
$gamelogs="/home/academy/.jkii/academy";

#set the path to the backup folder
$backups="/home/academy/.jkii/academy/backups";

#set to 1 if you want output!
$verbose=0;


####################################################
#Don't change anything below this line
####################################################
$date=`date +%y%m%d`;
chomp($date);

@logs=(split("\n",`ls -1 $gamelogs/*.log`));
foreach $log (@logs) {
        $log=~s/$gamelogs\///;
        
	#if you want to make this more secure use exec() instead - neo
        
	$output=`/usr/bin/gzip -c -9 "$gamelogs/$log" > "$backups/$date-$log.gz"`;

        if($verbose) { print $output; }

        #if using exec() change to test for value of $output

        if(-e "$backups/$date-$log.gz"){

                # Line commented out on 7/10/2003 8:37am CST by Kevin Laude
                # djsith@thejediacademy.net
                # It looks like by removing the log file the game server will
                # not recreate the log file. The game server had to be restarted
                # for a new log file to be created. I'm fixing this by copying
                # /dev/null to the log file instead of deleting it.
                #$output=`rm -f "$gamelogs/$log"`;

                $output=`cp /dev/null "$gamelogs/$log"`;

                if($verbose) { print $output; }
        }
}