/*
 * Decompiled with CFR 0.152.
 */
package jk2serverbrowser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import jk2serverbrowser.GameServer;
import jk2serverbrowser.ServerBrowser;

public class Gui
extends JPanel
implements ActionListener,
ListSelectionListener,
WindowListener {
    private JTable table;
    private JTable playerTable;
    private final JButton btnGetServers;
    private final JButton btnJoin;
    private GameServer selectedServer;
    private ServerBrowser browser = new ServerBrowser("63.146.124.53", 28060);
    private String jk2path;
    private String jkapath;
    private boolean jk2 = true;
    private JRadioButton botfilter;
    private JRadioButton emptyfilter;
    private TableRowSorter sorter;
    private JLabel lblServerCount;
    private NoneSelectedButtonGroup filtergroup;
    private JLabel hostname;
    private JLabel mod;
    private JLabel ip;
    private JLabel forcepowerdisable;
    private JLabel weapondisable;
    private JLabel ping;
    private JRadioButton[] rbtns = new JRadioButton[4];
    private ButtonGroup version;
    private Thread pingthread;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Gui.createGUI();
            }
        });
    }

    private static void createGUI() {
        JFrame frame = new JFrame("JK2/JKA server browser");
        frame.setPreferredSize(new Dimension(1024, 768));
        frame.setDefaultCloseOperation(3);
        Gui gui = new Gui();
        gui.setOpaque(true);
        frame.addWindowListener(gui);
        frame.setContentPane(gui);
        frame.pack();
        frame.setVisible(true);
    }

    @Override
    public void windowOpened(WindowEvent e) {
        try {
            List<String> settings = Files.readAllLines(new File("settings.ini").toPath(), Charset.forName("UTF-8"));
            for (String s : settings) {
                String[] pieces;
                if (s.startsWith("#") || (pieces = s.replaceAll("\\\\", "/").split(" ?= ?")).length != 2) continue;
                block6 : switch (pieces[0]) {
                    case "version": {
                        switch (pieces[1]) {
                            case "0": {
                                this.jk2 = true;
                                this.rbtns[0].setSelected(true);
                                break block6;
                            }
                            case "1": {
                                this.jk2 = true;
                                this.rbtns[1].setSelected(true);
                                break block6;
                            }
                            case "2": {
                                this.jk2 = false;
                                this.rbtns[3].setSelected(true);
                                break block6;
                            }
                            case "3": {
                                this.jk2 = false;
                                this.rbtns[2].setSelected(true);
                            }
                        }
                        break;
                    }
                    case "JK2path": {
                        this.jk2path = pieces[1];
                        break;
                    }
                    case "JKApath": {
                        this.jkapath = pieces[1];
                    }
                }
            }
        }
        catch (IOException ex) {
            System.out.println(" - settings.ini not found, using default settings");
        }
        this.changeMasterserver();
        this.getNewServerList();
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public Gui() {
        super(new BorderLayout());
        Object[] col = new String[]{"Server name", "Players", "Map", "Gametype", "Mod"};
        DefaultTableModel tableModel = new DefaultTableModel(col, 0);
        this.table = new JTable(tableModel){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c;
                try {
                    c = super.prepareRenderer(renderer, row, column);
                }
                catch (NullPointerException npe) {
                    return null;
                }
                c.setForeground(Color.blue);
                if (!this.isRowSelected(row)) {
                    c.setBackground(row % 2 == 0 ? this.getBackground() : Color.getHSBColor(360.0f, 0.0f, 0.9f));
                }
                Gui.this.lblServerCount.setText("Servers: " + Gui.this.table.getRowCount());
                return c;
            }

            @Override
            public boolean isCellEditable(int nRow, int nCol) {
                return false;
            }
        };
        this.sorter = new TableRowSorter<DefaultTableModel>(tableModel);
        this.sorter.setComparator(1, new IntComparator());
        this.table.setRowSorter(this.sorter);
        this.table.setFillsViewportHeight(true);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.setFont(new Font("Sans Serif", 0, 14));
        this.table.setRowHeight(20);
        for (int i = 0; i < 4; ++i) {
            TableColumn column = this.table.getColumnModel().getColumn(i);
            if (i == 0) {
                column.setPreferredWidth(500);
                continue;
            }
            column.setPreferredWidth(100);
        }
        this.btnGetServers = new JButton("Get servers");
        this.btnJoin = new JButton("Join");
        this.btnJoin.setEnabled(false);
        this.btnGetServers.setEnabled(false);
        this.addActionListeners(this.btnGetServers);
        this.addActionListeners(this.btnJoin);
        JPanel rightPanel = new JPanel(new BorderLayout());
        this.createPlayerTable();
        JScrollPane sp = new JScrollPane(this.playerTable);
        rightPanel.add((Component)sp, "North");
        JPanel centerpanel = new JPanel(new BorderLayout());
        JScrollPane infoPane = new JScrollPane(this.createInfoPanel());
        centerpanel.add((Component)infoPane, "Center");
        centerpanel.add((Component)this.createRadioButtonPanel(), "South");
        rightPanel.add((Component)centerpanel, "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JPanel buttonPanelhack = new JPanel();
        buttonPanel.add((Component)buttonPanelhack, "South");
        buttonPanelhack.add(this.btnGetServers);
        buttonPanelhack.add(this.btnJoin);
        rightPanel.add((Component)buttonPanel, "South");
        JPanel leftpanel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.table);
        leftpanel.add((Component)scrollPane, "Center");
        leftpanel.add((Component)this.createFilterPanel(), "South");
        JSplitPane splitPane = new JSplitPane(1, leftpanel, rightPanel);
        splitPane.setDividerLocation(800);
        this.add(splitPane);
    }

    private JPanel createFilterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel filterpanel = new JPanel();
        this.filtergroup = new NoneSelectedButtonGroup();
        TitledBorder border1 = BorderFactory.createTitledBorder("Server filters - Hide:");
        this.botfilter = new JRadioButton("Empty & bot-only servers");
        this.emptyfilter = new JRadioButton("Empty servers");
        this.filtergroup.add(this.botfilter);
        this.filtergroup.add(this.emptyfilter);
        this.botfilter.addActionListener(this);
        this.emptyfilter.addActionListener(this);
        this.lblServerCount = new JLabel("");
        this.lblServerCount.setBorder(new EmptyBorder(0, 0, 0, 20));
        filterpanel.add(this.botfilter);
        filterpanel.add(this.emptyfilter);
        filterpanel.setBorder(border1);
        panel.add((Component)filterpanel, "West");
        panel.add((Component)this.lblServerCount, "East");
        return panel;
    }

    private void addActionListeners(JButton btn) {
        btn.addActionListener(this);
    }

    private JPanel createInfoPanel() {
        JPanel infopanel = new JPanel();
        infopanel.setLayout(new BoxLayout(infopanel, 1));
        this.hostname = new JLabel("Hostname: ");
        this.mod = new JLabel("Mod: ");
        this.ip = new JLabel("IP: ");
        this.forcepowerdisable = new JLabel("Forcepower disable: ");
        this.weapondisable = new JLabel("Weapon disable: ");
        this.ping = new JLabel("Ping: ");
        infopanel.add(this.hostname);
        infopanel.add(this.mod);
        infopanel.add(this.ip);
        infopanel.add(this.forcepowerdisable);
        infopanel.add(this.weapondisable);
        infopanel.add(this.ping);
        return infopanel;
    }

    private JPanel createRadioButtonPanel() {
        this.rbtns[0] = new JRadioButton("1.04");
        this.rbtns[1] = new JRadioButton("1.02");
        this.rbtns[2] = new JRadioButton("1.01");
        this.rbtns[3] = new JRadioButton("1.00");
        JPanel rdbtnPanel = new JPanel(new GridLayout(0, 1));
        JPanel jk2panel = new JPanel(new GridLayout(0, 2));
        JPanel jkapanel = new JPanel(new GridLayout(0, 2));
        TitledBorder border1 = BorderFactory.createTitledBorder("Jedi Knight 2");
        TitledBorder border2 = BorderFactory.createTitledBorder("Jedi Academy");
        jk2panel.setBorder(border1);
        jkapanel.setBorder(border2);
        this.version = new ButtonGroup();
        this.version.add(this.rbtns[0]);
        this.version.add(this.rbtns[1]);
        this.version.add(this.rbtns[3]);
        this.version.add(this.rbtns[2]);
        jk2panel.add(this.rbtns[0]);
        this.rbtns[0].setSelected(true);
        jk2panel.add(this.rbtns[1]);
        jkapanel.add(this.rbtns[2]);
        jkapanel.add(this.rbtns[3]);
        this.rbtns[0].addActionListener(this);
        this.rbtns[1].addActionListener(this);
        this.rbtns[3].addActionListener(this);
        this.rbtns[2].addActionListener(this);
        rdbtnPanel.add(jk2panel);
        rdbtnPanel.add(jkapanel);
        return rdbtnPanel;
    }

    private void createPlayerTable() {
        Object[] col = new String[]{"Player", "Score", "Ping"};
        DefaultTableModel tableModel = new DefaultTableModel(col, 0);
        this.playerTable = new JTable(tableModel){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                if (!this.isRowSelected(row)) {
                    c.setBackground(this.getBackground());
                    int modelRow = this.convertRowIndexToModel(row);
                    String type = (String)this.getModel().getValueAt(modelRow, 0);
                    String ping = (String)this.getModel().getValueAt(modelRow, 2);
                    if (!ping.equals("0")) {
                        c.setBackground(Color.green);
                    }
                    if (type.toLowerCase().contains("grenixal")) {
                        c.setBackground(Color.yellow);
                    }
                }
                return c;
            }

            @Override
            public boolean isCellEditable(int nRow, int nCol) {
                return false;
            }
        };
        TableRowSorter<DefaultTableModel> trs = new TableRowSorter<DefaultTableModel>(tableModel);
        trs.setComparator(1, new IntComparator());
        trs.setComparator(2, new IntComparator());
        this.playerTable.setRowSorter(trs);
        this.playerTable.setPreferredScrollableViewportSize(new Dimension(220, 350));
        this.playerTable.setFillsViewportHeight(true);
        this.playerTable.setSelectionMode(0);
        this.playerTable.getColumnModel().getColumn(0).setPreferredWidth(140);
        this.playerTable.getColumnModel().getColumn(1).setPreferredWidth(40);
        this.playerTable.getColumnModel().getColumn(2).setPreferredWidth(40);
    }

    private void getNewServerList() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Gui.this.setupTableData(Gui.this.browser.getNewServerList());
                Gui.this.btnGetServers.setEnabled(true);
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o instanceof JButton) {
            JButton btn = (JButton)o;
            if (btn.getText().equals("Get servers")) {
                this.btnGetServers.setEnabled(false);
                DefaultTableModel tableModel = (DefaultTableModel)this.table.getModel();
                tableModel.setRowCount(0);
                this.getNewServerList();
            } else if (btn.getText().equals("Join")) {
                try {
                    String path = null;
                    path = this.jk2 ? this.jk2path : this.jkapath;
                    String strIp = this.selectedServer.getIp().getAddress().toString();
                    ProcessBuilder builder = new ProcessBuilder(path, "+connect", strIp.substring(strIp.indexOf("/") + 1, strIp.length()) + ":" + this.selectedServer.getIp().getPort());
                    builder.directory(new File(path.substring(0, path.lastIndexOf("/"))));
                    builder.redirectErrorStream(true);
                    Process process = builder.start();
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(null, "Couldn't find .exe! Please, check your settings.ini");
                }
            }
        } else if (o instanceof JRadioButton) {
            JRadioButton btn = (JRadioButton)o;
            if (btn.getText().equals("1.04") || btn.getText().equals("1.02") || btn.getText().equals("1.00") || btn.getText().equals("1.01")) {
                this.changeMasterserver();
            } else {
                this.changeFilter();
            }
        }
    }

    private void changeFilter() {
        if (this.botfilter.isSelected()) {
            RowFilter rf = RowFilter.regexFilter("\\[([1-9]|[0-9]{2,})\\]", 1);
            this.sorter.setRowFilter(rf);
        } else if (this.emptyfilter.isSelected()) {
            RowFilter rf = RowFilter.regexFilter("([1-9]|[0-9]{2,})/", 1);
            this.sorter.setRowFilter(rf);
        } else {
            this.sorter.setRowFilter(null);
        }
    }

    private void changeMasterserver() {
        block12: for (int i = 0; i < this.rbtns.length; ++i) {
            JRadioButton btn = this.rbtns[i];
            if (!btn.isSelected()) continue;
            switch (btn.getText()) {
                case "1.04": {
                    this.browser.setMasterserver("63.146.124.53", 28060);
                    this.browser.setProtocol("16");
                    this.jk2 = true;
                    continue block12;
                }
                case "1.02": {
                    this.browser.setMasterserver("63.146.124.53", 28060);
                    this.browser.setProtocol("15");
                    this.jk2 = true;
                    continue block12;
                }
                case "1.00": {
                    this.browser.setMasterserver("63.146.124.53", 29060);
                    this.browser.setProtocol("25");
                    this.jk2 = false;
                    continue block12;
                }
                case "1.01": {
                    this.browser.setMasterserver("63.146.124.53", 29060);
                    this.browser.setProtocol("26");
                    this.jk2 = false;
                }
            }
        }
    }

    public void setupTableData(List<GameServer> list) {
        if (list == null) {
            return;
        }
        DefaultTableModel tableModel = (DefaultTableModel)this.table.getModel();
        for (GameServer s : list) {
            Object[] data = new Object[5];
            if (s == null) continue;
            data[0] = s.getHostname();
            data[1] = s.getClients() + "/" + s.getMaxclients() + " [" + s.getPlayerCount() + "]";
            data[2] = s.getMapname();
            data[3] = s.getGametype();
            data[4] = s.getMod();
            tableModel.addRow(data);
        }
        this.table.setModel(tableModel);
    }

    public void setupPlayerTableData(List<String> list) {
        if (list == null) {
            return;
        }
        DefaultTableModel tableModel = (DefaultTableModel)this.playerTable.getModel();
        for (String s : list) {
            Object[] data = new String[3];
            String[] line = s.split(" ");
            data[0] = s.substring(s.indexOf("\""), s.lastIndexOf("\"")).replaceAll("\"", "");
            data[1] = line[0];
            data[2] = line[1];
            tableModel.addRow(data);
        }
        this.playerTable.setModel(tableModel);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow == -1) {
            this.btnJoin.setEnabled(false);
            return;
        }
        this.btnJoin.setEnabled(true);
        this.selectedServer = this.browser.getServerList().get(this.table.convertRowIndexToModel(selectedRow));
        System.out.println(this.selectedServer);
        try {
            String[] serverstatus = this.browser.getServerStatus(this.selectedServer);
            this.parseServerStatus(serverstatus);
        }
        catch (IOException ex) {
            Logger.getLogger(Gui.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void parseServerStatus(String[] array) {
        this.mod.setText("Mod: " + this.selectedServer.getMod());
        ArrayList<String> showablePlayers = new ArrayList<String>();
        for (String s : array) {
            if (!s.matches("-?[0-9]+ [0-9]+ \".*\"")) continue;
            showablePlayers.add(s.replaceAll("\\^[0-9]", "").replaceAll("\\^[a-z]", ""));
        }
        DefaultTableModel tableModel = (DefaultTableModel)this.playerTable.getModel();
        tableModel.setRowCount(0);
        this.setupPlayerTableData(showablePlayers);
        String strhostname = this.selectedServer.getHostname();
        String strIp = this.selectedServer.getIp().toString();
        String strForceDisable = this.selectedServer.getForce_disable();
        String strWeaponDisable = this.selectedServer.getWeapon_disable();
        if (strhostname != null) {
            this.hostname.setText("Hostname: " + strhostname);
        }
        if (strIp != null) {
            this.ip.setText("IP: " + strIp);
        }
        String no_force = "";
        if (strForceDisable != null) {
            if (strForceDisable.equals("163837")) {
                no_force = " (No force)";
            }
            this.forcepowerdisable.setText("Forcepower disable: " + strForceDisable + no_force);
        }
        if (strWeaponDisable != null) {
            String saberonly = "";
            if (strWeaponDisable.equals("65531")) {
                saberonly = " (Saber only)";
            }
            this.weapondisable.setText("Weapon disable: " + strWeaponDisable + saberonly);
        }
        if (this.pingthread != null && this.pingthread.isAlive()) {
            this.pingthread.interrupt();
        }
        this.pingthread = new Thread(new Runnable(){

            @Override
            public void run() {
                Gui.this.ping.setText("Ping: -");
                String serverping = Gui.this.selectedServer.ping();
                if (!Gui.this.pingthread.isInterrupted()) {
                    Gui.this.ping.setText("Ping: " + serverping);
                }
            }
        });
        this.pingthread.start();
    }

    public class NoneSelectedButtonGroup
    extends ButtonGroup {
        @Override
        public void setSelected(ButtonModel model, boolean selected) {
            if (selected) {
                super.setSelected(model, selected);
            } else {
                this.clearSelection();
            }
        }
    }

    class IntComparator
    implements Comparator {
        IntComparator() {
        }

        public int compare(Object o1, Object o2) {
            String int1 = (String)o1;
            String int2 = (String)o2;
            int index1 = int1.indexOf("[");
            int index2 = int1.indexOf("]");
            int index3 = int2.indexOf("[");
            int index4 = int2.indexOf("]");
            if (index1 == -1 || index3 == -1) {
                index2 = int1.length();
                index4 = int2.length();
            }
            int n1 = Integer.parseInt(int1.substring(index1 + 1, index2));
            int n2 = Integer.parseInt(int2.substring(index3 + 1, index4));
            if (index1 != -1 && index3 != -1 && n1 == n2) {
                int a = Integer.parseInt(int1.substring(0, int1.lastIndexOf("/")));
                int b = Integer.parseInt(int2.substring(0, int2.lastIndexOf("/")));
                return a - b;
            }
            return n1 - n2;
        }
    }
}

