/*
 * Decompiled with CFR 0.152.
 */
package jk2serverbrowser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.util.Objects;

public class GameServer {
    private InetSocketAddress ip;
    private String mod = "";
    private String force_disable = "";
    private String weapon_disable = "";
    private String gametype = "";
    private String maxclients = "";
    private String clients = "";
    private String mapname = "";
    private String hostname = "";
    private String ping = "";
    private String players = "";

    public GameServer(InetSocketAddress ip, String[] stringArray) {
        this.ip = ip;
        this.parseFromServerStatus(stringArray);
    }

    public void parseFromServerStatus(String[] array) {
        String[] serverStatus = array[1].split("\\\\");
        for (int i = 0; i < serverStatus.length; ++i) {
            switch (serverStatus[i]) {
                case "gamename": {
                    this.mod = serverStatus[i + 1].replaceAll("\\^[0-9]", "");
                    break;
                }
                case "g_forcePowerDisable": {
                    this.force_disable = serverStatus[i + 1];
                    break;
                }
                case "g_weapondisable": {
                    this.weapon_disable = serverStatus[i + 1];
                    break;
                }
                case "g_gametype": {
                    switch (serverStatus[i + 1]) {
                        case "0": {
                            this.gametype = "FFA";
                            break;
                        }
                        case "1": {
                            this.gametype = "Holocron";
                            break;
                        }
                        case "2": {
                            this.gametype = "Jedi master";
                            break;
                        }
                        case "3": {
                            this.gametype = "Duel";
                            break;
                        }
                        case "5": {
                            this.gametype = "TFFA";
                            break;
                        }
                        case "7": {
                            this.gametype = "CTF";
                            break;
                        }
                        case "8": {
                            this.gametype = "CTY";
                        }
                    }
                    break;
                }
                case "sv_maxclients": {
                    this.maxclients = serverStatus[i + 1];
                    break;
                }
                case "mapname": {
                    this.mapname = serverStatus[i + 1];
                    break;
                }
                case "sv_hostname": {
                    this.hostname = serverStatus[i + 1];
                    this.hostname = this.hostname.replaceAll("\\^[0-9]", "").replaceAll("[^a-zA-Z0-9?=@><#_'!&\\]\\[\\(\\)\\-\\.`~\\*\\^ ]", "");
                }
            }
            this.clients = Integer.toString(array.length - 3);
            this.players = this.countPlayers(array);
        }
    }

    private String countPlayers(String[] array) {
        int c = 0;
        for (String s : array) {
            if (!s.matches("-?[0-9]+ ([1-9]|[0-9]{2,}) \".*\"")) continue;
            ++c;
        }
        return Integer.toString(c);
    }

    private void parseFromStringArray(String[] array) {
        block38: for (int i = 0; i < array.length; ++i) {
            switch (array[i]) {
                case "game": {
                    this.mod = array[i + 1];
                    continue block38;
                }
                case "fdisable": {
                    this.force_disable = array[i + 1];
                    continue block38;
                }
                case "wdisable": {
                    this.weapon_disable = array[i + 1];
                    continue block38;
                }
                case "gametype": {
                    switch (array[i + 1]) {
                        case "0": {
                            this.gametype = "FFA";
                            break;
                        }
                        case "1": {
                            this.gametype = "Holocron";
                            break;
                        }
                        case "2": {
                            this.gametype = "Jedi master";
                            break;
                        }
                        case "3": {
                            this.gametype = "Duel";
                            break;
                        }
                        case "5": {
                            this.gametype = "TFFA";
                            break;
                        }
                        case "7": {
                            this.gametype = "CTF";
                            break;
                        }
                        case "8": {
                            this.gametype = "CTY";
                        }
                    }
                    continue block38;
                }
                case "sv_maxclients": {
                    this.maxclients = array[i + 1];
                    continue block38;
                }
                case "clients": {
                    this.clients = array[i + 1];
                    continue block38;
                }
                case "mapname": {
                    this.mapname = array[i + 1];
                    continue block38;
                }
                case "hostname": {
                    this.hostname = array[i + 1];
                    this.hostname = this.hostname.replaceAll("\\^[0-9]", "");
                    this.hostname = this.hostname.replaceAll("\\\\", "");
                }
            }
        }
    }

    public String toString() {
        return "Hostname: " + this.hostname + "\nIP: " + this.ip.getAddress() + ":" + this.ip.getPort() + "\nPlayers: " + this.clients + "/" + this.maxclients + "\n";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof GameServer)) {
            return false;
        }
        GameServer gs = (GameServer)o;
        return this.hashCode() == gs.hashCode();
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.ip);
        return hash;
    }

    public String ping() {
        try {
            String inputLine;
            Runtime r = Runtime.getRuntime();
            Process p = r.exec("ping -n 1 -w 300 " + this.ip.getHostName());
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                if (!inputLine.matches(".*time=.*")) continue;
                int index = inputLine.indexOf("time=");
                this.ping = inputLine.substring(index + 5, inputLine.lastIndexOf("ms") + 2);
                break;
            }
            in.close();
            return this.ping;
        }
        catch (IOException ex) {
            System.err.println("Pinging server failed");
            return "999";
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public InetSocketAddress getIp() {
        return this.ip;
    }

    public String getMod() {
        return this.mod;
    }

    public String getForce_disable() {
        return this.force_disable;
    }

    public String getWeapon_disable() {
        return this.weapon_disable;
    }

    public String getGametype() {
        return this.gametype;
    }

    public String getMaxclients() {
        return this.maxclients;
    }

    public String getClients() {
        return this.clients;
    }

    public String getMapname() {
        return this.mapname;
    }

    public String getPlayerCount() {
        return this.players;
    }
}

