export G_ReflectMissile
code
proc G_ReflectMissile 92 8
file "../g_missile.c"
line 18
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:#include "g_local.h"
;4:
;5:#define	MISSILE_PRESTEP_TIME	50
;6:
;7:extern void laserTrapStick( gentity_t *ent, vec3_t endpos, vec3_t normal );
;8:
;9:/*
;10:================
;11:G_ReflectMissile
;12:
;13:  Reflect the missile roughly back at it's owner
;14:================
;15:*/
;16:float RandFloat(float min, float max);
;17:void G_ReflectMissile( gentity_t *ent, gentity_t *missile, vec3_t forward ) 
;18:{
line 22
;19:	vec3_t	bounce_dir;
;20:	int		i;
;21:	float	speed;
;22:	gentity_t	*owner = ent;
ADDRLP4 24
ADDRFP4 0
INDIRP4
ASGNP4
line 23
;23:	int		isowner = 0;
ADDRLP4 20
CNSTI4 0
ASGNI4
line 25
;24:
;25:	if ( ent->r.ownerNum )
ADDRFP4 0
INDIRP4
CNSTI4 396
ADDP4
INDIRI4
CNSTI4 0
EQI4 $79
line 26
;26:	{
line 27
;27:		owner = &g_entities[ent->r.ownerNum];
ADDRLP4 24
CNSTI4 828
ADDRFP4 0
INDIRP4
CNSTI4 396
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 28
;28:	}
LABELV $79
line 30
;29:
;30:	if (missile->r.ownerNum == ent->s.number)
ADDRFP4 4
INDIRP4
CNSTI4 396
ADDP4
INDIRI4
ADDRFP4 0
INDIRP4
INDIRI4
NEI4 $81
line 31
;31:	{ //the original owner is bouncing the missile, so don't try to bounce it back at him
line 32
;32:		isowner = 1;
ADDRLP4 20
CNSTI4 1
ASGNI4
line 33
;33:	}
LABELV $81
line 36
;34:
;35:	//save the original speed
;36:	speed = VectorNormalize( missile->s.pos.trDelta );
ADDRFP4 4
INDIRP4
CNSTI4 36
ADDP4
ARGP4
ADDRLP4 28
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 16
ADDRLP4 28
INDIRF4
ASGNF4
line 39
;37:
;38:	//if ( ent && owner && owner->NPC && owner->enemy && Q_stricmp( "Tavion", owner->NPC_type ) == 0 && Q_irand( 0, 3 ) )
;39:	if ( &g_entities[missile->r.ownerNum] && missile->s.weapon != WP_SABER && missile->s.weapon != G2_MODEL_PART && !isowner )
ADDRLP4 32
ADDRFP4 4
INDIRP4
ASGNP4
CNSTI4 828
ADDRLP4 32
INDIRP4
CNSTI4 396
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
CVPU4 4
CNSTU4 0
EQU4 $83
ADDRLP4 36
ADDRLP4 32
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
ASGNI4
ADDRLP4 36
INDIRI4
CNSTI4 2
EQI4 $83
ADDRLP4 36
INDIRI4
CNSTI4 50
EQI4 $83
ADDRLP4 20
INDIRI4
CNSTI4 0
NEI4 $83
line 40
;40:	{//bounce back at them if you can
line 41
;41:		VectorSubtract( g_entities[missile->r.ownerNum].r.currentOrigin, missile->r.currentOrigin, bounce_dir );
ADDRLP4 40
CNSTI4 828
ASGNI4
ADDRLP4 44
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 48
ADDRLP4 44
INDIRP4
CNSTI4 396
ADDP4
ASGNP4
ADDRLP4 4
ADDRLP4 40
INDIRI4
ADDRLP4 48
INDIRP4
INDIRI4
MULI4
ADDRGP4 g_entities+296+72
ADDP4
INDIRF4
ADDRLP4 44
INDIRP4
CNSTI4 368
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 4+4
ADDRLP4 40
INDIRI4
ADDRLP4 48
INDIRP4
INDIRI4
MULI4
ADDRGP4 g_entities+296+72+4
ADDP4
INDIRF4
ADDRLP4 44
INDIRP4
CNSTI4 372
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 52
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 4+8
CNSTI4 828
ADDRLP4 52
INDIRP4
CNSTI4 396
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities+296+72+8
ADDP4
INDIRF4
ADDRLP4 52
INDIRP4
CNSTI4 376
ADDP4
INDIRF4
SUBF4
ASGNF4
line 42
;42:		VectorNormalize( bounce_dir );
ADDRLP4 4
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 43
;43:	}
ADDRGP4 $84
JUMPV
LABELV $83
line 44
;44:	else if (isowner)
ADDRLP4 20
INDIRI4
CNSTI4 0
EQI4 $95
line 45
;45:	{ //in this case, actually push the missile away from me, and since we're giving boost to our own missile by pushing it, up the velocity
line 48
;46:		vec3_t missile_dir;
;47:
;48:		speed *= 1.5;
ADDRLP4 16
CNSTF4 1069547520
ADDRLP4 16
INDIRF4
MULF4
ASGNF4
line 50
;49:
;50:		VectorSubtract( missile->r.currentOrigin, ent->r.currentOrigin, missile_dir );
ADDRLP4 52
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 56
CNSTI4 368
ASGNI4
ADDRLP4 60
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 40
ADDRLP4 52
INDIRP4
ADDRLP4 56
INDIRI4
ADDP4
INDIRF4
ADDRLP4 60
INDIRP4
ADDRLP4 56
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 64
CNSTI4 372
ASGNI4
ADDRLP4 40+4
ADDRLP4 52
INDIRP4
ADDRLP4 64
INDIRI4
ADDP4
INDIRF4
ADDRLP4 60
INDIRP4
ADDRLP4 64
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 68
CNSTI4 376
ASGNI4
ADDRLP4 40+8
ADDRFP4 4
INDIRP4
ADDRLP4 68
INDIRI4
ADDP4
INDIRF4
ADDRFP4 0
INDIRP4
ADDRLP4 68
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 51
;51:		VectorCopy( missile->s.pos.trDelta, bounce_dir );
ADDRLP4 4
ADDRFP4 4
INDIRP4
CNSTI4 36
ADDP4
INDIRB
ASGNB 12
line 52
;52:		VectorScale( bounce_dir, DotProduct( forward, missile_dir ), bounce_dir );
ADDRLP4 72
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 76
ADDRLP4 40
INDIRF4
ASGNF4
ADDRLP4 80
ADDRLP4 72
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 84
ADDRLP4 72
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 4
ADDRLP4 4
INDIRF4
ADDRLP4 72
INDIRP4
INDIRF4
ADDRLP4 76
INDIRF4
MULF4
ADDRLP4 80
INDIRP4
INDIRF4
ADDRLP4 40+4
INDIRF4
MULF4
ADDF4
ADDRLP4 84
INDIRP4
INDIRF4
ADDRLP4 40+8
INDIRF4
MULF4
ADDF4
MULF4
ASGNF4
ADDRLP4 4+4
ADDRLP4 4+4
INDIRF4
ADDRLP4 72
INDIRP4
INDIRF4
ADDRLP4 76
INDIRF4
MULF4
ADDRLP4 80
INDIRP4
INDIRF4
ADDRLP4 40+4
INDIRF4
MULF4
ADDF4
ADDRLP4 84
INDIRP4
INDIRF4
ADDRLP4 40+8
INDIRF4
MULF4
ADDF4
MULF4
ASGNF4
ADDRLP4 88
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 4+8
ADDRLP4 4+8
INDIRF4
ADDRLP4 88
INDIRP4
INDIRF4
ADDRLP4 40
INDIRF4
MULF4
ADDRLP4 88
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 40+4
INDIRF4
MULF4
ADDF4
ADDRLP4 88
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 40+8
INDIRF4
MULF4
ADDF4
MULF4
ASGNF4
line 53
;53:		VectorNormalize( bounce_dir );
ADDRLP4 4
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 54
;54:	}
ADDRGP4 $96
JUMPV
LABELV $95
line 56
;55:	else
;56:	{
line 59
;57:		vec3_t missile_dir;
;58:
;59:		VectorSubtract( ent->r.currentOrigin, missile->r.currentOrigin, missile_dir );
ADDRLP4 52
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 56
CNSTI4 368
ASGNI4
ADDRLP4 60
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 40
ADDRLP4 52
INDIRP4
ADDRLP4 56
INDIRI4
ADDP4
INDIRF4
ADDRLP4 60
INDIRP4
ADDRLP4 56
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 64
CNSTI4 372
ASGNI4
ADDRLP4 40+4
ADDRLP4 52
INDIRP4
ADDRLP4 64
INDIRI4
ADDP4
INDIRF4
ADDRLP4 60
INDIRP4
ADDRLP4 64
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 68
CNSTI4 376
ASGNI4
ADDRLP4 40+8
ADDRFP4 0
INDIRP4
ADDRLP4 68
INDIRI4
ADDP4
INDIRF4
ADDRFP4 4
INDIRP4
ADDRLP4 68
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 60
;60:		VectorCopy( missile->s.pos.trDelta, bounce_dir );
ADDRLP4 4
ADDRFP4 4
INDIRP4
CNSTI4 36
ADDP4
INDIRB
ASGNB 12
line 61
;61:		VectorScale( bounce_dir, DotProduct( forward, missile_dir ), bounce_dir );
ADDRLP4 72
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 76
ADDRLP4 40
INDIRF4
ASGNF4
ADDRLP4 80
ADDRLP4 72
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 84
ADDRLP4 72
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 4
ADDRLP4 4
INDIRF4
ADDRLP4 72
INDIRP4
INDIRF4
ADDRLP4 76
INDIRF4
MULF4
ADDRLP4 80
INDIRP4
INDIRF4
ADDRLP4 40+4
INDIRF4
MULF4
ADDF4
ADDRLP4 84
INDIRP4
INDIRF4
ADDRLP4 40+8
INDIRF4
MULF4
ADDF4
MULF4
ASGNF4
ADDRLP4 4+4
ADDRLP4 4+4
INDIRF4
ADDRLP4 72
INDIRP4
INDIRF4
ADDRLP4 76
INDIRF4
MULF4
ADDRLP4 80
INDIRP4
INDIRF4
ADDRLP4 40+4
INDIRF4
MULF4
ADDF4
ADDRLP4 84
INDIRP4
INDIRF4
ADDRLP4 40+8
INDIRF4
MULF4
ADDF4
MULF4
ASGNF4
ADDRLP4 88
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 4+8
ADDRLP4 4+8
INDIRF4
ADDRLP4 88
INDIRP4
INDIRF4
ADDRLP4 40
INDIRF4
MULF4
ADDRLP4 88
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 40+4
INDIRF4
MULF4
ADDF4
ADDRLP4 88
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 40+8
INDIRF4
MULF4
ADDF4
MULF4
ASGNF4
line 62
;62:		VectorNormalize( bounce_dir );
ADDRLP4 4
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 63
;63:	}
LABELV $96
LABELV $84
line 64
;64:	for ( i = 0; i < 3; i++ )
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $121
line 65
;65:	{
line 66
;66:		bounce_dir[i] += RandFloat( -0.2f, 0.2f );
CNSTF4 3192704205
ARGF4
CNSTF4 1045220557
ARGF4
ADDRLP4 40
ADDRGP4 RandFloat
CALLF4
ASGNF4
ADDRLP4 44
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
ADDP4
ASGNP4
ADDRLP4 44
INDIRP4
ADDRLP4 44
INDIRP4
INDIRF4
ADDRLP4 40
INDIRF4
ADDF4
ASGNF4
line 67
;67:	}
LABELV $122
line 64
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $121
line 69
;68:
;69:	VectorNormalize( bounce_dir );
ADDRLP4 4
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 70
;70:	VectorScale( bounce_dir, speed, missile->s.pos.trDelta );
ADDRFP4 4
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 4
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ASGNF4
ADDRFP4 4
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 4+4
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ASGNF4
ADDRFP4 4
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 4+8
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ASGNF4
line 71
;71:	missile->s.pos.trTime = level.time;		// move a bit on the very first frame
ADDRFP4 4
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 72
;72:	VectorCopy( missile->r.currentOrigin, missile->s.pos.trBase );
ADDRLP4 40
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 40
INDIRP4
CNSTI4 24
ADDP4
ADDRLP4 40
INDIRP4
CNSTI4 368
ADDP4
INDIRB
ASGNB 12
line 73
;73:	if ( missile->s.weapon != WP_SABER && missile->s.weapon != G2_MODEL_PART )
ADDRLP4 44
ADDRFP4 4
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
ASGNI4
ADDRLP4 44
INDIRI4
CNSTI4 2
EQI4 $128
ADDRLP4 44
INDIRI4
CNSTI4 50
EQI4 $128
line 74
;74:	{//you are mine, now!
line 75
;75:		missile->r.ownerNum = ent->s.number;
ADDRFP4 4
INDIRP4
CNSTI4 396
ADDP4
ADDRFP4 0
INDIRP4
INDIRI4
ASGNI4
line 76
;76:	}
LABELV $128
line 77
;77:	if ( missile->s.weapon == WP_ROCKET_LAUNCHER )
ADDRFP4 4
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 10
NEI4 $130
line 78
;78:	{//stop homing
line 79
;79:		missile->think = 0;
ADDRFP4 4
INDIRP4
CNSTI4 636
ADDP4
CNSTP4 0
ASGNP4
line 80
;80:		missile->nextthink = 0;
ADDRFP4 4
INDIRP4
CNSTI4 632
ADDP4
CNSTI4 0
ASGNI4
line 81
;81:	}
LABELV $130
line 82
;82:}
LABELV $78
endproc G_ReflectMissile 92 8
export G_DeflectMissile
proc G_DeflectMissile 72 16
line 85
;83:
;84:void G_DeflectMissile( gentity_t *ent, gentity_t *missile, vec3_t forward ) 
;85:{
line 89
;86:	vec3_t	bounce_dir;
;87:	int		i;
;88:	float	speed;
;89:	int		isowner = 0;
ADDRLP4 32
CNSTI4 0
ASGNI4
line 92
;90:	vec3_t missile_dir;
;91:
;92:	if (missile->r.ownerNum == ent->s.number)
ADDRFP4 4
INDIRP4
CNSTI4 396
ADDP4
INDIRI4
ADDRFP4 0
INDIRP4
INDIRI4
NEI4 $133
line 93
;93:	{ //the original owner is bouncing the missile, so don't try to bounce it back at him
line 94
;94:		isowner = 1;
ADDRLP4 32
CNSTI4 1
ASGNI4
line 95
;95:	}
LABELV $133
line 98
;96:
;97:	//save the original speed
;98:	speed = VectorNormalize( missile->s.pos.trDelta );
ADDRFP4 4
INDIRP4
CNSTI4 36
ADDP4
ARGP4
ADDRLP4 36
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 28
ADDRLP4 36
INDIRF4
ASGNF4
line 101
;99:
;100:	//VectorSubtract( ent->r.currentOrigin, missile->r.currentOrigin, missile_dir );
;101:	AngleVectors(ent->client->ps.viewangles, missile_dir, 0, 0);
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 156
ADDP4
ARGP4
ADDRLP4 16
ARGP4
ADDRLP4 40
CNSTP4 0
ASGNP4
ADDRLP4 40
INDIRP4
ARGP4
ADDRLP4 40
INDIRP4
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 102
;102:	VectorCopy(missile_dir, bounce_dir);
ADDRLP4 4
ADDRLP4 16
INDIRB
ASGNB 12
line 104
;103:	//VectorCopy( missile->s.pos.trDelta, bounce_dir );
;104:	VectorScale( bounce_dir, DotProduct( forward, missile_dir ), bounce_dir );
ADDRLP4 44
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 48
ADDRLP4 16
INDIRF4
ASGNF4
ADDRLP4 52
ADDRLP4 44
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 56
ADDRLP4 44
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 4
ADDRLP4 4
INDIRF4
ADDRLP4 44
INDIRP4
INDIRF4
ADDRLP4 48
INDIRF4
MULF4
ADDRLP4 52
INDIRP4
INDIRF4
ADDRLP4 16+4
INDIRF4
MULF4
ADDF4
ADDRLP4 56
INDIRP4
INDIRF4
ADDRLP4 16+8
INDIRF4
MULF4
ADDF4
MULF4
ASGNF4
ADDRLP4 4+4
ADDRLP4 4+4
INDIRF4
ADDRLP4 44
INDIRP4
INDIRF4
ADDRLP4 48
INDIRF4
MULF4
ADDRLP4 52
INDIRP4
INDIRF4
ADDRLP4 16+4
INDIRF4
MULF4
ADDF4
ADDRLP4 56
INDIRP4
INDIRF4
ADDRLP4 16+8
INDIRF4
MULF4
ADDF4
MULF4
ASGNF4
ADDRLP4 60
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 4+8
ADDRLP4 4+8
INDIRF4
ADDRLP4 60
INDIRP4
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ADDRLP4 60
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 16+4
INDIRF4
MULF4
ADDF4
ADDRLP4 60
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 16+8
INDIRF4
MULF4
ADDF4
MULF4
ASGNF4
line 105
;105:	VectorNormalize( bounce_dir );
ADDRLP4 4
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 107
;106:
;107:	for ( i = 0; i < 3; i++ )
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $145
line 108
;108:	{
line 109
;109:		bounce_dir[i] += RandFloat( -1.0f, 1.0f );
CNSTF4 3212836864
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 64
ADDRGP4 RandFloat
CALLF4
ASGNF4
ADDRLP4 68
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
ADDP4
ASGNP4
ADDRLP4 68
INDIRP4
ADDRLP4 68
INDIRP4
INDIRF4
ADDRLP4 64
INDIRF4
ADDF4
ASGNF4
line 110
;110:	}
LABELV $146
line 107
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $145
line 112
;111:
;112:	VectorNormalize( bounce_dir );
ADDRLP4 4
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 113
;113:	VectorScale( bounce_dir, speed, missile->s.pos.trDelta );
ADDRFP4 4
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 4
INDIRF4
ADDRLP4 28
INDIRF4
MULF4
ASGNF4
ADDRFP4 4
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 4+4
INDIRF4
ADDRLP4 28
INDIRF4
MULF4
ASGNF4
ADDRFP4 4
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 4+8
INDIRF4
ADDRLP4 28
INDIRF4
MULF4
ASGNF4
line 114
;114:	missile->s.pos.trTime = level.time;		// move a bit on the very first frame
ADDRFP4 4
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 115
;115:	VectorCopy( missile->r.currentOrigin, missile->s.pos.trBase );
ADDRLP4 64
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 64
INDIRP4
CNSTI4 24
ADDP4
ADDRLP4 64
INDIRP4
CNSTI4 368
ADDP4
INDIRB
ASGNB 12
line 116
;116:	if ( missile->s.weapon != WP_SABER && missile->s.weapon != G2_MODEL_PART )
ADDRLP4 68
ADDRFP4 4
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
ASGNI4
ADDRLP4 68
INDIRI4
CNSTI4 2
EQI4 $152
ADDRLP4 68
INDIRI4
CNSTI4 50
EQI4 $152
line 117
;117:	{//you are mine, now!
line 118
;118:		missile->r.ownerNum = ent->s.number;
ADDRFP4 4
INDIRP4
CNSTI4 396
ADDP4
ADDRFP4 0
INDIRP4
INDIRI4
ASGNI4
line 119
;119:	}
LABELV $152
line 120
;120:	if ( missile->s.weapon == WP_ROCKET_LAUNCHER )
ADDRFP4 4
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 10
NEI4 $154
line 121
;121:	{//stop homing
line 122
;122:		missile->think = 0;
ADDRFP4 4
INDIRP4
CNSTI4 636
ADDP4
CNSTP4 0
ASGNP4
line 123
;123:		missile->nextthink = 0;
ADDRFP4 4
INDIRP4
CNSTI4 632
ADDP4
CNSTI4 0
ASGNI4
line 124
;124:	}
LABELV $154
line 125
;125:}
LABELV $132
endproc G_DeflectMissile 72 16
export G_BounceMissile
proc G_BounceMissile 44 12
line 133
;126:
;127:/*
;128:================
;129:G_BounceMissile
;130:
;131:================
;132:*/
;133:void G_BounceMissile( gentity_t *ent, trace_t *trace ) {
line 139
;134:	vec3_t	velocity;
;135:	float	dot;
;136:	int		hitTime;
;137:
;138:	// reflect the velocity on the trace plane
;139:	hitTime = level.previousTime + ( level.time - level.previousTime ) * trace->fraction;
ADDRLP4 16
ADDRGP4 level+36
INDIRI4
CVIF4 4
ADDRGP4 level+32
INDIRI4
ADDRGP4 level+36
INDIRI4
SUBI4
CVIF4 4
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
ADDF4
CVFI4 4
ASGNI4
line 140
;140:	BG_EvaluateTrajectoryDelta( &ent->s.pos, hitTime, velocity );
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRLP4 16
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
ADDRGP4 BG_EvaluateTrajectoryDelta
CALLV
pop
line 141
;141:	dot = DotProduct( velocity, trace->plane.normal );
ADDRLP4 20
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 12
ADDRLP4 0
INDIRF4
ADDRLP4 20
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
MULF4
ADDRLP4 0+4
INDIRF4
ADDRLP4 20
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
MULF4
ADDF4
ADDRLP4 0+8
INDIRF4
ADDRLP4 20
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 142
;142:	VectorMA( velocity, -2*dot, trace->plane.normal, ent->s.pos.trDelta );
ADDRFP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 0
INDIRF4
ADDRFP4 4
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
CNSTF4 3221225472
ADDRLP4 12
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 0+4
INDIRF4
ADDRFP4 4
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
CNSTF4 3221225472
ADDRLP4 12
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 0+8
INDIRF4
ADDRFP4 4
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
CNSTF4 3221225472
ADDRLP4 12
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 145
;143:
;144:
;145:	if ( ent->s.eFlags & EF_BOUNCE_SHRAPNEL ) 
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $164
line 146
;146:	{
line 147
;147:		VectorScale( ent->s.pos.trDelta, 0.25f, ent->s.pos.trDelta );
ADDRLP4 24
ADDRFP4 0
INDIRP4
CNSTI4 36
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
CNSTF4 1048576000
ADDRLP4 24
INDIRP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 28
ADDRFP4 0
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
CNSTF4 1048576000
ADDRLP4 28
INDIRP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 32
ADDRFP4 0
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
ADDRLP4 32
INDIRP4
CNSTF4 1048576000
ADDRLP4 32
INDIRP4
INDIRF4
MULF4
ASGNF4
line 148
;148:		ent->s.pos.trType = TR_GRAVITY;
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 5
ASGNI4
line 151
;149:
;150:		// check for stop
;151:		if ( trace->plane.normal[2] > 0.7 && ent->s.pos.trDelta[2] < 40 ) //this can happen even on very slightly sloped walls, so changed it from > 0 to > 0.7
ADDRFP4 4
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
CNSTF4 1060320051
LEF4 $165
ADDRFP4 0
INDIRP4
CNSTI4 44
ADDP4
INDIRF4
CNSTF4 1109393408
GEF4 $165
line 152
;152:		{
line 153
;153:			G_SetOrigin( ent, trace->endpos );
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRGP4 G_SetOrigin
CALLV
pop
line 154
;154:			ent->nextthink = level.time + 100;
ADDRFP4 0
INDIRP4
CNSTI4 632
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 100
ADDI4
ASGNI4
line 155
;155:			return;
ADDRGP4 $156
JUMPV
line 157
;156:		}
;157:	}
LABELV $164
line 158
;158:	else if ( ent->s.eFlags & EF_BOUNCE_HALF ) 
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 32
BANDI4
CNSTI4 0
EQI4 $169
line 159
;159:	{
line 160
;160:		VectorScale( ent->s.pos.trDelta, 0.65, ent->s.pos.trDelta );
ADDRLP4 24
ADDRFP4 0
INDIRP4
CNSTI4 36
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
CNSTF4 1059481190
ADDRLP4 24
INDIRP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 28
ADDRFP4 0
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
CNSTF4 1059481190
ADDRLP4 28
INDIRP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 32
ADDRFP4 0
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
ADDRLP4 32
INDIRP4
CNSTF4 1059481190
ADDRLP4 32
INDIRP4
INDIRF4
MULF4
ASGNF4
line 162
;161:		// check for stop
;162:		if ( trace->plane.normal[2] > 0.2 && VectorLength( ent->s.pos.trDelta ) < 40 ) 
ADDRFP4 4
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
CNSTF4 1045220557
LEF4 $171
ADDRFP4 0
INDIRP4
CNSTI4 36
ADDP4
ARGP4
ADDRLP4 36
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 36
INDIRF4
CNSTF4 1109393408
GEF4 $171
line 163
;163:		{
line 164
;164:			G_SetOrigin( ent, trace->endpos );
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRGP4 G_SetOrigin
CALLV
pop
line 165
;165:			return;
ADDRGP4 $156
JUMPV
LABELV $171
line 167
;166:		}
;167:	}
LABELV $169
LABELV $165
line 169
;168:
;169:	if (ent->s.weapon == WP_THERMAL)
ADDRFP4 0
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 11
NEI4 $173
line 170
;170:	{ //slight hack for hit sound
line 171
;171:		G_Sound(ent, CHAN_BODY, G_SoundIndex(va("sound/weapons/thermal/bounce%i.wav", Q_irand(1, 2))));
CNSTI4 1
ARGI4
CNSTI4 2
ARGI4
ADDRLP4 24
ADDRGP4 Q_irand
CALLI4
ASGNI4
ADDRGP4 $175
ARGP4
ADDRLP4 24
INDIRI4
ARGI4
ADDRLP4 28
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 28
INDIRP4
ARGP4
ADDRLP4 32
ADDRGP4 G_SoundIndex
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 5
ARGI4
ADDRLP4 32
INDIRI4
ARGI4
ADDRGP4 G_Sound
CALLV
pop
line 172
;172:	}
ADDRGP4 $174
JUMPV
LABELV $173
line 173
;173:	else if (ent->s.weapon == WP_SABER)
ADDRFP4 0
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 2
NEI4 $176
line 174
;174:	{
line 175
;175:		G_Sound(ent, CHAN_BODY, G_SoundIndex(va("sound/weapons/saber/bounce%i.wav", Q_irand(1, 3))));
CNSTI4 1
ARGI4
CNSTI4 3
ARGI4
ADDRLP4 24
ADDRGP4 Q_irand
CALLI4
ASGNI4
ADDRGP4 $178
ARGP4
ADDRLP4 24
INDIRI4
ARGI4
ADDRLP4 28
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 28
INDIRP4
ARGP4
ADDRLP4 32
ADDRGP4 G_SoundIndex
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 5
ARGI4
ADDRLP4 32
INDIRI4
ARGI4
ADDRGP4 G_Sound
CALLV
pop
line 176
;176:	}
ADDRGP4 $177
JUMPV
LABELV $176
line 177
;177:	else if (ent->s.weapon == G2_MODEL_PART)
ADDRFP4 0
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 50
NEI4 $179
line 178
;178:	{
line 180
;179:		//Limb bounce sound?
;180:	}
LABELV $179
LABELV $177
LABELV $174
line 182
;181:
;182:	VectorAdd( ent->r.currentOrigin, trace->plane.normal, ent->r.currentOrigin);
ADDRLP4 24
ADDRFP4 0
INDIRP4
CNSTI4 368
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRF4
ADDRFP4 4
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 28
ADDRFP4 0
INDIRP4
CNSTI4 372
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRF4
ADDRFP4 4
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 32
ADDRFP4 0
INDIRP4
CNSTI4 376
ADDP4
ASGNP4
ADDRLP4 32
INDIRP4
ADDRLP4 32
INDIRP4
INDIRF4
ADDRFP4 4
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ADDF4
ASGNF4
line 183
;183:	VectorCopy( ent->r.currentOrigin, ent->s.pos.trBase );
ADDRLP4 36
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 36
INDIRP4
CNSTI4 24
ADDP4
ADDRLP4 36
INDIRP4
CNSTI4 368
ADDP4
INDIRB
ASGNB 12
line 184
;184:	ent->s.pos.trTime = level.time;
ADDRFP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 186
;185:
;186:	if (ent->bounceCount != -5)
ADDRFP4 0
INDIRP4
CNSTI4 716
ADDP4
INDIRI4
CNSTI4 -5
EQI4 $182
line 187
;187:	{
line 188
;188:		ent->bounceCount--;
ADDRLP4 40
ADDRFP4 0
INDIRP4
CNSTI4 716
ADDP4
ASGNP4
ADDRLP4 40
INDIRP4
ADDRLP4 40
INDIRP4
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
line 189
;189:	}
LABELV $182
line 190
;190:}
LABELV $156
endproc G_BounceMissile 44 12
export G_ExplodeMissile
proc G_ExplodeMissile 44 24
line 200
;191:
;192:
;193:/*
;194:================
;195:G_ExplodeMissile
;196:
;197:Explode a missile without an impact
;198:================
;199:*/
;200:void G_ExplodeMissile( gentity_t *ent ) {
line 204
;201:	vec3_t		dir;
;202:	vec3_t		origin;
;203:
;204:	BG_EvaluateTrajectory( &ent->s.pos, level.time, origin );
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRGP4 level+32
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
ADDRGP4 BG_EvaluateTrajectory
CALLV
pop
line 205
;205:	SnapVector( origin );
ADDRLP4 0
ADDRLP4 0
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
line 206
;206:	G_SetOrigin( ent, origin );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 G_SetOrigin
CALLV
pop
line 209
;207:
;208:	// we don't have a valid direction, so just point straight up
;209:	dir[0] = dir[1] = 0;
ADDRLP4 24
CNSTF4 0
ASGNF4
ADDRLP4 12+4
ADDRLP4 24
INDIRF4
ASGNF4
ADDRLP4 12
ADDRLP4 24
INDIRF4
ASGNF4
line 210
;210:	dir[2] = 1;
ADDRLP4 12+8
CNSTF4 1065353216
ASGNF4
line 212
;211:
;212:	ent->s.eType = ET_GENERAL;
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 0
ASGNI4
line 213
;213:	G_AddEvent( ent, EV_MISSILE_MISS, DirToByte( dir ) );
ADDRLP4 12
ARGP4
ADDRLP4 28
ADDRGP4 DirToByte
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 74
ARGI4
ADDRLP4 28
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 215
;214:
;215:	ent->freeAfterEvent = qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 492
ADDP4
CNSTI4 1
ASGNI4
line 218
;216:
;217:	// splash damage
;218:	if ( ent->splashDamage ) {
ADDRFP4 0
INDIRP4
CNSTI4 696
ADDP4
INDIRI4
CNSTI4 0
EQI4 $192
line 219
;219:		if( G_RadiusDamage( ent->r.currentOrigin, ent->parent, ent->splashDamage, ent->splashRadius, ent, 
ADDRLP4 32
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 32
INDIRP4
CNSTI4 368
ADDP4
ARGP4
ADDRLP4 32
INDIRP4
CNSTI4 536
ADDP4
INDIRP4
ARGP4
ADDRLP4 32
INDIRP4
CNSTI4 696
ADDP4
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 32
INDIRP4
CNSTI4 700
ADDP4
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 32
INDIRP4
ARGP4
ADDRLP4 32
INDIRP4
CNSTI4 708
ADDP4
INDIRI4
ARGI4
ADDRLP4 36
ADDRGP4 G_RadiusDamage
CALLI4
ASGNI4
ADDRLP4 36
INDIRI4
CNSTI4 0
EQI4 $194
line 221
;220:				ent->splashMethodOfDeath ) ) 
;221:		{
line 222
;222:			if (ent->parent)
ADDRFP4 0
INDIRP4
CNSTI4 536
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $196
line 223
;223:			{
line 224
;224:				g_entities[ent->parent->s.number].client->accuracy_hits++;
ADDRLP4 40
CNSTI4 828
ADDRFP4 0
INDIRP4
CNSTI4 536
ADDP4
INDIRP4
INDIRI4
MULI4
ADDRGP4 g_entities+408
ADDP4
INDIRP4
CNSTI4 1668
ADDP4
ASGNP4
ADDRLP4 40
INDIRP4
ADDRLP4 40
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 225
;225:			}
ADDRGP4 $197
JUMPV
LABELV $196
line 226
;226:			else if (ent->activator)
ADDRFP4 0
INDIRP4
CNSTI4 732
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $199
line 227
;227:			{
line 228
;228:				g_entities[ent->activator->s.number].client->accuracy_hits++;
ADDRLP4 40
CNSTI4 828
ADDRFP4 0
INDIRP4
CNSTI4 732
ADDP4
INDIRP4
INDIRI4
MULI4
ADDRGP4 g_entities+408
ADDP4
INDIRP4
CNSTI4 1668
ADDP4
ASGNP4
ADDRLP4 40
INDIRP4
ADDRLP4 40
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 229
;229:			}
LABELV $199
LABELV $197
line 230
;230:		}
LABELV $194
line 231
;231:	}
LABELV $192
line 233
;232:
;233:	trap_LinkEntity( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 234
;234:}
LABELV $184
endproc G_ExplodeMissile 44 24
export G_RunStuckMissile
proc G_RunStuckMissile 32 32
line 237
;235:
;236:void G_RunStuckMissile( gentity_t *ent )
;237:{
line 238
;238:	if ( ent->takedamage )
ADDRFP4 0
INDIRP4
CNSTI4 680
ADDP4
INDIRI4
CNSTI4 0
EQI4 $203
line 239
;239:	{
line 240
;240:		if ( ent->s.groundEntityNum >= 0 && ent->s.groundEntityNum < ENTITYNUM_WORLD )
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
LTI4 $205
ADDRLP4 0
INDIRI4
CNSTI4 1022
GEI4 $205
line 241
;241:		{
line 242
;242:			gentity_t *other = &g_entities[ent->s.groundEntityNum];
ADDRLP4 4
CNSTI4 828
ADDRFP4 0
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 244
;243:
;244:			if ( (!VectorCompare( vec3_origin, other->s.pos.trDelta ) && other->s.pos.trType != TR_STATIONARY) || 
ADDRGP4 vec3_origin
ARGP4
ADDRLP4 4
INDIRP4
CNSTI4 36
ADDP4
ARGP4
ADDRLP4 8
ADDRGP4 VectorCompare
CALLI4
ASGNI4
ADDRLP4 12
CNSTI4 0
ASGNI4
ADDRLP4 8
INDIRI4
ADDRLP4 12
INDIRI4
NEI4 $210
ADDRLP4 4
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ADDRLP4 12
INDIRI4
NEI4 $209
LABELV $210
ADDRGP4 vec3_origin
ARGP4
ADDRLP4 4
INDIRP4
CNSTI4 72
ADDP4
ARGP4
ADDRLP4 16
ADDRGP4 VectorCompare
CALLI4
ASGNI4
ADDRLP4 20
CNSTI4 0
ASGNI4
ADDRLP4 16
INDIRI4
ADDRLP4 20
INDIRI4
NEI4 $207
ADDRLP4 4
INDIRP4
CNSTI4 48
ADDP4
INDIRI4
ADDRLP4 20
INDIRI4
EQI4 $207
LABELV $209
line 246
;245:				(!VectorCompare( vec3_origin, other->s.apos.trDelta ) && other->s.apos.trType != TR_STATIONARY) )
;246:			{//thing I stuck to is moving or rotating now, kill me
line 247
;247:				G_Damage( ent, other, other, NULL, NULL, 99999, 0, MOD_CRUSH );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 24
ADDRLP4 4
INDIRP4
ASGNP4
ADDRLP4 24
INDIRP4
ARGP4
ADDRLP4 24
INDIRP4
ARGP4
ADDRLP4 28
CNSTP4 0
ASGNP4
ADDRLP4 28
INDIRP4
ARGP4
ADDRLP4 28
INDIRP4
ARGP4
CNSTI4 99999
ARGI4
CNSTI4 0
ARGI4
CNSTI4 32
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 248
;248:				return;
ADDRGP4 $202
JUMPV
LABELV $207
line 250
;249:			}
;250:		}
LABELV $205
line 251
;251:	}
LABELV $203
line 253
;252:	// check think function
;253:	G_RunThink( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_RunThink
CALLV
pop
line 254
;254:}
LABELV $202
endproc G_RunStuckMissile 32 32
export G_BounceProjectile
proc G_BounceProjectile 64 4
line 261
;255:
;256:/*
;257:================
;258:G_BounceProjectile
;259:================
;260:*/
;261:void G_BounceProjectile( vec3_t start, vec3_t impact, vec3_t dir, vec3_t endout ) {
line 265
;262:	vec3_t v, newv;
;263:	float dot;
;264:
;265:	VectorSubtract( impact, start, v );
ADDRLP4 28
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 32
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 28
INDIRP4
INDIRF4
ADDRLP4 32
INDIRP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 36
CNSTI4 4
ASGNI4
ADDRLP4 0+4
ADDRLP4 28
INDIRP4
ADDRLP4 36
INDIRI4
ADDP4
INDIRF4
ADDRLP4 32
INDIRP4
ADDRLP4 36
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 40
CNSTI4 8
ASGNI4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
ADDRLP4 40
INDIRI4
ADDP4
INDIRF4
ADDRFP4 0
INDIRP4
ADDRLP4 40
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 266
;266:	dot = DotProduct( v, dir );
ADDRLP4 44
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 24
ADDRLP4 0
INDIRF4
ADDRLP4 44
INDIRP4
INDIRF4
MULF4
ADDRLP4 0+4
INDIRF4
ADDRLP4 44
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
MULF4
ADDF4
ADDRLP4 0+8
INDIRF4
ADDRLP4 44
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 267
;267:	VectorMA( v, -2*dot, dir, newv );
ADDRLP4 48
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 52
CNSTF4 3221225472
ADDRLP4 24
INDIRF4
MULF4
ASGNF4
ADDRLP4 12
ADDRLP4 0
INDIRF4
ADDRLP4 48
INDIRP4
INDIRF4
ADDRLP4 52
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 12+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 48
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 52
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 12+8
ADDRLP4 0+8
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
CNSTF4 3221225472
ADDRLP4 24
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 269
;268:
;269:	VectorNormalize(newv);
ADDRLP4 12
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 270
;270:	VectorMA(impact, 8192, newv, endout);
ADDRFP4 12
INDIRP4
ADDRFP4 4
INDIRP4
INDIRF4
CNSTF4 1174405120
ADDRLP4 12
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 56
CNSTI4 4
ASGNI4
ADDRFP4 12
INDIRP4
ADDRLP4 56
INDIRI4
ADDP4
ADDRFP4 4
INDIRP4
ADDRLP4 56
INDIRI4
ADDP4
INDIRF4
CNSTF4 1174405120
ADDRLP4 12+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 60
CNSTI4 8
ASGNI4
ADDRFP4 12
INDIRP4
ADDRLP4 60
INDIRI4
ADDP4
ADDRFP4 4
INDIRP4
ADDRLP4 60
INDIRI4
ADDP4
INDIRF4
CNSTF4 1174405120
ADDRLP4 12+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 271
;271:}
LABELV $211
endproc G_BounceProjectile 64 4
export CreateMissile
proc CreateMissile 20 0
line 278
;272:
;273:
;274://-----------------------------------------------------------------------------
;275:gentity_t *CreateMissile( vec3_t org, vec3_t dir, float vel, int life, 
;276:							gentity_t *owner, qboolean altFire)
;277://-----------------------------------------------------------------------------
;278:{
line 281
;279:	gentity_t	*missile;
;280:
;281:	missile = G_Spawn();
ADDRLP4 4
ADDRGP4 G_Spawn
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
line 283
;282:	
;283:	missile->nextthink = level.time + life;
ADDRLP4 0
INDIRP4
CNSTI4 632
ADDP4
ADDRGP4 level+32
INDIRI4
ADDRFP4 12
INDIRI4
ADDI4
ASGNI4
line 284
;284:	missile->think = G_FreeEntity;
ADDRLP4 0
INDIRP4
CNSTI4 636
ADDP4
ADDRGP4 G_FreeEntity
ASGNP4
line 285
;285:	missile->s.eType = ET_MISSILE;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 3
ASGNI4
line 286
;286:	missile->r.svFlags = SVF_USE_CURRENT_ORIGIN;
ADDRLP4 0
INDIRP4
CNSTI4 304
ADDP4
CNSTI4 128
ASGNI4
line 287
;287:	missile->parent = owner;
ADDRLP4 0
INDIRP4
CNSTI4 536
ADDP4
ADDRFP4 16
INDIRP4
ASGNP4
line 288
;288:	missile->r.ownerNum = owner->s.number;
ADDRLP4 0
INDIRP4
CNSTI4 396
ADDP4
ADDRFP4 16
INDIRP4
INDIRI4
ASGNI4
line 290
;289:
;290:	if (altFire)
ADDRFP4 20
INDIRI4
CNSTI4 0
EQI4 $224
line 291
;291:	{
line 292
;292:		missile->s.eFlags |= EF_ALT_FIRING;
ADDRLP4 8
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 512
BORI4
ASGNI4
line 293
;293:	}
LABELV $224
line 295
;294:
;295:	missile->s.pos.trType = TR_LINEAR;
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 2
ASGNI4
line 296
;296:	missile->s.pos.trTime = level.time;// - MISSILE_PRESTEP_TIME;	// NOTENOTE This is a Quake 3 addition over JK2
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 297
;297:	missile->target_ent = NULL;
ADDRLP4 0
INDIRP4
CNSTI4 604
ADDP4
CNSTP4 0
ASGNP4
line 299
;298:
;299:	SnapVector(org);
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
ADDRLP4 12
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
ADDRLP4 16
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
line 300
;300:	VectorCopy( org, missile->s.pos.trBase );
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 301
;301:	VectorScale( dir, vel, missile->s.pos.trDelta );
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRFP4 4
INDIRP4
INDIRF4
ADDRFP4 8
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRFP4 8
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRFP4 8
INDIRF4
MULF4
ASGNF4
line 302
;302:	VectorCopy( org, missile->r.currentOrigin);
ADDRLP4 0
INDIRP4
CNSTI4 368
ADDP4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 303
;303:	SnapVector(missile->s.pos.trDelta);
ADDRLP4 8
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
ADDRLP4 12
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
line 305
;304:
;305:	return missile;
ADDRLP4 0
INDIRP4
RETP4
LABELV $222
endproc CreateMissile 20 0
export G_MissileImpact
proc G_MissileImpact 128 32
line 314
;306:}
;307:
;308:
;309:/*
;310:================
;311:G_MissileImpact
;312:================
;313:*/
;314:void G_MissileImpact( gentity_t *ent, trace_t *trace ) {
line 316
;315:	gentity_t		*other;
;316:	qboolean		hitClient = qfalse;
ADDRLP4 4
CNSTI4 0
ASGNI4
line 317
;317:	other = &g_entities[trace->entityNum];
ADDRLP4 0
CNSTI4 828
ADDRFP4 4
INDIRP4
CNSTI4 52
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 320
;318:
;319:	// check for bounce
;320:	if ( !other->takedamage &&
ADDRLP4 8
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 680
ADDP4
INDIRI4
ADDRLP4 8
INDIRI4
NEI4 $228
ADDRLP4 12
ADDRFP4 0
INDIRP4
CNSTI4 716
ADDP4
INDIRI4
ASGNI4
ADDRLP4 12
INDIRI4
ADDRLP4 8
INDIRI4
GTI4 $230
ADDRLP4 12
INDIRI4
CNSTI4 -5
NEI4 $228
LABELV $230
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 48
BANDI4
CNSTI4 0
EQI4 $228
line 322
;321:		(ent->bounceCount > 0 || ent->bounceCount == -5) &&
;322:		( ent->s.eFlags & ( EF_BOUNCE | EF_BOUNCE_HALF ) ) ) {
line 323
;323:		G_BounceMissile( ent, trace );
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 G_BounceMissile
CALLV
pop
line 324
;324:		G_AddEvent( ent, EV_GRENADE_BOUNCE, 0 );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 61
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 325
;325:		return;
ADDRGP4 $227
JUMPV
LABELV $228
line 329
;326:	}
;327:	
;328:	// I would glom onto the EF_BOUNCE code section above, but don't feel like risking breaking something else
;329:	if ( (!other->takedamage && (ent->bounceCount > 0 || ent->bounceCount == -5) && ( ent->s.eFlags&(EF_BOUNCE_SHRAPNEL) ) ) || ((trace->surfaceFlags&SURF_FORCEFIELD)&&!ent->splashDamage&&!ent->splashRadius&&(ent->bounceCount > 0 || ent->bounceCount == -5)) ) 
ADDRLP4 16
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 680
ADDP4
INDIRI4
ADDRLP4 16
INDIRI4
NEI4 $235
ADDRLP4 20
ADDRFP4 0
INDIRP4
CNSTI4 716
ADDP4
INDIRI4
ASGNI4
ADDRLP4 20
INDIRI4
ADDRLP4 16
INDIRI4
GTI4 $236
ADDRLP4 20
INDIRI4
CNSTI4 -5
NEI4 $235
LABELV $236
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
NEI4 $237
LABELV $235
ADDRLP4 24
CNSTI4 0
ASGNI4
ADDRFP4 4
INDIRP4
CNSTI4 44
ADDP4
INDIRI4
CNSTI4 65536
BANDI4
ADDRLP4 24
INDIRI4
EQI4 $231
ADDRLP4 28
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 28
INDIRP4
CNSTI4 696
ADDP4
INDIRI4
ADDRLP4 24
INDIRI4
NEI4 $231
ADDRLP4 28
INDIRP4
CNSTI4 700
ADDP4
INDIRI4
ADDRLP4 24
INDIRI4
NEI4 $231
ADDRLP4 32
ADDRLP4 28
INDIRP4
CNSTI4 716
ADDP4
INDIRI4
ASGNI4
ADDRLP4 32
INDIRI4
ADDRLP4 24
INDIRI4
GTI4 $237
ADDRLP4 32
INDIRI4
CNSTI4 -5
NEI4 $231
LABELV $237
line 330
;330:	{
line 331
;331:		G_BounceMissile( ent, trace );
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 G_BounceMissile
CALLV
pop
line 333
;332:
;333:		if ( ent->bounceCount < 1 )
ADDRFP4 0
INDIRP4
CNSTI4 716
ADDP4
INDIRI4
CNSTI4 1
GEI4 $227
line 334
;334:		{
line 335
;335:			ent->s.eFlags &= ~EF_BOUNCE_SHRAPNEL;
ADDRLP4 36
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 36
INDIRP4
ADDRLP4 36
INDIRP4
INDIRI4
CNSTI4 -3
BANDI4
ASGNI4
line 336
;336:		}
line 337
;337:		return;
ADDRGP4 $227
JUMPV
LABELV $231
line 353
;338:	}
;339:
;340:	/*
;341:	if ( !other->takedamage && ent->s.weapon == WP_THERMAL && !ent->alt_fire )
;342:	{//rolling thermal det - FIXME: make this an eFlag like bounce & stick!!!
;343:		//G_BounceRollMissile( ent, trace );
;344:		if ( ent->owner && ent->owner->s.number == 0 ) 
;345:		{
;346:			G_MissileAddAlerts( ent );
;347:		}
;348:		//gi.linkentity( ent );
;349:		return;
;350:	}
;351:	*/
;352:
;353:	if (other->r.contents & CONTENTS_LIGHTSABER)
ADDRLP4 0
INDIRP4
CNSTI4 340
ADDP4
INDIRI4
CNSTI4 262144
BANDI4
CNSTI4 0
EQI4 $240
line 354
;354:	{ //hit this person's saber, so..
line 355
;355:		gentity_t *otherOwner = &g_entities[other->r.ownerNum];
ADDRLP4 36
CNSTI4 828
ADDRLP4 0
INDIRP4
CNSTI4 396
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 357
;356:
;357:		if (otherOwner->takedamage && otherOwner->client && otherOwner->client->ps.duelInProgress &&
ADDRLP4 44
CNSTI4 0
ASGNI4
ADDRLP4 36
INDIRP4
CNSTI4 680
ADDP4
INDIRI4
ADDRLP4 44
INDIRI4
EQI4 $241
ADDRLP4 48
ADDRLP4 36
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 48
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $241
ADDRLP4 48
INDIRP4
CNSTI4 1304
ADDP4
INDIRI4
ADDRLP4 44
INDIRI4
EQI4 $241
ADDRLP4 48
INDIRP4
CNSTI4 1296
ADDP4
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 396
ADDP4
INDIRI4
EQI4 $241
line 359
;358:			otherOwner->client->ps.duelIndex != ent->r.ownerNum)
;359:		{
line 360
;360:			goto killProj;
ADDRGP4 $244
JUMPV
line 362
;361:		}
;362:	}
LABELV $240
line 364
;363:	else
;364:	{
line 365
;365:		if (other->takedamage && other->client && other->client->ps.duelInProgress &&
ADDRLP4 40
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 680
ADDP4
INDIRI4
ADDRLP4 40
INDIRI4
EQI4 $245
ADDRLP4 44
ADDRLP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 44
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $245
ADDRLP4 44
INDIRP4
CNSTI4 1304
ADDP4
INDIRI4
ADDRLP4 40
INDIRI4
EQI4 $245
ADDRLP4 44
INDIRP4
CNSTI4 1296
ADDP4
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 396
ADDP4
INDIRI4
EQI4 $245
line 367
;366:			other->client->ps.duelIndex != ent->r.ownerNum)
;367:		{
line 368
;368:			goto killProj;
ADDRGP4 $244
JUMPV
LABELV $245
line 370
;369:		}
;370:	}
LABELV $241
line 372
;371:
;372:	if (other->takedamage && other->client &&
ADDRLP4 40
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 680
ADDP4
INDIRI4
ADDRLP4 40
INDIRI4
EQI4 $247
ADDRLP4 44
ADDRLP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 44
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $247
ADDRLP4 48
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 52
ADDRLP4 48
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
ASGNI4
ADDRLP4 52
INDIRI4
CNSTI4 10
EQI4 $247
ADDRLP4 52
INDIRI4
CNSTI4 11
EQI4 $247
ADDRLP4 56
CNSTI4 12
ASGNI4
ADDRLP4 52
INDIRI4
ADDRLP4 56
INDIRI4
EQI4 $247
ADDRLP4 52
INDIRI4
CNSTI4 13
EQI4 $247
ADDRLP4 52
INDIRI4
CNSTI4 8
EQI4 $247
ADDRLP4 60
ADDRLP4 48
INDIRP4
CNSTI4 704
ADDP4
INDIRI4
ASGNI4
ADDRLP4 60
INDIRI4
ADDRLP4 56
INDIRI4
EQI4 $247
ADDRLP4 60
INDIRI4
CNSTI4 17
EQI4 $247
ADDRLP4 44
INDIRP4
CNSTI4 756
ADDP4
INDIRI4
ADDRGP4 level+32
INDIRI4
GEI4 $247
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 48
INDIRP4
CNSTI4 368
ADDP4
ARGP4
ADDRLP4 40
INDIRI4
ARGI4
ADDRLP4 40
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRLP4 40
INDIRI4
ARGI4
ADDRLP4 64
ADDRGP4 WP_SaberCanBlock
CALLI4
ASGNI4
ADDRLP4 64
INDIRI4
CNSTI4 0
EQI4 $247
line 382
;373:		ent->s.weapon != WP_ROCKET_LAUNCHER &&
;374:		ent->s.weapon != WP_THERMAL &&
;375:		ent->s.weapon != WP_TRIP_MINE &&
;376:		ent->s.weapon != WP_DET_PACK &&
;377:		ent->s.weapon != WP_DEMP2 &&
;378:		ent->methodOfDeath != MOD_REPEATER_ALT &&
;379:		ent->methodOfDeath != MOD_FLECHETTE_ALT_SPLASH &&
;380:		other->client->ps.saberBlockTime < level.time &&
;381:		WP_SaberCanBlock(other, ent->r.currentOrigin, 0, 0, qtrue, 0))
;382:	{ //only block one projectile per 200ms (to prevent giant swarms of projectiles being blocked)
line 385
;383:		vec3_t fwd;
;384:		gentity_t *te;
;385:		int otherDefLevel = other->client->ps.fd.forcePowerLevel[FP_SABERDEFEND];
ADDRLP4 68
ADDRLP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1008
ADDP4
INDIRI4
ASGNI4
line 387
;386:
;387:		te = G_TempEntity( ent->r.currentOrigin, EV_SABER_BLOCK );
ADDRFP4 0
INDIRP4
CNSTI4 368
ADDP4
ARGP4
CNSTI4 28
ARGI4
ADDRLP4 88
ADDRGP4 G_TempEntity
CALLP4
ASGNP4
ADDRLP4 72
ADDRLP4 88
INDIRP4
ASGNP4
line 388
;388:		VectorCopy(ent->r.currentOrigin, te->s.origin);
ADDRLP4 72
INDIRP4
CNSTI4 92
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 368
ADDP4
INDIRB
ASGNB 12
line 389
;389:		VectorCopy(trace->plane.normal, te->s.angles);
ADDRLP4 72
INDIRP4
CNSTI4 116
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 24
ADDP4
INDIRB
ASGNB 12
line 390
;390:		te->s.eventParm = 0;
ADDRLP4 72
INDIRP4
CNSTI4 256
ADDP4
CNSTI4 0
ASGNI4
line 396
;391:
;392:		/*if (other->client->ps.velocity[2] > 0 ||
;393:			other->client->pers.cmd.forwardmove ||
;394:			other->client->pers.cmd.rightmove)
;395:			*/
;396:		if (other->client->ps.velocity[2] > 0 ||
ADDRLP4 92
ADDRLP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 92
INDIRP4
CNSTI4 40
ADDP4
INDIRF4
CNSTF4 0
GTF4 $252
ADDRLP4 92
INDIRP4
CNSTI4 1408
ADDP4
INDIRI1
CVII4 1
CNSTI4 0
GEI4 $250
LABELV $252
line 398
;397:			other->client->pers.cmd.forwardmove < 0) //now we only do it if jumping or running backward. Should be able to full-on charge.
;398:		{
line 399
;399:			otherDefLevel -= 1;
ADDRLP4 68
ADDRLP4 68
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
line 400
;400:			if (otherDefLevel < 0)
ADDRLP4 68
INDIRI4
CNSTI4 0
GEI4 $253
line 401
;401:			{
line 402
;402:				otherDefLevel = 0;
ADDRLP4 68
CNSTI4 0
ASGNI4
line 403
;403:			}
LABELV $253
line 404
;404:		}
LABELV $250
line 406
;405:
;406:		AngleVectors(other->client->ps.viewangles, fwd, NULL, NULL);
ADDRLP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 156
ADDP4
ARGP4
ADDRLP4 76
ARGP4
ADDRLP4 96
CNSTP4 0
ASGNP4
ADDRLP4 96
INDIRP4
ARGP4
ADDRLP4 96
INDIRP4
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 407
;407:		if (otherDefLevel == FORCE_LEVEL_1)
ADDRLP4 68
INDIRI4
CNSTI4 1
NEI4 $255
line 408
;408:		{
line 410
;409:			//if def is only level 1, instead of deflecting the shot it should just die here
;410:		}
ADDRGP4 $256
JUMPV
LABELV $255
line 411
;411:		else if (otherDefLevel == FORCE_LEVEL_2)
ADDRLP4 68
INDIRI4
CNSTI4 2
NEI4 $257
line 412
;412:		{
line 413
;413:			G_DeflectMissile(other, ent, fwd);
ADDRLP4 0
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 76
ARGP4
ADDRGP4 G_DeflectMissile
CALLV
pop
line 414
;414:		}
ADDRGP4 $258
JUMPV
LABELV $257
line 416
;415:		else
;416:		{
line 417
;417:			G_ReflectMissile(other, ent, fwd);
ADDRLP4 0
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 76
ARGP4
ADDRGP4 G_ReflectMissile
CALLV
pop
line 418
;418:		}
LABELV $258
LABELV $256
line 419
;419:		other->client->ps.saberBlockTime = level.time + (350 - (otherDefLevel*100)); //200;
ADDRLP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 756
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 350
CNSTI4 100
ADDRLP4 68
INDIRI4
MULI4
SUBI4
ADDI4
ASGNI4
line 421
;420:
;421:		if (otherDefLevel == FORCE_LEVEL_3)
ADDRLP4 68
INDIRI4
CNSTI4 3
NEI4 $260
line 422
;422:		{
line 423
;423:			other->client->ps.saberBlockTime = 0; //^_^
ADDRLP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 756
ADDP4
CNSTI4 0
ASGNI4
line 424
;424:		}
LABELV $260
line 426
;425:
;426:		if (otherDefLevel == FORCE_LEVEL_1)
ADDRLP4 68
INDIRI4
CNSTI4 1
NEI4 $227
line 427
;427:		{
line 428
;428:			goto killProj;
ADDRGP4 $244
JUMPV
line 430
;429:		}
;430:		return;
LABELV $247
line 432
;431:	}
;432:	else if (other->r.contents & CONTENTS_LIGHTSABER)
ADDRLP4 0
INDIRP4
CNSTI4 340
ADDP4
INDIRI4
CNSTI4 262144
BANDI4
CNSTI4 0
EQI4 $264
line 433
;433:	{ //hit this person's saber, so..
line 434
;434:		gentity_t *otherOwner = &g_entities[other->r.ownerNum];
ADDRLP4 68
CNSTI4 828
ADDRLP4 0
INDIRP4
CNSTI4 396
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 436
;435:
;436:		if (otherOwner->takedamage && otherOwner->client &&
ADDRLP4 72
ADDRLP4 68
INDIRP4
ASGNP4
ADDRLP4 72
INDIRP4
CNSTI4 680
ADDP4
INDIRI4
CNSTI4 0
EQI4 $266
ADDRLP4 72
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $266
ADDRLP4 76
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 80
ADDRLP4 76
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
ASGNI4
ADDRLP4 80
INDIRI4
CNSTI4 10
EQI4 $266
ADDRLP4 80
INDIRI4
CNSTI4 11
EQI4 $266
ADDRLP4 84
CNSTI4 12
ASGNI4
ADDRLP4 80
INDIRI4
ADDRLP4 84
INDIRI4
EQI4 $266
ADDRLP4 80
INDIRI4
CNSTI4 13
EQI4 $266
ADDRLP4 80
INDIRI4
CNSTI4 8
EQI4 $266
ADDRLP4 88
ADDRLP4 76
INDIRP4
CNSTI4 704
ADDP4
INDIRI4
ASGNI4
ADDRLP4 88
INDIRI4
ADDRLP4 84
INDIRI4
EQI4 $266
ADDRLP4 88
INDIRI4
CNSTI4 17
EQI4 $266
line 445
;437:			ent->s.weapon != WP_ROCKET_LAUNCHER &&
;438:			ent->s.weapon != WP_THERMAL &&
;439:			ent->s.weapon != WP_TRIP_MINE &&
;440:			ent->s.weapon != WP_DET_PACK &&
;441:			ent->s.weapon != WP_DEMP2 &&
;442:			ent->methodOfDeath != MOD_REPEATER_ALT &&
;443:			ent->methodOfDeath != MOD_FLECHETTE_ALT_SPLASH /*&&
;444:			otherOwner->client->ps.saberBlockTime < level.time*/)
;445:		{ //for now still deflect even if saberBlockTime >= level.time because it hit the actual saber
line 448
;446:			vec3_t fwd;
;447:			gentity_t *te;
;448:			int otherDefLevel = otherOwner->client->ps.fd.forcePowerLevel[FP_SABERDEFEND];
ADDRLP4 92
ADDRLP4 68
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1008
ADDP4
INDIRI4
ASGNI4
line 451
;449:
;450:			//in this case, deflect it even if we can't actually block it because it hit our saber
;451:			WP_SaberCanBlock(otherOwner, ent->r.currentOrigin, 0, 0, qtrue, 0);
ADDRLP4 68
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 368
ADDP4
ARGP4
ADDRLP4 112
CNSTI4 0
ASGNI4
ADDRLP4 112
INDIRI4
ARGI4
ADDRLP4 112
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRLP4 112
INDIRI4
ARGI4
ADDRGP4 WP_SaberCanBlock
CALLI4
pop
line 453
;452:
;453:			te = G_TempEntity( ent->r.currentOrigin, EV_SABER_BLOCK );
ADDRFP4 0
INDIRP4
CNSTI4 368
ADDP4
ARGP4
CNSTI4 28
ARGI4
ADDRLP4 116
ADDRGP4 G_TempEntity
CALLP4
ASGNP4
ADDRLP4 96
ADDRLP4 116
INDIRP4
ASGNP4
line 454
;454:			VectorCopy(ent->r.currentOrigin, te->s.origin);
ADDRLP4 96
INDIRP4
CNSTI4 92
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 368
ADDP4
INDIRB
ASGNB 12
line 455
;455:			VectorCopy(trace->plane.normal, te->s.angles);
ADDRLP4 96
INDIRP4
CNSTI4 116
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 24
ADDP4
INDIRB
ASGNB 12
line 456
;456:			te->s.eventParm = 0;
ADDRLP4 96
INDIRP4
CNSTI4 256
ADDP4
CNSTI4 0
ASGNI4
line 461
;457:
;458:			/*if (otherOwner->client->ps.velocity[2] > 0 ||
;459:				otherOwner->client->pers.cmd.forwardmove ||
;460:				otherOwner->client->pers.cmd.rightmove)*/
;461:			if (otherOwner->client->ps.velocity[2] > 0 ||
ADDRLP4 120
ADDRLP4 68
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 120
INDIRP4
CNSTI4 40
ADDP4
INDIRF4
CNSTF4 0
GTF4 $270
ADDRLP4 120
INDIRP4
CNSTI4 1408
ADDP4
INDIRI1
CVII4 1
CNSTI4 0
GEI4 $268
LABELV $270
line 463
;462:				otherOwner->client->pers.cmd.forwardmove < 0) //now we only do it if jumping or running backward. Should be able to full-on charge.
;463:			{
line 464
;464:				otherDefLevel -= 1;
ADDRLP4 92
ADDRLP4 92
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
line 465
;465:				if (otherDefLevel < 0)
ADDRLP4 92
INDIRI4
CNSTI4 0
GEI4 $271
line 466
;466:				{
line 467
;467:					otherDefLevel = 0;
ADDRLP4 92
CNSTI4 0
ASGNI4
line 468
;468:				}
LABELV $271
line 469
;469:			}
LABELV $268
line 471
;470:
;471:			AngleVectors(otherOwner->client->ps.viewangles, fwd, NULL, NULL);
ADDRLP4 68
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 156
ADDP4
ARGP4
ADDRLP4 100
ARGP4
ADDRLP4 124
CNSTP4 0
ASGNP4
ADDRLP4 124
INDIRP4
ARGP4
ADDRLP4 124
INDIRP4
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 473
;472:
;473:			if (otherDefLevel == FORCE_LEVEL_1)
ADDRLP4 92
INDIRI4
CNSTI4 1
NEI4 $273
line 474
;474:			{
line 476
;475:				//if def is only level 1, instead of deflecting the shot it should just die here
;476:			}
ADDRGP4 $274
JUMPV
LABELV $273
line 477
;477:			else if (otherDefLevel == FORCE_LEVEL_2)
ADDRLP4 92
INDIRI4
CNSTI4 2
NEI4 $275
line 478
;478:			{
line 479
;479:				G_DeflectMissile(otherOwner, ent, fwd);
ADDRLP4 68
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 100
ARGP4
ADDRGP4 G_DeflectMissile
CALLV
pop
line 480
;480:			}
ADDRGP4 $276
JUMPV
LABELV $275
line 482
;481:			else
;482:			{
line 483
;483:				G_ReflectMissile(otherOwner, ent, fwd);
ADDRLP4 68
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 100
ARGP4
ADDRGP4 G_ReflectMissile
CALLV
pop
line 484
;484:			}
LABELV $276
LABELV $274
line 485
;485:			otherOwner->client->ps.saberBlockTime = level.time + (350 - (otherDefLevel*100));//200;
ADDRLP4 68
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 756
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 350
CNSTI4 100
ADDRLP4 92
INDIRI4
MULI4
SUBI4
ADDI4
ASGNI4
line 487
;486:
;487:			if (otherDefLevel == FORCE_LEVEL_3)
ADDRLP4 92
INDIRI4
CNSTI4 3
NEI4 $278
line 488
;488:			{
line 489
;489:				otherOwner->client->ps.saberBlockTime = 0; //^_^
ADDRLP4 68
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 756
ADDP4
CNSTI4 0
ASGNI4
line 490
;490:			}
LABELV $278
line 492
;491:
;492:			if (otherDefLevel == FORCE_LEVEL_1)
ADDRLP4 92
INDIRI4
CNSTI4 1
NEI4 $227
line 493
;493:			{
line 494
;494:				goto killProj;
ADDRGP4 $244
JUMPV
line 496
;495:			}
;496:			return;
LABELV $266
line 498
;497:		}
;498:	}
LABELV $264
line 501
;499:
;500:	// check for sticking
;501:	if ( !other->takedamage && ( ent->s.eFlags & EF_MISSILE_STICK ) ) 
ADDRLP4 68
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 680
ADDP4
INDIRI4
ADDRLP4 68
INDIRI4
NEI4 $282
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 2097152
BANDI4
ADDRLP4 68
INDIRI4
EQI4 $282
line 502
;502:	{
line 503
;503:		laserTrapStick( ent, trace->endpos, trace->plane.normal );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 72
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 72
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRLP4 72
INDIRP4
CNSTI4 24
ADDP4
ARGP4
ADDRGP4 laserTrapStick
CALLV
pop
line 504
;504:		G_AddEvent( ent, EV_MISSILE_STICK, 0 );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 62
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 505
;505:		return;
ADDRGP4 $227
JUMPV
LABELV $282
line 509
;506:	}
;507:
;508:	// impact damage
;509:	if (other->takedamage) {
ADDRLP4 0
INDIRP4
CNSTI4 680
ADDP4
INDIRI4
CNSTI4 0
EQI4 $284
line 511
;510:		// FIXME: wrong damage direction?
;511:		if ( ent->damage ) {
ADDRFP4 0
INDIRP4
CNSTI4 688
ADDP4
INDIRI4
CNSTI4 0
EQI4 $286
line 514
;512:			vec3_t	velocity;
;513:
;514:			if( LogAccuracyHit( other, &g_entities[ent->r.ownerNum] ) ) {
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 828
ADDRFP4 0
INDIRP4
CNSTI4 396
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ARGP4
ADDRLP4 84
ADDRGP4 LogAccuracyHit
CALLI4
ASGNI4
ADDRLP4 84
INDIRI4
CNSTI4 0
EQI4 $288
line 515
;515:				g_entities[ent->r.ownerNum].client->accuracy_hits++;
ADDRLP4 88
CNSTI4 828
ADDRFP4 0
INDIRP4
CNSTI4 396
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities+408
ADDP4
INDIRP4
CNSTI4 1668
ADDP4
ASGNP4
ADDRLP4 88
INDIRP4
ADDRLP4 88
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 516
;516:				hitClient = qtrue;
ADDRLP4 4
CNSTI4 1
ASGNI4
line 517
;517:			}
LABELV $288
line 518
;518:			BG_EvaluateTrajectoryDelta( &ent->s.pos, level.time, velocity );
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRGP4 level+32
INDIRI4
ARGI4
ADDRLP4 72
ARGP4
ADDRGP4 BG_EvaluateTrajectoryDelta
CALLV
pop
line 519
;519:			if ( VectorLength( velocity ) == 0 ) {
ADDRLP4 72
ARGP4
ADDRLP4 88
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 88
INDIRF4
CNSTF4 0
NEF4 $292
line 520
;520:				velocity[2] = 1;	// stepped on a grenade
ADDRLP4 72+8
CNSTF4 1065353216
ASGNF4
line 521
;521:			}
LABELV $292
line 523
;522:
;523:			if (ent->s.weapon == WP_BOWCASTER || ent->s.weapon == WP_FLECHETTE ||
ADDRLP4 92
ADDRFP4 0
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
ASGNI4
ADDRLP4 92
INDIRI4
CNSTI4 6
EQI4 $298
ADDRLP4 92
INDIRI4
CNSTI4 9
EQI4 $298
ADDRLP4 92
INDIRI4
CNSTI4 10
NEI4 $295
LABELV $298
line 525
;524:				ent->s.weapon == WP_ROCKET_LAUNCHER)
;525:			{
line 526
;526:				if (ent->s.weapon == WP_FLECHETTE && (ent->s.eFlags & EF_ALT_FIRING))
ADDRLP4 96
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 96
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 9
NEI4 $299
ADDRLP4 96
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 512
BANDI4
CNSTI4 0
EQI4 $299
line 527
;527:				{
line 528
;528:					ent->think(ent);
ADDRLP4 100
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 100
INDIRP4
ARGP4
ADDRLP4 100
INDIRP4
CNSTI4 636
ADDP4
INDIRP4
CALLV
pop
line 529
;529:				}
ADDRGP4 $296
JUMPV
LABELV $299
line 531
;530:				else
;531:				{
line 532
;532:					G_Damage (other, ent, &g_entities[ent->r.ownerNum], velocity,
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 100
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 100
INDIRP4
ARGP4
CNSTI4 828
ADDRLP4 100
INDIRP4
CNSTI4 396
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ARGP4
ADDRLP4 72
ARGP4
ADDRLP4 100
INDIRP4
CNSTI4 368
ADDP4
ARGP4
ADDRLP4 100
INDIRP4
CNSTI4 688
ADDP4
INDIRI4
ARGI4
CNSTI4 1024
ARGI4
ADDRLP4 100
INDIRP4
CNSTI4 704
ADDP4
INDIRI4
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 535
;533:						/*ent->s.origin*/ent->r.currentOrigin, ent->damage, 
;534:						DAMAGE_HALF_ABSORB, ent->methodOfDeath);
;535:				}
line 536
;536:			}
ADDRGP4 $296
JUMPV
LABELV $295
line 538
;537:			else
;538:			{
line 539
;539:				G_Damage (other, ent, &g_entities[ent->r.ownerNum], velocity,
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 96
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 96
INDIRP4
ARGP4
CNSTI4 828
ADDRLP4 96
INDIRP4
CNSTI4 396
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ARGP4
ADDRLP4 72
ARGP4
ADDRLP4 96
INDIRP4
CNSTI4 368
ADDP4
ARGP4
ADDRLP4 96
INDIRP4
CNSTI4 688
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRLP4 96
INDIRP4
CNSTI4 704
ADDP4
INDIRI4
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 542
;540:					/*ent->s.origin*/ent->r.currentOrigin, ent->damage, 
;541:					0, ent->methodOfDeath);
;542:			}
LABELV $296
line 543
;543:		}
LABELV $286
line 544
;544:	}
LABELV $284
LABELV $244
line 549
;545:killProj:
;546:	// is it cheaper in bandwidth to just remove this ent and create a new
;547:	// one, rather than changing the missile into the explosion?
;548:
;549:	if ( other->takedamage && other->client ) {
ADDRLP4 0
INDIRP4
CNSTI4 680
ADDP4
INDIRI4
CNSTI4 0
EQI4 $301
ADDRLP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $301
line 550
;550:		G_AddEvent( ent, EV_MISSILE_HIT, DirToByte( trace->plane.normal ) );
ADDRFP4 4
INDIRP4
CNSTI4 24
ADDP4
ARGP4
ADDRLP4 76
ADDRGP4 DirToByte
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 73
ARGI4
ADDRLP4 76
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 551
;551:		ent->s.otherEntityNum = other->s.number;
ADDRFP4 0
INDIRP4
CNSTI4 184
ADDP4
ADDRLP4 0
INDIRP4
INDIRI4
ASGNI4
line 552
;552:	} else if( trace->surfaceFlags & SURF_METALSTEPS ) {
ADDRGP4 $302
JUMPV
LABELV $301
ADDRFP4 4
INDIRP4
CNSTI4 44
ADDP4
INDIRI4
CNSTI4 32768
BANDI4
CNSTI4 0
EQI4 $303
line 553
;553:		G_AddEvent( ent, EV_MISSILE_MISS_METAL, DirToByte( trace->plane.normal ) );
ADDRFP4 4
INDIRP4
CNSTI4 24
ADDP4
ARGP4
ADDRLP4 76
ADDRGP4 DirToByte
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 75
ARGI4
ADDRLP4 76
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 554
;554:	} else if (ent->s.weapon != G2_MODEL_PART) {
ADDRGP4 $304
JUMPV
LABELV $303
ADDRFP4 0
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 50
EQI4 $305
line 555
;555:		G_AddEvent( ent, EV_MISSILE_MISS, DirToByte( trace->plane.normal ) );
ADDRFP4 4
INDIRP4
CNSTI4 24
ADDP4
ARGP4
ADDRLP4 76
ADDRGP4 DirToByte
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 74
ARGI4
ADDRLP4 76
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 556
;556:	}
LABELV $305
LABELV $304
LABELV $302
line 558
;557:
;558:	ent->freeAfterEvent = qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 492
ADDP4
CNSTI4 1
ASGNI4
line 561
;559:
;560:	// change over to a normal entity right at the point of impact
;561:	ent->s.eType = ET_GENERAL;
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 0
ASGNI4
line 563
;562:
;563:	SnapVectorTowards( trace->endpos, ent->s.pos.trBase );	// save net bandwidth
ADDRFP4 4
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
ARGP4
ADDRGP4 SnapVectorTowards
CALLV
pop
line 565
;564:
;565:	G_SetOrigin( ent, trace->endpos );
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRGP4 G_SetOrigin
CALLV
pop
line 568
;566:
;567:	// splash damage (doesn't apply to person directly hit)
;568:	if ( ent->splashDamage ) {
ADDRFP4 0
INDIRP4
CNSTI4 696
ADDP4
INDIRI4
CNSTI4 0
EQI4 $307
line 569
;569:		if( G_RadiusDamage( trace->endpos, ent->parent, ent->splashDamage, ent->splashRadius, 
ADDRFP4 4
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRLP4 76
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 76
INDIRP4
CNSTI4 536
ADDP4
INDIRP4
ARGP4
ADDRLP4 76
INDIRP4
CNSTI4 696
ADDP4
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 76
INDIRP4
CNSTI4 700
ADDP4
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 76
INDIRP4
CNSTI4 708
ADDP4
INDIRI4
ARGI4
ADDRLP4 80
ADDRGP4 G_RadiusDamage
CALLI4
ASGNI4
ADDRLP4 80
INDIRI4
CNSTI4 0
EQI4 $309
line 570
;570:			other, ent->splashMethodOfDeath ) ) {
line 571
;571:			if( !hitClient ) {
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $311
line 572
;572:				g_entities[ent->r.ownerNum].client->accuracy_hits++;
ADDRLP4 84
CNSTI4 828
ADDRFP4 0
INDIRP4
CNSTI4 396
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities+408
ADDP4
INDIRP4
CNSTI4 1668
ADDP4
ASGNP4
ADDRLP4 84
INDIRP4
ADDRLP4 84
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 573
;573:			}
LABELV $311
line 574
;574:		}
LABELV $309
line 575
;575:	}
LABELV $307
line 577
;576:
;577:	if (ent->s.weapon == G2_MODEL_PART)
ADDRFP4 0
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 50
NEI4 $314
line 578
;578:	{
line 579
;579:		ent->freeAfterEvent = qfalse; //it will free itself
ADDRFP4 0
INDIRP4
CNSTI4 492
ADDP4
CNSTI4 0
ASGNI4
line 580
;580:	}
LABELV $314
line 582
;581:
;582:	trap_LinkEntity( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 583
;583:}
LABELV $227
endproc G_MissileImpact 128 32
export G_RunMissile
proc G_RunMissile 2224 28
line 590
;584:
;585:/*
;586:================
;587:G_RunMissile
;588:================
;589:*/
;590:void G_RunMissile( gentity_t *ent ) {
line 596
;591:	vec3_t		origin, groundSpot;
;592:	trace_t		tr;
;593:	int			passent;
;594:
;595:	// get current position
;596:	BG_EvaluateTrajectory( &ent->s.pos, level.time, origin );
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRGP4 level+32
INDIRI4
ARGI4
ADDRLP4 1084
ARGP4
ADDRGP4 BG_EvaluateTrajectory
CALLV
pop
line 599
;597:
;598:	// if this missile bounced off an invulnerability sphere
;599:	if ( ent->target_ent ) {
ADDRFP4 0
INDIRP4
CNSTI4 604
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $318
line 600
;600:		passent = ent->target_ent->s.number;
ADDRLP4 1080
ADDRFP4 0
INDIRP4
CNSTI4 604
ADDP4
INDIRP4
INDIRI4
ASGNI4
line 601
;601:	}
ADDRGP4 $319
JUMPV
LABELV $318
line 602
;602:	else {
line 604
;603:		// ignore interactions with the missile owner
;604:		passent = ent->r.ownerNum;
ADDRLP4 1080
ADDRFP4 0
INDIRP4
CNSTI4 396
ADDP4
INDIRI4
ASGNI4
line 605
;605:	}
LABELV $319
line 607
;606:	// trace a line from the previous position to the current position
;607:	trap_Trace( &tr, ent->r.currentOrigin, ent->r.mins, ent->r.maxs, origin, passent, ent->clipmask );
ADDRLP4 0
ARGP4
ADDRLP4 1108
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1108
INDIRP4
CNSTI4 368
ADDP4
ARGP4
ADDRLP4 1108
INDIRP4
CNSTI4 316
ADDP4
ARGP4
ADDRLP4 1108
INDIRP4
CNSTI4 328
ADDP4
ARGP4
ADDRLP4 1084
ARGP4
ADDRLP4 1080
INDIRI4
ARGI4
ADDRLP4 1108
INDIRP4
CNSTI4 508
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_Trace
CALLV
pop
line 609
;608:
;609:	if ( tr.startsolid || tr.allsolid ) {
ADDRLP4 1112
CNSTI4 0
ASGNI4
ADDRLP4 0+4
INDIRI4
ADDRLP4 1112
INDIRI4
NEI4 $323
ADDRLP4 0
INDIRI4
ADDRLP4 1112
INDIRI4
EQI4 $320
LABELV $323
line 611
;610:		// make sure the tr.entityNum is set to the entity we're stuck in
;611:		trap_Trace( &tr, ent->r.currentOrigin, ent->r.mins, ent->r.maxs, ent->r.currentOrigin, passent, ent->clipmask );
ADDRLP4 0
ARGP4
ADDRLP4 1116
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1120
ADDRLP4 1116
INDIRP4
CNSTI4 368
ADDP4
ASGNP4
ADDRLP4 1120
INDIRP4
ARGP4
ADDRLP4 1116
INDIRP4
CNSTI4 316
ADDP4
ARGP4
ADDRLP4 1116
INDIRP4
CNSTI4 328
ADDP4
ARGP4
ADDRLP4 1120
INDIRP4
ARGP4
ADDRLP4 1080
INDIRI4
ARGI4
ADDRLP4 1116
INDIRP4
CNSTI4 508
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_Trace
CALLV
pop
line 612
;612:		tr.fraction = 0;
ADDRLP4 0+8
CNSTF4 0
ASGNF4
line 613
;613:	}
ADDRGP4 $321
JUMPV
LABELV $320
line 614
;614:	else {
line 615
;615:		VectorCopy( tr.endpos, ent->r.currentOrigin );
ADDRFP4 0
INDIRP4
CNSTI4 368
ADDP4
ADDRLP4 0+12
INDIRB
ASGNB 12
line 616
;616:	}
LABELV $321
line 618
;617:
;618:	if (ent->passThroughNum && tr.entityNum == (ent->passThroughNum-1))
ADDRLP4 1116
ADDRFP4 0
INDIRP4
CNSTI4 444
ADDP4
INDIRI4
ASGNI4
ADDRLP4 1116
INDIRI4
CNSTI4 0
EQI4 $326
ADDRLP4 0+52
INDIRI4
ADDRLP4 1116
INDIRI4
CNSTI4 1
SUBI4
NEI4 $326
line 619
;619:	{
line 620
;620:		VectorCopy( origin, ent->r.currentOrigin );
ADDRFP4 0
INDIRP4
CNSTI4 368
ADDP4
ADDRLP4 1084
INDIRB
ASGNB 12
line 621
;621:		trap_LinkEntity( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 622
;622:		goto passthrough;
ADDRGP4 $329
JUMPV
LABELV $326
line 625
;623:	}
;624:
;625:	trap_LinkEntity( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 627
;626:
;627:	if (ent->s.weapon == G2_MODEL_PART && !ent->bounceCount)
ADDRLP4 1120
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1120
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 50
NEI4 $330
ADDRLP4 1120
INDIRP4
CNSTI4 716
ADDP4
INDIRI4
CNSTI4 0
NEI4 $330
line 628
;628:	{
line 632
;629:		vec3_t lowerOrg;
;630:		trace_t trG;
;631:
;632:		VectorCopy(ent->r.currentOrigin, lowerOrg);
ADDRLP4 2204
ADDRFP4 0
INDIRP4
CNSTI4 368
ADDP4
INDIRB
ASGNB 12
line 633
;633:		lowerOrg[2] -= 1;
ADDRLP4 2204+8
ADDRLP4 2204+8
INDIRF4
CNSTF4 1065353216
SUBF4
ASGNF4
line 634
;634:		trap_Trace( &trG, ent->r.currentOrigin, ent->r.mins, ent->r.maxs, lowerOrg, passent, ent->clipmask );
ADDRLP4 1124
ARGP4
ADDRLP4 2216
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 2216
INDIRP4
CNSTI4 368
ADDP4
ARGP4
ADDRLP4 2216
INDIRP4
CNSTI4 316
ADDP4
ARGP4
ADDRLP4 2216
INDIRP4
CNSTI4 328
ADDP4
ARGP4
ADDRLP4 2204
ARGP4
ADDRLP4 1080
INDIRI4
ARGI4
ADDRLP4 2216
INDIRP4
CNSTI4 508
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_Trace
CALLV
pop
line 636
;635:
;636:		VectorCopy(trG.endpos, groundSpot);
ADDRLP4 1096
ADDRLP4 1124+12
INDIRB
ASGNB 12
line 638
;637:
;638:		if (!trG.startsolid && !trG.allsolid && trG.entityNum == ENTITYNUM_WORLD)
ADDRLP4 2220
CNSTI4 0
ASGNI4
ADDRLP4 1124+4
INDIRI4
ADDRLP4 2220
INDIRI4
NEI4 $334
ADDRLP4 1124
INDIRI4
ADDRLP4 2220
INDIRI4
NEI4 $334
ADDRLP4 1124+52
INDIRI4
CNSTI4 1022
NEI4 $334
line 639
;639:		{
line 640
;640:			ent->s.groundEntityNum = trG.entityNum;
ADDRFP4 0
INDIRP4
CNSTI4 192
ADDP4
ADDRLP4 1124+52
INDIRI4
ASGNI4
line 641
;641:		}
ADDRGP4 $335
JUMPV
LABELV $334
line 643
;642:		else
;643:		{
line 644
;644:			ent->s.groundEntityNum = ENTITYNUM_NONE;
ADDRFP4 0
INDIRP4
CNSTI4 192
ADDP4
CNSTI4 1023
ASGNI4
line 645
;645:		}
LABELV $335
line 646
;646:	}
LABELV $330
line 648
;647:
;648:	if ( tr.fraction != 1) {
ADDRLP4 0+8
INDIRF4
CNSTF4 1065353216
EQF4 $339
line 650
;649:		// never explode or bounce on sky
;650:		if ( tr.surfaceFlags & SURF_NOIMPACT ) {
ADDRLP4 0+44
INDIRI4
CNSTI4 524288
BANDI4
CNSTI4 0
EQI4 $342
line 652
;651:			// If grapple, reset owner
;652:			if (ent->parent && ent->parent->client && ent->parent->client->hook == ent) {
ADDRLP4 1124
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1128
ADDRLP4 1124
INDIRP4
CNSTI4 536
ADDP4
INDIRP4
ASGNP4
ADDRLP4 1132
CNSTU4 0
ASGNU4
ADDRLP4 1128
INDIRP4
CVPU4 4
ADDRLP4 1132
INDIRU4
EQU4 $345
ADDRLP4 1136
ADDRLP4 1128
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 1136
INDIRP4
CVPU4 4
ADDRLP4 1132
INDIRU4
EQU4 $345
ADDRLP4 1136
INDIRP4
CNSTI4 1712
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 1124
INDIRP4
CVPU4 4
NEU4 $345
line 653
;653:				ent->parent->client->hook = NULL;
ADDRFP4 0
INDIRP4
CNSTI4 536
ADDP4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1712
ADDP4
CNSTP4 0
ASGNP4
line 654
;654:			}
LABELV $345
line 656
;655:
;656:			if (ent->s.weapon == WP_SABER && ent->isSaberEntity)
ADDRLP4 1140
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1140
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 2
NEI4 $347
ADDRLP4 1140
INDIRP4
CNSTI4 812
ADDP4
INDIRI4
CNSTI4 0
EQI4 $347
line 657
;657:			{
line 658
;658:				G_RunThink( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_RunThink
CALLV
pop
line 659
;659:				return;
ADDRGP4 $316
JUMPV
LABELV $347
line 661
;660:			}
;661:			else if (ent->s.weapon != G2_MODEL_PART)
ADDRFP4 0
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 50
EQI4 $349
line 662
;662:			{
line 663
;663:				G_FreeEntity( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_FreeEntity
CALLV
pop
line 664
;664:				return;
ADDRGP4 $316
JUMPV
LABELV $349
line 666
;665:			}
;666:		}
LABELV $342
line 667
;667:		G_MissileImpact( ent, &tr );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 G_MissileImpact
CALLV
pop
line 668
;668:		if ( ent->s.eType != ET_MISSILE && ent->s.weapon != G2_MODEL_PART ) {
ADDRLP4 1124
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1124
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 3
EQI4 $351
ADDRLP4 1124
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 50
EQI4 $351
line 669
;669:			return;		// exploded
ADDRGP4 $316
JUMPV
LABELV $351
line 671
;670:		}
;671:	}
LABELV $339
LABELV $329
line 674
;672:
;673:passthrough:
;674:	if ( ent->s.pos.trType == TR_STATIONARY && (ent->s.eFlags&EF_MISSILE_STICK) )
ADDRLP4 1124
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1128
CNSTI4 0
ASGNI4
ADDRLP4 1124
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ADDRLP4 1128
INDIRI4
NEI4 $353
ADDRLP4 1124
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 2097152
BANDI4
ADDRLP4 1128
INDIRI4
EQI4 $353
line 675
;675:	{//stuck missiles should check some special stuff
line 676
;676:		G_RunStuckMissile( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_RunStuckMissile
CALLV
pop
line 677
;677:		return;
ADDRGP4 $316
JUMPV
LABELV $353
line 680
;678:	}
;679:
;680:	if (ent->s.weapon == G2_MODEL_PART)
ADDRFP4 0
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 50
NEI4 $355
line 681
;681:	{
line 682
;682:		if (ent->s.groundEntityNum == ENTITYNUM_WORLD)
ADDRFP4 0
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
CNSTI4 1022
NEI4 $357
line 683
;683:		{
line 684
;684:			ent->s.pos.trType = TR_LINEAR;
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 2
ASGNI4
line 685
;685:			VectorClear(ent->s.pos.trDelta);
ADDRLP4 1132
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1136
CNSTF4 0
ASGNF4
ADDRLP4 1132
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 1136
INDIRF4
ASGNF4
ADDRLP4 1132
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 1136
INDIRF4
ASGNF4
ADDRLP4 1132
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 1136
INDIRF4
ASGNF4
line 686
;686:			ent->s.pos.trTime = level.time;
ADDRFP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 688
;687:
;688:			VectorCopy(groundSpot, ent->s.pos.trBase);
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
ADDRLP4 1096
INDIRB
ASGNB 12
line 689
;689:			VectorCopy(groundSpot, ent->r.currentOrigin);
ADDRFP4 0
INDIRP4
CNSTI4 368
ADDP4
ADDRLP4 1096
INDIRB
ASGNB 12
line 691
;690:
;691:			if (ent->s.apos.trType != TR_STATIONARY)
ADDRFP4 0
INDIRP4
CNSTI4 48
ADDP4
INDIRI4
CNSTI4 0
EQI4 $360
line 692
;692:			{
line 693
;693:				ent->s.apos.trType = TR_STATIONARY;
ADDRFP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 0
ASGNI4
line 694
;694:				ent->s.apos.trTime = level.time;
ADDRFP4 0
INDIRP4
CNSTI4 52
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 696
;695:
;696:				ent->s.apos.trBase[ROLL] = 0;
ADDRFP4 0
INDIRP4
CNSTI4 68
ADDP4
CNSTF4 0
ASGNF4
line 697
;697:				ent->s.apos.trBase[PITCH] = 0;
ADDRFP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 698
;698:			}
LABELV $360
line 699
;699:		}
LABELV $357
line 700
;700:	}
LABELV $355
line 703
;701:
;702:	// check think function after bouncing
;703:	G_RunThink( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_RunThink
CALLV
pop
line 704
;704:}
LABELV $316
endproc G_RunMissile 2224 28
import RandFloat
import laserTrapStick
import trap_ROFF_Purge_Ent
import trap_ROFF_Play
import trap_ROFF_Cache
import trap_ROFF_UpdateEntities
import trap_ROFF_Clean
import trap_SP_GetStringTextString
import trap_SP_Register
import trap_SP_RegisterServer
import trap_SnapVector
import trap_GeneticParentsAndChildSelection
import trap_BotResetWeaponState
import trap_BotFreeWeaponState
import trap_BotAllocWeaponState
import trap_BotLoadWeaponWeights
import trap_BotGetWeaponInfo
import trap_BotChooseBestFightWeapon
import trap_BotAddAvoidSpot
import trap_BotInitMoveState
import trap_BotFreeMoveState
import trap_BotAllocMoveState
import trap_BotPredictVisiblePosition
import trap_BotMovementViewTarget
import trap_BotReachabilityArea
import trap_BotResetLastAvoidReach
import trap_BotResetAvoidReach
import trap_BotMoveInDirection
import trap_BotMoveToGoal
import trap_BotResetMoveState
import trap_BotFreeGoalState
import trap_BotAllocGoalState
import trap_BotMutateGoalFuzzyLogic
import trap_BotSaveGoalFuzzyLogic
import trap_BotInterbreedGoalFuzzyLogic
import trap_BotFreeItemWeights
import trap_BotLoadItemWeights
import trap_BotUpdateEntityItems
import trap_BotInitLevelItems
import trap_BotSetAvoidGoalTime
import trap_BotAvoidGoalTime
import trap_BotGetLevelItemGoal
import trap_BotGetMapLocationGoal
import trap_BotGetNextCampSpotGoal
import trap_BotItemGoalInVisButNotVisible
import trap_BotTouchingGoal
import trap_BotChooseNBGItem
import trap_BotChooseLTGItem
import trap_BotGetSecondGoal
import trap_BotGetTopGoal
import trap_BotGoalName
import trap_BotDumpGoalStack
import trap_BotDumpAvoidGoals
import trap_BotEmptyGoalStack
import trap_BotPopGoal
import trap_BotPushGoal
import trap_BotResetAvoidGoals
import trap_BotRemoveFromAvoidGoals
import trap_BotResetGoalState
import trap_BotSetChatName
import trap_BotSetChatGender
import trap_BotLoadChatFile
import trap_BotReplaceSynonyms
import trap_UnifyWhiteSpaces
import trap_BotMatchVariable
import trap_BotFindMatch
import trap_StringContains
import trap_BotGetChatMessage
import trap_BotEnterChat
import trap_BotChatLength
import trap_BotReplyChat
import trap_BotNumInitialChats
import trap_BotInitialChat
import trap_BotNumConsoleMessages
import trap_BotNextConsoleMessage
import trap_BotRemoveConsoleMessage
import trap_BotQueueConsoleMessage
import trap_BotFreeChatState
import trap_BotAllocChatState
import trap_Characteristic_String
import trap_Characteristic_BInteger
import trap_Characteristic_Integer
import trap_Characteristic_BFloat
import trap_Characteristic_Float
import trap_BotFreeCharacter
import trap_BotLoadCharacter
import trap_EA_ResetInput
import trap_EA_GetInput
import trap_EA_EndRegular
import trap_EA_ForcePower
import trap_EA_Alt_Attack
import trap_EA_View
import trap_EA_Move
import trap_EA_DelayedJump
import trap_EA_Jump
import trap_EA_SelectWeapon
import trap_EA_MoveRight
import trap_EA_MoveLeft
import trap_EA_MoveBack
import trap_EA_MoveForward
import trap_EA_MoveDown
import trap_EA_MoveUp
import trap_EA_Crouch
import trap_EA_Respawn
import trap_EA_Use
import trap_EA_Attack
import trap_EA_Talk
import trap_EA_Gesture
import trap_EA_Action
import trap_EA_Command
import trap_EA_SayTeam
import trap_EA_Say
import trap_AAS_PredictClientMovement
import trap_AAS_Swimming
import trap_AAS_AlternativeRouteGoals
import trap_AAS_PredictRoute
import trap_AAS_EnableRoutingArea
import trap_AAS_AreaTravelTimeToGoalArea
import trap_AAS_AreaReachability
import trap_AAS_IntForBSPEpairKey
import trap_AAS_FloatForBSPEpairKey
import trap_AAS_VectorForBSPEpairKey
import trap_AAS_ValueForBSPEpairKey
import trap_AAS_NextBSPEntity
import trap_AAS_PointContents
import trap_AAS_TraceAreas
import trap_AAS_PointReachabilityAreaIndex
import trap_AAS_PointAreaNum
import trap_AAS_Time
import trap_AAS_PresenceTypeBoundingBox
import trap_AAS_Initialized
import trap_AAS_EntityInfo
import trap_AAS_AreaInfo
import trap_AAS_BBoxAreas
import trap_BotUserCommand
import trap_BotGetServerCommand
import trap_BotGetSnapshotEntity
import trap_BotLibTest
import trap_BotLibUpdateEntity
import trap_BotLibLoadMap
import trap_BotLibStartFrame
import trap_BotLibDefine
import trap_BotLibVarGet
import trap_BotLibVarSet
import trap_BotLibShutdown
import trap_BotLibSetup
import trap_DebugPolygonDelete
import trap_DebugPolygonCreate
import trap_GetEntityToken
import trap_GetUsercmd
import trap_BotFreeClient
import trap_BotAllocateClient
import trap_EntityContact
import trap_EntitiesInBox
import trap_UnlinkEntity
import trap_LinkEntity
import trap_AreasConnected
import trap_AdjustAreaPortalState
import trap_InPVSIgnorePortals
import trap_InPVS
import trap_PointContents
import trap_Trace
import trap_SetBrushModel
import trap_GetServerinfo
import trap_SetUserinfo
import trap_GetUserinfo
import trap_GetConfigstring
import trap_SetConfigstring
import trap_SendServerCommand
import trap_DropClient
import trap_LocateGameData
import trap_Cvar_VariableStringBuffer
import trap_Cvar_VariableValue
import trap_Cvar_VariableIntegerValue
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_SendConsoleCommand
import trap_FS_GetFileList
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Milliseconds
import trap_Error
import trap_Printf
import g_austrian
import g_saberDebugPrint
import g_saberDmgDelay_Wound
import g_saberDmgDelay_Idle
import g_saberDmgVelocityScale
import g_timeouttospec
import g_forceDodge
import g_dismember
import g_singlePlayer
import g_enableBreath
import g_enableDust
import g_rankings
import pmove_msec
import pmove_fixed
import g_smoothClients
import g_blueteam
import g_redteam
import g_debugUp
import g_debugRight
import g_debugForward
import g_filterBan
import g_banIPs
import g_teamForceBalance
import g_teamAutoJoin
import g_allowVote
import g_blood
import g_doWarmup
import g_warmup
import g_motd
import g_synchronousClients
import g_adaptRespawn
import g_weaponTeamRespawn
import g_weaponRespawn
import g_debugDamage
import g_debugAlloc
import g_debugMove
import g_inactivity
import g_forcerespawn
import g_quadfactor
import g_knockback
import g_speed
import g_gravity
import g_needpass
import g_password
import g_friendlySaber
import g_friendlyFire
import g_saberInterpolate
import g_capturelimit
import g_timelimit
import g_duel_fraglimit
import g_fraglimit
import g_duelWeaponDisable
import g_fraglimitVoteCorrection
import g_allowDuelSuicide
import g_weaponDisable
import g_forcePowerDisable
import g_spawnInvulnerability
import g_forceRegenTime
import g_saberDamageScale
import g_slowmoDuelEnd
import g_logClientInfo
import g_saberBoxTraceSize
import g_saberAlwaysBoxTrace
import g_saberGhoul2Collision
import g_saberTraceSaberFirst
import g_saberLockFactor
import g_saberLocking
import g_privateDuel
import g_forceBasedTeams
import g_maxForceRank
import g_dmflags
import g_autoMapCycle
import g_trueJedi
import g_restarted
import g_maxGameClients
import g_maxclients
import g_cheats
import g_dedicated
import g_gametype
import g_entities
import level
import Pickup_Team
import CheckTeamStatus
import TeamplayInfoMessage
import Team_GetLocationMsg
import Team_GetLocation
import SelectSagaSpawnPoint
import SelectCTFSpawnPoint
import Team_FreeEntity
import Team_ReturnFlag
import Team_InitGame
import Team_CheckHurtCarrier
import Team_FragBonuses
import Team_DroppedFlagThink
import AddTeamScore
import TeamColorString
import OtherTeamName
import TeamName
import OtherTeam
import BotAIStartFrame
import BotAIShutdownClient
import BotAISetupClient
import BotAILoadMap
import BotAIShutdown
import BotAISetup
import B_CleanupAlloc
import B_InitAlloc
import InFieldOfVision
import BotOrder
import OrgVisible
import InitSagaMode
import G_ClearClientLog
import G_LogExit
import G_LogWeaponOutput
import G_LogWeaponInit
import G_LogWeaponItem
import G_LogWeaponPowerup
import G_LogWeaponFrag
import G_LogWeaponDeath
import G_LogWeaponKill
import G_LogWeaponDamage
import G_LogWeaponFire
import G_LogWeaponPickup
import Jedi_DodgeEvasion
import ForceTelepathy
import ForceThrow
import ForceSeeing
import ForceTeamForceReplenish
import ForceTeamHeal
import ForceAbsorb
import ForceProtect
import ForceGrip
import ForceRage
import ForceSpeed
import ForceHeal
import ForcePowerUsableOn
import WP_ForcePowersUpdate
import WP_SpawnInitForcePowers
import WP_InitForcePowers
import WP_SaberInitBladeData
import WP_SaberCanBlock
import WP_SaberPositionUpdate
import WP_ForcePowerStop
import HasSetSaberOnly
import G_PreDefSound
import G_RefreshNextMap
import G_DoesMapSupportGametype
import BotInterbreedEndMatch
import Svcmd_BotList_f
import Svcmd_AddBot_f
import G_BotConnect
import G_RemoveQueuedBotBegin
import G_CheckBotSpawn
import G_GetBotInfoByName
import G_GetBotInfoByNumber
import G_InitBots
import UpdateTournamentInfo
import G_WriteSessionData
import G_InitWorldSession
import G_InitSessionData
import G_ReadSessionData
import Svcmd_GameMem_f
import G_InitMemory
import G_Alloc
import Team_CheckDroppedItem
import OnSameTeam
import G_RunClient
import ClientEndFrame
import ClientThink
import G_CheckClientTimeouts
import ClientCommand
import ClientBegin
import ClientDisconnect
import ClientUserinfoChanged
import ClientConnect
import G_GetStripEdString
import G_Error
import G_Printf
import SendScoreboardMessageToAllClients
import G_LogPrintf
import G_RunThink
import CheckTeamLeader
import SetLeader
import FindIntermissionPoint
import gSlowMoDuelTime
import gDoSlowMoDuel
import g_ff_objectives
import DeathmatchScoreboardMessage
import G_SetStats
import MoveClientToIntermission
import BlowDetpacks
import FireWeapon
import G_FilterPacket
import G_ProcessIPBans
import ConsoleCommand
import gJMSaberEnt
import SpotWouldTelefrag
import CalculateRanks
import AddScore
import player_die
import ClientSpawn
import InitBodyQue
import BeginIntermission
import respawn
import CopyToBodyQue
import SelectSpawnPoint
import SetClientViewAngle
import PickTeam
import TeamLeader
import TeamCount
import CheckGauntletAttack
import SnapVectorTowards
import CalcMuzzlePoint
import LogAccuracyHit
import WP_FireGenericBlasterMissile
import WP_FireTurretMissile
import G_CreateExampleAnimEnt
import G_PlayerBecomeATST
import ATST_ManageDamageBoxes
import TeleportPlayer
import trigger_teleporter_touch
import Touch_DoorTrigger
import G_RunMover
import WP_FireBlasterMissile
import gGAvoidDismember
import G_CheckForDismemberment
import ExplodeDeath
import TossClientCubes
import TossClientItems
import TossClientWeapon
import body_die
import G_RadiusDamage
import G_Damage
import CanDamage
import trap_G2API_SetBoneAnim
import trap_G2API_GetGLAName
import trap_G2API_SetBoneAngles
import trap_G2API_CollisionDetect
import trap_G2API_CleanGhoul2Models
import trap_G2API_RemoveGhoul2Model
import trap_G2API_HasGhoul2ModelOnIndex
import trap_G2API_DuplicateGhoul2Instance
import trap_G2API_CopySpecificGhoul2Model
import trap_G2API_CopyGhoul2Instance
import trap_G2API_SetBoltInfo
import trap_G2API_AddBolt
import trap_G2API_InitGhoul2Model
import trap_G2API_GetBoltMatrix_NoRecNoRot
import trap_G2API_GetBoltMatrix_NoReconstruct
import trap_G2API_GetBoltMatrix
import trap_G2_HaveWeGhoul2Models
import trap_G2_SetGhoul2ModelIndexes
import trap_G2_ListModelBones
import trap_G2_ListModelSurfaces
import G_SkinIndex
import BuildShaderStateConfig
import AddRemap
import G_SetOrigin
import G_AddEvent
import G_AddPredictableEvent
import vtos
import tv
import G_RunObject
import G_TouchSolids
import G_TouchTriggers
import G_EntitiesFree
import G_FreeEntity
import G_KillG2Queue
import G_SendG2KillQueue
import TryUse
import G_EntitySound
import G_SoundAtLoc
import G_Sound
import G_MuteSound
import G_ScreenShake
import G_PlayEffect
import G_TempEntity
import G_Spawn
import G_InitGentity
import G_SetAngles
import G_SetMovedir
import G_UseTargets
import G_PickTarget
import G_RadiusList
import G_Find
import G_KillBox
import G_TeamCommand
import G_EffectIndex
import G_SoundIndex
import G_ModelIndex
import SaveRegisteredItems
import RegisterItem
import ClearRegisteredItems
import Touch_Item
import Add_Ammo
import ArmorIndex
import Think_Weapon
import FinishSpawningItem
import G_SpawnItem
import SetRespawn
import LaunchItem
import Drop_Item
import PrecacheItem
import UseHoldableItem
import RespawnItem
import G_RunItem
import G_CheckTeamItems
import ItemUse_MedPack
import ItemUse_Seeker
import ItemUse_Sentry
import ItemUse_Shield
import ItemUse_Binoculars
import G_GetDuelWinner
import Cmd_EngageDuel_f
import Cmd_ToggleSaber_f
import G_ItemUsable
import Cmd_SaberAttackCycle_f
import Cmd_FollowCycle_f
import SetTeam
import BroadcastTeamChange
import StopFollowing
import Cmd_Score_f
import G_NewString
import G_SpawnEntitiesFromString
import G_SpawnVector
import G_SpawnInt
import G_SpawnFloat
import G_SpawnString
import gEscapeTime
import gEscaping
import g2SaberInstance
import precachedKyle
import forcePowerDarkLight
import WeaponAttackAnim
import WeaponReadyAnim
import BG_OutOfMemory
import BG_StringAlloc
import BG_TempFree
import BG_TempAlloc
import BG_AllocUnaligned
import BG_Alloc
import BG_CanUseFPNow
import BG_HasYsalamiri
import BG_GetItemIndexByTag
import BG_ParseAnimationFile
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityStateExtraPolate
import BG_PlayerStateToEntityState
import BG_TouchJumpPad
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_ForcePowerDrain
import BG_SaberStartTransAnim
import BG_InDeathAnim
import BG_InRoll
import BG_KnockawayForParry
import BG_BrokenParryForParry
import BG_BrokenParryForAttack
import BG_SaberInSpecialAttack
import BG_SpinningSaberAnim
import BG_FlippingAnim
import BG_SaberInIdle
import BG_SaberInSpecial
import BG_SaberInAttack
import BG_DirectFlippingAnim
import BG_InSaberStandAnim
import BG_InSpecialJump
import BG_LegalizedForcePowers
import saberMoveData
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindItem
import vectoyaw
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import pm
import bgForcePowerCost
import forceMasteryPoints
import forceMasteryLevels
import bgGlobalAnimations
import BGPAFtextLoaded
import forcePowerSorted
import WP_MuzzlePoint
import ammoData
import weaponData
import GetStringForID
import GetIDForString
import Q_irand
import irand
import flrand
import Rand_Init
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey_Big
import Info_SetValueForKey
import Info_RemoveKey_big
import Info_RemoveKey
import Info_ValueForKey
import va
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseVec4
import COM_ParseFloat
import COM_ParseInt
import COM_ParseString
import COM_ParseWarning
import COM_ParseError
import COM_Compress
import COM_ParseExt
import COM_Parse
import SkipWhitespace
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_acos
import Q_log2
import VectorRotate
import Vector4Scale
import VectorNormalize2
import VectorNormalize
import CrossProduct
import VectorInverse
import VectorNormalizeFast
import DistanceSquared
import Distance
import VectorLengthSquared
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import powf
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkBlue
import colorLtBlue
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import colorTable
import bytedirs
import Com_Memcpy
import Com_Memset
import Hunk_Alloc
import forceSpeedLevels
import FloatSwap
import LongSwap
import ShortSwap
import acos
import fabs
import abs
import tan
import atan2
import cos
import sin
import sqrt
import floor
import ceil
import memcpy
import memset
import memmove
import sscanf
import vsprintf
import _atoi
import atoi
import _atof
import atof
import toupper
import tolower
import strncpy
import strstr
import strchr
import strcmp
import strcpy
import strcat
import strlen
import rand
import srand
import qsort
lit
align 1
LABELV $178
char 1 115
char 1 111
char 1 117
char 1 110
char 1 100
char 1 47
char 1 119
char 1 101
char 1 97
char 1 112
char 1 111
char 1 110
char 1 115
char 1 47
char 1 115
char 1 97
char 1 98
char 1 101
char 1 114
char 1 47
char 1 98
char 1 111
char 1 117
char 1 110
char 1 99
char 1 101
char 1 37
char 1 105
char 1 46
char 1 119
char 1 97
char 1 118
char 1 0
align 1
LABELV $175
char 1 115
char 1 111
char 1 117
char 1 110
char 1 100
char 1 47
char 1 119
char 1 101
char 1 97
char 1 112
char 1 111
char 1 110
char 1 115
char 1 47
char 1 116
char 1 104
char 1 101
char 1 114
char 1 109
char 1 97
char 1 108
char 1 47
char 1 98
char 1 111
char 1 117
char 1 110
char 1 99
char 1 101
char 1 37
char 1 105
char 1 46
char 1 119
char 1 97
char 1 118
char 1 0
