export CG_InitMarkPolys
code
proc CG_InitMarkPolys 12 12
file "../cg_marks.c"
line 28
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:// cg_marks.c -- wall marks
;4:
;5:#include "cg_local.h"
;6:
;7:/*
;8:===================================================================
;9:
;10:MARK POLYS
;11:
;12:===================================================================
;13:*/
;14:
;15:
;16:markPoly_t	cg_activeMarkPolys;			// double linked list
;17:markPoly_t	*cg_freeMarkPolys;			// single linked list
;18:markPoly_t	cg_markPolys[MAX_MARK_POLYS];
;19:static		int	markTotal;
;20:
;21:/*
;22:===================
;23:CG_InitMarkPolys
;24:
;25:This is called at startup and for tournement restarts
;26:===================
;27:*/
;28:void	CG_InitMarkPolys( void ) {
line 31
;29:	int		i;
;30:
;31:	memset( cg_markPolys, 0, sizeof(cg_markPolys) );
ADDRGP4 cg_markPolys
ARGP4
CNSTI4 0
ARGI4
CNSTI4 73728
ARGI4
ADDRGP4 memset
CALLP4
pop
line 33
;32:
;33:	cg_activeMarkPolys.nextMark = &cg_activeMarkPolys;
ADDRGP4 cg_activeMarkPolys+4
ADDRGP4 cg_activeMarkPolys
ASGNP4
line 34
;34:	cg_activeMarkPolys.prevMark = &cg_activeMarkPolys;
ADDRLP4 4
ADDRGP4 cg_activeMarkPolys
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
ASGNP4
line 35
;35:	cg_freeMarkPolys = cg_markPolys;
ADDRGP4 cg_freeMarkPolys
ADDRGP4 cg_markPolys
ASGNP4
line 36
;36:	for ( i = 0 ; i < MAX_MARK_POLYS - 1 ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $122
line 37
;37:		cg_markPolys[i].nextMark = &cg_markPolys[i+1];
ADDRLP4 8
CNSTI4 288
ADDRLP4 0
INDIRI4
MULI4
ASGNI4
ADDRLP4 8
INDIRI4
ADDRGP4 cg_markPolys+4
ADDP4
ADDRLP4 8
INDIRI4
ADDRGP4 cg_markPolys+288
ADDP4
ASGNP4
line 38
;38:	}
LABELV $123
line 36
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 255
LTI4 $122
line 39
;39:}
LABELV $120
endproc CG_InitMarkPolys 12 12
export CG_FreeMarkPoly
proc CG_FreeMarkPoly 12 4
line 47
;40:
;41:
;42:/*
;43:==================
;44:CG_FreeMarkPoly
;45:==================
;46:*/
;47:void CG_FreeMarkPoly( markPoly_t *le ) {
line 48
;48:	if ( !le->prevMark ) {
ADDRFP4 0
INDIRP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $129
line 49
;49:		CG_Error( "CG_FreeLocalEntity: not active" );
ADDRGP4 $131
ARGP4
ADDRGP4 CG_Error
CALLV
pop
line 50
;50:	}
LABELV $129
line 53
;51:
;52:	// remove from the doubly linked active list
;53:	le->prevMark->nextMark = le->nextMark;
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
CNSTI4 4
ASGNI4
ADDRLP4 0
INDIRP4
INDIRP4
ADDRLP4 4
INDIRI4
ADDP4
ADDRLP4 0
INDIRP4
ADDRLP4 4
INDIRI4
ADDP4
INDIRP4
ASGNP4
line 54
;54:	le->nextMark->prevMark = le->prevMark;
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CNSTI4 4
ADDP4
INDIRP4
ADDRLP4 8
INDIRP4
INDIRP4
ASGNP4
line 57
;55:
;56:	// the free list is only singly linked
;57:	le->nextMark = cg_freeMarkPolys;
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg_freeMarkPolys
INDIRP4
ASGNP4
line 58
;58:	cg_freeMarkPolys = le;
ADDRGP4 cg_freeMarkPolys
ADDRFP4 0
INDIRP4
ASGNP4
line 59
;59:}
LABELV $128
endproc CG_FreeMarkPoly 12 4
export CG_AllocMark
proc CG_AllocMark 12 12
line 68
;60:
;61:/*
;62:===================
;63:CG_AllocMark
;64:
;65:Will allways succeed, even if it requires freeing an old active mark
;66:===================
;67:*/
;68:markPoly_t	*CG_AllocMark( void ) {
line 72
;69:	markPoly_t	*le;
;70:	int time;
;71:
;72:	if ( !cg_freeMarkPolys ) {
ADDRGP4 cg_freeMarkPolys
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $133
line 75
;73:		// no free entities, so free the one at the end of the chain
;74:		// remove the oldest active entity
;75:		time = cg_activeMarkPolys.prevMark->time;
ADDRLP4 4
ADDRGP4 cg_activeMarkPolys
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ASGNI4
ADDRGP4 $136
JUMPV
LABELV $135
line 76
;76:		while (cg_activeMarkPolys.prevMark && time == cg_activeMarkPolys.prevMark->time) {
line 77
;77:			CG_FreeMarkPoly( cg_activeMarkPolys.prevMark );
ADDRGP4 cg_activeMarkPolys
INDIRP4
ARGP4
ADDRGP4 CG_FreeMarkPoly
CALLV
pop
line 78
;78:		}
LABELV $136
line 76
ADDRLP4 8
ADDRGP4 cg_activeMarkPolys
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $138
ADDRLP4 4
INDIRI4
ADDRLP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
EQI4 $135
LABELV $138
line 79
;79:	}
LABELV $133
line 81
;80:
;81:	le = cg_freeMarkPolys;
ADDRLP4 0
ADDRGP4 cg_freeMarkPolys
INDIRP4
ASGNP4
line 82
;82:	cg_freeMarkPolys = cg_freeMarkPolys->nextMark;
ADDRLP4 8
ADDRGP4 cg_freeMarkPolys
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRP4
CNSTI4 4
ADDP4
INDIRP4
ASGNP4
line 84
;83:
;84:	memset( le, 0, sizeof( *le ) );
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 0
ARGI4
CNSTI4 288
ARGI4
ADDRGP4 memset
CALLP4
pop
line 87
;85:
;86:	// link into the active list
;87:	le->nextMark = cg_activeMarkPolys.nextMark;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg_activeMarkPolys+4
INDIRP4
ASGNP4
line 88
;88:	le->prevMark = &cg_activeMarkPolys;
ADDRLP4 0
INDIRP4
ADDRGP4 cg_activeMarkPolys
ASGNP4
line 89
;89:	cg_activeMarkPolys.nextMark->prevMark = le;
ADDRGP4 cg_activeMarkPolys+4
INDIRP4
ADDRLP4 0
INDIRP4
ASGNP4
line 90
;90:	cg_activeMarkPolys.nextMark = le;
ADDRGP4 cg_activeMarkPolys+4
ADDRLP4 0
INDIRP4
ASGNP4
line 91
;91:	return le;
ADDRLP4 0
INDIRP4
RETP4
LABELV $132
endproc CG_AllocMark 12 12
export CG_ImpactMark
proc CG_ImpactMark 6088 28
line 112
;92:}
;93:
;94:
;95:
;96:/*
;97:=================
;98:CG_ImpactMark
;99:
;100:origin should be a point within a unit of the plane
;101:dir should be the plane normal
;102:
;103:temporary marks will not be stored or randomly oriented, but immediately
;104:passed to the renderer.
;105:=================
;106:*/
;107:#define	MAX_MARK_FRAGMENTS	128
;108:#define	MAX_MARK_POINTS		384
;109:
;110:void CG_ImpactMark( qhandle_t markShader, const vec3_t origin, const vec3_t dir, 
;111:				   float orientation, float red, float green, float blue, float alpha,
;112:				   qboolean alphaFade, float radius, qboolean temporary ) {
line 123
;113:	vec3_t			axis[3];
;114:	float			texCoordScale;
;115:	vec3_t			originalPoints[4];
;116:	byte			colors[4];
;117:	int				i, j;
;118:	int				numFragments;
;119:	markFragment_t	markFragments[MAX_MARK_FRAGMENTS], *mf;
;120:	vec3_t			markPoints[MAX_MARK_POINTS];
;121:	vec3_t			projection;
;122:
;123:	if ( !cg_addMarks.integer ) {
ADDRGP4 cg_addMarks+12
INDIRI4
CNSTI4 0
NEI4 $143
line 124
;124:		return;
ADDRGP4 $142
JUMPV
LABELV $143
line 127
;125:	}
;126:
;127:	if ( radius <= 0 ) {
ADDRFP4 36
INDIRF4
CNSTF4 0
GTF4 $146
line 128
;128:		CG_Error( "CG_ImpactMark called with <= 0 radius" );
ADDRGP4 $148
ARGP4
ADDRGP4 CG_Error
CALLV
pop
line 129
;129:	}
LABELV $146
line 136
;130:
;131:	//if ( markTotal >= MAX_MARK_POLYS ) {
;132:	//	return;
;133:	//}
;134:
;135:	// create the texture axis
;136:	VectorNormalize2( dir, axis[0] );
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 VectorNormalize2
CALLF4
pop
line 137
;137:	PerpendicularVector( axis[1], axis[0] );
ADDRLP4 0+12
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 PerpendicularVector
CALLV
pop
line 138
;138:	RotatePointAroundVector( axis[2], axis[0], axis[1], orientation );
ADDRLP4 0+24
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 0+12
ARGP4
ADDRFP4 12
INDIRF4
ARGF4
ADDRGP4 RotatePointAroundVector
CALLV
pop
line 139
;139:	CrossProduct( axis[0], axis[2], axis[1] );
ADDRLP4 0
ARGP4
ADDRLP4 0+24
ARGP4
ADDRLP4 0+12
ARGP4
ADDRGP4 CrossProduct
CALLV
pop
line 141
;140:
;141:	texCoordScale = 0.5 * 1.0 / radius;
ADDRLP4 48
CNSTF4 1056964608
ADDRFP4 36
INDIRF4
DIVF4
ASGNF4
line 144
;142:
;143:	// create the full polygon
;144:	for ( i = 0 ; i < 3 ; i++ ) {
ADDRLP4 44
CNSTI4 0
ASGNI4
LABELV $154
line 145
;145:		originalPoints[0][i] = origin[i] - radius * axis[1][i] - radius * axis[2][i];
ADDRLP4 5752
ADDRLP4 44
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 5756
ADDRFP4 36
INDIRF4
ASGNF4
ADDRLP4 5752
INDIRI4
ADDRLP4 4664
ADDP4
ADDRLP4 5752
INDIRI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRF4
ADDRLP4 5756
INDIRF4
ADDRLP4 5752
INDIRI4
ADDRLP4 0+12
ADDP4
INDIRF4
MULF4
SUBF4
ADDRLP4 5756
INDIRF4
ADDRLP4 5752
INDIRI4
ADDRLP4 0+24
ADDP4
INDIRF4
MULF4
SUBF4
ASGNF4
line 146
;146:		originalPoints[1][i] = origin[i] + radius * axis[1][i] - radius * axis[2][i];
ADDRLP4 5760
ADDRLP4 44
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 5764
ADDRFP4 36
INDIRF4
ASGNF4
ADDRLP4 5760
INDIRI4
ADDRLP4 4664+12
ADDP4
ADDRLP4 5760
INDIRI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRF4
ADDRLP4 5764
INDIRF4
ADDRLP4 5760
INDIRI4
ADDRLP4 0+12
ADDP4
INDIRF4
MULF4
ADDF4
ADDRLP4 5764
INDIRF4
ADDRLP4 5760
INDIRI4
ADDRLP4 0+24
ADDP4
INDIRF4
MULF4
SUBF4
ASGNF4
line 147
;147:		originalPoints[2][i] = origin[i] + radius * axis[1][i] + radius * axis[2][i];
ADDRLP4 5768
ADDRLP4 44
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 5772
ADDRFP4 36
INDIRF4
ASGNF4
ADDRLP4 5768
INDIRI4
ADDRLP4 4664+24
ADDP4
ADDRLP4 5768
INDIRI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRF4
ADDRLP4 5772
INDIRF4
ADDRLP4 5768
INDIRI4
ADDRLP4 0+12
ADDP4
INDIRF4
MULF4
ADDF4
ADDRLP4 5772
INDIRF4
ADDRLP4 5768
INDIRI4
ADDRLP4 0+24
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 148
;148:		originalPoints[3][i] = origin[i] - radius * axis[1][i] + radius * axis[2][i];
ADDRLP4 5776
ADDRLP4 44
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 5780
ADDRFP4 36
INDIRF4
ASGNF4
ADDRLP4 5776
INDIRI4
ADDRLP4 4664+36
ADDP4
ADDRLP4 5776
INDIRI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRF4
ADDRLP4 5780
INDIRF4
ADDRLP4 5776
INDIRI4
ADDRLP4 0+12
ADDP4
INDIRF4
MULF4
SUBF4
ADDRLP4 5780
INDIRF4
ADDRLP4 5776
INDIRI4
ADDRLP4 0+24
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 149
;149:	}
LABELV $155
line 144
ADDRLP4 44
ADDRLP4 44
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 44
INDIRI4
CNSTI4 3
LTI4 $154
line 152
;150:
;151:	// get the fragments
;152:	VectorScale( dir, -20, projection );
ADDRLP4 5752
CNSTF4 3248488448
ASGNF4
ADDRLP4 5756
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 4716
ADDRLP4 5752
INDIRF4
ADDRLP4 5756
INDIRP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 4716+4
ADDRLP4 5752
INDIRF4
ADDRLP4 5756
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 4716+8
CNSTF4 3248488448
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
ASGNF4
line 153
;153:	numFragments = trap_CM_MarkFragments( 4, (void *)originalPoints,
CNSTI4 4
ARGI4
ADDRLP4 4664
ARGP4
ADDRLP4 4716
ARGP4
CNSTI4 384
ARGI4
ADDRLP4 56
ARGP4
CNSTI4 128
ARGI4
ADDRLP4 4728
ARGP4
ADDRLP4 5760
ADDRGP4 trap_CM_MarkFragments
CALLI4
ASGNI4
ADDRLP4 4712
ADDRLP4 5760
INDIRI4
ASGNI4
line 157
;154:					projection, MAX_MARK_POINTS, markPoints[0],
;155:					MAX_MARK_FRAGMENTS, markFragments );
;156:
;157:	colors[0] = red * 255;
ADDRLP4 5768
CNSTF4 1132396544
ADDRFP4 16
INDIRF4
MULF4
ASGNF4
ADDRLP4 5772
CNSTF4 1325400064
ASGNF4
ADDRLP4 5768
INDIRF4
ADDRLP4 5772
INDIRF4
LTF4 $172
ADDRLP4 5764
ADDRLP4 5768
INDIRF4
ADDRLP4 5772
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $173
JUMPV
LABELV $172
ADDRLP4 5764
ADDRLP4 5768
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $173
ADDRLP4 52
ADDRLP4 5764
INDIRU4
CVUU1 4
ASGNU1
line 158
;158:	colors[1] = green * 255;
ADDRLP4 5780
CNSTF4 1132396544
ADDRFP4 20
INDIRF4
MULF4
ASGNF4
ADDRLP4 5784
CNSTF4 1325400064
ASGNF4
ADDRLP4 5780
INDIRF4
ADDRLP4 5784
INDIRF4
LTF4 $176
ADDRLP4 5776
ADDRLP4 5780
INDIRF4
ADDRLP4 5784
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $177
JUMPV
LABELV $176
ADDRLP4 5776
ADDRLP4 5780
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $177
ADDRLP4 52+1
ADDRLP4 5776
INDIRU4
CVUU1 4
ASGNU1
line 159
;159:	colors[2] = blue * 255;
ADDRLP4 5792
CNSTF4 1132396544
ADDRFP4 24
INDIRF4
MULF4
ASGNF4
ADDRLP4 5796
CNSTF4 1325400064
ASGNF4
ADDRLP4 5792
INDIRF4
ADDRLP4 5796
INDIRF4
LTF4 $180
ADDRLP4 5788
ADDRLP4 5792
INDIRF4
ADDRLP4 5796
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $181
JUMPV
LABELV $180
ADDRLP4 5788
ADDRLP4 5792
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $181
ADDRLP4 52+2
ADDRLP4 5788
INDIRU4
CVUU1 4
ASGNU1
line 160
;160:	colors[3] = alpha * 255;
ADDRLP4 5804
CNSTF4 1132396544
ADDRFP4 28
INDIRF4
MULF4
ASGNF4
ADDRLP4 5808
CNSTF4 1325400064
ASGNF4
ADDRLP4 5804
INDIRF4
ADDRLP4 5808
INDIRF4
LTF4 $184
ADDRLP4 5800
ADDRLP4 5804
INDIRF4
ADDRLP4 5808
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $185
JUMPV
LABELV $184
ADDRLP4 5800
ADDRLP4 5804
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $185
ADDRLP4 52+3
ADDRLP4 5800
INDIRU4
CVUU1 4
ASGNU1
line 162
;161:
;162:	for ( i = 0, mf = markFragments ; i < numFragments ; i++, mf++ ) {
ADDRLP4 44
CNSTI4 0
ASGNI4
ADDRLP4 40
ADDRLP4 4728
ASGNP4
ADDRGP4 $189
JUMPV
LABELV $186
line 169
;163:		polyVert_t	*v;
;164:		polyVert_t	verts[MAX_VERTS_ON_POLY];
;165:		markPoly_t	*mark;
;166:
;167:		// we have an upper limit on the complexity of polygons
;168:		// that we store persistantly
;169:		if ( mf->numPoints > MAX_VERTS_ON_POLY ) {
ADDRLP4 40
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 10
LEI4 $190
line 170
;170:			mf->numPoints = MAX_VERTS_ON_POLY;
ADDRLP4 40
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 10
ASGNI4
line 171
;171:		}
LABELV $190
line 172
;172:		for ( j = 0, v = verts ; j < mf->numPoints ; j++, v++ ) {
ADDRLP4 36
CNSTI4 0
ASGNI4
ADDRLP4 5812
ADDRLP4 5820
ASGNP4
ADDRGP4 $195
JUMPV
LABELV $192
line 175
;173:			vec3_t		delta;
;174:
;175:			VectorCopy( markPoints[mf->firstPoint + j], v->xyz );
ADDRLP4 5812
INDIRP4
CNSTI4 12
ADDRLP4 40
INDIRP4
INDIRI4
ADDRLP4 36
INDIRI4
ADDI4
MULI4
ADDRLP4 56
ADDP4
INDIRB
ASGNB 12
line 177
;176:
;177:			VectorSubtract( v->xyz, origin, delta );
ADDRLP4 6076
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 6060
ADDRLP4 5812
INDIRP4
INDIRF4
ADDRLP4 6076
INDIRP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 6080
CNSTI4 4
ASGNI4
ADDRLP4 6060+4
ADDRLP4 5812
INDIRP4
ADDRLP4 6080
INDIRI4
ADDP4
INDIRF4
ADDRLP4 6076
INDIRP4
ADDRLP4 6080
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 6084
CNSTI4 8
ASGNI4
ADDRLP4 6060+8
ADDRLP4 5812
INDIRP4
ADDRLP4 6084
INDIRI4
ADDP4
INDIRF4
ADDRFP4 4
INDIRP4
ADDRLP4 6084
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 178
;178:			v->st[0] = 0.5 + DotProduct( delta, axis[1] ) * texCoordScale;
ADDRLP4 5812
INDIRP4
CNSTI4 12
ADDP4
ADDRLP4 6060
INDIRF4
ADDRLP4 0+12
INDIRF4
MULF4
ADDRLP4 6060+4
INDIRF4
ADDRLP4 0+12+4
INDIRF4
MULF4
ADDF4
ADDRLP4 6060+8
INDIRF4
ADDRLP4 0+12+8
INDIRF4
MULF4
ADDF4
ADDRLP4 48
INDIRF4
MULF4
CNSTF4 1056964608
ADDF4
ASGNF4
line 179
;179:			v->st[1] = 0.5 + DotProduct( delta, axis[2] ) * texCoordScale;
ADDRLP4 5812
INDIRP4
CNSTI4 16
ADDP4
ADDRLP4 6060
INDIRF4
ADDRLP4 0+24
INDIRF4
MULF4
ADDRLP4 6060+4
INDIRF4
ADDRLP4 0+24+4
INDIRF4
MULF4
ADDF4
ADDRLP4 6060+8
INDIRF4
ADDRLP4 0+24+8
INDIRF4
MULF4
ADDF4
ADDRLP4 48
INDIRF4
MULF4
CNSTF4 1056964608
ADDF4
ASGNF4
line 180
;180:			*(int *)v->modulate = *(int *)colors;
ADDRLP4 5812
INDIRP4
CNSTI4 20
ADDP4
ADDRLP4 52
INDIRI4
ASGNI4
line 181
;181:		}
LABELV $193
line 172
ADDRLP4 36
ADDRLP4 36
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 5812
ADDRLP4 5812
INDIRP4
CNSTI4 24
ADDP4
ASGNP4
LABELV $195
ADDRLP4 36
INDIRI4
ADDRLP4 40
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
LTI4 $192
line 184
;182:
;183:		// if it is a temporary (shadow) mark, add it immediately and forget about it
;184:		if ( temporary ) {
ADDRFP4 40
INDIRI4
CNSTI4 0
EQI4 $212
line 185
;185:			trap_R_AddPolyToScene( markShader, mf->numPoints, verts );
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 40
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
ARGI4
ADDRLP4 5820
ARGP4
ADDRGP4 trap_R_AddPolyToScene
CALLV
pop
line 186
;186:			continue;
ADDRGP4 $187
JUMPV
LABELV $212
line 190
;187:		}
;188:
;189:		// otherwise save it persistantly
;190:		mark = CG_AllocMark();
ADDRLP4 6060
ADDRGP4 CG_AllocMark
CALLP4
ASGNP4
ADDRLP4 5816
ADDRLP4 6060
INDIRP4
ASGNP4
line 191
;191:		mark->time = cg.time;
ADDRLP4 5816
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 192
;192:		mark->alphaFade = alphaFade;
ADDRLP4 5816
INDIRP4
CNSTI4 16
ADDP4
ADDRFP4 32
INDIRI4
ASGNI4
line 193
;193:		mark->markShader = markShader;
ADDRLP4 5816
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 0
INDIRI4
ASGNI4
line 194
;194:		mark->poly.numVerts = mf->numPoints;
ADDRLP4 5816
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 40
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
ASGNI4
line 195
;195:		mark->color[0] = red;
ADDRLP4 5816
INDIRP4
CNSTI4 20
ADDP4
ADDRFP4 16
INDIRF4
ASGNF4
line 196
;196:		mark->color[1] = green;
ADDRLP4 5816
INDIRP4
CNSTI4 24
ADDP4
ADDRFP4 20
INDIRF4
ASGNF4
line 197
;197:		mark->color[2] = blue;
ADDRLP4 5816
INDIRP4
CNSTI4 28
ADDP4
ADDRFP4 24
INDIRF4
ASGNF4
line 198
;198:		mark->color[3] = alpha;
ADDRLP4 5816
INDIRP4
CNSTI4 32
ADDP4
ADDRFP4 28
INDIRF4
ASGNF4
line 199
;199:		memcpy( mark->verts, verts, mf->numPoints * sizeof( verts[0] ) );
ADDRLP4 5816
INDIRP4
CNSTI4 48
ADDP4
ARGP4
ADDRLP4 5820
ARGP4
CNSTU4 24
ADDRLP4 40
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CVIU4 4
MULU4
CVUI4 4
ARGI4
ADDRGP4 memcpy
CALLP4
pop
line 200
;200:		markTotal++;
ADDRLP4 6064
ADDRGP4 markTotal
ASGNP4
ADDRLP4 6064
INDIRP4
ADDRLP4 6064
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 201
;201:	}
LABELV $187
line 162
ADDRLP4 44
ADDRLP4 44
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 40
ADDRLP4 40
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
LABELV $189
ADDRLP4 44
INDIRI4
ADDRLP4 4712
INDIRI4
LTI4 $186
line 202
;202:}
LABELV $142
endproc CG_ImpactMark 6088 28
export CG_AddMarks
proc CG_AddMarks 80 12
line 213
;203:
;204:
;205:/*
;206:===============
;207:CG_AddMarks
;208:===============
;209:*/
;210:#define	MARK_TOTAL_TIME		10000
;211:#define	MARK_FADE_TIME		1000
;212:
;213:void CG_AddMarks( void ) {
line 219
;214:	int			j;
;215:	markPoly_t	*mp, *next;
;216:	int			t;
;217:	int			fade;
;218:
;219:	if ( !cg_addMarks.integer ) {
ADDRGP4 cg_addMarks+12
INDIRI4
CNSTI4 0
NEI4 $216
line 220
;220:		return;
ADDRGP4 $215
JUMPV
LABELV $216
line 223
;221:	}
;222:
;223:	mp = cg_activeMarkPolys.nextMark;
ADDRLP4 0
ADDRGP4 cg_activeMarkPolys+4
INDIRP4
ASGNP4
line 224
;224:	for ( ; mp != &cg_activeMarkPolys ; mp = next ) {
ADDRGP4 $223
JUMPV
LABELV $220
line 227
;225:		// grab next now, so if the local entity is freed we
;226:		// still have it
;227:		next = mp->nextMark;
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRP4
ASGNP4
line 230
;228:
;229:		// see if it is time to completely remove it
;230:		if ( cg.time > mp->time + MARK_TOTAL_TIME ) {
ADDRGP4 cg+64
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 10000
ADDI4
LEI4 $224
line 231
;231:			CG_FreeMarkPoly( mp );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 CG_FreeMarkPoly
CALLV
pop
line 232
;232:			continue;
ADDRGP4 $221
JUMPV
LABELV $224
line 236
;233:		}
;234:
;235:		// fade out the energy bursts
;236:		if ( mp->markShader == cgs.media.energyMarkShader ) {
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ADDRGP4 cgs+70296+432
INDIRI4
NEI4 $227
line 238
;237:
;238:			fade = 450 - 450 * ( (cg.time - mp->time ) / 3000.0 );
ADDRLP4 20
CNSTF4 1138819072
ASGNF4
ADDRLP4 8
ADDRLP4 20
INDIRF4
ADDRLP4 20
INDIRF4
ADDRGP4 cg+64
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
SUBI4
CVIF4 4
CNSTF4 1161527296
DIVF4
MULF4
SUBF4
CVFI4 4
ASGNI4
line 239
;239:			if ( fade < 255 ) {
ADDRLP4 8
INDIRI4
CNSTI4 255
GEI4 $232
line 240
;240:				if ( fade < 0 ) {
ADDRLP4 8
INDIRI4
CNSTI4 0
GEI4 $234
line 241
;241:					fade = 0;
ADDRLP4 8
CNSTI4 0
ASGNI4
line 242
;242:				}
LABELV $234
line 243
;243:				if ( mp->verts[0].modulate[0] != 0 ) {
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
INDIRU1
CVUI4 1
CNSTI4 0
EQI4 $236
line 244
;244:					for ( j = 0 ; j < mp->poly.numVerts ; j++ ) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $241
JUMPV
LABELV $238
line 245
;245:						mp->verts[j].modulate[0] = mp->color[0] * fade;
ADDRLP4 32
CNSTI4 20
ASGNI4
ADDRLP4 36
ADDRLP4 0
INDIRP4
ADDRLP4 32
INDIRI4
ADDP4
INDIRF4
ADDRLP4 8
INDIRI4
CVIF4 4
MULF4
ASGNF4
ADDRLP4 40
CNSTF4 1325400064
ASGNF4
ADDRLP4 36
INDIRF4
ADDRLP4 40
INDIRF4
LTF4 $243
ADDRLP4 24
ADDRLP4 36
INDIRF4
ADDRLP4 40
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $244
JUMPV
LABELV $243
ADDRLP4 24
ADDRLP4 36
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $244
CNSTI4 24
ADDRLP4 4
INDIRI4
MULI4
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
ADDP4
ADDRLP4 32
INDIRI4
ADDP4
ADDRLP4 24
INDIRU4
CVUU1 4
ASGNU1
line 246
;246:						mp->verts[j].modulate[1] = mp->color[1] * fade;
ADDRLP4 52
CNSTI4 24
ASGNI4
ADDRLP4 56
ADDRLP4 0
INDIRP4
ADDRLP4 52
INDIRI4
ADDP4
INDIRF4
ADDRLP4 8
INDIRI4
CVIF4 4
MULF4
ASGNF4
ADDRLP4 60
CNSTF4 1325400064
ASGNF4
ADDRLP4 56
INDIRF4
ADDRLP4 60
INDIRF4
LTF4 $246
ADDRLP4 44
ADDRLP4 56
INDIRF4
ADDRLP4 60
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $247
JUMPV
LABELV $246
ADDRLP4 44
ADDRLP4 56
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $247
ADDRLP4 52
INDIRI4
ADDRLP4 4
INDIRI4
MULI4
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
ADDP4
CNSTI4 21
ADDP4
ADDRLP4 44
INDIRU4
CVUU1 4
ASGNU1
line 247
;247:						mp->verts[j].modulate[2] = mp->color[2] * fade;
ADDRLP4 72
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRLP4 8
INDIRI4
CVIF4 4
MULF4
ASGNF4
ADDRLP4 76
CNSTF4 1325400064
ASGNF4
ADDRLP4 72
INDIRF4
ADDRLP4 76
INDIRF4
LTF4 $249
ADDRLP4 64
ADDRLP4 72
INDIRF4
ADDRLP4 76
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $250
JUMPV
LABELV $249
ADDRLP4 64
ADDRLP4 72
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $250
CNSTI4 24
ADDRLP4 4
INDIRI4
MULI4
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
ADDP4
CNSTI4 22
ADDP4
ADDRLP4 64
INDIRU4
CVUU1 4
ASGNU1
line 248
;248:					}
LABELV $239
line 244
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $241
ADDRLP4 4
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
LTI4 $238
line 249
;249:				}
LABELV $236
line 250
;250:			}
LABELV $232
line 251
;251:		}
LABELV $227
line 254
;252:
;253:		// fade all marks out with time
;254:		t = mp->time + MARK_TOTAL_TIME - cg.time;
ADDRLP4 12
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 10000
ADDI4
ADDRGP4 cg+64
INDIRI4
SUBI4
ASGNI4
line 255
;255:		if ( t < MARK_FADE_TIME ) {
ADDRLP4 12
INDIRI4
CNSTI4 1000
GEI4 $252
line 256
;256:			fade = 255 * t / MARK_FADE_TIME;
ADDRLP4 8
CNSTI4 255
ADDRLP4 12
INDIRI4
MULI4
CNSTI4 1000
DIVI4
ASGNI4
line 257
;257:			if ( mp->alphaFade ) {
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
CNSTI4 0
EQI4 $254
line 258
;258:				for ( j = 0 ; j < mp->poly.numVerts ; j++ ) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $259
JUMPV
LABELV $256
line 259
;259:					mp->verts[j].modulate[3] = fade;
CNSTI4 24
ADDRLP4 4
INDIRI4
MULI4
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
ADDP4
CNSTI4 23
ADDP4
ADDRLP4 8
INDIRI4
CVIU4 4
CVUU1 4
ASGNU1
line 260
;260:				}
LABELV $257
line 258
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $259
ADDRLP4 4
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
LTI4 $256
line 261
;261:			}
ADDRGP4 $253
JUMPV
LABELV $254
line 263
;262:			else 
;263:			{
line 264
;264:				float f = (float)t / MARK_FADE_TIME;
ADDRLP4 20
ADDRLP4 12
INDIRI4
CVIF4 4
CNSTF4 1148846080
DIVF4
ASGNF4
line 265
;265:				for ( j = 0 ; j < mp->poly.numVerts ; j++ ) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $263
JUMPV
LABELV $260
line 266
;266:					mp->verts[j].modulate[0] = mp->color[0] * f;
ADDRLP4 32
CNSTI4 20
ASGNI4
ADDRLP4 36
ADDRLP4 0
INDIRP4
ADDRLP4 32
INDIRI4
ADDP4
INDIRF4
ADDRLP4 20
INDIRF4
MULF4
ASGNF4
ADDRLP4 40
CNSTF4 1325400064
ASGNF4
ADDRLP4 36
INDIRF4
ADDRLP4 40
INDIRF4
LTF4 $265
ADDRLP4 24
ADDRLP4 36
INDIRF4
ADDRLP4 40
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $266
JUMPV
LABELV $265
ADDRLP4 24
ADDRLP4 36
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $266
CNSTI4 24
ADDRLP4 4
INDIRI4
MULI4
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
ADDP4
ADDRLP4 32
INDIRI4
ADDP4
ADDRLP4 24
INDIRU4
CVUU1 4
ASGNU1
line 267
;267:					mp->verts[j].modulate[1] = mp->color[1] * f;
ADDRLP4 52
CNSTI4 24
ASGNI4
ADDRLP4 56
ADDRLP4 0
INDIRP4
ADDRLP4 52
INDIRI4
ADDP4
INDIRF4
ADDRLP4 20
INDIRF4
MULF4
ASGNF4
ADDRLP4 60
CNSTF4 1325400064
ASGNF4
ADDRLP4 56
INDIRF4
ADDRLP4 60
INDIRF4
LTF4 $268
ADDRLP4 44
ADDRLP4 56
INDIRF4
ADDRLP4 60
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $269
JUMPV
LABELV $268
ADDRLP4 44
ADDRLP4 56
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $269
ADDRLP4 52
INDIRI4
ADDRLP4 4
INDIRI4
MULI4
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
ADDP4
CNSTI4 21
ADDP4
ADDRLP4 44
INDIRU4
CVUU1 4
ASGNU1
line 268
;268:					mp->verts[j].modulate[2] = mp->color[2] * f;
ADDRLP4 72
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRLP4 20
INDIRF4
MULF4
ASGNF4
ADDRLP4 76
CNSTF4 1325400064
ASGNF4
ADDRLP4 72
INDIRF4
ADDRLP4 76
INDIRF4
LTF4 $271
ADDRLP4 64
ADDRLP4 72
INDIRF4
ADDRLP4 76
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $272
JUMPV
LABELV $271
ADDRLP4 64
ADDRLP4 72
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $272
CNSTI4 24
ADDRLP4 4
INDIRI4
MULI4
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
ADDP4
CNSTI4 22
ADDP4
ADDRLP4 64
INDIRU4
CVUU1 4
ASGNU1
line 269
;269:				}
LABELV $261
line 265
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $263
ADDRLP4 4
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
LTI4 $260
line 270
;270:			}
line 271
;271:		}
ADDRGP4 $253
JUMPV
LABELV $252
line 273
;272:		else
;273:		{
line 274
;274:			for ( j = 0 ; j < mp->poly.numVerts ; j++ ) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $276
JUMPV
LABELV $273
line 275
;275:				mp->verts[j].modulate[0] = mp->color[0];
ADDRLP4 28
CNSTI4 20
ASGNI4
ADDRLP4 32
ADDRLP4 0
INDIRP4
ADDRLP4 28
INDIRI4
ADDP4
INDIRF4
ASGNF4
ADDRLP4 36
CNSTF4 1325400064
ASGNF4
ADDRLP4 32
INDIRF4
ADDRLP4 36
INDIRF4
LTF4 $278
ADDRLP4 20
ADDRLP4 32
INDIRF4
ADDRLP4 36
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $279
JUMPV
LABELV $278
ADDRLP4 20
ADDRLP4 32
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $279
CNSTI4 24
ADDRLP4 4
INDIRI4
MULI4
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
ADDP4
ADDRLP4 28
INDIRI4
ADDP4
ADDRLP4 20
INDIRU4
CVUU1 4
ASGNU1
line 276
;276:				mp->verts[j].modulate[1] = mp->color[1];
ADDRLP4 48
CNSTI4 24
ASGNI4
ADDRLP4 52
ADDRLP4 0
INDIRP4
ADDRLP4 48
INDIRI4
ADDP4
INDIRF4
ASGNF4
ADDRLP4 56
CNSTF4 1325400064
ASGNF4
ADDRLP4 52
INDIRF4
ADDRLP4 56
INDIRF4
LTF4 $281
ADDRLP4 40
ADDRLP4 52
INDIRF4
ADDRLP4 56
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $282
JUMPV
LABELV $281
ADDRLP4 40
ADDRLP4 52
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $282
ADDRLP4 48
INDIRI4
ADDRLP4 4
INDIRI4
MULI4
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
ADDP4
CNSTI4 21
ADDP4
ADDRLP4 40
INDIRU4
CVUU1 4
ASGNU1
line 277
;277:				mp->verts[j].modulate[2] = mp->color[2];
ADDRLP4 68
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ASGNF4
ADDRLP4 72
CNSTF4 1325400064
ASGNF4
ADDRLP4 68
INDIRF4
ADDRLP4 72
INDIRF4
LTF4 $284
ADDRLP4 60
ADDRLP4 68
INDIRF4
ADDRLP4 72
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $285
JUMPV
LABELV $284
ADDRLP4 60
ADDRLP4 68
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $285
CNSTI4 24
ADDRLP4 4
INDIRI4
MULI4
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
ADDP4
CNSTI4 22
ADDP4
ADDRLP4 60
INDIRU4
CVUU1 4
ASGNU1
line 278
;278:			}
LABELV $274
line 274
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $276
ADDRLP4 4
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
LTI4 $273
line 279
;279:		}
LABELV $253
line 281
;280:
;281:		trap_R_AddPolyToScene( mp->markShader, mp->poly.numVerts, mp->verts );
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
ARGP4
ADDRGP4 trap_R_AddPolyToScene
CALLV
pop
line 282
;282:	}
LABELV $221
line 224
ADDRLP4 0
ADDRLP4 16
INDIRP4
ASGNP4
LABELV $223
ADDRLP4 0
INDIRP4
CVPU4 4
ADDRGP4 cg_activeMarkPolys
CVPU4 4
NEU4 $220
line 283
;283:}
LABELV $215
endproc CG_AddMarks 80 12
data
align 4
LABELV shaderAnimNames
address $287
byte 4 0
skip 120
align 4
LABELV shaderAnimCounts
byte 4 23
skip 124
align 4
LABELV shaderAnimSTRatio
byte 4 1065353216
skip 124
export cl_numparticles
align 4
LABELV cl_numparticles
byte 4 1024
export initparticles
align 4
LABELV initparticles
byte 4 0
export CG_ClearParticles
code
proc CG_ClearParticles 28 12
line 387
;284:
;285:// cg_particles.c  
;286:
;287:#define BLOODRED	2
;288:#define EMISIVEFADE	3
;289:#define GREY75		4
;290:
;291:typedef struct particle_s
;292:{
;293:	struct particle_s	*next;
;294:
;295:	float		time;
;296:	float		endtime;
;297:
;298:	vec3_t		org;
;299:	vec3_t		vel;
;300:	vec3_t		accel;
;301:	int			color;
;302:	float		colorvel;
;303:	float		alpha;
;304:	float		alphavel;
;305:	int			type;
;306:	qhandle_t	pshader;
;307:	
;308:	float		height;
;309:	float		width;
;310:				
;311:	float		endheight;
;312:	float		endwidth;
;313:	
;314:	float		start;
;315:	float		end;
;316:
;317:	float		startfade;
;318:	qboolean	rotate;
;319:	int			snum;
;320:	
;321:	qboolean	link;
;322:
;323:	// Ridah
;324:	int			shaderAnim;
;325:	int			roll;
;326:
;327:	int			accumroll;
;328:
;329:} cparticle_t;
;330:
;331:typedef enum
;332:{
;333:	P_NONE,
;334:	P_WEATHER,
;335:	P_FLAT,
;336:	P_SMOKE,
;337:	P_ROTATE,
;338:	P_WEATHER_TURBULENT,
;339:	P_ANIM,	// Ridah
;340:	P_BAT,
;341:	P_BLEED,
;342:	P_FLAT_SCALEUP,
;343:	P_FLAT_SCALEUP_FADE,
;344:	P_WEATHER_FLURRY,
;345:	P_SMOKE_IMPACT,
;346:	P_BUBBLE,
;347:	P_BUBBLE_TURBULENT,
;348:	P_SPRITE
;349:} particle_type_t;
;350:
;351:#define	MAX_SHADER_ANIMS		32
;352:#define	MAX_SHADER_ANIM_FRAMES	64
;353:
;354:static char *shaderAnimNames[MAX_SHADER_ANIMS] = {
;355:	"explode1",
;356:	NULL
;357:};
;358:static qhandle_t shaderAnims[MAX_SHADER_ANIMS][MAX_SHADER_ANIM_FRAMES];
;359:static int	shaderAnimCounts[MAX_SHADER_ANIMS] = {
;360:	23
;361:};
;362:static float	shaderAnimSTRatio[MAX_SHADER_ANIMS] = {
;363:	1.0f
;364:};
;365:static int	numShaderAnims;
;366:// done.
;367:
;368:#define		PARTICLE_GRAVITY	40
;369:#define		MAX_PARTICLES	1024
;370:
;371:cparticle_t	*active_particles, *free_particles;
;372:cparticle_t	particles[MAX_PARTICLES];
;373:int		cl_numparticles = MAX_PARTICLES;
;374:
;375:qboolean		initparticles = qfalse;
;376:vec3_t			pvforward, pvright, pvup;
;377:vec3_t			rforward, rright, rup;
;378:
;379:float			oldtime;
;380:
;381:/*
;382:===============
;383:CL_ClearParticles
;384:===============
;385:*/
;386:void CG_ClearParticles (void)
;387:{
line 390
;388:	int		i;
;389:
;390:	memset( particles, 0, sizeof(particles) );
ADDRGP4 particles
ARGP4
CNSTI4 0
ARGI4
CNSTI4 126976
ARGI4
ADDRGP4 memset
CALLP4
pop
line 392
;391:
;392:	free_particles = &particles[0];
ADDRGP4 free_particles
ADDRGP4 particles
ASGNP4
line 393
;393:	active_particles = NULL;
ADDRGP4 active_particles
CNSTP4 0
ASGNP4
line 395
;394:
;395:	for (i=0 ;i<cl_numparticles ; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $292
JUMPV
LABELV $289
line 396
;396:	{
line 397
;397:		particles[i].next = &particles[i+1];
ADDRLP4 4
CNSTI4 124
ADDRLP4 0
INDIRI4
MULI4
ASGNI4
ADDRLP4 4
INDIRI4
ADDRGP4 particles
ADDP4
ADDRLP4 4
INDIRI4
ADDRGP4 particles+124
ADDP4
ASGNP4
line 398
;398:		particles[i].type = 0;
CNSTI4 124
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 particles+64
ADDP4
CNSTI4 0
ASGNI4
line 399
;399:	}
LABELV $290
line 395
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $292
ADDRLP4 0
INDIRI4
ADDRGP4 cl_numparticles
INDIRI4
LTI4 $289
line 400
;400:	particles[cl_numparticles-1].next = NULL;
CNSTI4 124
ADDRGP4 cl_numparticles
INDIRI4
MULI4
ADDRGP4 particles-124
ADDP4
CNSTP4 0
ASGNP4
line 402
;401:
;402:	oldtime = cg.time;
ADDRGP4 oldtime
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ASGNF4
line 405
;403:
;404:	// Ridah, init the shaderAnims
;405:	for (i=0; shaderAnimNames[i]; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $300
JUMPV
LABELV $297
line 408
;406:		int j;
;407:
;408:		for (j=0; j<shaderAnimCounts[i]; j++) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $304
JUMPV
LABELV $301
line 409
;409:			shaderAnims[i][j] = trap_R_RegisterShader( va("%s%i", shaderAnimNames[i], j+1) );
ADDRGP4 $305
ARGP4
ADDRLP4 12
CNSTI4 2
ASGNI4
ADDRLP4 0
INDIRI4
ADDRLP4 12
INDIRI4
LSHI4
ADDRGP4 shaderAnimNames
ADDP4
INDIRP4
ARGP4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ARGI4
ADDRLP4 20
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 20
INDIRP4
ARGP4
ADDRLP4 24
ADDRGP4 trap_R_RegisterShader
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
ADDRLP4 12
INDIRI4
LSHI4
ADDRLP4 0
INDIRI4
CNSTI4 8
LSHI4
ADDRGP4 shaderAnims
ADDP4
ADDP4
ADDRLP4 24
INDIRI4
ASGNI4
line 410
;410:		}
LABELV $302
line 408
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $304
ADDRLP4 4
INDIRI4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 shaderAnimCounts
ADDP4
INDIRI4
LTI4 $301
line 411
;411:	}
LABELV $298
line 405
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $300
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 shaderAnimNames
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $297
line 412
;412:	numShaderAnims = i;
ADDRGP4 numShaderAnims
ADDRLP4 0
INDIRI4
ASGNI4
line 415
;413:	// done.
;414:
;415:	initparticles = qtrue;
ADDRGP4 initparticles
CNSTI4 1
ASGNI4
line 416
;416:}
LABELV $288
endproc CG_ClearParticles 28 12
export CG_AddParticleToScene
proc CG_AddParticleToScene 472 16
line 425
;417:
;418:
;419:/*
;420:=====================
;421:CG_AddParticleToScene
;422:=====================
;423:*/
;424:void CG_AddParticleToScene (cparticle_t *p, vec3_t org, float alpha)
;425:{
line 438
;426:
;427:	vec3_t		point;
;428:	polyVert_t	verts[4];
;429:	float		width;
;430:	float		height;
;431:	float		time, time2;
;432:	float		ratio;
;433:	float		invratio;
;434:	vec3_t		color;
;435:	polyVert_t	TRIverts[3];
;436:	vec3_t		rright2, rup2;
;437:
;438:	if (p->type == P_WEATHER || p->type == P_WEATHER_TURBULENT || p->type == P_WEATHER_FLURRY
ADDRLP4 240
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
ASGNI4
ADDRLP4 240
INDIRI4
CNSTI4 1
EQI4 $312
ADDRLP4 240
INDIRI4
CNSTI4 5
EQI4 $312
ADDRLP4 240
INDIRI4
CNSTI4 11
EQI4 $312
ADDRLP4 240
INDIRI4
CNSTI4 13
EQI4 $312
ADDRLP4 240
INDIRI4
CNSTI4 14
NEI4 $307
LABELV $312
line 440
;439:		|| p->type == P_BUBBLE || p->type == P_BUBBLE_TURBULENT)
;440:	{// create a front facing polygon
line 442
;441:			
;442:		if (p->type != P_WEATHER_FLURRY)
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
CNSTI4 11
EQI4 $313
line 443
;443:		{
line 444
;444:			if (p->type == P_BUBBLE || p->type == P_BUBBLE_TURBULENT)
ADDRLP4 244
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
ASGNI4
ADDRLP4 244
INDIRI4
CNSTI4 13
EQI4 $317
ADDRLP4 244
INDIRI4
CNSTI4 14
NEI4 $315
LABELV $317
line 445
;445:			{
line 446
;446:				if (org[2] > p->end)			
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 92
ADDP4
INDIRF4
LEF4 $316
line 447
;447:				{	
line 448
;448:					p->time = cg.time;	
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ASGNF4
line 449
;449:					VectorCopy (org, p->org); // Ridah, fixes rare snow flakes that flicker on the ground
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 451
;450:									
;451:					p->org[2] = ( p->start + crandom () * 4 );
ADDRLP4 248
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 252
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 252
INDIRP4
CNSTI4 20
ADDP4
ADDRLP4 252
INDIRP4
CNSTI4 88
ADDP4
INDIRF4
CNSTF4 1082130432
CNSTF4 1073741824
ADDRLP4 248
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ASGNF4
line 454
;452:					
;453:					
;454:					if (p->type == P_BUBBLE_TURBULENT)
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
CNSTI4 14
NEI4 $316
line 455
;455:					{
line 456
;456:						p->vel[0] = crandom() * 4;
ADDRLP4 256
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
CNSTF4 1082130432
CNSTF4 1073741824
ADDRLP4 256
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 457
;457:						p->vel[1] = crandom() * 4;
ADDRLP4 260
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTF4 1082130432
CNSTF4 1073741824
ADDRLP4 260
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 458
;458:					}
line 460
;459:				
;460:				}
line 461
;461:			}
ADDRGP4 $316
JUMPV
LABELV $315
line 463
;462:			else
;463:			{
line 464
;464:				if (org[2] < p->end)			
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 92
ADDP4
INDIRF4
GEF4 $323
line 465
;465:				{	
line 466
;466:					p->time = cg.time;	
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ASGNF4
line 467
;467:					VectorCopy (org, p->org); // Ridah, fixes rare snow flakes that flicker on the ground
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
ADDRGP4 $327
JUMPV
LABELV $326
line 470
;468:									
;469:					while (p->org[2] < p->end) 
;470:					{
line 471
;471:						p->org[2] += (p->start - p->end); 
ADDRLP4 248
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 252
ADDRLP4 248
INDIRP4
CNSTI4 20
ADDP4
ASGNP4
ADDRLP4 252
INDIRP4
ADDRLP4 252
INDIRP4
INDIRF4
ADDRLP4 248
INDIRP4
CNSTI4 88
ADDP4
INDIRF4
ADDRLP4 248
INDIRP4
CNSTI4 92
ADDP4
INDIRF4
SUBF4
ADDF4
ASGNF4
line 472
;472:					}
LABELV $327
line 469
ADDRLP4 248
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 248
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
ADDRLP4 248
INDIRP4
CNSTI4 92
ADDP4
INDIRF4
LTF4 $326
line 475
;473:					
;474:					
;475:					if (p->type == P_WEATHER_TURBULENT)
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
CNSTI4 5
NEI4 $329
line 476
;476:					{
line 477
;477:						p->vel[0] = crandom() * 16;
ADDRLP4 252
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
CNSTF4 1098907648
CNSTF4 1073741824
ADDRLP4 252
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 478
;478:						p->vel[1] = crandom() * 16;
ADDRLP4 256
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTF4 1098907648
CNSTF4 1073741824
ADDRLP4 256
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 479
;479:					}
LABELV $329
line 481
;480:				
;481:				}
LABELV $323
line 482
;482:			}
LABELV $316
line 486
;483:			
;484:
;485:			// Rafael snow pvs check
;486:			if (!p->link)
ADDRFP4 0
INDIRP4
CNSTI4 108
ADDP4
INDIRI4
CNSTI4 0
NEI4 $331
line 487
;487:				return;
ADDRGP4 $306
JUMPV
LABELV $331
line 489
;488:
;489:			p->alpha = 1;
ADDRFP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1065353216
ASGNF4
line 490
;490:		}
LABELV $313
line 493
;491:		
;492:		// Ridah, had to do this or MAX_POLYS is being exceeded in village1.bsp
;493:		if (Distance( cg.snap->ps.origin, org ) > 1024) {
ADDRGP4 cg+36
INDIRP4
CNSTI4 64
ADDP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 244
ADDRGP4 Distance
CALLF4
ASGNF4
ADDRLP4 244
INDIRF4
CNSTF4 1149239296
LEF4 $333
line 494
;494:			return;
ADDRGP4 $306
JUMPV
LABELV $333
line 498
;495:		}
;496:		// done.
;497:	
;498:		if (p->type == P_BUBBLE || p->type == P_BUBBLE_TURBULENT)
ADDRLP4 248
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
ASGNI4
ADDRLP4 248
INDIRI4
CNSTI4 13
EQI4 $338
ADDRLP4 248
INDIRI4
CNSTI4 14
NEI4 $336
LABELV $338
line 499
;499:		{
line 500
;500:			VectorMA (org, -p->height, pvup, point);	
ADDRLP4 252
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 256
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 252
INDIRP4
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 256
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 252
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 256
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRGP4 pvup+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 501
;501:			VectorMA (point, -p->width, pvright, point);	
ADDRLP4 260
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 260
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 260
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 502
;502:			VectorCopy (point, verts[0].xyz);	
ADDRLP4 12
ADDRLP4 0
INDIRB
ASGNB 12
line 503
;503:			verts[0].st[0] = 0;	
ADDRLP4 12+12
CNSTF4 0
ASGNF4
line 504
;504:			verts[0].st[1] = 0;	
ADDRLP4 12+12+4
CNSTF4 0
ASGNF4
line 505
;505:			verts[0].modulate[0] = 255;	
ADDRLP4 12+20
CNSTU1 255
ASGNU1
line 506
;506:			verts[0].modulate[1] = 255;	
ADDRLP4 12+20+1
CNSTU1 255
ASGNU1
line 507
;507:			verts[0].modulate[2] = 255;	
ADDRLP4 12+20+2
CNSTU1 255
ASGNU1
line 508
;508:			verts[0].modulate[3] = 255 * p->alpha;	
ADDRLP4 268
CNSTF4 1132396544
ADDRFP4 0
INDIRP4
CNSTI4 56
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 272
CNSTF4 1325400064
ASGNF4
ADDRLP4 268
INDIRF4
ADDRLP4 272
INDIRF4
LTF4 $360
ADDRLP4 264
ADDRLP4 268
INDIRF4
ADDRLP4 272
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $361
JUMPV
LABELV $360
ADDRLP4 264
ADDRLP4 268
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $361
ADDRLP4 12+20+3
ADDRLP4 264
INDIRU4
CVUU1 4
ASGNU1
line 510
;509:
;510:			VectorMA (org, -p->height, pvup, point);	
ADDRLP4 276
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 280
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 276
INDIRP4
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 280
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 276
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 280
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRGP4 pvup+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 511
;511:			VectorMA (point, p->width, pvright, point);	
ADDRLP4 284
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 284
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 284
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 512
;512:			VectorCopy (point, verts[1].xyz);	
ADDRLP4 12+24
ADDRLP4 0
INDIRB
ASGNB 12
line 513
;513:			verts[1].st[0] = 0;	
ADDRLP4 12+24+12
CNSTF4 0
ASGNF4
line 514
;514:			verts[1].st[1] = 1;	
ADDRLP4 12+24+12+4
CNSTF4 1065353216
ASGNF4
line 515
;515:			verts[1].modulate[0] = 255;	
ADDRLP4 12+24+20
CNSTU1 255
ASGNU1
line 516
;516:			verts[1].modulate[1] = 255;	
ADDRLP4 12+24+20+1
CNSTU1 255
ASGNU1
line 517
;517:			verts[1].modulate[2] = 255;	
ADDRLP4 12+24+20+2
CNSTU1 255
ASGNU1
line 518
;518:			verts[1].modulate[3] = 255 * p->alpha;	
ADDRLP4 292
CNSTF4 1132396544
ADDRFP4 0
INDIRP4
CNSTI4 56
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 296
CNSTF4 1325400064
ASGNF4
ADDRLP4 292
INDIRF4
ADDRLP4 296
INDIRF4
LTF4 $390
ADDRLP4 288
ADDRLP4 292
INDIRF4
ADDRLP4 296
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $391
JUMPV
LABELV $390
ADDRLP4 288
ADDRLP4 292
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $391
ADDRLP4 12+24+20+3
ADDRLP4 288
INDIRU4
CVUU1 4
ASGNU1
line 520
;519:
;520:			VectorMA (org, p->height, pvup, point);	
ADDRLP4 300
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 304
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 300
INDIRP4
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 304
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 300
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 304
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRGP4 pvup+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 521
;521:			VectorMA (point, p->width, pvright, point);	
ADDRLP4 308
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 308
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 308
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 522
;522:			VectorCopy (point, verts[2].xyz);	
ADDRLP4 12+48
ADDRLP4 0
INDIRB
ASGNB 12
line 523
;523:			verts[2].st[0] = 1;	
ADDRLP4 12+48+12
CNSTF4 1065353216
ASGNF4
line 524
;524:			verts[2].st[1] = 1;	
ADDRLP4 12+48+12+4
CNSTF4 1065353216
ASGNF4
line 525
;525:			verts[2].modulate[0] = 255;	
ADDRLP4 12+48+20
CNSTU1 255
ASGNU1
line 526
;526:			verts[2].modulate[1] = 255;	
ADDRLP4 12+48+20+1
CNSTU1 255
ASGNU1
line 527
;527:			verts[2].modulate[2] = 255;	
ADDRLP4 12+48+20+2
CNSTU1 255
ASGNU1
line 528
;528:			verts[2].modulate[3] = 255 * p->alpha;	
ADDRLP4 316
CNSTF4 1132396544
ADDRFP4 0
INDIRP4
CNSTI4 56
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 320
CNSTF4 1325400064
ASGNF4
ADDRLP4 316
INDIRF4
ADDRLP4 320
INDIRF4
LTF4 $420
ADDRLP4 312
ADDRLP4 316
INDIRF4
ADDRLP4 320
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $421
JUMPV
LABELV $420
ADDRLP4 312
ADDRLP4 316
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $421
ADDRLP4 12+48+20+3
ADDRLP4 312
INDIRU4
CVUU1 4
ASGNU1
line 530
;529:
;530:			VectorMA (org, p->height, pvup, point);	
ADDRLP4 324
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 328
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 324
INDIRP4
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 328
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 324
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 328
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRGP4 pvup+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 531
;531:			VectorMA (point, -p->width, pvright, point);	
ADDRLP4 332
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 332
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 332
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 532
;532:			VectorCopy (point, verts[3].xyz);	
ADDRLP4 12+72
ADDRLP4 0
INDIRB
ASGNB 12
line 533
;533:			verts[3].st[0] = 1;	
ADDRLP4 12+72+12
CNSTF4 1065353216
ASGNF4
line 534
;534:			verts[3].st[1] = 0;	
ADDRLP4 12+72+12+4
CNSTF4 0
ASGNF4
line 535
;535:			verts[3].modulate[0] = 255;	
ADDRLP4 12+72+20
CNSTU1 255
ASGNU1
line 536
;536:			verts[3].modulate[1] = 255;	
ADDRLP4 12+72+20+1
CNSTU1 255
ASGNU1
line 537
;537:			verts[3].modulate[2] = 255;	
ADDRLP4 12+72+20+2
CNSTU1 255
ASGNU1
line 538
;538:			verts[3].modulate[3] = 255 * p->alpha;	
ADDRLP4 340
CNSTF4 1132396544
ADDRFP4 0
INDIRP4
CNSTI4 56
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 344
CNSTF4 1325400064
ASGNF4
ADDRLP4 340
INDIRF4
ADDRLP4 344
INDIRF4
LTF4 $450
ADDRLP4 336
ADDRLP4 340
INDIRF4
ADDRLP4 344
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $451
JUMPV
LABELV $450
ADDRLP4 336
ADDRLP4 340
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $451
ADDRLP4 12+72+20+3
ADDRLP4 336
INDIRU4
CVUU1 4
ASGNU1
line 539
;539:		}
ADDRGP4 $308
JUMPV
LABELV $336
line 541
;540:		else
;541:		{
line 542
;542:			VectorMA (org, -p->height, pvup, point);	
ADDRLP4 252
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 256
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 252
INDIRP4
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 256
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 252
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 256
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRGP4 pvup+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 543
;543:			VectorMA (point, -p->width, pvright, point);	
ADDRLP4 260
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 260
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 260
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 544
;544:			VectorCopy( point, TRIverts[0].xyz );
ADDRLP4 108
ADDRLP4 0
INDIRB
ASGNB 12
line 545
;545:			TRIverts[0].st[0] = 1;
ADDRLP4 108+12
CNSTF4 1065353216
ASGNF4
line 546
;546:			TRIverts[0].st[1] = 0;
ADDRLP4 108+12+4
CNSTF4 0
ASGNF4
line 547
;547:			TRIverts[0].modulate[0] = 255;
ADDRLP4 108+20
CNSTU1 255
ASGNU1
line 548
;548:			TRIverts[0].modulate[1] = 255;
ADDRLP4 108+20+1
CNSTU1 255
ASGNU1
line 549
;549:			TRIverts[0].modulate[2] = 255;
ADDRLP4 108+20+2
CNSTU1 255
ASGNU1
line 550
;550:			TRIverts[0].modulate[3] = 255 * p->alpha;	
ADDRLP4 268
CNSTF4 1132396544
ADDRFP4 0
INDIRP4
CNSTI4 56
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 272
CNSTF4 1325400064
ASGNF4
ADDRLP4 268
INDIRF4
ADDRLP4 272
INDIRF4
LTF4 $473
ADDRLP4 264
ADDRLP4 268
INDIRF4
ADDRLP4 272
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $474
JUMPV
LABELV $473
ADDRLP4 264
ADDRLP4 268
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $474
ADDRLP4 108+20+3
ADDRLP4 264
INDIRU4
CVUU1 4
ASGNU1
line 552
;551:
;552:			VectorMA (org, p->height, pvup, point);	
ADDRLP4 276
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 280
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 276
INDIRP4
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 280
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 276
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 280
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRGP4 pvup+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 553
;553:			VectorMA (point, -p->width, pvright, point);	
ADDRLP4 284
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 284
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 284
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 554
;554:			VectorCopy (point, TRIverts[1].xyz);	
ADDRLP4 108+24
ADDRLP4 0
INDIRB
ASGNB 12
line 555
;555:			TRIverts[1].st[0] = 0;
ADDRLP4 108+24+12
CNSTF4 0
ASGNF4
line 556
;556:			TRIverts[1].st[1] = 0;
ADDRLP4 108+24+12+4
CNSTF4 0
ASGNF4
line 557
;557:			TRIverts[1].modulate[0] = 255;
ADDRLP4 108+24+20
CNSTU1 255
ASGNU1
line 558
;558:			TRIverts[1].modulate[1] = 255;
ADDRLP4 108+24+20+1
CNSTU1 255
ASGNU1
line 559
;559:			TRIverts[1].modulate[2] = 255;
ADDRLP4 108+24+20+2
CNSTU1 255
ASGNU1
line 560
;560:			TRIverts[1].modulate[3] = 255 * p->alpha;	
ADDRLP4 292
CNSTF4 1132396544
ADDRFP4 0
INDIRP4
CNSTI4 56
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 296
CNSTF4 1325400064
ASGNF4
ADDRLP4 292
INDIRF4
ADDRLP4 296
INDIRF4
LTF4 $503
ADDRLP4 288
ADDRLP4 292
INDIRF4
ADDRLP4 296
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $504
JUMPV
LABELV $503
ADDRLP4 288
ADDRLP4 292
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $504
ADDRLP4 108+24+20+3
ADDRLP4 288
INDIRU4
CVUU1 4
ASGNU1
line 562
;561:
;562:			VectorMA (org, p->height, pvup, point);	
ADDRLP4 300
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 304
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 300
INDIRP4
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 304
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 300
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 304
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRGP4 pvup+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 563
;563:			VectorMA (point, p->width, pvright, point);	
ADDRLP4 308
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 308
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 308
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 564
;564:			VectorCopy (point, TRIverts[2].xyz);	
ADDRLP4 108+48
ADDRLP4 0
INDIRB
ASGNB 12
line 565
;565:			TRIverts[2].st[0] = 0;
ADDRLP4 108+48+12
CNSTF4 0
ASGNF4
line 566
;566:			TRIverts[2].st[1] = 1;
ADDRLP4 108+48+12+4
CNSTF4 1065353216
ASGNF4
line 567
;567:			TRIverts[2].modulate[0] = 255;
ADDRLP4 108+48+20
CNSTU1 255
ASGNU1
line 568
;568:			TRIverts[2].modulate[1] = 255;
ADDRLP4 108+48+20+1
CNSTU1 255
ASGNU1
line 569
;569:			TRIverts[2].modulate[2] = 255;
ADDRLP4 108+48+20+2
CNSTU1 255
ASGNU1
line 570
;570:			TRIverts[2].modulate[3] = 255 * p->alpha;	
ADDRLP4 316
CNSTF4 1132396544
ADDRFP4 0
INDIRP4
CNSTI4 56
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 320
CNSTF4 1325400064
ASGNF4
ADDRLP4 316
INDIRF4
ADDRLP4 320
INDIRF4
LTF4 $533
ADDRLP4 312
ADDRLP4 316
INDIRF4
ADDRLP4 320
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $534
JUMPV
LABELV $533
ADDRLP4 312
ADDRLP4 316
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $534
ADDRLP4 108+48+20+3
ADDRLP4 312
INDIRU4
CVUU1 4
ASGNU1
line 571
;571:		}
line 573
;572:	
;573:	}
ADDRGP4 $308
JUMPV
LABELV $307
line 574
;574:	else if (p->type == P_SPRITE)
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
CNSTI4 15
NEI4 $535
line 575
;575:	{
line 579
;576:		vec3_t	rr, ru;
;577:		vec3_t	rotate_ang;
;578:
;579:		VectorSet (color, 1.0, 1.0, 0.5);
ADDRLP4 280
CNSTF4 1065353216
ASGNF4
ADDRLP4 184
ADDRLP4 280
INDIRF4
ASGNF4
ADDRLP4 184+4
ADDRLP4 280
INDIRF4
ASGNF4
ADDRLP4 184+8
CNSTF4 1056964608
ASGNF4
line 580
;580:		time = cg.time - p->time;
ADDRLP4 232
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 581
;581:		time2 = p->endtime - p->time;
ADDRLP4 284
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 236
ADDRLP4 284
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 284
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 582
;582:		ratio = time / time2;
ADDRLP4 200
ADDRLP4 232
INDIRF4
ADDRLP4 236
INDIRF4
DIVF4
ASGNF4
line 584
;583:
;584:		width = p->width + ( ratio * ( p->endwidth - p->width) );
ADDRLP4 288
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 292
ADDRLP4 288
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
ASGNF4
ADDRLP4 196
ADDRLP4 292
INDIRF4
ADDRLP4 200
INDIRF4
ADDRLP4 288
INDIRP4
CNSTI4 84
ADDP4
INDIRF4
ADDRLP4 292
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 585
;585:		height = p->height + ( ratio * ( p->endheight - p->height) );
ADDRLP4 296
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 300
ADDRLP4 296
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
ASGNF4
ADDRLP4 180
ADDRLP4 300
INDIRF4
ADDRLP4 200
INDIRF4
ADDRLP4 296
INDIRP4
CNSTI4 80
ADDP4
INDIRF4
ADDRLP4 300
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 587
;586:
;587:		if (p->roll) {
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CNSTI4 0
EQI4 $540
line 588
;588:			vectoangles( cg.refdef.viewaxis[0], rotate_ang );
ADDRGP4 cg+3616+36
ARGP4
ADDRLP4 268
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 589
;589:			rotate_ang[ROLL] += p->roll;
ADDRLP4 268+8
ADDRLP4 268+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CVIF4 4
ADDF4
ASGNF4
line 590
;590:			AngleVectors ( rotate_ang, NULL, rr, ru);
ADDRLP4 268
ARGP4
CNSTP4 0
ARGP4
ADDRLP4 256
ARGP4
ADDRLP4 244
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 591
;591:		}
LABELV $540
line 593
;592:
;593:		if (p->roll) {
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CNSTI4 0
EQI4 $545
line 594
;594:			VectorMA (org, -height, ru, point);	
ADDRLP4 304
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 308
ADDRLP4 180
INDIRF4
NEGF4
ASGNF4
ADDRLP4 0
ADDRLP4 304
INDIRP4
INDIRF4
ADDRLP4 244
INDIRF4
ADDRLP4 308
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 304
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 244+4
INDIRF4
ADDRLP4 308
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 244+8
INDIRF4
ADDRLP4 180
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 595
;595:			VectorMA (point, -width, rr, point);	
ADDRLP4 312
ADDRLP4 196
INDIRF4
NEGF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 256
INDIRF4
ADDRLP4 312
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 256+4
INDIRF4
ADDRLP4 312
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 256+8
INDIRF4
ADDRLP4 196
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 596
;596:		} else {
ADDRGP4 $546
JUMPV
LABELV $545
line 597
;597:			VectorMA (org, -height, pvup, point);	
ADDRLP4 304
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 308
ADDRLP4 180
INDIRF4
NEGF4
ASGNF4
ADDRLP4 0
ADDRLP4 304
INDIRP4
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 308
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 304
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 308
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRGP4 pvup+8
INDIRF4
ADDRLP4 180
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 598
;598:			VectorMA (point, -width, pvright, point);	
ADDRLP4 312
ADDRLP4 196
INDIRF4
NEGF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 312
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 312
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
ADDRLP4 196
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 599
;599:		}
LABELV $546
line 600
;600:		VectorCopy (point, verts[0].xyz);	
ADDRLP4 12
ADDRLP4 0
INDIRB
ASGNB 12
line 601
;601:		verts[0].st[0] = 0;	
ADDRLP4 12+12
CNSTF4 0
ASGNF4
line 602
;602:		verts[0].st[1] = 0;	
ADDRLP4 12+12+4
CNSTF4 0
ASGNF4
line 603
;603:		verts[0].modulate[0] = 255;	
ADDRLP4 12+20
CNSTU1 255
ASGNU1
line 604
;604:		verts[0].modulate[1] = 255;	
ADDRLP4 12+20+1
CNSTU1 255
ASGNU1
line 605
;605:		verts[0].modulate[2] = 255;	
ADDRLP4 12+20+2
CNSTU1 255
ASGNU1
line 606
;606:		verts[0].modulate[3] = 255;
ADDRLP4 12+20+3
CNSTU1 255
ASGNU1
line 608
;607:
;608:		if (p->roll) {
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CNSTI4 0
EQI4 $577
line 609
;609:			VectorMA (point, 2*height, ru, point);	
ADDRLP4 304
CNSTF4 1073741824
ADDRLP4 180
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 244
INDIRF4
ADDRLP4 304
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 244+4
INDIRF4
ADDRLP4 304
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 244+8
INDIRF4
CNSTF4 1073741824
ADDRLP4 180
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 610
;610:		} else {
ADDRGP4 $578
JUMPV
LABELV $577
line 611
;611:			VectorMA (point, 2*height, pvup, point);	
ADDRLP4 304
CNSTF4 1073741824
ADDRLP4 180
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 304
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 304
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvup+8
INDIRF4
CNSTF4 1073741824
ADDRLP4 180
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 612
;612:		}
LABELV $578
line 613
;613:		VectorCopy (point, verts[1].xyz);	
ADDRLP4 12+24
ADDRLP4 0
INDIRB
ASGNB 12
line 614
;614:		verts[1].st[0] = 0;	
ADDRLP4 12+24+12
CNSTF4 0
ASGNF4
line 615
;615:		verts[1].st[1] = 1;	
ADDRLP4 12+24+12+4
CNSTF4 1065353216
ASGNF4
line 616
;616:		verts[1].modulate[0] = 255;	
ADDRLP4 12+24+20
CNSTU1 255
ASGNU1
line 617
;617:		verts[1].modulate[1] = 255;	
ADDRLP4 12+24+20+1
CNSTU1 255
ASGNU1
line 618
;618:		verts[1].modulate[2] = 255;	
ADDRLP4 12+24+20+2
CNSTU1 255
ASGNU1
line 619
;619:		verts[1].modulate[3] = 255;	
ADDRLP4 12+24+20+3
CNSTU1 255
ASGNU1
line 621
;620:
;621:		if (p->roll) {
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CNSTI4 0
EQI4 $608
line 622
;622:			VectorMA (point, 2*width, rr, point);	
ADDRLP4 304
CNSTF4 1073741824
ADDRLP4 196
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 256
INDIRF4
ADDRLP4 304
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 256+4
INDIRF4
ADDRLP4 304
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 256+8
INDIRF4
CNSTF4 1073741824
ADDRLP4 196
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 623
;623:		} else {
ADDRGP4 $609
JUMPV
LABELV $608
line 624
;624:			VectorMA (point, 2*width, pvright, point);	
ADDRLP4 304
CNSTF4 1073741824
ADDRLP4 196
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 304
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 304
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
CNSTF4 1073741824
ADDRLP4 196
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 625
;625:		}
LABELV $609
line 626
;626:		VectorCopy (point, verts[2].xyz);	
ADDRLP4 12+48
ADDRLP4 0
INDIRB
ASGNB 12
line 627
;627:		verts[2].st[0] = 1;	
ADDRLP4 12+48+12
CNSTF4 1065353216
ASGNF4
line 628
;628:		verts[2].st[1] = 1;	
ADDRLP4 12+48+12+4
CNSTF4 1065353216
ASGNF4
line 629
;629:		verts[2].modulate[0] = 255;	
ADDRLP4 12+48+20
CNSTU1 255
ASGNU1
line 630
;630:		verts[2].modulate[1] = 255;	
ADDRLP4 12+48+20+1
CNSTU1 255
ASGNU1
line 631
;631:		verts[2].modulate[2] = 255;	
ADDRLP4 12+48+20+2
CNSTU1 255
ASGNU1
line 632
;632:		verts[2].modulate[3] = 255;	
ADDRLP4 12+48+20+3
CNSTU1 255
ASGNU1
line 634
;633:
;634:		if (p->roll) {
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CNSTI4 0
EQI4 $639
line 635
;635:			VectorMA (point, -2*height, ru, point);	
ADDRLP4 304
CNSTF4 3221225472
ADDRLP4 180
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 244
INDIRF4
ADDRLP4 304
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 244+4
INDIRF4
ADDRLP4 304
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 244+8
INDIRF4
CNSTF4 3221225472
ADDRLP4 180
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 636
;636:		} else {
ADDRGP4 $640
JUMPV
LABELV $639
line 637
;637:			VectorMA (point, -2*height, pvup, point);	
ADDRLP4 304
CNSTF4 3221225472
ADDRLP4 180
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 304
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 304
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvup+8
INDIRF4
CNSTF4 3221225472
ADDRLP4 180
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 638
;638:		}
LABELV $640
line 639
;639:		VectorCopy (point, verts[3].xyz);	
ADDRLP4 12+72
ADDRLP4 0
INDIRB
ASGNB 12
line 640
;640:		verts[3].st[0] = 1;	
ADDRLP4 12+72+12
CNSTF4 1065353216
ASGNF4
line 641
;641:		verts[3].st[1] = 0;	
ADDRLP4 12+72+12+4
CNSTF4 0
ASGNF4
line 642
;642:		verts[3].modulate[0] = 255;	
ADDRLP4 12+72+20
CNSTU1 255
ASGNU1
line 643
;643:		verts[3].modulate[1] = 255;	
ADDRLP4 12+72+20+1
CNSTU1 255
ASGNU1
line 644
;644:		verts[3].modulate[2] = 255;	
ADDRLP4 12+72+20+2
CNSTU1 255
ASGNU1
line 645
;645:		verts[3].modulate[3] = 255;	
ADDRLP4 12+72+20+3
CNSTU1 255
ASGNU1
line 646
;646:	}
ADDRGP4 $536
JUMPV
LABELV $535
line 647
;647:	else if (p->type == P_SMOKE || p->type == P_SMOKE_IMPACT)
ADDRLP4 244
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
ASGNI4
ADDRLP4 244
INDIRI4
CNSTI4 3
EQI4 $672
ADDRLP4 244
INDIRI4
CNSTI4 12
NEI4 $670
LABELV $672
line 648
;648:	{// create a front rotating facing polygon
line 650
;649:
;650:		if ( p->type == P_SMOKE_IMPACT && Distance( cg.snap->ps.origin, org ) > 1024) {
ADDRLP4 248
CNSTI4 64
ASGNI4
ADDRFP4 0
INDIRP4
ADDRLP4 248
INDIRI4
ADDP4
INDIRI4
CNSTI4 12
NEI4 $673
ADDRGP4 cg+36
INDIRP4
ADDRLP4 248
INDIRI4
ADDP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 252
ADDRGP4 Distance
CALLF4
ASGNF4
ADDRLP4 252
INDIRF4
CNSTF4 1149239296
LEF4 $673
line 651
;651:			return;
ADDRGP4 $306
JUMPV
LABELV $673
line 654
;652:		}
;653:
;654:		if (p->color == BLOODRED)
ADDRFP4 0
INDIRP4
CNSTI4 48
ADDP4
INDIRI4
CNSTI4 2
NEI4 $676
line 655
;655:			VectorSet (color, 0.22f, 0.0f, 0.0f);
ADDRLP4 184
CNSTF4 1046562734
ASGNF4
ADDRLP4 184+4
CNSTF4 0
ASGNF4
ADDRLP4 184+8
CNSTF4 0
ASGNF4
ADDRGP4 $677
JUMPV
LABELV $676
line 656
;656:		else if (p->color == GREY75)
ADDRFP4 0
INDIRP4
CNSTI4 48
ADDP4
INDIRI4
CNSTI4 4
NEI4 $680
line 657
;657:		{
line 661
;658:			float	len;
;659:			float	greyit;
;660:			float	val;
;661:			len = Distance (cg.snap->ps.origin, org);
ADDRGP4 cg+36
INDIRP4
CNSTI4 64
ADDP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 268
ADDRGP4 Distance
CALLF4
ASGNF4
ADDRLP4 260
ADDRLP4 268
INDIRF4
ASGNF4
line 662
;662:			if (!len)
ADDRLP4 260
INDIRF4
CNSTF4 0
NEF4 $683
line 663
;663:				len = 1;
ADDRLP4 260
CNSTF4 1065353216
ASGNF4
LABELV $683
line 665
;664:
;665:			val = 4096/len;
ADDRLP4 264
CNSTF4 1166016512
ADDRLP4 260
INDIRF4
DIVF4
ASGNF4
line 666
;666:			greyit = 0.25 * val;
ADDRLP4 256
CNSTF4 1048576000
ADDRLP4 264
INDIRF4
MULF4
ASGNF4
line 667
;667:			if (greyit > 0.5)
ADDRLP4 256
INDIRF4
CNSTF4 1056964608
LEF4 $685
line 668
;668:				greyit = 0.5;
ADDRLP4 256
CNSTF4 1056964608
ASGNF4
LABELV $685
line 670
;669:
;670:			VectorSet (color, greyit, greyit, greyit);
ADDRLP4 272
ADDRLP4 256
INDIRF4
ASGNF4
ADDRLP4 184
ADDRLP4 272
INDIRF4
ASGNF4
ADDRLP4 184+4
ADDRLP4 272
INDIRF4
ASGNF4
ADDRLP4 184+8
ADDRLP4 256
INDIRF4
ASGNF4
line 671
;671:		}
ADDRGP4 $681
JUMPV
LABELV $680
line 673
;672:		else
;673:			VectorSet (color, 1.0, 1.0, 1.0);
ADDRLP4 256
CNSTF4 1065353216
ASGNF4
ADDRLP4 184
ADDRLP4 256
INDIRF4
ASGNF4
ADDRLP4 184+4
ADDRLP4 256
INDIRF4
ASGNF4
ADDRLP4 184+8
CNSTF4 1065353216
ASGNF4
LABELV $681
LABELV $677
line 675
;674:
;675:		time = cg.time - p->time;
ADDRLP4 232
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 676
;676:		time2 = p->endtime - p->time;
ADDRLP4 260
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 236
ADDRLP4 260
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 260
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 677
;677:		ratio = time / time2;
ADDRLP4 200
ADDRLP4 232
INDIRF4
ADDRLP4 236
INDIRF4
DIVF4
ASGNF4
line 679
;678:		
;679:		if (cg.time > p->startfade)
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ADDRFP4 0
INDIRP4
CNSTI4 96
ADDP4
INDIRF4
LEF4 $692
line 680
;680:		{
line 681
;681:			invratio = 1 - ( (cg.time - p->startfade) / (p->endtime - p->startfade) );
ADDRLP4 264
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 268
ADDRLP4 264
INDIRP4
CNSTI4 96
ADDP4
INDIRF4
ASGNF4
ADDRLP4 204
CNSTF4 1065353216
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ADDRLP4 268
INDIRF4
SUBF4
ADDRLP4 264
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 268
INDIRF4
SUBF4
DIVF4
SUBF4
ASGNF4
line 683
;682:
;683:			if (p->color == EMISIVEFADE)
ADDRFP4 0
INDIRP4
CNSTI4 48
ADDP4
INDIRI4
CNSTI4 3
NEI4 $696
line 684
;684:			{
line 686
;685:				float fval;
;686:				fval = (invratio * invratio);
ADDRLP4 276
ADDRLP4 204
INDIRF4
ASGNF4
ADDRLP4 272
ADDRLP4 276
INDIRF4
ADDRLP4 276
INDIRF4
MULF4
ASGNF4
line 687
;687:				if (fval < 0)
ADDRLP4 272
INDIRF4
CNSTF4 0
GEF4 $698
line 688
;688:					fval = 0;
ADDRLP4 272
CNSTF4 0
ASGNF4
LABELV $698
line 689
;689:				VectorSet (color, fval , fval , fval );
ADDRLP4 280
ADDRLP4 272
INDIRF4
ASGNF4
ADDRLP4 184
ADDRLP4 280
INDIRF4
ASGNF4
ADDRLP4 184+4
ADDRLP4 280
INDIRF4
ASGNF4
ADDRLP4 184+8
ADDRLP4 272
INDIRF4
ASGNF4
line 690
;690:			}
LABELV $696
line 691
;691:			invratio *= p->alpha;
ADDRLP4 204
ADDRLP4 204
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 56
ADDP4
INDIRF4
MULF4
ASGNF4
line 692
;692:		}
ADDRGP4 $693
JUMPV
LABELV $692
line 694
;693:		else 
;694:			invratio = 1 * p->alpha;
ADDRLP4 204
CNSTF4 1065353216
ADDRFP4 0
INDIRP4
CNSTI4 56
ADDP4
INDIRF4
MULF4
ASGNF4
LABELV $693
line 696
;695:
;696:		if (invratio > 1)
ADDRLP4 204
INDIRF4
CNSTF4 1065353216
LEF4 $702
line 697
;697:			invratio = 1;
ADDRLP4 204
CNSTF4 1065353216
ASGNF4
LABELV $702
line 699
;698:	
;699:		width = p->width + ( ratio * ( p->endwidth - p->width) );
ADDRLP4 264
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 268
ADDRLP4 264
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
ASGNF4
ADDRLP4 196
ADDRLP4 268
INDIRF4
ADDRLP4 200
INDIRF4
ADDRLP4 264
INDIRP4
CNSTI4 84
ADDP4
INDIRF4
ADDRLP4 268
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 700
;700:		height = p->height + ( ratio * ( p->endheight - p->height) );
ADDRLP4 272
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 276
ADDRLP4 272
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
ASGNF4
ADDRLP4 180
ADDRLP4 276
INDIRF4
ADDRLP4 200
INDIRF4
ADDRLP4 272
INDIRP4
CNSTI4 80
ADDP4
INDIRF4
ADDRLP4 276
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 702
;701:
;702:		if (p->type != P_SMOKE_IMPACT)
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
CNSTI4 12
EQI4 $704
line 703
;703:		{
line 706
;704:			vec3_t temp;
;705:
;706:			vectoangles (rforward, temp);
ADDRGP4 rforward
ARGP4
ADDRLP4 280
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 707
;707:			p->accumroll += p->roll;
ADDRLP4 292
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 296
ADDRLP4 292
INDIRP4
CNSTI4 120
ADDP4
ASGNP4
ADDRLP4 296
INDIRP4
ADDRLP4 296
INDIRP4
INDIRI4
ADDRLP4 292
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
ADDI4
ASGNI4
line 708
;708:			temp[ROLL] += p->accumroll * 0.1;
ADDRLP4 280+8
ADDRLP4 280+8
INDIRF4
CNSTF4 1036831949
ADDRFP4 0
INDIRP4
CNSTI4 120
ADDP4
INDIRI4
CVIF4 4
MULF4
ADDF4
ASGNF4
line 709
;709:			AngleVectors ( temp, NULL, rright2, rup2);
ADDRLP4 280
ARGP4
CNSTP4 0
ARGP4
ADDRLP4 208
ARGP4
ADDRLP4 220
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 710
;710:		}
ADDRGP4 $705
JUMPV
LABELV $704
line 712
;711:		else
;712:		{
line 713
;713:			VectorCopy (rright, rright2);
ADDRLP4 208
ADDRGP4 rright
INDIRB
ASGNB 12
line 714
;714:			VectorCopy (rup, rup2);
ADDRLP4 220
ADDRGP4 rup
INDIRB
ASGNB 12
line 715
;715:		}
LABELV $705
line 717
;716:		
;717:		if (p->rotate)
ADDRFP4 0
INDIRP4
CNSTI4 100
ADDP4
INDIRI4
CNSTI4 0
EQI4 $707
line 718
;718:		{
line 719
;719:			VectorMA (org, -height, rup2, point);	
ADDRLP4 280
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 284
ADDRLP4 180
INDIRF4
NEGF4
ASGNF4
ADDRLP4 0
ADDRLP4 280
INDIRP4
INDIRF4
ADDRLP4 220
INDIRF4
ADDRLP4 284
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 280
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 220+4
INDIRF4
ADDRLP4 284
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 220+8
INDIRF4
ADDRLP4 180
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 720
;720:			VectorMA (point, -width, rright2, point);	
ADDRLP4 288
ADDRLP4 196
INDIRF4
NEGF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 208
INDIRF4
ADDRLP4 288
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 208+4
INDIRF4
ADDRLP4 288
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 208+8
INDIRF4
ADDRLP4 196
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 721
;721:		}
ADDRGP4 $708
JUMPV
LABELV $707
line 723
;722:		else
;723:		{
line 724
;724:			VectorMA (org, -p->height, pvup, point);	
ADDRLP4 280
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 284
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 280
INDIRP4
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 284
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 280
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 284
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRGP4 pvup+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 725
;725:			VectorMA (point, -p->width, pvright, point);	
ADDRLP4 288
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 288
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 288
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 726
;726:		}
LABELV $708
line 727
;727:		VectorCopy (point, verts[0].xyz);	
ADDRLP4 12
ADDRLP4 0
INDIRB
ASGNB 12
line 728
;728:		verts[0].st[0] = 0;	
ADDRLP4 12+12
CNSTF4 0
ASGNF4
line 729
;729:		verts[0].st[1] = 0;	
ADDRLP4 12+12+4
CNSTF4 0
ASGNF4
line 730
;730:		verts[0].modulate[0] = 255 * color[0];	
ADDRLP4 284
CNSTF4 1132396544
ADDRLP4 184
INDIRF4
MULF4
ASGNF4
ADDRLP4 288
CNSTF4 1325400064
ASGNF4
ADDRLP4 284
INDIRF4
ADDRLP4 288
INDIRF4
LTF4 $734
ADDRLP4 280
ADDRLP4 284
INDIRF4
ADDRLP4 288
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $735
JUMPV
LABELV $734
ADDRLP4 280
ADDRLP4 284
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $735
ADDRLP4 12+20
ADDRLP4 280
INDIRU4
CVUU1 4
ASGNU1
line 731
;731:		verts[0].modulate[1] = 255 * color[1];	
ADDRLP4 296
CNSTF4 1132396544
ADDRLP4 184+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 300
CNSTF4 1325400064
ASGNF4
ADDRLP4 296
INDIRF4
ADDRLP4 300
INDIRF4
LTF4 $740
ADDRLP4 292
ADDRLP4 296
INDIRF4
ADDRLP4 300
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $741
JUMPV
LABELV $740
ADDRLP4 292
ADDRLP4 296
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $741
ADDRLP4 12+20+1
ADDRLP4 292
INDIRU4
CVUU1 4
ASGNU1
line 732
;732:		verts[0].modulate[2] = 255 * color[2];	
ADDRLP4 308
CNSTF4 1132396544
ADDRLP4 184+8
INDIRF4
MULF4
ASGNF4
ADDRLP4 312
CNSTF4 1325400064
ASGNF4
ADDRLP4 308
INDIRF4
ADDRLP4 312
INDIRF4
LTF4 $746
ADDRLP4 304
ADDRLP4 308
INDIRF4
ADDRLP4 312
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $747
JUMPV
LABELV $746
ADDRLP4 304
ADDRLP4 308
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $747
ADDRLP4 12+20+2
ADDRLP4 304
INDIRU4
CVUU1 4
ASGNU1
line 733
;733:		verts[0].modulate[3] = 255 * invratio;	
ADDRLP4 320
CNSTF4 1132396544
ADDRLP4 204
INDIRF4
MULF4
ASGNF4
ADDRLP4 324
CNSTF4 1325400064
ASGNF4
ADDRLP4 320
INDIRF4
ADDRLP4 324
INDIRF4
LTF4 $751
ADDRLP4 316
ADDRLP4 320
INDIRF4
ADDRLP4 324
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $752
JUMPV
LABELV $751
ADDRLP4 316
ADDRLP4 320
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $752
ADDRLP4 12+20+3
ADDRLP4 316
INDIRU4
CVUU1 4
ASGNU1
line 735
;734:
;735:		if (p->rotate)
ADDRFP4 0
INDIRP4
CNSTI4 100
ADDP4
INDIRI4
CNSTI4 0
EQI4 $753
line 736
;736:		{
line 737
;737:			VectorMA (org, -height, rup2, point);	
ADDRLP4 328
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 332
ADDRLP4 180
INDIRF4
NEGF4
ASGNF4
ADDRLP4 0
ADDRLP4 328
INDIRP4
INDIRF4
ADDRLP4 220
INDIRF4
ADDRLP4 332
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 328
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 220+4
INDIRF4
ADDRLP4 332
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 220+8
INDIRF4
ADDRLP4 180
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 738
;738:			VectorMA (point, width, rright2, point);	
ADDRLP4 336
ADDRLP4 196
INDIRF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 208
INDIRF4
ADDRLP4 336
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 208+4
INDIRF4
ADDRLP4 336
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 208+8
INDIRF4
ADDRLP4 196
INDIRF4
MULF4
ADDF4
ASGNF4
line 739
;739:		}
ADDRGP4 $754
JUMPV
LABELV $753
line 741
;740:		else
;741:		{
line 742
;742:			VectorMA (org, -p->height, pvup, point);	
ADDRLP4 328
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 332
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 328
INDIRP4
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 332
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 328
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 332
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRGP4 pvup+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 743
;743:			VectorMA (point, p->width, pvright, point);	
ADDRLP4 336
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 336
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 336
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 744
;744:		}
LABELV $754
line 745
;745:		VectorCopy (point, verts[1].xyz);	
ADDRLP4 12+24
ADDRLP4 0
INDIRB
ASGNB 12
line 746
;746:		verts[1].st[0] = 0;	
ADDRLP4 12+24+12
CNSTF4 0
ASGNF4
line 747
;747:		verts[1].st[1] = 1;	
ADDRLP4 12+24+12+4
CNSTF4 1065353216
ASGNF4
line 748
;748:		verts[1].modulate[0] = 255 * color[0];	
ADDRLP4 332
CNSTF4 1132396544
ADDRLP4 184
INDIRF4
MULF4
ASGNF4
ADDRLP4 336
CNSTF4 1325400064
ASGNF4
ADDRLP4 332
INDIRF4
ADDRLP4 336
INDIRF4
LTF4 $784
ADDRLP4 328
ADDRLP4 332
INDIRF4
ADDRLP4 336
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $785
JUMPV
LABELV $784
ADDRLP4 328
ADDRLP4 332
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $785
ADDRLP4 12+24+20
ADDRLP4 328
INDIRU4
CVUU1 4
ASGNU1
line 749
;749:		verts[1].modulate[1] = 255 * color[1];	
ADDRLP4 344
CNSTF4 1132396544
ADDRLP4 184+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 348
CNSTF4 1325400064
ASGNF4
ADDRLP4 344
INDIRF4
ADDRLP4 348
INDIRF4
LTF4 $791
ADDRLP4 340
ADDRLP4 344
INDIRF4
ADDRLP4 348
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $792
JUMPV
LABELV $791
ADDRLP4 340
ADDRLP4 344
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $792
ADDRLP4 12+24+20+1
ADDRLP4 340
INDIRU4
CVUU1 4
ASGNU1
line 750
;750:		verts[1].modulate[2] = 255 * color[2];	
ADDRLP4 356
CNSTF4 1132396544
ADDRLP4 184+8
INDIRF4
MULF4
ASGNF4
ADDRLP4 360
CNSTF4 1325400064
ASGNF4
ADDRLP4 356
INDIRF4
ADDRLP4 360
INDIRF4
LTF4 $798
ADDRLP4 352
ADDRLP4 356
INDIRF4
ADDRLP4 360
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $799
JUMPV
LABELV $798
ADDRLP4 352
ADDRLP4 356
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $799
ADDRLP4 12+24+20+2
ADDRLP4 352
INDIRU4
CVUU1 4
ASGNU1
line 751
;751:		verts[1].modulate[3] = 255 * invratio;	
ADDRLP4 368
CNSTF4 1132396544
ADDRLP4 204
INDIRF4
MULF4
ASGNF4
ADDRLP4 372
CNSTF4 1325400064
ASGNF4
ADDRLP4 368
INDIRF4
ADDRLP4 372
INDIRF4
LTF4 $804
ADDRLP4 364
ADDRLP4 368
INDIRF4
ADDRLP4 372
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $805
JUMPV
LABELV $804
ADDRLP4 364
ADDRLP4 368
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $805
ADDRLP4 12+24+20+3
ADDRLP4 364
INDIRU4
CVUU1 4
ASGNU1
line 753
;752:
;753:		if (p->rotate)
ADDRFP4 0
INDIRP4
CNSTI4 100
ADDP4
INDIRI4
CNSTI4 0
EQI4 $806
line 754
;754:		{
line 755
;755:			VectorMA (org, height, rup2, point);	
ADDRLP4 376
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 376
INDIRP4
INDIRF4
ADDRLP4 220
INDIRF4
ADDRLP4 180
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 376
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 220+4
INDIRF4
ADDRLP4 180
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 220+8
INDIRF4
ADDRLP4 180
INDIRF4
MULF4
ADDF4
ASGNF4
line 756
;756:			VectorMA (point, width, rright2, point);	
ADDRLP4 384
ADDRLP4 196
INDIRF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 208
INDIRF4
ADDRLP4 384
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 208+4
INDIRF4
ADDRLP4 384
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 208+8
INDIRF4
ADDRLP4 196
INDIRF4
MULF4
ADDF4
ASGNF4
line 757
;757:		}
ADDRGP4 $807
JUMPV
LABELV $806
line 759
;758:		else
;759:		{
line 760
;760:			VectorMA (org, p->height, pvup, point);	
ADDRLP4 376
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 380
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 376
INDIRP4
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 380
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 376
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 380
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRGP4 pvup+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 761
;761:			VectorMA (point, p->width, pvright, point);	
ADDRLP4 384
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 384
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 384
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 762
;762:		}
LABELV $807
line 763
;763:		VectorCopy (point, verts[2].xyz);	
ADDRLP4 12+48
ADDRLP4 0
INDIRB
ASGNB 12
line 764
;764:		verts[2].st[0] = 1;	
ADDRLP4 12+48+12
CNSTF4 1065353216
ASGNF4
line 765
;765:		verts[2].st[1] = 1;	
ADDRLP4 12+48+12+4
CNSTF4 1065353216
ASGNF4
line 766
;766:		verts[2].modulate[0] = 255 * color[0];	
ADDRLP4 380
CNSTF4 1132396544
ADDRLP4 184
INDIRF4
MULF4
ASGNF4
ADDRLP4 384
CNSTF4 1325400064
ASGNF4
ADDRLP4 380
INDIRF4
ADDRLP4 384
INDIRF4
LTF4 $837
ADDRLP4 376
ADDRLP4 380
INDIRF4
ADDRLP4 384
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $838
JUMPV
LABELV $837
ADDRLP4 376
ADDRLP4 380
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $838
ADDRLP4 12+48+20
ADDRLP4 376
INDIRU4
CVUU1 4
ASGNU1
line 767
;767:		verts[2].modulate[1] = 255 * color[1];	
ADDRLP4 392
CNSTF4 1132396544
ADDRLP4 184+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 396
CNSTF4 1325400064
ASGNF4
ADDRLP4 392
INDIRF4
ADDRLP4 396
INDIRF4
LTF4 $844
ADDRLP4 388
ADDRLP4 392
INDIRF4
ADDRLP4 396
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $845
JUMPV
LABELV $844
ADDRLP4 388
ADDRLP4 392
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $845
ADDRLP4 12+48+20+1
ADDRLP4 388
INDIRU4
CVUU1 4
ASGNU1
line 768
;768:		verts[2].modulate[2] = 255 * color[2];	
ADDRLP4 404
CNSTF4 1132396544
ADDRLP4 184+8
INDIRF4
MULF4
ASGNF4
ADDRLP4 408
CNSTF4 1325400064
ASGNF4
ADDRLP4 404
INDIRF4
ADDRLP4 408
INDIRF4
LTF4 $851
ADDRLP4 400
ADDRLP4 404
INDIRF4
ADDRLP4 408
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $852
JUMPV
LABELV $851
ADDRLP4 400
ADDRLP4 404
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $852
ADDRLP4 12+48+20+2
ADDRLP4 400
INDIRU4
CVUU1 4
ASGNU1
line 769
;769:		verts[2].modulate[3] = 255 * invratio;	
ADDRLP4 416
CNSTF4 1132396544
ADDRLP4 204
INDIRF4
MULF4
ASGNF4
ADDRLP4 420
CNSTF4 1325400064
ASGNF4
ADDRLP4 416
INDIRF4
ADDRLP4 420
INDIRF4
LTF4 $857
ADDRLP4 412
ADDRLP4 416
INDIRF4
ADDRLP4 420
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $858
JUMPV
LABELV $857
ADDRLP4 412
ADDRLP4 416
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $858
ADDRLP4 12+48+20+3
ADDRLP4 412
INDIRU4
CVUU1 4
ASGNU1
line 771
;770:
;771:		if (p->rotate)
ADDRFP4 0
INDIRP4
CNSTI4 100
ADDP4
INDIRI4
CNSTI4 0
EQI4 $859
line 772
;772:		{
line 773
;773:			VectorMA (org, height, rup2, point);	
ADDRLP4 424
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 424
INDIRP4
INDIRF4
ADDRLP4 220
INDIRF4
ADDRLP4 180
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 424
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 220+4
INDIRF4
ADDRLP4 180
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 220+8
INDIRF4
ADDRLP4 180
INDIRF4
MULF4
ADDF4
ASGNF4
line 774
;774:			VectorMA (point, -width, rright2, point);	
ADDRLP4 432
ADDRLP4 196
INDIRF4
NEGF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 208
INDIRF4
ADDRLP4 432
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 208+4
INDIRF4
ADDRLP4 432
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 208+8
INDIRF4
ADDRLP4 196
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 775
;775:		}
ADDRGP4 $860
JUMPV
LABELV $859
line 777
;776:		else
;777:		{
line 778
;778:			VectorMA (org, p->height, pvup, point);	
ADDRLP4 424
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 428
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 424
INDIRP4
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 428
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 424
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 428
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRGP4 pvup+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 779
;779:			VectorMA (point, -p->width, pvright, point);	
ADDRLP4 432
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 432
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 432
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 780
;780:		}
LABELV $860
line 781
;781:		VectorCopy (point, verts[3].xyz);	
ADDRLP4 12+72
ADDRLP4 0
INDIRB
ASGNB 12
line 782
;782:		verts[3].st[0] = 1;	
ADDRLP4 12+72+12
CNSTF4 1065353216
ASGNF4
line 783
;783:		verts[3].st[1] = 0;	
ADDRLP4 12+72+12+4
CNSTF4 0
ASGNF4
line 784
;784:		verts[3].modulate[0] = 255 * color[0];	
ADDRLP4 428
CNSTF4 1132396544
ADDRLP4 184
INDIRF4
MULF4
ASGNF4
ADDRLP4 432
CNSTF4 1325400064
ASGNF4
ADDRLP4 428
INDIRF4
ADDRLP4 432
INDIRF4
LTF4 $890
ADDRLP4 424
ADDRLP4 428
INDIRF4
ADDRLP4 432
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $891
JUMPV
LABELV $890
ADDRLP4 424
ADDRLP4 428
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $891
ADDRLP4 12+72+20
ADDRLP4 424
INDIRU4
CVUU1 4
ASGNU1
line 785
;785:		verts[3].modulate[1] = 255 * color[1];	
ADDRLP4 440
CNSTF4 1132396544
ADDRLP4 184+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 444
CNSTF4 1325400064
ASGNF4
ADDRLP4 440
INDIRF4
ADDRLP4 444
INDIRF4
LTF4 $897
ADDRLP4 436
ADDRLP4 440
INDIRF4
ADDRLP4 444
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $898
JUMPV
LABELV $897
ADDRLP4 436
ADDRLP4 440
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $898
ADDRLP4 12+72+20+1
ADDRLP4 436
INDIRU4
CVUU1 4
ASGNU1
line 786
;786:		verts[3].modulate[2] = 255 * color[2];	
ADDRLP4 452
CNSTF4 1132396544
ADDRLP4 184+8
INDIRF4
MULF4
ASGNF4
ADDRLP4 456
CNSTF4 1325400064
ASGNF4
ADDRLP4 452
INDIRF4
ADDRLP4 456
INDIRF4
LTF4 $904
ADDRLP4 448
ADDRLP4 452
INDIRF4
ADDRLP4 456
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $905
JUMPV
LABELV $904
ADDRLP4 448
ADDRLP4 452
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $905
ADDRLP4 12+72+20+2
ADDRLP4 448
INDIRU4
CVUU1 4
ASGNU1
line 787
;787:		verts[3].modulate[3] = 255  * invratio;	
ADDRLP4 464
CNSTF4 1132396544
ADDRLP4 204
INDIRF4
MULF4
ASGNF4
ADDRLP4 468
CNSTF4 1325400064
ASGNF4
ADDRLP4 464
INDIRF4
ADDRLP4 468
INDIRF4
LTF4 $910
ADDRLP4 460
ADDRLP4 464
INDIRF4
ADDRLP4 468
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $911
JUMPV
LABELV $910
ADDRLP4 460
ADDRLP4 464
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $911
ADDRLP4 12+72+20+3
ADDRLP4 460
INDIRU4
CVUU1 4
ASGNU1
line 789
;788:		
;789:	}
ADDRGP4 $671
JUMPV
LABELV $670
line 790
;790:	else if (p->type == P_BLEED)
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
CNSTI4 8
NEI4 $912
line 791
;791:	{
line 796
;792:		vec3_t	rr, ru;
;793:		vec3_t	rotate_ang;
;794:		float	alpha;
;795:
;796:		alpha = p->alpha;
ADDRLP4 272
ADDRFP4 0
INDIRP4
CNSTI4 56
ADDP4
INDIRF4
ASGNF4
line 798
;797:		
;798:		if (p->roll) 
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CNSTI4 0
EQI4 $914
line 799
;799:		{
line 800
;800:			vectoangles( cg.refdef.viewaxis[0], rotate_ang );
ADDRGP4 cg+3616+36
ARGP4
ADDRLP4 276
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 801
;801:			rotate_ang[ROLL] += p->roll;
ADDRLP4 276+8
ADDRLP4 276+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CVIF4 4
ADDF4
ASGNF4
line 802
;802:			AngleVectors ( rotate_ang, NULL, rr, ru);
ADDRLP4 276
ARGP4
CNSTP4 0
ARGP4
ADDRLP4 248
ARGP4
ADDRLP4 260
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 803
;803:		}
ADDRGP4 $915
JUMPV
LABELV $914
line 805
;804:		else
;805:		{
line 806
;806:			VectorCopy (pvup, ru);
ADDRLP4 260
ADDRGP4 pvup
INDIRB
ASGNB 12
line 807
;807:			VectorCopy (pvright, rr);
ADDRLP4 248
ADDRGP4 pvright
INDIRB
ASGNB 12
line 808
;808:		}
LABELV $915
line 810
;809:
;810:		VectorMA (org, -p->height, ru, point);	
ADDRLP4 288
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 292
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 288
INDIRP4
INDIRF4
ADDRLP4 260
INDIRF4
ADDRLP4 292
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 288
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 260+4
INDIRF4
ADDRLP4 292
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 260+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 811
;811:		VectorMA (point, -p->width, rr, point);	
ADDRLP4 296
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 248
INDIRF4
ADDRLP4 296
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 248+4
INDIRF4
ADDRLP4 296
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 248+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 812
;812:		VectorCopy (point, verts[0].xyz);	
ADDRLP4 12
ADDRLP4 0
INDIRB
ASGNB 12
line 813
;813:		verts[0].st[0] = 0;	
ADDRLP4 12+12
CNSTF4 0
ASGNF4
line 814
;814:		verts[0].st[1] = 0;	
ADDRLP4 12+12+4
CNSTF4 0
ASGNF4
line 815
;815:		verts[0].modulate[0] = 111;	
ADDRLP4 12+20
CNSTU1 111
ASGNU1
line 816
;816:		verts[0].modulate[1] = 19;	
ADDRLP4 12+20+1
CNSTU1 19
ASGNU1
line 817
;817:		verts[0].modulate[2] = 9;	
ADDRLP4 12+20+2
CNSTU1 9
ASGNU1
line 818
;818:		verts[0].modulate[3] = 255 * alpha;	
ADDRLP4 304
CNSTF4 1132396544
ADDRLP4 272
INDIRF4
MULF4
ASGNF4
ADDRLP4 308
CNSTF4 1325400064
ASGNF4
ADDRLP4 304
INDIRF4
ADDRLP4 308
INDIRF4
LTF4 $940
ADDRLP4 300
ADDRLP4 304
INDIRF4
ADDRLP4 308
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $941
JUMPV
LABELV $940
ADDRLP4 300
ADDRLP4 304
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $941
ADDRLP4 12+20+3
ADDRLP4 300
INDIRU4
CVUU1 4
ASGNU1
line 820
;819:
;820:		VectorMA (org, -p->height, ru, point);	
ADDRLP4 312
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 316
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 312
INDIRP4
INDIRF4
ADDRLP4 260
INDIRF4
ADDRLP4 316
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 312
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 260+4
INDIRF4
ADDRLP4 316
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 260+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 821
;821:		VectorMA (point, p->width, rr, point);	
ADDRLP4 320
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 248
INDIRF4
ADDRLP4 320
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 248+4
INDIRF4
ADDRLP4 320
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 248+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 822
;822:		VectorCopy (point, verts[1].xyz);	
ADDRLP4 12+24
ADDRLP4 0
INDIRB
ASGNB 12
line 823
;823:		verts[1].st[0] = 0;	
ADDRLP4 12+24+12
CNSTF4 0
ASGNF4
line 824
;824:		verts[1].st[1] = 1;	
ADDRLP4 12+24+12+4
CNSTF4 1065353216
ASGNF4
line 825
;825:		verts[1].modulate[0] = 111;	
ADDRLP4 12+24+20
CNSTU1 111
ASGNU1
line 826
;826:		verts[1].modulate[1] = 19;	
ADDRLP4 12+24+20+1
CNSTU1 19
ASGNU1
line 827
;827:		verts[1].modulate[2] = 9;	
ADDRLP4 12+24+20+2
CNSTU1 9
ASGNU1
line 828
;828:		verts[1].modulate[3] = 255 * alpha;	
ADDRLP4 328
CNSTF4 1132396544
ADDRLP4 272
INDIRF4
MULF4
ASGNF4
ADDRLP4 332
CNSTF4 1325400064
ASGNF4
ADDRLP4 328
INDIRF4
ADDRLP4 332
INDIRF4
LTF4 $970
ADDRLP4 324
ADDRLP4 328
INDIRF4
ADDRLP4 332
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $971
JUMPV
LABELV $970
ADDRLP4 324
ADDRLP4 328
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $971
ADDRLP4 12+24+20+3
ADDRLP4 324
INDIRU4
CVUU1 4
ASGNU1
line 830
;829:
;830:		VectorMA (org, p->height, ru, point);	
ADDRLP4 336
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 340
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 336
INDIRP4
INDIRF4
ADDRLP4 260
INDIRF4
ADDRLP4 340
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 336
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 260+4
INDIRF4
ADDRLP4 340
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 260+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 831
;831:		VectorMA (point, p->width, rr, point);	
ADDRLP4 344
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 248
INDIRF4
ADDRLP4 344
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 248+4
INDIRF4
ADDRLP4 344
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 248+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 832
;832:		VectorCopy (point, verts[2].xyz);	
ADDRLP4 12+48
ADDRLP4 0
INDIRB
ASGNB 12
line 833
;833:		verts[2].st[0] = 1;	
ADDRLP4 12+48+12
CNSTF4 1065353216
ASGNF4
line 834
;834:		verts[2].st[1] = 1;	
ADDRLP4 12+48+12+4
CNSTF4 1065353216
ASGNF4
line 835
;835:		verts[2].modulate[0] = 111;	
ADDRLP4 12+48+20
CNSTU1 111
ASGNU1
line 836
;836:		verts[2].modulate[1] = 19;	
ADDRLP4 12+48+20+1
CNSTU1 19
ASGNU1
line 837
;837:		verts[2].modulate[2] = 9;	
ADDRLP4 12+48+20+2
CNSTU1 9
ASGNU1
line 838
;838:		verts[2].modulate[3] = 255 * alpha;	
ADDRLP4 352
CNSTF4 1132396544
ADDRLP4 272
INDIRF4
MULF4
ASGNF4
ADDRLP4 356
CNSTF4 1325400064
ASGNF4
ADDRLP4 352
INDIRF4
ADDRLP4 356
INDIRF4
LTF4 $1000
ADDRLP4 348
ADDRLP4 352
INDIRF4
ADDRLP4 356
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $1001
JUMPV
LABELV $1000
ADDRLP4 348
ADDRLP4 352
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $1001
ADDRLP4 12+48+20+3
ADDRLP4 348
INDIRU4
CVUU1 4
ASGNU1
line 840
;839:
;840:		VectorMA (org, p->height, ru, point);	
ADDRLP4 360
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 364
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 360
INDIRP4
INDIRF4
ADDRLP4 260
INDIRF4
ADDRLP4 364
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 360
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 260+4
INDIRF4
ADDRLP4 364
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 260+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 841
;841:		VectorMA (point, -p->width, rr, point);	
ADDRLP4 368
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 248
INDIRF4
ADDRLP4 368
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 248+4
INDIRF4
ADDRLP4 368
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 248+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 842
;842:		VectorCopy (point, verts[3].xyz);	
ADDRLP4 12+72
ADDRLP4 0
INDIRB
ASGNB 12
line 843
;843:		verts[3].st[0] = 1;	
ADDRLP4 12+72+12
CNSTF4 1065353216
ASGNF4
line 844
;844:		verts[3].st[1] = 0;	
ADDRLP4 12+72+12+4
CNSTF4 0
ASGNF4
line 845
;845:		verts[3].modulate[0] = 111;	
ADDRLP4 12+72+20
CNSTU1 111
ASGNU1
line 846
;846:		verts[3].modulate[1] = 19;	
ADDRLP4 12+72+20+1
CNSTU1 19
ASGNU1
line 847
;847:		verts[3].modulate[2] = 9;	
ADDRLP4 12+72+20+2
CNSTU1 9
ASGNU1
line 848
;848:		verts[3].modulate[3] = 255 * alpha;	
ADDRLP4 376
CNSTF4 1132396544
ADDRLP4 272
INDIRF4
MULF4
ASGNF4
ADDRLP4 380
CNSTF4 1325400064
ASGNF4
ADDRLP4 376
INDIRF4
ADDRLP4 380
INDIRF4
LTF4 $1030
ADDRLP4 372
ADDRLP4 376
INDIRF4
ADDRLP4 380
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $1031
JUMPV
LABELV $1030
ADDRLP4 372
ADDRLP4 376
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $1031
ADDRLP4 12+72+20+3
ADDRLP4 372
INDIRU4
CVUU1 4
ASGNU1
line 850
;849:
;850:	}
ADDRGP4 $913
JUMPV
LABELV $912
line 851
;851:	else if (p->type == P_FLAT_SCALEUP)
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
CNSTI4 9
NEI4 $1032
line 852
;852:	{
line 856
;853:		float width, height;
;854:		float sinR, cosR;
;855:
;856:		if (p->color == BLOODRED)
ADDRFP4 0
INDIRP4
CNSTI4 48
ADDP4
INDIRI4
CNSTI4 2
NEI4 $1034
line 857
;857:			VectorSet (color, 1, 1, 1);
ADDRLP4 264
CNSTF4 1065353216
ASGNF4
ADDRLP4 184
ADDRLP4 264
INDIRF4
ASGNF4
ADDRLP4 184+4
ADDRLP4 264
INDIRF4
ASGNF4
ADDRLP4 184+8
CNSTF4 1065353216
ASGNF4
ADDRGP4 $1035
JUMPV
LABELV $1034
line 859
;858:		else
;859:			VectorSet (color, 0.5, 0.5, 0.5);
ADDRLP4 268
CNSTF4 1056964608
ASGNF4
ADDRLP4 184
ADDRLP4 268
INDIRF4
ASGNF4
ADDRLP4 184+4
ADDRLP4 268
INDIRF4
ASGNF4
ADDRLP4 184+8
CNSTF4 1056964608
ASGNF4
LABELV $1035
line 861
;860:		
;861:		time = cg.time - p->time;
ADDRLP4 232
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 862
;862:		time2 = p->endtime - p->time;
ADDRLP4 272
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 236
ADDRLP4 272
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 272
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 863
;863:		ratio = time / time2;
ADDRLP4 200
ADDRLP4 232
INDIRF4
ADDRLP4 236
INDIRF4
DIVF4
ASGNF4
line 865
;864:
;865:		width = p->width + ( ratio * ( p->endwidth - p->width) );
ADDRLP4 276
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 280
ADDRLP4 276
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
ASGNF4
ADDRLP4 256
ADDRLP4 280
INDIRF4
ADDRLP4 200
INDIRF4
ADDRLP4 276
INDIRP4
CNSTI4 84
ADDP4
INDIRF4
ADDRLP4 280
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 866
;866:		height = p->height + ( ratio * ( p->endheight - p->height) );
ADDRLP4 284
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 288
ADDRLP4 284
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
ASGNF4
ADDRLP4 260
ADDRLP4 288
INDIRF4
ADDRLP4 200
INDIRF4
ADDRLP4 284
INDIRP4
CNSTI4 80
ADDP4
INDIRF4
ADDRLP4 288
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 868
;867:
;868:		if (width > p->endwidth)
ADDRLP4 256
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 84
ADDP4
INDIRF4
LEF4 $1041
line 869
;869:			width = p->endwidth;
ADDRLP4 256
ADDRFP4 0
INDIRP4
CNSTI4 84
ADDP4
INDIRF4
ASGNF4
LABELV $1041
line 871
;870:
;871:		if (height > p->endheight)
ADDRLP4 260
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 80
ADDP4
INDIRF4
LEF4 $1043
line 872
;872:			height = p->endheight;
ADDRLP4 260
ADDRFP4 0
INDIRP4
CNSTI4 80
ADDP4
INDIRF4
ASGNF4
LABELV $1043
line 874
;873:
;874:		sinR = height * sin(DEG2RAD(p->roll)) * sqrt(2);
CNSTF4 1078530011
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CVIF4 4
MULF4
CNSTF4 1127481344
DIVF4
ARGF4
ADDRLP4 292
ADDRGP4 sin
CALLF4
ASGNF4
CNSTF4 1073741824
ARGF4
ADDRLP4 296
ADDRGP4 sqrt
CALLF4
ASGNF4
ADDRLP4 248
ADDRLP4 260
INDIRF4
ADDRLP4 292
INDIRF4
MULF4
ADDRLP4 296
INDIRF4
MULF4
ASGNF4
line 875
;875:		cosR = width * cos(DEG2RAD(p->roll)) * sqrt(2);
CNSTF4 1078530011
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CVIF4 4
MULF4
CNSTF4 1127481344
DIVF4
ARGF4
ADDRLP4 300
ADDRGP4 cos
CALLF4
ASGNF4
CNSTF4 1073741824
ARGF4
ADDRLP4 304
ADDRGP4 sqrt
CALLF4
ASGNF4
ADDRLP4 252
ADDRLP4 256
INDIRF4
ADDRLP4 300
INDIRF4
MULF4
ADDRLP4 304
INDIRF4
MULF4
ASGNF4
line 877
;876:
;877:		VectorCopy (org, verts[0].xyz);	
ADDRLP4 12
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 878
;878:		verts[0].xyz[0] -= sinR;
ADDRLP4 12
ADDRLP4 12
INDIRF4
ADDRLP4 248
INDIRF4
SUBF4
ASGNF4
line 879
;879:		verts[0].xyz[1] -= cosR;
ADDRLP4 12+4
ADDRLP4 12+4
INDIRF4
ADDRLP4 252
INDIRF4
SUBF4
ASGNF4
line 880
;880:		verts[0].st[0] = 0;	
ADDRLP4 12+12
CNSTF4 0
ASGNF4
line 881
;881:		verts[0].st[1] = 0;	
ADDRLP4 12+12+4
CNSTF4 0
ASGNF4
line 882
;882:		verts[0].modulate[0] = 255 * color[0];	
ADDRLP4 312
CNSTF4 1132396544
ADDRLP4 184
INDIRF4
MULF4
ASGNF4
ADDRLP4 316
CNSTF4 1325400064
ASGNF4
ADDRLP4 312
INDIRF4
ADDRLP4 316
INDIRF4
LTF4 $1051
ADDRLP4 308
ADDRLP4 312
INDIRF4
ADDRLP4 316
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $1052
JUMPV
LABELV $1051
ADDRLP4 308
ADDRLP4 312
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $1052
ADDRLP4 12+20
ADDRLP4 308
INDIRU4
CVUU1 4
ASGNU1
line 883
;883:		verts[0].modulate[1] = 255 * color[1];	
ADDRLP4 324
CNSTF4 1132396544
ADDRLP4 184+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 328
CNSTF4 1325400064
ASGNF4
ADDRLP4 324
INDIRF4
ADDRLP4 328
INDIRF4
LTF4 $1057
ADDRLP4 320
ADDRLP4 324
INDIRF4
ADDRLP4 328
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $1058
JUMPV
LABELV $1057
ADDRLP4 320
ADDRLP4 324
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $1058
ADDRLP4 12+20+1
ADDRLP4 320
INDIRU4
CVUU1 4
ASGNU1
line 884
;884:		verts[0].modulate[2] = 255 * color[2];	
ADDRLP4 336
CNSTF4 1132396544
ADDRLP4 184+8
INDIRF4
MULF4
ASGNF4
ADDRLP4 340
CNSTF4 1325400064
ASGNF4
ADDRLP4 336
INDIRF4
ADDRLP4 340
INDIRF4
LTF4 $1063
ADDRLP4 332
ADDRLP4 336
INDIRF4
ADDRLP4 340
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $1064
JUMPV
LABELV $1063
ADDRLP4 332
ADDRLP4 336
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $1064
ADDRLP4 12+20+2
ADDRLP4 332
INDIRU4
CVUU1 4
ASGNU1
line 885
;885:		verts[0].modulate[3] = 255;	
ADDRLP4 12+20+3
CNSTU1 255
ASGNU1
line 887
;886:
;887:		VectorCopy (org, verts[1].xyz);	
ADDRLP4 12+24
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 888
;888:		verts[1].xyz[0] -= cosR;	
ADDRLP4 12+24
ADDRLP4 12+24
INDIRF4
ADDRLP4 252
INDIRF4
SUBF4
ASGNF4
line 889
;889:		verts[1].xyz[1] += sinR;	
ADDRLP4 12+24+4
ADDRLP4 12+24+4
INDIRF4
ADDRLP4 248
INDIRF4
ADDF4
ASGNF4
line 890
;890:		verts[1].st[0] = 0;	
ADDRLP4 12+24+12
CNSTF4 0
ASGNF4
line 891
;891:		verts[1].st[1] = 1;	
ADDRLP4 12+24+12+4
CNSTF4 1065353216
ASGNF4
line 892
;892:		verts[1].modulate[0] = 255 * color[0];	
ADDRLP4 348
CNSTF4 1132396544
ADDRLP4 184
INDIRF4
MULF4
ASGNF4
ADDRLP4 352
CNSTF4 1325400064
ASGNF4
ADDRLP4 348
INDIRF4
ADDRLP4 352
INDIRF4
LTF4 $1079
ADDRLP4 344
ADDRLP4 348
INDIRF4
ADDRLP4 352
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $1080
JUMPV
LABELV $1079
ADDRLP4 344
ADDRLP4 348
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $1080
ADDRLP4 12+24+20
ADDRLP4 344
INDIRU4
CVUU1 4
ASGNU1
line 893
;893:		verts[1].modulate[1] = 255 * color[1];	
ADDRLP4 360
CNSTF4 1132396544
ADDRLP4 184+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 364
CNSTF4 1325400064
ASGNF4
ADDRLP4 360
INDIRF4
ADDRLP4 364
INDIRF4
LTF4 $1086
ADDRLP4 356
ADDRLP4 360
INDIRF4
ADDRLP4 364
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $1087
JUMPV
LABELV $1086
ADDRLP4 356
ADDRLP4 360
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $1087
ADDRLP4 12+24+20+1
ADDRLP4 356
INDIRU4
CVUU1 4
ASGNU1
line 894
;894:		verts[1].modulate[2] = 255 * color[2];	
ADDRLP4 372
CNSTF4 1132396544
ADDRLP4 184+8
INDIRF4
MULF4
ASGNF4
ADDRLP4 376
CNSTF4 1325400064
ASGNF4
ADDRLP4 372
INDIRF4
ADDRLP4 376
INDIRF4
LTF4 $1093
ADDRLP4 368
ADDRLP4 372
INDIRF4
ADDRLP4 376
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $1094
JUMPV
LABELV $1093
ADDRLP4 368
ADDRLP4 372
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $1094
ADDRLP4 12+24+20+2
ADDRLP4 368
INDIRU4
CVUU1 4
ASGNU1
line 895
;895:		verts[1].modulate[3] = 255;	
ADDRLP4 12+24+20+3
CNSTU1 255
ASGNU1
line 897
;896:
;897:		VectorCopy (org, verts[2].xyz);	
ADDRLP4 12+48
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 898
;898:		verts[2].xyz[0] += sinR;	
ADDRLP4 12+48
ADDRLP4 12+48
INDIRF4
ADDRLP4 248
INDIRF4
ADDF4
ASGNF4
line 899
;899:		verts[2].xyz[1] += cosR;	
ADDRLP4 12+48+4
ADDRLP4 12+48+4
INDIRF4
ADDRLP4 252
INDIRF4
ADDF4
ASGNF4
line 900
;900:		verts[2].st[0] = 1;	
ADDRLP4 12+48+12
CNSTF4 1065353216
ASGNF4
line 901
;901:		verts[2].st[1] = 1;	
ADDRLP4 12+48+12+4
CNSTF4 1065353216
ASGNF4
line 902
;902:		verts[2].modulate[0] = 255 * color[0];	
ADDRLP4 384
CNSTF4 1132396544
ADDRLP4 184
INDIRF4
MULF4
ASGNF4
ADDRLP4 388
CNSTF4 1325400064
ASGNF4
ADDRLP4 384
INDIRF4
ADDRLP4 388
INDIRF4
LTF4 $1110
ADDRLP4 380
ADDRLP4 384
INDIRF4
ADDRLP4 388
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $1111
JUMPV
LABELV $1110
ADDRLP4 380
ADDRLP4 384
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $1111
ADDRLP4 12+48+20
ADDRLP4 380
INDIRU4
CVUU1 4
ASGNU1
line 903
;903:		verts[2].modulate[1] = 255 * color[1];	
ADDRLP4 396
CNSTF4 1132396544
ADDRLP4 184+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 400
CNSTF4 1325400064
ASGNF4
ADDRLP4 396
INDIRF4
ADDRLP4 400
INDIRF4
LTF4 $1117
ADDRLP4 392
ADDRLP4 396
INDIRF4
ADDRLP4 400
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $1118
JUMPV
LABELV $1117
ADDRLP4 392
ADDRLP4 396
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $1118
ADDRLP4 12+48+20+1
ADDRLP4 392
INDIRU4
CVUU1 4
ASGNU1
line 904
;904:		verts[2].modulate[2] = 255 * color[2];	
ADDRLP4 408
CNSTF4 1132396544
ADDRLP4 184+8
INDIRF4
MULF4
ASGNF4
ADDRLP4 412
CNSTF4 1325400064
ASGNF4
ADDRLP4 408
INDIRF4
ADDRLP4 412
INDIRF4
LTF4 $1124
ADDRLP4 404
ADDRLP4 408
INDIRF4
ADDRLP4 412
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $1125
JUMPV
LABELV $1124
ADDRLP4 404
ADDRLP4 408
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $1125
ADDRLP4 12+48+20+2
ADDRLP4 404
INDIRU4
CVUU1 4
ASGNU1
line 905
;905:		verts[2].modulate[3] = 255;	
ADDRLP4 12+48+20+3
CNSTU1 255
ASGNU1
line 907
;906:
;907:		VectorCopy (org, verts[3].xyz);	
ADDRLP4 12+72
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 908
;908:		verts[3].xyz[0] += cosR;	
ADDRLP4 12+72
ADDRLP4 12+72
INDIRF4
ADDRLP4 252
INDIRF4
ADDF4
ASGNF4
line 909
;909:		verts[3].xyz[1] -= sinR;	
ADDRLP4 12+72+4
ADDRLP4 12+72+4
INDIRF4
ADDRLP4 248
INDIRF4
SUBF4
ASGNF4
line 910
;910:		verts[3].st[0] = 1;	
ADDRLP4 12+72+12
CNSTF4 1065353216
ASGNF4
line 911
;911:		verts[3].st[1] = 0;	
ADDRLP4 12+72+12+4
CNSTF4 0
ASGNF4
line 912
;912:		verts[3].modulate[0] = 255 * color[0];	
ADDRLP4 420
CNSTF4 1132396544
ADDRLP4 184
INDIRF4
MULF4
ASGNF4
ADDRLP4 424
CNSTF4 1325400064
ASGNF4
ADDRLP4 420
INDIRF4
ADDRLP4 424
INDIRF4
LTF4 $1141
ADDRLP4 416
ADDRLP4 420
INDIRF4
ADDRLP4 424
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $1142
JUMPV
LABELV $1141
ADDRLP4 416
ADDRLP4 420
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $1142
ADDRLP4 12+72+20
ADDRLP4 416
INDIRU4
CVUU1 4
ASGNU1
line 913
;913:		verts[3].modulate[1] = 255 * color[1];	
ADDRLP4 432
CNSTF4 1132396544
ADDRLP4 184+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 436
CNSTF4 1325400064
ASGNF4
ADDRLP4 432
INDIRF4
ADDRLP4 436
INDIRF4
LTF4 $1148
ADDRLP4 428
ADDRLP4 432
INDIRF4
ADDRLP4 436
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $1149
JUMPV
LABELV $1148
ADDRLP4 428
ADDRLP4 432
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $1149
ADDRLP4 12+72+20+1
ADDRLP4 428
INDIRU4
CVUU1 4
ASGNU1
line 914
;914:		verts[3].modulate[2] = 255 * color[2];	
ADDRLP4 444
CNSTF4 1132396544
ADDRLP4 184+8
INDIRF4
MULF4
ASGNF4
ADDRLP4 448
CNSTF4 1325400064
ASGNF4
ADDRLP4 444
INDIRF4
ADDRLP4 448
INDIRF4
LTF4 $1155
ADDRLP4 440
ADDRLP4 444
INDIRF4
ADDRLP4 448
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $1156
JUMPV
LABELV $1155
ADDRLP4 440
ADDRLP4 444
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $1156
ADDRLP4 12+72+20+2
ADDRLP4 440
INDIRU4
CVUU1 4
ASGNU1
line 915
;915:		verts[3].modulate[3] = 255;		
ADDRLP4 12+72+20+3
CNSTU1 255
ASGNU1
line 916
;916:	}
ADDRGP4 $1033
JUMPV
LABELV $1032
line 917
;917:	else if (p->type == P_FLAT)
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
CNSTI4 2
NEI4 $1160
line 918
;918:	{
line 920
;919:
;920:		VectorCopy (org, verts[0].xyz);	
ADDRLP4 12
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 921
;921:		verts[0].xyz[0] -= p->height;	
ADDRLP4 12
ADDRLP4 12
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
SUBF4
ASGNF4
line 922
;922:		verts[0].xyz[1] -= p->width;	
ADDRLP4 12+4
ADDRLP4 12+4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
SUBF4
ASGNF4
line 923
;923:		verts[0].st[0] = 0;	
ADDRLP4 12+12
CNSTF4 0
ASGNF4
line 924
;924:		verts[0].st[1] = 0;	
ADDRLP4 12+12+4
CNSTF4 0
ASGNF4
line 925
;925:		verts[0].modulate[0] = 255;	
ADDRLP4 12+20
CNSTU1 255
ASGNU1
line 926
;926:		verts[0].modulate[1] = 255;	
ADDRLP4 12+20+1
CNSTU1 255
ASGNU1
line 927
;927:		verts[0].modulate[2] = 255;	
ADDRLP4 12+20+2
CNSTU1 255
ASGNU1
line 928
;928:		verts[0].modulate[3] = 255;	
ADDRLP4 12+20+3
CNSTU1 255
ASGNU1
line 930
;929:
;930:		VectorCopy (org, verts[1].xyz);	
ADDRLP4 12+24
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 931
;931:		verts[1].xyz[0] -= p->height;	
ADDRLP4 12+24
ADDRLP4 12+24
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
SUBF4
ASGNF4
line 932
;932:		verts[1].xyz[1] += p->width;	
ADDRLP4 12+24+4
ADDRLP4 12+24+4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
ADDF4
ASGNF4
line 933
;933:		verts[1].st[0] = 0;	
ADDRLP4 12+24+12
CNSTF4 0
ASGNF4
line 934
;934:		verts[1].st[1] = 1;	
ADDRLP4 12+24+12+4
CNSTF4 1065353216
ASGNF4
line 935
;935:		verts[1].modulate[0] = 255;	
ADDRLP4 12+24+20
CNSTU1 255
ASGNU1
line 936
;936:		verts[1].modulate[1] = 255;	
ADDRLP4 12+24+20+1
CNSTU1 255
ASGNU1
line 937
;937:		verts[1].modulate[2] = 255;	
ADDRLP4 12+24+20+2
CNSTU1 255
ASGNU1
line 938
;938:		verts[1].modulate[3] = 255;	
ADDRLP4 12+24+20+3
CNSTU1 255
ASGNU1
line 940
;939:
;940:		VectorCopy (org, verts[2].xyz);	
ADDRLP4 12+48
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 941
;941:		verts[2].xyz[0] += p->height;	
ADDRLP4 12+48
ADDRLP4 12+48
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
ADDF4
ASGNF4
line 942
;942:		verts[2].xyz[1] += p->width;	
ADDRLP4 12+48+4
ADDRLP4 12+48+4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
ADDF4
ASGNF4
line 943
;943:		verts[2].st[0] = 1;	
ADDRLP4 12+48+12
CNSTF4 1065353216
ASGNF4
line 944
;944:		verts[2].st[1] = 1;	
ADDRLP4 12+48+12+4
CNSTF4 1065353216
ASGNF4
line 945
;945:		verts[2].modulate[0] = 255;	
ADDRLP4 12+48+20
CNSTU1 255
ASGNU1
line 946
;946:		verts[2].modulate[1] = 255;	
ADDRLP4 12+48+20+1
CNSTU1 255
ASGNU1
line 947
;947:		verts[2].modulate[2] = 255;	
ADDRLP4 12+48+20+2
CNSTU1 255
ASGNU1
line 948
;948:		verts[2].modulate[3] = 255;	
ADDRLP4 12+48+20+3
CNSTU1 255
ASGNU1
line 950
;949:
;950:		VectorCopy (org, verts[3].xyz);	
ADDRLP4 12+72
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 951
;951:		verts[3].xyz[0] += p->height;	
ADDRLP4 12+72
ADDRLP4 12+72
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
ADDF4
ASGNF4
line 952
;952:		verts[3].xyz[1] -= p->width;	
ADDRLP4 12+72+4
ADDRLP4 12+72+4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
SUBF4
ASGNF4
line 953
;953:		verts[3].st[0] = 1;	
ADDRLP4 12+72+12
CNSTF4 1065353216
ASGNF4
line 954
;954:		verts[3].st[1] = 0;	
ADDRLP4 12+72+12+4
CNSTF4 0
ASGNF4
line 955
;955:		verts[3].modulate[0] = 255;	
ADDRLP4 12+72+20
CNSTU1 255
ASGNU1
line 956
;956:		verts[3].modulate[1] = 255;	
ADDRLP4 12+72+20+1
CNSTU1 255
ASGNU1
line 957
;957:		verts[3].modulate[2] = 255;	
ADDRLP4 12+72+20+2
CNSTU1 255
ASGNU1
line 958
;958:		verts[3].modulate[3] = 255;	
ADDRLP4 12+72+20+3
CNSTU1 255
ASGNU1
line 960
;959:
;960:	}
ADDRGP4 $1161
JUMPV
LABELV $1160
line 962
;961:	// Ridah
;962:	else if (p->type == P_ANIM) {
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
CNSTI4 6
NEI4 $1233
line 967
;963:		vec3_t	rr, ru;
;964:		vec3_t	rotate_ang;
;965:		int i, j;
;966:
;967:		time = cg.time - p->time;
ADDRLP4 232
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 968
;968:		time2 = p->endtime - p->time;
ADDRLP4 292
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 236
ADDRLP4 292
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 292
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 969
;969:		ratio = time / time2;
ADDRLP4 200
ADDRLP4 232
INDIRF4
ADDRLP4 236
INDIRF4
DIVF4
ASGNF4
line 970
;970:		if (ratio >= 1.0f) {
ADDRLP4 200
INDIRF4
CNSTF4 1065353216
LTF4 $1236
line 971
;971:			ratio = 0.9999f;
ADDRLP4 200
CNSTF4 1065351538
ASGNF4
line 972
;972:		}
LABELV $1236
line 974
;973:
;974:		width = p->width + ( ratio * ( p->endwidth - p->width) );
ADDRLP4 296
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 300
ADDRLP4 296
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
ASGNF4
ADDRLP4 196
ADDRLP4 300
INDIRF4
ADDRLP4 200
INDIRF4
ADDRLP4 296
INDIRP4
CNSTI4 84
ADDP4
INDIRF4
ADDRLP4 300
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 975
;975:		height = p->height + ( ratio * ( p->endheight - p->height) );
ADDRLP4 304
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 308
ADDRLP4 304
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
ASGNF4
ADDRLP4 180
ADDRLP4 308
INDIRF4
ADDRLP4 200
INDIRF4
ADDRLP4 304
INDIRP4
CNSTI4 80
ADDP4
INDIRF4
ADDRLP4 308
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 978
;976:
;977:		// if we are "inside" this sprite, don't draw
;978:		if (Distance( cg.snap->ps.origin, org ) < width/1.5) {
ADDRGP4 cg+36
INDIRP4
CNSTI4 64
ADDP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 312
ADDRGP4 Distance
CALLF4
ASGNF4
ADDRLP4 312
INDIRF4
ADDRLP4 196
INDIRF4
CNSTF4 1069547520
DIVF4
GEF4 $1238
line 979
;979:			return;
ADDRGP4 $306
JUMPV
LABELV $1238
line 982
;980:		}
;981:
;982:		i = p->shaderAnim;
ADDRLP4 272
ADDRFP4 0
INDIRP4
CNSTI4 112
ADDP4
INDIRI4
ASGNI4
line 983
;983:		j = (int)floor(ratio * shaderAnimCounts[p->shaderAnim]);
ADDRLP4 200
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 112
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 shaderAnimCounts
ADDP4
INDIRI4
CVIF4 4
MULF4
ARGF4
ADDRLP4 316
ADDRGP4 floor
CALLF4
ASGNF4
ADDRLP4 276
ADDRLP4 316
INDIRF4
CVFI4 4
ASGNI4
line 984
;984:		p->pshader = shaderAnims[i][j];
ADDRFP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRLP4 276
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 272
INDIRI4
CNSTI4 8
LSHI4
ADDRGP4 shaderAnims
ADDP4
ADDP4
INDIRI4
ASGNI4
line 986
;985:
;986:		if (p->roll) {
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CNSTI4 0
EQI4 $1241
line 987
;987:			vectoangles( cg.refdef.viewaxis[0], rotate_ang );
ADDRGP4 cg+3616+36
ARGP4
ADDRLP4 280
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 988
;988:			rotate_ang[ROLL] += p->roll;
ADDRLP4 280+8
ADDRLP4 280+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CVIF4 4
ADDF4
ASGNF4
line 989
;989:			AngleVectors ( rotate_ang, NULL, rr, ru);
ADDRLP4 280
ARGP4
CNSTP4 0
ARGP4
ADDRLP4 260
ARGP4
ADDRLP4 248
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 990
;990:		}
LABELV $1241
line 992
;991:
;992:		if (p->roll) {
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CNSTI4 0
EQI4 $1246
line 993
;993:			VectorMA (org, -height, ru, point);	
ADDRLP4 320
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 324
ADDRLP4 180
INDIRF4
NEGF4
ASGNF4
ADDRLP4 0
ADDRLP4 320
INDIRP4
INDIRF4
ADDRLP4 248
INDIRF4
ADDRLP4 324
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 320
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 248+4
INDIRF4
ADDRLP4 324
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 248+8
INDIRF4
ADDRLP4 180
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 994
;994:			VectorMA (point, -width, rr, point);	
ADDRLP4 328
ADDRLP4 196
INDIRF4
NEGF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 260
INDIRF4
ADDRLP4 328
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 260+4
INDIRF4
ADDRLP4 328
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 260+8
INDIRF4
ADDRLP4 196
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 995
;995:		} else {
ADDRGP4 $1247
JUMPV
LABELV $1246
line 996
;996:			VectorMA (org, -height, pvup, point);	
ADDRLP4 320
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 324
ADDRLP4 180
INDIRF4
NEGF4
ASGNF4
ADDRLP4 0
ADDRLP4 320
INDIRP4
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 324
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 320
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 324
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRGP4 pvup+8
INDIRF4
ADDRLP4 180
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 997
;997:			VectorMA (point, -width, pvright, point);	
ADDRLP4 328
ADDRLP4 196
INDIRF4
NEGF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 328
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 328
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
ADDRLP4 196
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 998
;998:		}
LABELV $1247
line 999
;999:		VectorCopy (point, verts[0].xyz);	
ADDRLP4 12
ADDRLP4 0
INDIRB
ASGNB 12
line 1000
;1000:		verts[0].st[0] = 0;	
ADDRLP4 12+12
CNSTF4 0
ASGNF4
line 1001
;1001:		verts[0].st[1] = 0;	
ADDRLP4 12+12+4
CNSTF4 0
ASGNF4
line 1002
;1002:		verts[0].modulate[0] = 255;	
ADDRLP4 12+20
CNSTU1 255
ASGNU1
line 1003
;1003:		verts[0].modulate[1] = 255;	
ADDRLP4 12+20+1
CNSTU1 255
ASGNU1
line 1004
;1004:		verts[0].modulate[2] = 255;	
ADDRLP4 12+20+2
CNSTU1 255
ASGNU1
line 1005
;1005:		verts[0].modulate[3] = 255;
ADDRLP4 12+20+3
CNSTU1 255
ASGNU1
line 1007
;1006:
;1007:		if (p->roll) {
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CNSTI4 0
EQI4 $1278
line 1008
;1008:			VectorMA (point, 2*height, ru, point);	
ADDRLP4 320
CNSTF4 1073741824
ADDRLP4 180
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 248
INDIRF4
ADDRLP4 320
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 248+4
INDIRF4
ADDRLP4 320
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 248+8
INDIRF4
CNSTF4 1073741824
ADDRLP4 180
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 1009
;1009:		} else {
ADDRGP4 $1279
JUMPV
LABELV $1278
line 1010
;1010:			VectorMA (point, 2*height, pvup, point);	
ADDRLP4 320
CNSTF4 1073741824
ADDRLP4 180
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 320
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 320
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvup+8
INDIRF4
CNSTF4 1073741824
ADDRLP4 180
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 1011
;1011:		}
LABELV $1279
line 1012
;1012:		VectorCopy (point, verts[1].xyz);	
ADDRLP4 12+24
ADDRLP4 0
INDIRB
ASGNB 12
line 1013
;1013:		verts[1].st[0] = 0;	
ADDRLP4 12+24+12
CNSTF4 0
ASGNF4
line 1014
;1014:		verts[1].st[1] = 1;	
ADDRLP4 12+24+12+4
CNSTF4 1065353216
ASGNF4
line 1015
;1015:		verts[1].modulate[0] = 255;	
ADDRLP4 12+24+20
CNSTU1 255
ASGNU1
line 1016
;1016:		verts[1].modulate[1] = 255;	
ADDRLP4 12+24+20+1
CNSTU1 255
ASGNU1
line 1017
;1017:		verts[1].modulate[2] = 255;	
ADDRLP4 12+24+20+2
CNSTU1 255
ASGNU1
line 1018
;1018:		verts[1].modulate[3] = 255;	
ADDRLP4 12+24+20+3
CNSTU1 255
ASGNU1
line 1020
;1019:
;1020:		if (p->roll) {
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CNSTI4 0
EQI4 $1309
line 1021
;1021:			VectorMA (point, 2*width, rr, point);	
ADDRLP4 320
CNSTF4 1073741824
ADDRLP4 196
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 260
INDIRF4
ADDRLP4 320
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 260+4
INDIRF4
ADDRLP4 320
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 260+8
INDIRF4
CNSTF4 1073741824
ADDRLP4 196
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 1022
;1022:		} else {
ADDRGP4 $1310
JUMPV
LABELV $1309
line 1023
;1023:			VectorMA (point, 2*width, pvright, point);	
ADDRLP4 320
CNSTF4 1073741824
ADDRLP4 196
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 320
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 320
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
CNSTF4 1073741824
ADDRLP4 196
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 1024
;1024:		}
LABELV $1310
line 1025
;1025:		VectorCopy (point, verts[2].xyz);	
ADDRLP4 12+48
ADDRLP4 0
INDIRB
ASGNB 12
line 1026
;1026:		verts[2].st[0] = 1;	
ADDRLP4 12+48+12
CNSTF4 1065353216
ASGNF4
line 1027
;1027:		verts[2].st[1] = 1;	
ADDRLP4 12+48+12+4
CNSTF4 1065353216
ASGNF4
line 1028
;1028:		verts[2].modulate[0] = 255;	
ADDRLP4 12+48+20
CNSTU1 255
ASGNU1
line 1029
;1029:		verts[2].modulate[1] = 255;	
ADDRLP4 12+48+20+1
CNSTU1 255
ASGNU1
line 1030
;1030:		verts[2].modulate[2] = 255;	
ADDRLP4 12+48+20+2
CNSTU1 255
ASGNU1
line 1031
;1031:		verts[2].modulate[3] = 255;	
ADDRLP4 12+48+20+3
CNSTU1 255
ASGNU1
line 1033
;1032:
;1033:		if (p->roll) {
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CNSTI4 0
EQI4 $1340
line 1034
;1034:			VectorMA (point, -2*height, ru, point);	
ADDRLP4 320
CNSTF4 3221225472
ADDRLP4 180
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 248
INDIRF4
ADDRLP4 320
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 248+4
INDIRF4
ADDRLP4 320
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 248+8
INDIRF4
CNSTF4 3221225472
ADDRLP4 180
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 1035
;1035:		} else {
ADDRGP4 $1341
JUMPV
LABELV $1340
line 1036
;1036:			VectorMA (point, -2*height, pvup, point);	
ADDRLP4 320
CNSTF4 3221225472
ADDRLP4 180
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 320
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 320
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvup+8
INDIRF4
CNSTF4 3221225472
ADDRLP4 180
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 1037
;1037:		}
LABELV $1341
line 1038
;1038:		VectorCopy (point, verts[3].xyz);	
ADDRLP4 12+72
ADDRLP4 0
INDIRB
ASGNB 12
line 1039
;1039:		verts[3].st[0] = 1;	
ADDRLP4 12+72+12
CNSTF4 1065353216
ASGNF4
line 1040
;1040:		verts[3].st[1] = 0;	
ADDRLP4 12+72+12+4
CNSTF4 0
ASGNF4
line 1041
;1041:		verts[3].modulate[0] = 255;	
ADDRLP4 12+72+20
CNSTU1 255
ASGNU1
line 1042
;1042:		verts[3].modulate[1] = 255;	
ADDRLP4 12+72+20+1
CNSTU1 255
ASGNU1
line 1043
;1043:		verts[3].modulate[2] = 255;	
ADDRLP4 12+72+20+2
CNSTU1 255
ASGNU1
line 1044
;1044:		verts[3].modulate[3] = 255;	
ADDRLP4 12+72+20+3
CNSTU1 255
ASGNU1
line 1045
;1045:	}
LABELV $1233
LABELV $1161
LABELV $1033
LABELV $913
LABELV $671
LABELV $536
LABELV $308
line 1048
;1046:	// done.
;1047:	
;1048:	if (!p->pshader) {
ADDRFP4 0
INDIRP4
CNSTI4 68
ADDP4
INDIRI4
CNSTI4 0
NEI4 $1371
line 1051
;1049:// (SA) temp commented out for DM
;1050://		CG_Printf ("CG_AddParticleToScene type %d p->pshader == ZERO\n", p->type);
;1051:		return;
ADDRGP4 $306
JUMPV
LABELV $1371
line 1054
;1052:	}
;1053:
;1054:	if (p->type == P_WEATHER || p->type == P_WEATHER_TURBULENT || p->type == P_WEATHER_FLURRY)
ADDRLP4 248
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
ASGNI4
ADDRLP4 248
INDIRI4
CNSTI4 1
EQI4 $1376
ADDRLP4 248
INDIRI4
CNSTI4 5
EQI4 $1376
ADDRLP4 248
INDIRI4
CNSTI4 11
NEI4 $1373
LABELV $1376
line 1055
;1055:		trap_R_AddPolyToScene( p->pshader, 3, TRIverts );
ADDRFP4 0
INDIRP4
CNSTI4 68
ADDP4
INDIRI4
ARGI4
CNSTI4 3
ARGI4
ADDRLP4 108
ARGP4
ADDRGP4 trap_R_AddPolyToScene
CALLV
pop
ADDRGP4 $1374
JUMPV
LABELV $1373
line 1057
;1056:	else
;1057:		trap_R_AddPolyToScene( p->pshader, 4, verts );
ADDRFP4 0
INDIRP4
CNSTI4 68
ADDP4
INDIRI4
ARGI4
CNSTI4 4
ARGI4
ADDRLP4 12
ARGP4
ADDRGP4 trap_R_AddPolyToScene
CALLV
pop
LABELV $1374
line 1059
;1058:
;1059:}
LABELV $306
endproc CG_AddParticleToScene 472 16
data
align 4
LABELV roll
byte 4 0
export CG_AddParticles
code
proc CG_AddParticles 96 16
line 1070
;1060:
;1061:// Ridah, made this static so it doesn't interfere with other files
;1062:static float roll = 0.0;
;1063:
;1064:/*
;1065:===============
;1066:CG_AddParticles
;1067:===============
;1068:*/
;1069:void CG_AddParticles (void)
;1070:{
line 1080
;1071:	cparticle_t		*p, *next;
;1072:	float			alpha;
;1073:	float			time, time2;
;1074:	vec3_t			org;
;1075:	int				color;
;1076:	cparticle_t		*active, *tail;
;1077:	int				type;
;1078:	vec3_t			rotate_ang;
;1079:
;1080:	if (!initparticles)
ADDRGP4 initparticles
INDIRI4
CNSTI4 0
NEI4 $1378
line 1081
;1081:		CG_ClearParticles ();
ADDRGP4 CG_ClearParticles
CALLV
pop
LABELV $1378
line 1083
;1082:
;1083:	VectorCopy( cg.refdef.viewaxis[0], pvforward );
ADDRGP4 pvforward
ADDRGP4 cg+3616+36
INDIRB
ASGNB 12
line 1084
;1084:	VectorCopy( cg.refdef.viewaxis[1], pvright );
ADDRGP4 pvright
ADDRGP4 cg+3616+36+12
INDIRB
ASGNB 12
line 1085
;1085:	VectorCopy( cg.refdef.viewaxis[2], pvup );
ADDRGP4 pvup
ADDRGP4 cg+3616+36+24
INDIRB
ASGNB 12
line 1087
;1086:
;1087:	vectoangles( cg.refdef.viewaxis[0], rotate_ang );
ADDRGP4 cg+3616+36
ARGP4
ADDRLP4 48
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 1088
;1088:	roll += ((cg.time - oldtime) * 0.1) ;
ADDRLP4 60
ADDRGP4 roll
ASGNP4
ADDRLP4 60
INDIRP4
ADDRLP4 60
INDIRP4
INDIRF4
CNSTF4 1036831949
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ADDRGP4 oldtime
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 1089
;1089:	rotate_ang[ROLL] += (roll*0.9);
ADDRLP4 48+8
ADDRLP4 48+8
INDIRF4
CNSTF4 1063675494
ADDRGP4 roll
INDIRF4
MULF4
ADDF4
ASGNF4
line 1090
;1090:	AngleVectors ( rotate_ang, rforward, rright, rup);
ADDRLP4 48
ARGP4
ADDRGP4 rforward
ARGP4
ADDRGP4 rright
ARGP4
ADDRGP4 rup
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 1092
;1091:	
;1092:	oldtime = cg.time;
ADDRGP4 oldtime
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ASGNF4
line 1094
;1093:
;1094:	active = NULL;
ADDRLP4 44
CNSTP4 0
ASGNP4
line 1095
;1095:	tail = NULL;
ADDRLP4 28
CNSTP4 0
ASGNP4
line 1097
;1096:
;1097:	for (p=active_particles ; p ; p=next)
ADDRLP4 0
ADDRGP4 active_particles
INDIRP4
ASGNP4
ADDRGP4 $1396
JUMPV
LABELV $1393
line 1098
;1098:	{
line 1100
;1099:
;1100:		next = p->next;
ADDRLP4 32
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 1102
;1101:
;1102:		time = (cg.time - p->time)*0.001;
ADDRLP4 4
CNSTF4 981668463
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
MULF4
ASGNF4
line 1104
;1103:
;1104:		alpha = p->alpha + time*p->alphavel;
ADDRLP4 8
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
INDIRF4
ADDRLP4 4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 1105
;1105:		if (alpha <= 0)
ADDRLP4 8
INDIRF4
CNSTF4 0
GTF4 $1398
line 1106
;1106:		{	// faded out
line 1107
;1107:			p->next = free_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1108
;1108:			free_particles = p;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1109
;1109:			p->type = 0;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 0
ASGNI4
line 1110
;1110:			p->color = 0;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 0
ASGNI4
line 1111
;1111:			p->alpha = 0;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 0
ASGNF4
line 1112
;1112:			continue;
ADDRGP4 $1394
JUMPV
LABELV $1398
line 1115
;1113:		}
;1114:
;1115:		if (p->type == P_SMOKE || p->type == P_ANIM || p->type == P_BLEED || p->type == P_SMOKE_IMPACT)
ADDRLP4 68
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
ASGNI4
ADDRLP4 68
INDIRI4
CNSTI4 3
EQI4 $1404
ADDRLP4 68
INDIRI4
CNSTI4 6
EQI4 $1404
ADDRLP4 68
INDIRI4
CNSTI4 8
EQI4 $1404
ADDRLP4 68
INDIRI4
CNSTI4 12
NEI4 $1400
LABELV $1404
line 1116
;1116:		{
line 1117
;1117:			if (cg.time > p->endtime)
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
LEF4 $1405
line 1118
;1118:			{
line 1119
;1119:				p->next = free_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1120
;1120:				free_particles = p;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1121
;1121:				p->type = 0;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 0
ASGNI4
line 1122
;1122:				p->color = 0;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 0
ASGNI4
line 1123
;1123:				p->alpha = 0;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 0
ASGNF4
line 1125
;1124:			
;1125:				continue;
ADDRGP4 $1394
JUMPV
LABELV $1405
line 1128
;1126:			}
;1127:
;1128:		}
LABELV $1400
line 1130
;1129:
;1130:		if (p->type == P_WEATHER_FLURRY)
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
CNSTI4 11
NEI4 $1408
line 1131
;1131:		{
line 1132
;1132:			if (cg.time > p->endtime)
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
LEF4 $1410
line 1133
;1133:			{
line 1134
;1134:				p->next = free_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1135
;1135:				free_particles = p;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1136
;1136:				p->type = 0;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 0
ASGNI4
line 1137
;1137:				p->color = 0;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 0
ASGNI4
line 1138
;1138:				p->alpha = 0;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 0
ASGNF4
line 1140
;1139:			
;1140:				continue;
ADDRGP4 $1394
JUMPV
LABELV $1410
line 1142
;1141:			}
;1142:		}
LABELV $1408
line 1145
;1143:
;1144:
;1145:		if (p->type == P_FLAT_SCALEUP_FADE)
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
CNSTI4 10
NEI4 $1413
line 1146
;1146:		{
line 1147
;1147:			if (cg.time > p->endtime)
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
LEF4 $1415
line 1148
;1148:			{
line 1149
;1149:				p->next = free_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1150
;1150:				free_particles = p;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1151
;1151:				p->type = 0;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 0
ASGNI4
line 1152
;1152:				p->color = 0;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 0
ASGNI4
line 1153
;1153:				p->alpha = 0;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 0
ASGNF4
line 1154
;1154:				continue;
ADDRGP4 $1394
JUMPV
LABELV $1415
line 1157
;1155:			}
;1156:
;1157:		}
LABELV $1413
line 1159
;1158:
;1159:		if ((p->type == P_BAT || p->type == P_SPRITE) && p->endtime < 0) {
ADDRLP4 72
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
ASGNI4
ADDRLP4 72
INDIRI4
CNSTI4 7
EQI4 $1420
ADDRLP4 72
INDIRI4
CNSTI4 15
NEI4 $1418
LABELV $1420
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
CNSTF4 0
GEF4 $1418
line 1161
;1160:			// temporary sprite
;1161:			CG_AddParticleToScene (p, p->org, alpha);
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRLP4 8
INDIRF4
ARGF4
ADDRGP4 CG_AddParticleToScene
CALLV
pop
line 1162
;1162:			p->next = free_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1163
;1163:			free_particles = p;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1164
;1164:			p->type = 0;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 0
ASGNI4
line 1165
;1165:			p->color = 0;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 0
ASGNI4
line 1166
;1166:			p->alpha = 0;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 0
ASGNF4
line 1167
;1167:			continue;
ADDRGP4 $1394
JUMPV
LABELV $1418
line 1170
;1168:		}
;1169:
;1170:		p->next = NULL;
ADDRLP4 0
INDIRP4
CNSTP4 0
ASGNP4
line 1171
;1171:		if (!tail)
ADDRLP4 28
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1421
line 1172
;1172:			active = tail = p;
ADDRLP4 28
ADDRLP4 0
INDIRP4
ASGNP4
ADDRLP4 44
ADDRLP4 0
INDIRP4
ASGNP4
ADDRGP4 $1422
JUMPV
LABELV $1421
line 1174
;1173:		else
;1174:		{
line 1175
;1175:			tail->next = p;
ADDRLP4 28
INDIRP4
ADDRLP4 0
INDIRP4
ASGNP4
line 1176
;1176:			tail = p;
ADDRLP4 28
ADDRLP4 0
INDIRP4
ASGNP4
line 1177
;1177:		}
LABELV $1422
line 1179
;1178:
;1179:		if (alpha > 1.0)
ADDRLP4 8
INDIRF4
CNSTF4 1065353216
LEF4 $1423
line 1180
;1180:			alpha = 1;
ADDRLP4 8
CNSTF4 1065353216
ASGNF4
LABELV $1423
line 1182
;1181:
;1182:		color = p->color;
ADDRLP4 36
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
INDIRI4
ASGNI4
line 1184
;1183:
;1184:		time2 = time*time;
ADDRLP4 12
ADDRLP4 4
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ASGNF4
line 1186
;1185:
;1186:		org[0] = p->org[0] + p->vel[0]*time + p->accel[0]*time2;
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ADDF4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ADDF4
ASGNF4
line 1187
;1187:		org[1] = p->org[1] + p->vel[1]*time + p->accel[1]*time2;
ADDRLP4 16+4
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ADDF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ADDF4
ASGNF4
line 1188
;1188:		org[2] = p->org[2] + p->vel[2]*time + p->accel[2]*time2;
ADDRLP4 16+8
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ADDF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ADDF4
ASGNF4
line 1190
;1189:
;1190:		type = p->type;
ADDRLP4 40
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
ASGNI4
line 1192
;1191:
;1192:		CG_AddParticleToScene (p, org, alpha);
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 16
ARGP4
ADDRLP4 8
INDIRF4
ARGF4
ADDRGP4 CG_AddParticleToScene
CALLV
pop
line 1193
;1193:	}
LABELV $1394
line 1097
ADDRLP4 0
ADDRLP4 32
INDIRP4
ASGNP4
LABELV $1396
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1393
line 1195
;1194:
;1195:	active_particles = active;
ADDRGP4 active_particles
ADDRLP4 44
INDIRP4
ASGNP4
line 1196
;1196:}
LABELV $1377
endproc CG_AddParticles 96 16
export CG_ParticleSnowFlurry
proc CG_ParticleSnowFlurry 68 4
line 1204
;1197:
;1198:/*
;1199:======================
;1200:CG_AddParticles
;1201:======================
;1202:*/
;1203:void CG_ParticleSnowFlurry (qhandle_t pshader, centity_t *cent)
;1204:{
line 1206
;1205:	cparticle_t	*p;
;1206:	qboolean turb = qtrue;
ADDRLP4 4
CNSTI4 1
ASGNI4
line 1208
;1207:
;1208:	if (!pshader)
ADDRFP4 0
INDIRI4
CNSTI4 0
NEI4 $1428
line 1209
;1209:		CG_Printf ("CG_ParticleSnowFlurry pshader == ZERO!\n");
ADDRGP4 $1430
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $1428
line 1211
;1210:
;1211:	if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1431
line 1212
;1212:		return;
ADDRGP4 $1427
JUMPV
LABELV $1431
line 1213
;1213:	p = free_particles;
ADDRLP4 0
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1214
;1214:	free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 1215
;1215:	p->next = active_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 1216
;1216:	active_particles = p;
ADDRGP4 active_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1217
;1217:	p->time = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ASGNF4
line 1218
;1218:	p->color = 0;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 0
ASGNI4
line 1219
;1219:	p->alpha = 0.90f;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1063675494
ASGNF4
line 1220
;1220:	p->alphavel = 0;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 1222
;1221:
;1222:	p->start = cent->currentState.origin2[0];
ADDRLP4 0
INDIRP4
CNSTI4 88
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 104
ADDP4
INDIRF4
ASGNF4
line 1223
;1223:	p->end = cent->currentState.origin2[1];
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 108
ADDP4
INDIRF4
ASGNF4
line 1225
;1224:	
;1225:	p->endtime = cg.time + cent->currentState.time;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+64
INDIRI4
ADDRFP4 4
INDIRP4
CNSTI4 84
ADDP4
INDIRI4
ADDI4
CVIF4 4
ASGNF4
line 1226
;1226:	p->startfade = cg.time + cent->currentState.time2;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
ADDRGP4 cg+64
INDIRI4
ADDRFP4 4
INDIRP4
CNSTI4 88
ADDP4
INDIRI4
ADDI4
CVIF4 4
ASGNF4
line 1228
;1227:	
;1228:	p->pshader = pshader;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 0
INDIRI4
ASGNI4
line 1230
;1229:	
;1230:	if (rand()%100 > 90)
ADDRLP4 8
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 100
MODI4
CNSTI4 90
LEI4 $1436
line 1231
;1231:	{
line 1232
;1232:		p->height = 32;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
CNSTF4 1107296256
ASGNF4
line 1233
;1233:		p->width = 32;
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
CNSTF4 1107296256
ASGNF4
line 1234
;1234:		p->alpha = 0.10f;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1036831949
ASGNF4
line 1235
;1235:	}
ADDRGP4 $1437
JUMPV
LABELV $1436
line 1237
;1236:	else
;1237:	{
line 1238
;1238:		p->height = 1;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
CNSTF4 1065353216
ASGNF4
line 1239
;1239:		p->width = 1;
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
CNSTF4 1065353216
ASGNF4
line 1240
;1240:	}
LABELV $1437
line 1242
;1241:
;1242:	p->vel[2] = -20;
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTF4 3248488448
ASGNF4
line 1244
;1243:
;1244:	p->type = P_WEATHER_FLURRY;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 11
ASGNI4
line 1246
;1245:	
;1246:	if (turb)
ADDRLP4 4
INDIRI4
CNSTI4 0
EQI4 $1438
line 1247
;1247:		p->vel[2] = -10;
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTF4 3240099840
ASGNF4
LABELV $1438
line 1249
;1248:	
;1249:	VectorCopy(cent->currentState.origin, p->org);
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 1251
;1250:
;1251:	p->org[0] = p->org[0];
ADDRLP4 12
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRF4
ASGNF4
line 1252
;1252:	p->org[1] = p->org[1];
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRF4
ASGNF4
line 1253
;1253:	p->org[2] = p->org[2];
ADDRLP4 20
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
ASGNP4
ADDRLP4 20
INDIRP4
ADDRLP4 20
INDIRP4
INDIRF4
ASGNF4
line 1255
;1254:
;1255:	p->vel[0] = p->vel[1] = 0;
ADDRLP4 28
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
ADDRLP4 28
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ADDRLP4 28
INDIRF4
ASGNF4
line 1257
;1256:	
;1257:	p->accel[0] = p->accel[1] = p->accel[2] = 0;
ADDRLP4 36
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 36
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 36
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 36
INDIRF4
ASGNF4
line 1259
;1258:
;1259:	p->vel[0] += cent->currentState.angles[0] * 32 + (crandom() * 16);
ADDRLP4 40
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 44
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ASGNP4
ADDRLP4 44
INDIRP4
ADDRLP4 44
INDIRP4
INDIRF4
CNSTF4 1107296256
ADDRFP4 4
INDIRP4
CNSTI4 116
ADDP4
INDIRF4
MULF4
CNSTF4 1098907648
CNSTF4 1073741824
ADDRLP4 40
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ADDF4
ASGNF4
line 1260
;1260:	p->vel[1] += cent->currentState.angles[1] * 32 + (crandom() * 16);
ADDRLP4 48
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 52
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
ASGNP4
ADDRLP4 52
INDIRP4
ADDRLP4 52
INDIRP4
INDIRF4
CNSTF4 1107296256
ADDRFP4 4
INDIRP4
CNSTI4 120
ADDP4
INDIRF4
MULF4
CNSTF4 1098907648
CNSTF4 1073741824
ADDRLP4 48
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ADDF4
ASGNF4
line 1261
;1261:	p->vel[2] += cent->currentState.angles[2];
ADDRLP4 56
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 56
INDIRP4
ADDRLP4 56
INDIRP4
INDIRF4
ADDRFP4 4
INDIRP4
CNSTI4 124
ADDP4
INDIRF4
ADDF4
ASGNF4
line 1263
;1262:
;1263:	if (turb)
ADDRLP4 4
INDIRI4
CNSTI4 0
EQI4 $1440
line 1264
;1264:	{
line 1265
;1265:		p->accel[0] = crandom () * 16;
ADDRLP4 60
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
CNSTF4 1098907648
CNSTF4 1073741824
ADDRLP4 60
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 1266
;1266:		p->accel[1] = crandom () * 16;
ADDRLP4 64
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 1098907648
CNSTF4 1073741824
ADDRLP4 64
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 1267
;1267:	}
LABELV $1440
line 1269
;1268:
;1269:}
LABELV $1427
endproc CG_ParticleSnowFlurry 68 4
export CG_ParticleSnow
proc CG_ParticleSnow 56 4
line 1272
;1270:
;1271:void CG_ParticleSnow (qhandle_t pshader, vec3_t origin, vec3_t origin2, int turb, float range, int snum)
;1272:{
line 1275
;1273:	cparticle_t	*p;
;1274:
;1275:	if (!pshader)
ADDRFP4 0
INDIRI4
CNSTI4 0
NEI4 $1443
line 1276
;1276:		CG_Printf ("CG_ParticleSnow pshader == ZERO!\n");
ADDRGP4 $1445
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $1443
line 1278
;1277:
;1278:	if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1446
line 1279
;1279:		return;
ADDRGP4 $1442
JUMPV
LABELV $1446
line 1280
;1280:	p = free_particles;
ADDRLP4 0
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1281
;1281:	free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 1282
;1282:	p->next = active_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 1283
;1283:	active_particles = p;
ADDRGP4 active_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1284
;1284:	p->time = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ASGNF4
line 1285
;1285:	p->color = 0;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 0
ASGNI4
line 1286
;1286:	p->alpha = 0.40f;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1053609165
ASGNF4
line 1287
;1287:	p->alphavel = 0;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 1288
;1288:	p->start = origin[2];
ADDRLP4 0
INDIRP4
CNSTI4 88
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ASGNF4
line 1289
;1289:	p->end = origin2[2];
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ASGNF4
line 1290
;1290:	p->pshader = pshader;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 0
INDIRI4
ASGNI4
line 1291
;1291:	p->height = 1;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
CNSTF4 1065353216
ASGNF4
line 1292
;1292:	p->width = 1;
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
CNSTF4 1065353216
ASGNF4
line 1294
;1293:	
;1294:	p->vel[2] = -50;
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTF4 3259498496
ASGNF4
line 1296
;1295:
;1296:	if (turb)
ADDRFP4 12
INDIRI4
CNSTI4 0
EQI4 $1449
line 1297
;1297:	{
line 1298
;1298:		p->type = P_WEATHER_TURBULENT;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 5
ASGNI4
line 1299
;1299:		p->vel[2] = -50 * 1.3;
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTF4 3263299584
ASGNF4
line 1300
;1300:	}
ADDRGP4 $1450
JUMPV
LABELV $1449
line 1302
;1301:	else
;1302:	{
line 1303
;1303:		p->type = P_WEATHER;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 1
ASGNI4
line 1304
;1304:	}
LABELV $1450
line 1306
;1305:	
;1306:	VectorCopy(origin, p->org);
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 1308
;1307:
;1308:	p->org[0] = p->org[0] + ( crandom() * range);
ADDRLP4 4
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 8
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRF4
CNSTF4 1073741824
ADDRLP4 4
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
ADDRFP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
line 1309
;1309:	p->org[1] = p->org[1] + ( crandom() * range);
ADDRLP4 12
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRF4
CNSTF4 1073741824
ADDRLP4 12
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
ADDRFP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
line 1310
;1310:	p->org[2] = p->org[2] + ( crandom() * (p->start - p->end)); 
ADDRLP4 20
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 24
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRF4
CNSTF4 1073741824
ADDRLP4 20
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
ADDRLP4 0
INDIRP4
CNSTI4 88
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 1312
;1311:
;1312:	p->vel[0] = p->vel[1] = 0;
ADDRLP4 36
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
ADDRLP4 36
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ADDRLP4 36
INDIRF4
ASGNF4
line 1314
;1313:	
;1314:	p->accel[0] = p->accel[1] = p->accel[2] = 0;
ADDRLP4 44
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 44
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 44
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 44
INDIRF4
ASGNF4
line 1316
;1315:
;1316:	if (turb)
ADDRFP4 12
INDIRI4
CNSTI4 0
EQI4 $1451
line 1317
;1317:	{
line 1318
;1318:		p->vel[0] = crandom() * 16;
ADDRLP4 48
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
CNSTF4 1098907648
CNSTF4 1073741824
ADDRLP4 48
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 1319
;1319:		p->vel[1] = crandom() * 16;
ADDRLP4 52
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTF4 1098907648
CNSTF4 1073741824
ADDRLP4 52
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 1320
;1320:	}
LABELV $1451
line 1323
;1321:
;1322:	// Rafael snow pvs check
;1323:	p->snum = snum;
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
ADDRFP4 20
INDIRI4
ASGNI4
line 1324
;1324:	p->link = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 108
ADDP4
CNSTI4 1
ASGNI4
line 1326
;1325:
;1326:}
LABELV $1442
endproc CG_ParticleSnow 56 4
export CG_ParticleBubble
proc CG_ParticleBubble 68 4
line 1329
;1327:
;1328:void CG_ParticleBubble (qhandle_t pshader, vec3_t origin, vec3_t origin2, int turb, float range, int snum)
;1329:{
line 1333
;1330:	cparticle_t	*p;
;1331:	float		randsize;
;1332:
;1333:	if (!pshader)
ADDRFP4 0
INDIRI4
CNSTI4 0
NEI4 $1454
line 1334
;1334:		CG_Printf ("CG_ParticleSnow pshader == ZERO!\n");
ADDRGP4 $1445
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $1454
line 1336
;1335:
;1336:	if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1456
line 1337
;1337:		return;
ADDRGP4 $1453
JUMPV
LABELV $1456
line 1338
;1338:	p = free_particles;
ADDRLP4 0
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1339
;1339:	free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 1340
;1340:	p->next = active_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 1341
;1341:	active_particles = p;
ADDRGP4 active_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1342
;1342:	p->time = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ASGNF4
line 1343
;1343:	p->color = 0;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 0
ASGNI4
line 1344
;1344:	p->alpha = 0.40f;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1053609165
ASGNF4
line 1345
;1345:	p->alphavel = 0;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 1346
;1346:	p->start = origin[2];
ADDRLP4 0
INDIRP4
CNSTI4 88
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ASGNF4
line 1347
;1347:	p->end = origin2[2];
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ASGNF4
line 1348
;1348:	p->pshader = pshader;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 0
INDIRI4
ASGNI4
line 1350
;1349:	
;1350:	randsize = 1 + (crandom() * 0.5);
ADDRLP4 8
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 4
CNSTF4 1056964608
CNSTF4 1073741824
ADDRLP4 8
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1065353216
ADDF4
ASGNF4
line 1352
;1351:	
;1352:	p->height = randsize;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
ADDRLP4 4
INDIRF4
ASGNF4
line 1353
;1353:	p->width = randsize;
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
ADDRLP4 4
INDIRF4
ASGNF4
line 1355
;1354:	
;1355:	p->vel[2] = 50 + ( crandom() * 10 );
ADDRLP4 12
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTF4 1092616192
CNSTF4 1073741824
ADDRLP4 12
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1112014848
ADDF4
ASGNF4
line 1357
;1356:
;1357:	if (turb)
ADDRFP4 12
INDIRI4
CNSTI4 0
EQI4 $1459
line 1358
;1358:	{
line 1359
;1359:		p->type = P_BUBBLE_TURBULENT;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 14
ASGNI4
line 1360
;1360:		p->vel[2] = 50 * 1.3;
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTF4 1115815936
ASGNF4
line 1361
;1361:	}
ADDRGP4 $1460
JUMPV
LABELV $1459
line 1363
;1362:	else
;1363:	{
line 1364
;1364:		p->type = P_BUBBLE;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 13
ASGNI4
line 1365
;1365:	}
LABELV $1460
line 1367
;1366:	
;1367:	VectorCopy(origin, p->org);
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 1369
;1368:
;1369:	p->org[0] = p->org[0] + ( crandom() * range);
ADDRLP4 16
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 20
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 20
INDIRP4
ADDRLP4 20
INDIRP4
INDIRF4
CNSTF4 1073741824
ADDRLP4 16
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
ADDRFP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
line 1370
;1370:	p->org[1] = p->org[1] + ( crandom() * range);
ADDRLP4 24
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 28
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRF4
CNSTF4 1073741824
ADDRLP4 24
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
ADDRFP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
line 1371
;1371:	p->org[2] = p->org[2] + ( crandom() * (p->start - p->end)); 
ADDRLP4 32
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 36
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
ASGNP4
ADDRLP4 36
INDIRP4
ADDRLP4 36
INDIRP4
INDIRF4
CNSTF4 1073741824
ADDRLP4 32
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
ADDRLP4 0
INDIRP4
CNSTI4 88
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 1373
;1372:
;1373:	p->vel[0] = p->vel[1] = 0;
ADDRLP4 48
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
ADDRLP4 48
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ADDRLP4 48
INDIRF4
ASGNF4
line 1375
;1374:	
;1375:	p->accel[0] = p->accel[1] = p->accel[2] = 0;
ADDRLP4 56
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 56
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 56
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 56
INDIRF4
ASGNF4
line 1377
;1376:
;1377:	if (turb)
ADDRFP4 12
INDIRI4
CNSTI4 0
EQI4 $1461
line 1378
;1378:	{
line 1379
;1379:		p->vel[0] = crandom() * 4;
ADDRLP4 60
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
CNSTF4 1082130432
CNSTF4 1073741824
ADDRLP4 60
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 1380
;1380:		p->vel[1] = crandom() * 4;
ADDRLP4 64
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTF4 1082130432
CNSTF4 1073741824
ADDRLP4 64
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 1381
;1381:	}
LABELV $1461
line 1384
;1382:
;1383:	// Rafael snow pvs check
;1384:	p->snum = snum;
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
ADDRFP4 20
INDIRI4
ASGNI4
line 1385
;1385:	p->link = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 108
ADDP4
CNSTI4 1
ASGNI4
line 1387
;1386:
;1387:}
LABELV $1453
endproc CG_ParticleBubble 68 4
export CG_ParticleSmoke
proc CG_ParticleSmoke 28 4
line 1390
;1388:
;1389:void CG_ParticleSmoke (qhandle_t pshader, centity_t *cent)
;1390:{
line 1396
;1391:
;1392:	// using cent->density = enttime
;1393:	//		 cent->frame = startfade
;1394:	cparticle_t	*p;
;1395:
;1396:	if (!pshader)
ADDRFP4 0
INDIRI4
CNSTI4 0
NEI4 $1464
line 1397
;1397:		CG_Printf ("CG_ParticleSmoke == ZERO!\n");
ADDRGP4 $1466
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $1464
line 1399
;1398:
;1399:	if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1467
line 1400
;1400:		return;
ADDRGP4 $1463
JUMPV
LABELV $1467
line 1401
;1401:	p = free_particles;
ADDRLP4 0
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1402
;1402:	free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 1403
;1403:	p->next = active_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 1404
;1404:	active_particles = p;
ADDRGP4 active_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1405
;1405:	p->time = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ASGNF4
line 1407
;1406:	
;1407:	p->endtime = cg.time + cent->currentState.time;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+64
INDIRI4
ADDRFP4 4
INDIRP4
CNSTI4 84
ADDP4
INDIRI4
ADDI4
CVIF4 4
ASGNF4
line 1408
;1408:	p->startfade = cg.time + cent->currentState.time2;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
ADDRGP4 cg+64
INDIRI4
ADDRFP4 4
INDIRP4
CNSTI4 88
ADDP4
INDIRI4
ADDI4
CVIF4 4
ASGNF4
line 1410
;1409:	
;1410:	p->color = 0;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 0
ASGNI4
line 1411
;1411:	p->alpha = 1.0;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1065353216
ASGNF4
line 1412
;1412:	p->alphavel = 0;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 1413
;1413:	p->start = cent->currentState.origin[2];
ADDRLP4 0
INDIRP4
CNSTI4 88
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 100
ADDP4
INDIRF4
ASGNF4
line 1414
;1414:	p->end = cent->currentState.origin2[2];
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 112
ADDP4
INDIRF4
ASGNF4
line 1415
;1415:	p->pshader = pshader;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 0
INDIRI4
ASGNI4
line 1416
;1416:	p->rotate = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 100
ADDP4
CNSTI4 0
ASGNI4
line 1417
;1417:	p->height = 8;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
CNSTF4 1090519040
ASGNF4
line 1418
;1418:	p->width = 8;
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
CNSTF4 1090519040
ASGNF4
line 1419
;1419:	p->endheight = 32;
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
CNSTF4 1107296256
ASGNF4
line 1420
;1420:	p->endwidth = 32;
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
CNSTF4 1107296256
ASGNF4
line 1421
;1421:	p->type = P_SMOKE;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 3
ASGNI4
line 1423
;1422:	
;1423:	VectorCopy(cent->currentState.origin, p->org);
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 1425
;1424:
;1425:	p->vel[0] = p->vel[1] = 0;
ADDRLP4 8
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
ADDRLP4 8
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ADDRLP4 8
INDIRF4
ASGNF4
line 1426
;1426:	p->accel[0] = p->accel[1] = p->accel[2] = 0;
ADDRLP4 16
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 16
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 16
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 16
INDIRF4
ASGNF4
line 1428
;1427:
;1428:	p->vel[2] = 5;
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTF4 1084227584
ASGNF4
line 1430
;1429:
;1430:	if (cent->currentState.frame == 1)// reverse gravity	
ADDRFP4 4
INDIRP4
CNSTI4 224
ADDP4
INDIRI4
CNSTI4 1
NEI4 $1472
line 1431
;1431:		p->vel[2] *= -1;
ADDRLP4 20
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 20
INDIRP4
CNSTF4 3212836864
ADDRLP4 20
INDIRP4
INDIRF4
MULF4
ASGNF4
LABELV $1472
line 1433
;1432:
;1433:	p->roll = 8 + (crandom() * 4);
ADDRLP4 24
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
CNSTF4 1082130432
CNSTF4 1073741824
ADDRLP4 24
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1090519040
ADDF4
CVFI4 4
ASGNI4
line 1434
;1434:}
LABELV $1463
endproc CG_ParticleSmoke 28 4
export CG_ParticleBulletDebris
proc CG_ParticleBulletDebris 16 0
line 1438
;1435:
;1436:
;1437:void CG_ParticleBulletDebris (vec3_t org, vec3_t vel, int duration)
;1438:{
line 1442
;1439:
;1440:	cparticle_t	*p;
;1441:
;1442:	if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1475
line 1443
;1443:		return;
ADDRGP4 $1474
JUMPV
LABELV $1475
line 1444
;1444:	p = free_particles;
ADDRLP4 0
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1445
;1445:	free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 1446
;1446:	p->next = active_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 1447
;1447:	active_particles = p;
ADDRGP4 active_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1448
;1448:	p->time = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ASGNF4
line 1450
;1449:	
;1450:	p->endtime = cg.time + duration;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+64
INDIRI4
ADDRFP4 8
INDIRI4
ADDI4
CVIF4 4
ASGNF4
line 1451
;1451:	p->startfade = cg.time + duration/2;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
ADDRGP4 cg+64
INDIRI4
ADDRFP4 8
INDIRI4
CNSTI4 2
DIVI4
ADDI4
CVIF4 4
ASGNF4
line 1453
;1452:	
;1453:	p->color = EMISIVEFADE;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 3
ASGNI4
line 1454
;1454:	p->alpha = 1.0;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1065353216
ASGNF4
line 1455
;1455:	p->alphavel = 0;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 1457
;1456:
;1457:	p->height = 0.5;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
CNSTF4 1056964608
ASGNF4
line 1458
;1458:	p->width = 0.5;
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
CNSTF4 1056964608
ASGNF4
line 1459
;1459:	p->endheight = 0.5;
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
CNSTF4 1056964608
ASGNF4
line 1460
;1460:	p->endwidth = 0.5;
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
CNSTF4 1056964608
ASGNF4
line 1462
;1461:
;1462:	p->pshader = cgs.media.tracerShader;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRGP4 cgs+70296+196
INDIRI4
ASGNI4
line 1464
;1463:
;1464:	p->type = P_SMOKE;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 3
ASGNI4
line 1466
;1465:	
;1466:	VectorCopy(org, p->org);
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 1468
;1467:
;1468:	p->vel[0] = vel[0];
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ADDRFP4 4
INDIRP4
INDIRF4
ASGNF4
line 1469
;1469:	p->vel[1] = vel[1];
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ASGNF4
line 1470
;1470:	p->vel[2] = vel[2];
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ASGNF4
line 1471
;1471:	p->accel[0] = p->accel[1] = p->accel[2] = 0;
ADDRLP4 8
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 8
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 8
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 8
INDIRF4
ASGNF4
line 1473
;1472:
;1473:	p->accel[2] = -60;
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
CNSTF4 3262119936
ASGNF4
line 1474
;1474:	p->vel[2] += -20;
ADDRLP4 12
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRF4
CNSTF4 3248488448
ADDF4
ASGNF4
line 1476
;1475:	
;1476:}
LABELV $1474
endproc CG_ParticleBulletDebris 16 0
export CG_ParticleExplosion
proc CG_ParticleExplosion 16 8
line 1485
;1477:
;1478:/*
;1479:======================
;1480:CG_ParticleExplosion
;1481:======================
;1482:*/
;1483:
;1484:void CG_ParticleExplosion (char *animStr, vec3_t origin, vec3_t vel, int duration, int sizeStart, int sizeEnd)
;1485:{
line 1489
;1486:	cparticle_t	*p;
;1487:	int anim;
;1488:
;1489:	if (animStr < (char *)10)
ADDRFP4 0
INDIRP4
CVPU4 4
CNSTU4 10
GEU4 $1483
line 1490
;1490:		CG_Error( "CG_ParticleExplosion: animStr is probably an index rather than a string" );
ADDRGP4 $1485
ARGP4
ADDRGP4 CG_Error
CALLV
pop
LABELV $1483
line 1493
;1491:
;1492:	// find the animation string
;1493:	for (anim=0; shaderAnimNames[anim]; anim++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $1489
JUMPV
LABELV $1486
line 1494
;1494:		if (!Q_stricmp( animStr, shaderAnimNames[anim] ))
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 shaderAnimNames
ADDP4
INDIRP4
ARGP4
ADDRLP4 8
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 0
NEI4 $1490
line 1495
;1495:			break;
ADDRGP4 $1488
JUMPV
LABELV $1490
line 1496
;1496:	}
LABELV $1487
line 1493
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $1489
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 shaderAnimNames
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1486
LABELV $1488
line 1497
;1497:	if (!shaderAnimNames[anim]) {
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 shaderAnimNames
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1492
line 1498
;1498:		CG_Error("CG_ParticleExplosion: unknown animation string: %s\n", animStr);
ADDRGP4 $1494
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_Error
CALLV
pop
line 1499
;1499:		return;
ADDRGP4 $1482
JUMPV
LABELV $1492
line 1502
;1500:	}
;1501:
;1502:	if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1495
line 1503
;1503:		return;
ADDRGP4 $1482
JUMPV
LABELV $1495
line 1504
;1504:	p = free_particles;
ADDRLP4 4
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1505
;1505:	free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 4
INDIRP4
INDIRP4
ASGNP4
line 1506
;1506:	p->next = active_particles;
ADDRLP4 4
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 1507
;1507:	active_particles = p;
ADDRGP4 active_particles
ADDRLP4 4
INDIRP4
ASGNP4
line 1508
;1508:	p->time = cg.time;
ADDRLP4 4
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ASGNF4
line 1509
;1509:	p->alpha = 0.5;
ADDRLP4 4
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1056964608
ASGNF4
line 1510
;1510:	p->alphavel = 0;
ADDRLP4 4
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 1512
;1511:
;1512:	if (duration < 0) {
ADDRFP4 12
INDIRI4
CNSTI4 0
GEI4 $1498
line 1513
;1513:		duration *= -1;
ADDRFP4 12
CNSTI4 -1
ADDRFP4 12
INDIRI4
MULI4
ASGNI4
line 1514
;1514:		p->roll = 0;
ADDRLP4 4
INDIRP4
CNSTI4 116
ADDP4
CNSTI4 0
ASGNI4
line 1515
;1515:	} else {
ADDRGP4 $1499
JUMPV
LABELV $1498
line 1516
;1516:		p->roll = crandom()*179;
ADDRLP4 8
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 4
INDIRP4
CNSTI4 116
ADDP4
CNSTF4 1127415808
CNSTF4 1073741824
ADDRLP4 8
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CVFI4 4
ASGNI4
line 1517
;1517:	}
LABELV $1499
line 1519
;1518:
;1519:	p->shaderAnim = anim;
ADDRLP4 4
INDIRP4
CNSTI4 112
ADDP4
ADDRLP4 0
INDIRI4
ASGNI4
line 1521
;1520:
;1521:	p->width = sizeStart;
ADDRLP4 4
INDIRP4
CNSTI4 76
ADDP4
ADDRFP4 16
INDIRI4
CVIF4 4
ASGNF4
line 1522
;1522:	p->height = sizeStart*shaderAnimSTRatio[anim];	// for sprites that are stretch in either direction
ADDRLP4 4
INDIRP4
CNSTI4 72
ADDP4
ADDRFP4 16
INDIRI4
CVIF4 4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 shaderAnimSTRatio
ADDP4
INDIRF4
MULF4
ASGNF4
line 1524
;1523:
;1524:	p->endheight = sizeEnd;
ADDRLP4 4
INDIRP4
CNSTI4 80
ADDP4
ADDRFP4 20
INDIRI4
CVIF4 4
ASGNF4
line 1525
;1525:	p->endwidth = sizeEnd*shaderAnimSTRatio[anim];
ADDRLP4 4
INDIRP4
CNSTI4 84
ADDP4
ADDRFP4 20
INDIRI4
CVIF4 4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 shaderAnimSTRatio
ADDP4
INDIRF4
MULF4
ASGNF4
line 1527
;1526:
;1527:	p->endtime = cg.time + duration;
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+64
INDIRI4
ADDRFP4 12
INDIRI4
ADDI4
CVIF4 4
ASGNF4
line 1529
;1528:
;1529:	p->type = P_ANIM;
ADDRLP4 4
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 6
ASGNI4
line 1531
;1530:
;1531:	VectorCopy( origin, p->org );
ADDRLP4 4
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 1532
;1532:	VectorCopy( vel, p->vel );
ADDRLP4 4
INDIRP4
CNSTI4 24
ADDP4
ADDRFP4 8
INDIRP4
INDIRB
ASGNB 12
line 1533
;1533:	VectorClear( p->accel );
ADDRLP4 12
CNSTF4 0
ASGNF4
ADDRLP4 4
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 12
INDIRF4
ASGNF4
ADDRLP4 4
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 12
INDIRF4
ASGNF4
ADDRLP4 4
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 12
INDIRF4
ASGNF4
line 1535
;1534:
;1535:}
LABELV $1482
endproc CG_ParticleExplosion 16 8
export CG_AddParticleShrapnel
proc CG_AddParticleShrapnel 0 0
line 1539
;1536:
;1537:// Rafael Shrapnel
;1538:void CG_AddParticleShrapnel (localEntity_t *le)
;1539:{
line 1540
;1540:	return;
LABELV $1501
endproc CG_AddParticleShrapnel 0 0
export CG_NewParticleArea
proc CG_NewParticleArea 92 24
line 1545
;1541:}
;1542:// done.
;1543:
;1544:int CG_NewParticleArea (int num)
;1545:{
line 1552
;1546:	// const char *str;
;1547:	char *str;
;1548:	char *token;
;1549:	int type;
;1550:	vec3_t origin, origin2;
;1551:	int		i;
;1552:	float range = 0;
ADDRLP4 40
CNSTF4 0
ASGNF4
line 1557
;1553:	int turb;
;1554:	int	numparticles;
;1555:	int	snum;
;1556:	
;1557:	str = (char *) CG_ConfigString (num);
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 56
ADDRGP4 CG_ConfigString
CALLP4
ASGNP4
ADDRLP4 8
ADDRLP4 56
INDIRP4
ASGNP4
line 1558
;1558:	if (!str[0])
ADDRLP4 8
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $1503
line 1559
;1559:		return (0);
CNSTI4 0
RETI4
ADDRGP4 $1502
JUMPV
LABELV $1503
line 1562
;1560:	
;1561:	// returns type 128 64 or 32
;1562:	token = COM_Parse ((const char **)&str);
ADDRLP4 8
ARGP4
ADDRLP4 60
ADDRGP4 COM_Parse
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 60
INDIRP4
ASGNP4
line 1563
;1563:	type = atoi (token);
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 64
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 36
ADDRLP4 64
INDIRI4
ASGNI4
line 1565
;1564:	
;1565:	if (type == 1)
ADDRLP4 36
INDIRI4
CNSTI4 1
NEI4 $1505
line 1566
;1566:		range = 128;
ADDRLP4 40
CNSTF4 1124073472
ASGNF4
ADDRGP4 $1506
JUMPV
LABELV $1505
line 1567
;1567:	else if (type == 2)
ADDRLP4 36
INDIRI4
CNSTI4 2
NEI4 $1507
line 1568
;1568:		range = 64;
ADDRLP4 40
CNSTF4 1115684864
ASGNF4
ADDRGP4 $1508
JUMPV
LABELV $1507
line 1569
;1569:	else if (type == 3)
ADDRLP4 36
INDIRI4
CNSTI4 3
NEI4 $1509
line 1570
;1570:		range = 32;
ADDRLP4 40
CNSTF4 1107296256
ASGNF4
ADDRGP4 $1510
JUMPV
LABELV $1509
line 1571
;1571:	else if (type == 0)
ADDRLP4 36
INDIRI4
CNSTI4 0
NEI4 $1511
line 1572
;1572:		range = 256;
ADDRLP4 40
CNSTF4 1132462080
ASGNF4
ADDRGP4 $1512
JUMPV
LABELV $1511
line 1573
;1573:	else if (type == 4)
ADDRLP4 36
INDIRI4
CNSTI4 4
NEI4 $1513
line 1574
;1574:		range = 8;
ADDRLP4 40
CNSTF4 1090519040
ASGNF4
ADDRGP4 $1514
JUMPV
LABELV $1513
line 1575
;1575:	else if (type == 5)
ADDRLP4 36
INDIRI4
CNSTI4 5
NEI4 $1515
line 1576
;1576:		range = 16;
ADDRLP4 40
CNSTF4 1098907648
ASGNF4
ADDRGP4 $1516
JUMPV
LABELV $1515
line 1577
;1577:	else if (type == 6)
ADDRLP4 36
INDIRI4
CNSTI4 6
NEI4 $1517
line 1578
;1578:		range = 32;
ADDRLP4 40
CNSTF4 1107296256
ASGNF4
ADDRGP4 $1518
JUMPV
LABELV $1517
line 1579
;1579:	else if (type == 7)
ADDRLP4 36
INDIRI4
CNSTI4 7
NEI4 $1519
line 1580
;1580:		range = 64;
ADDRLP4 40
CNSTF4 1115684864
ASGNF4
LABELV $1519
LABELV $1518
LABELV $1516
LABELV $1514
LABELV $1512
LABELV $1510
LABELV $1508
LABELV $1506
line 1583
;1581:
;1582:
;1583:	for (i=0; i<3; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $1521
line 1584
;1584:	{
line 1585
;1585:		token = COM_Parse ((const char **)&str);
ADDRLP4 8
ARGP4
ADDRLP4 68
ADDRGP4 COM_Parse
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 68
INDIRP4
ASGNP4
line 1586
;1586:		origin[i] = atof (token);
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 72
ADDRGP4 atof
CALLF4
ASGNF4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 12
ADDP4
ADDRLP4 72
INDIRF4
ASGNF4
line 1587
;1587:	}
LABELV $1522
line 1583
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $1521
line 1589
;1588:
;1589:	for (i=0; i<3; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $1525
line 1590
;1590:	{
line 1591
;1591:		token = COM_Parse ((const char **)&str);
ADDRLP4 8
ARGP4
ADDRLP4 68
ADDRGP4 COM_Parse
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 68
INDIRP4
ASGNP4
line 1592
;1592:		origin2[i] = atof (token);
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 72
ADDRGP4 atof
CALLF4
ASGNF4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 24
ADDP4
ADDRLP4 72
INDIRF4
ASGNF4
line 1593
;1593:	}
LABELV $1526
line 1589
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $1525
line 1595
;1594:		
;1595:	token = COM_Parse ((const char **)&str);
ADDRLP4 8
ARGP4
ADDRLP4 68
ADDRGP4 COM_Parse
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 68
INDIRP4
ASGNP4
line 1596
;1596:	numparticles = atoi (token);
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 72
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 48
ADDRLP4 72
INDIRI4
ASGNI4
line 1598
;1597:	
;1598:	token = COM_Parse ((const char **)&str);
ADDRLP4 8
ARGP4
ADDRLP4 76
ADDRGP4 COM_Parse
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 76
INDIRP4
ASGNP4
line 1599
;1599:	turb = atoi (token);
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 80
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 44
ADDRLP4 80
INDIRI4
ASGNI4
line 1601
;1600:
;1601:	token = COM_Parse ((const char **)&str);
ADDRLP4 8
ARGP4
ADDRLP4 84
ADDRGP4 COM_Parse
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 84
INDIRP4
ASGNP4
line 1602
;1602:	snum = atoi (token);
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 88
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 52
ADDRLP4 88
INDIRI4
ASGNI4
line 1604
;1603:	
;1604:	for (i=0; i<numparticles; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $1532
JUMPV
LABELV $1529
line 1605
;1605:	{
line 1606
;1606:		if (type >= 4)
ADDRLP4 36
INDIRI4
CNSTI4 4
LTI4 $1533
line 1607
;1607:			CG_ParticleBubble (cgs.media.waterBubbleShader, origin, origin2, turb, range, snum);
ADDRGP4 cgs+70296+256
INDIRI4
ARGI4
ADDRLP4 12
ARGP4
ADDRLP4 24
ARGP4
ADDRLP4 44
INDIRI4
ARGI4
ADDRLP4 40
INDIRF4
ARGF4
ADDRLP4 52
INDIRI4
ARGI4
ADDRGP4 CG_ParticleBubble
CALLV
pop
ADDRGP4 $1534
JUMPV
LABELV $1533
line 1609
;1608:		else
;1609:			CG_ParticleSnow (cgs.media.waterBubbleShader, origin, origin2, turb, range, snum);
ADDRGP4 cgs+70296+256
INDIRI4
ARGI4
ADDRLP4 12
ARGP4
ADDRLP4 24
ARGP4
ADDRLP4 44
INDIRI4
ARGI4
ADDRLP4 40
INDIRF4
ARGF4
ADDRLP4 52
INDIRI4
ARGI4
ADDRGP4 CG_ParticleSnow
CALLV
pop
LABELV $1534
line 1610
;1610:	}
LABELV $1530
line 1604
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $1532
ADDRLP4 0
INDIRI4
ADDRLP4 48
INDIRI4
LTI4 $1529
line 1612
;1611:
;1612:	return (1);
CNSTI4 1
RETI4
LABELV $1502
endproc CG_NewParticleArea 92 24
export CG_SnowLink
proc CG_SnowLink 16 0
line 1616
;1613:}
;1614:
;1615:void	CG_SnowLink (centity_t *cent, qboolean particleOn)
;1616:{
line 1620
;1617:	cparticle_t		*p, *next;
;1618:	int id;
;1619:
;1620:	id = cent->currentState.frame;
ADDRLP4 8
ADDRFP4 0
INDIRP4
CNSTI4 224
ADDP4
INDIRI4
ASGNI4
line 1622
;1621:
;1622:	for (p=active_particles ; p ; p=next)
ADDRLP4 0
ADDRGP4 active_particles
INDIRP4
ASGNP4
ADDRGP4 $1543
JUMPV
LABELV $1540
line 1623
;1623:	{
line 1624
;1624:		next = p->next;
ADDRLP4 4
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 1626
;1625:		
;1626:		if (p->type == P_WEATHER || p->type == P_WEATHER_TURBULENT)
ADDRLP4 12
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
ASGNI4
ADDRLP4 12
INDIRI4
CNSTI4 1
EQI4 $1546
ADDRLP4 12
INDIRI4
CNSTI4 5
NEI4 $1544
LABELV $1546
line 1627
;1627:		{
line 1628
;1628:			if (p->snum == id)
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
INDIRI4
ADDRLP4 8
INDIRI4
NEI4 $1547
line 1629
;1629:			{
line 1630
;1630:				if (particleOn)
ADDRFP4 4
INDIRI4
CNSTI4 0
EQI4 $1549
line 1631
;1631:					p->link = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 108
ADDP4
CNSTI4 1
ASGNI4
ADDRGP4 $1550
JUMPV
LABELV $1549
line 1633
;1632:				else
;1633:					p->link = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 108
ADDP4
CNSTI4 0
ASGNI4
LABELV $1550
line 1634
;1634:			}
LABELV $1547
line 1635
;1635:		}
LABELV $1544
line 1637
;1636:
;1637:	}
LABELV $1541
line 1622
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
LABELV $1543
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1540
line 1638
;1638:}
LABELV $1539
endproc CG_SnowLink 16 0
export CG_ParticleImpactSmokePuff
proc CG_ParticleImpactSmokePuff 24 4
line 1641
;1639:
;1640:void CG_ParticleImpactSmokePuff (qhandle_t pshader, vec3_t origin)
;1641:{
line 1644
;1642:	cparticle_t	*p;
;1643:
;1644:	if (!pshader)
ADDRFP4 0
INDIRI4
CNSTI4 0
NEI4 $1552
line 1645
;1645:		CG_Printf ("CG_ParticleImpactSmokePuff pshader == ZERO!\n");
ADDRGP4 $1554
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $1552
line 1647
;1646:
;1647:	if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1555
line 1648
;1648:		return;
ADDRGP4 $1551
JUMPV
LABELV $1555
line 1649
;1649:	p = free_particles;
ADDRLP4 0
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1650
;1650:	free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 1651
;1651:	p->next = active_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 1652
;1652:	active_particles = p;
ADDRGP4 active_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1653
;1653:	p->time = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ASGNF4
line 1654
;1654:	p->alpha = 0.25;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1048576000
ASGNF4
line 1655
;1655:	p->alphavel = 0;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 1656
;1656:	p->roll = crandom()*179;
ADDRLP4 4
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
CNSTF4 1127415808
CNSTF4 1073741824
ADDRLP4 4
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CVFI4 4
ASGNI4
line 1658
;1657:
;1658:	p->pshader = pshader;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 0
INDIRI4
ASGNI4
line 1660
;1659:
;1660:	p->endtime = cg.time + 1000;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+64
INDIRI4
CNSTI4 1000
ADDI4
CVIF4 4
ASGNF4
line 1661
;1661:	p->startfade = cg.time + 100;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
ADDRGP4 cg+64
INDIRI4
CNSTI4 100
ADDI4
CVIF4 4
ASGNF4
line 1663
;1662:
;1663:	p->width = rand()%4 + 8;
ADDRLP4 8
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
ADDRLP4 8
INDIRI4
CNSTI4 4
MODI4
CNSTI4 8
ADDI4
CVIF4 4
ASGNF4
line 1664
;1664:	p->height = rand()%4 + 8;
ADDRLP4 12
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
ADDRLP4 12
INDIRI4
CNSTI4 4
MODI4
CNSTI4 8
ADDI4
CVIF4 4
ASGNF4
line 1666
;1665:
;1666:	p->endheight = p->height *2;
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
CNSTF4 1073741824
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
MULF4
ASGNF4
line 1667
;1667:	p->endwidth = p->width * 2;
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
CNSTF4 1073741824
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
MULF4
ASGNF4
line 1669
;1668:
;1669:	p->endtime = cg.time + 500;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+64
INDIRI4
CNSTI4 500
ADDI4
CVIF4 4
ASGNF4
line 1671
;1670:
;1671:	p->type = P_SMOKE_IMPACT;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 12
ASGNI4
line 1673
;1672:
;1673:	VectorCopy( origin, p->org );
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 1674
;1674:	VectorSet(p->vel, 0, 0, 20);
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTF4 1101004800
ASGNF4
line 1675
;1675:	VectorSet(p->accel, 0, 0, 20);
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
CNSTF4 1101004800
ASGNF4
line 1677
;1676:
;1677:	p->rotate = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 100
ADDP4
CNSTI4 1
ASGNI4
line 1678
;1678:}
LABELV $1551
endproc CG_ParticleImpactSmokePuff 24 4
export CG_Particle_Bleed
proc CG_Particle_Bleed 24 4
line 1681
;1679:
;1680:void CG_Particle_Bleed (qhandle_t pshader, vec3_t start, vec3_t dir, int fleshEntityNum, int duration)
;1681:{
line 1684
;1682:	cparticle_t	*p;
;1683:
;1684:	if (!pshader)
ADDRFP4 0
INDIRI4
CNSTI4 0
NEI4 $1562
line 1685
;1685:		CG_Printf ("CG_Particle_Bleed pshader == ZERO!\n");
ADDRGP4 $1564
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $1562
line 1687
;1686:
;1687:	if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1565
line 1688
;1688:		return;
ADDRGP4 $1561
JUMPV
LABELV $1565
line 1689
;1689:	p = free_particles;
ADDRLP4 0
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1690
;1690:	free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 1691
;1691:	p->next = active_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 1692
;1692:	active_particles = p;
ADDRGP4 active_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1693
;1693:	p->time = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ASGNF4
line 1694
;1694:	p->alpha = 1.0;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1065353216
ASGNF4
line 1695
;1695:	p->alphavel = 0;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 1696
;1696:	p->roll = 0;
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
CNSTI4 0
ASGNI4
line 1698
;1697:
;1698:	p->pshader = pshader;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 0
INDIRI4
ASGNI4
line 1700
;1699:
;1700:	p->endtime = cg.time + duration;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+64
INDIRI4
ADDRFP4 16
INDIRI4
ADDI4
CVIF4 4
ASGNF4
line 1702
;1701:	
;1702:	if (fleshEntityNum)
ADDRFP4 12
INDIRI4
CNSTI4 0
EQI4 $1569
line 1703
;1703:		p->startfade = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ASGNF4
ADDRGP4 $1570
JUMPV
LABELV $1569
line 1705
;1704:	else
;1705:		p->startfade = cg.time + 100;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
ADDRGP4 cg+64
INDIRI4
CNSTI4 100
ADDI4
CVIF4 4
ASGNF4
LABELV $1570
line 1707
;1706:
;1707:	p->width = 4;
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
CNSTF4 1082130432
ASGNF4
line 1708
;1708:	p->height = 4;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
CNSTF4 1082130432
ASGNF4
line 1710
;1709:
;1710:	p->endheight = 4+rand()%3;
ADDRLP4 4
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
ADDRLP4 4
INDIRI4
CNSTI4 3
MODI4
CNSTI4 4
ADDI4
CVIF4 4
ASGNF4
line 1711
;1711:	p->endwidth = p->endheight;
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
INDIRF4
ASGNF4
line 1713
;1712:
;1713:	p->type = P_SMOKE;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 3
ASGNI4
line 1715
;1714:
;1715:	VectorCopy( start, p->org );
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 1716
;1716:	p->vel[0] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
CNSTF4 0
ASGNF4
line 1717
;1717:	p->vel[1] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTF4 0
ASGNF4
line 1718
;1718:	p->vel[2] = -20;
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTF4 3248488448
ASGNF4
line 1719
;1719:	VectorClear( p->accel );
ADDRLP4 16
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 16
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 16
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 16
INDIRF4
ASGNF4
line 1721
;1720:
;1721:	p->rotate = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 100
ADDP4
CNSTI4 0
ASGNI4
line 1723
;1722:
;1723:	p->roll = rand()%179;
ADDRLP4 20
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
ADDRLP4 20
INDIRI4
CNSTI4 179
MODI4
ASGNI4
line 1725
;1724:	
;1725:	p->color = BLOODRED;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 2
ASGNI4
line 1726
;1726:	p->alpha = 0.75;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1061158912
ASGNF4
line 1728
;1727:
;1728:}
LABELV $1561
endproc CG_Particle_Bleed 24 4
export CG_Particle_OilParticle
proc CG_Particle_OilParticle 36 4
line 1731
;1729:
;1730:void CG_Particle_OilParticle (qhandle_t pshader, centity_t *cent)
;1731:{
line 1738
;1732:	cparticle_t	*p;
;1733:
;1734:	int			time;
;1735:	int			time2;
;1736:	float		ratio;
;1737:
;1738:	float	duration = 1500;
ADDRLP4 16
CNSTF4 1153138688
ASGNF4
line 1740
;1739:
;1740:	time = cg.time;
ADDRLP4 8
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 1741
;1741:	time2 = cg.time + cent->currentState.time;
ADDRLP4 12
ADDRGP4 cg+64
INDIRI4
ADDRFP4 4
INDIRP4
CNSTI4 84
ADDP4
INDIRI4
ADDI4
ASGNI4
line 1743
;1742:
;1743:	ratio =(float)1 - ((float)time / (float)time2);
ADDRLP4 4
CNSTF4 1065353216
ADDRLP4 8
INDIRI4
CVIF4 4
ADDRLP4 12
INDIRI4
CVIF4 4
DIVF4
SUBF4
ASGNF4
line 1745
;1744:
;1745:	if (!pshader)
ADDRFP4 0
INDIRI4
CNSTI4 0
NEI4 $1576
line 1746
;1746:		CG_Printf ("CG_Particle_OilParticle == ZERO!\n");
ADDRGP4 $1578
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $1576
line 1748
;1747:
;1748:	if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1579
line 1749
;1749:		return;
ADDRGP4 $1573
JUMPV
LABELV $1579
line 1750
;1750:	p = free_particles;
ADDRLP4 0
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1751
;1751:	free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 1752
;1752:	p->next = active_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 1753
;1753:	active_particles = p;
ADDRGP4 active_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1754
;1754:	p->time = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ASGNF4
line 1755
;1755:	p->alpha = 1.0;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1065353216
ASGNF4
line 1756
;1756:	p->alphavel = 0;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 1757
;1757:	p->roll = 0;
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
CNSTI4 0
ASGNI4
line 1759
;1758:
;1759:	p->pshader = pshader;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 0
INDIRI4
ASGNI4
line 1761
;1760:
;1761:	p->endtime = cg.time + duration;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ADDRLP4 16
INDIRF4
ADDF4
ASGNF4
line 1763
;1762:	
;1763:	p->startfade = p->endtime;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ASGNF4
line 1765
;1764:
;1765:	p->width = 1;
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
CNSTF4 1065353216
ASGNF4
line 1766
;1766:	p->height = 3;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
CNSTF4 1077936128
ASGNF4
line 1768
;1767:
;1768:	p->endheight = 3;
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
CNSTF4 1077936128
ASGNF4
line 1769
;1769:	p->endwidth = 1;
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
CNSTF4 1065353216
ASGNF4
line 1771
;1770:
;1771:	p->type = P_SMOKE;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 3
ASGNI4
line 1773
;1772:
;1773:	VectorCopy(cent->currentState.origin, p->org );	
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 1775
;1774:	
;1775:	p->vel[0] = (cent->currentState.origin2[0] * (16 * ratio));
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 104
ADDP4
INDIRF4
CNSTF4 1098907648
ADDRLP4 4
INDIRF4
MULF4
MULF4
ASGNF4
line 1776
;1776:	p->vel[1] = (cent->currentState.origin2[1] * (16 * ratio));
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 108
ADDP4
INDIRF4
CNSTF4 1098907648
ADDRLP4 4
INDIRF4
MULF4
MULF4
ASGNF4
line 1777
;1777:	p->vel[2] = (cent->currentState.origin2[2]);
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 112
ADDP4
INDIRF4
ASGNF4
line 1779
;1778:
;1779:	p->snum = 1.0f;
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
CNSTI4 1
ASGNI4
line 1781
;1780:
;1781:	VectorClear( p->accel );
ADDRLP4 28
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 28
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 28
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 28
INDIRF4
ASGNF4
line 1783
;1782:
;1783:	p->accel[2] = -20;
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
CNSTF4 3248488448
ASGNF4
line 1785
;1784:
;1785:	p->rotate = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 100
ADDP4
CNSTI4 0
ASGNI4
line 1787
;1786:
;1787:	p->roll = rand()%179;
ADDRLP4 32
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
ADDRLP4 32
INDIRI4
CNSTI4 179
MODI4
ASGNI4
line 1789
;1788:	
;1789:	p->alpha = 0.75;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1061158912
ASGNF4
line 1791
;1790:
;1791:}
LABELV $1573
endproc CG_Particle_OilParticle 36 4
export CG_Particle_OilSlick
proc CG_Particle_OilSlick 36 4
line 1795
;1792:
;1793:
;1794:void CG_Particle_OilSlick (qhandle_t pshader, centity_t *cent)
;1795:{
line 1798
;1796:	cparticle_t	*p;
;1797:	
;1798:  	if (!pshader)
ADDRFP4 0
INDIRI4
CNSTI4 0
NEI4 $1584
line 1799
;1799:		CG_Printf ("CG_Particle_OilSlick == ZERO!\n");
ADDRGP4 $1586
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $1584
line 1801
;1800:
;1801:	if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1587
line 1802
;1802:		return;
ADDRGP4 $1583
JUMPV
LABELV $1587
line 1803
;1803:	p = free_particles;
ADDRLP4 0
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1804
;1804:	free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 1805
;1805:	p->next = active_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 1806
;1806:	active_particles = p;
ADDRGP4 active_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1807
;1807:	p->time = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ASGNF4
line 1809
;1808:	
;1809:	if (cent->currentState.angles2[2])
ADDRFP4 4
INDIRP4
CNSTI4 136
ADDP4
INDIRF4
CNSTF4 0
EQF4 $1590
line 1810
;1810:		p->endtime = cg.time + cent->currentState.angles2[2];
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ADDRFP4 4
INDIRP4
CNSTI4 136
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRGP4 $1591
JUMPV
LABELV $1590
line 1812
;1811:	else
;1812:		p->endtime = cg.time + 60000;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+64
INDIRI4
CNSTI4 60000
ADDI4
CVIF4 4
ASGNF4
LABELV $1591
line 1814
;1813:
;1814:	p->startfade = p->endtime;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ASGNF4
line 1816
;1815:
;1816:	p->alpha = 1.0;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1065353216
ASGNF4
line 1817
;1817:	p->alphavel = 0;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 1818
;1818:	p->roll = 0;
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
CNSTI4 0
ASGNI4
line 1820
;1819:
;1820:	p->pshader = pshader;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 0
INDIRI4
ASGNI4
line 1822
;1821:
;1822:	if (cent->currentState.angles2[0] || cent->currentState.angles2[1])
ADDRLP4 8
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 12
CNSTF4 0
ASGNF4
ADDRLP4 8
INDIRP4
CNSTI4 128
ADDP4
INDIRF4
ADDRLP4 12
INDIRF4
NEF4 $1596
ADDRLP4 8
INDIRP4
CNSTI4 132
ADDP4
INDIRF4
ADDRLP4 12
INDIRF4
EQF4 $1594
LABELV $1596
line 1823
;1823:	{
line 1824
;1824:		p->width = cent->currentState.angles2[0];
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 128
ADDP4
INDIRF4
ASGNF4
line 1825
;1825:		p->height = cent->currentState.angles2[0];
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 128
ADDP4
INDIRF4
ASGNF4
line 1827
;1826:
;1827:		p->endheight = cent->currentState.angles2[1];
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 132
ADDP4
INDIRF4
ASGNF4
line 1828
;1828:		p->endwidth = cent->currentState.angles2[1];
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 132
ADDP4
INDIRF4
ASGNF4
line 1829
;1829:	}
ADDRGP4 $1595
JUMPV
LABELV $1594
line 1831
;1830:	else
;1831:	{
line 1832
;1832:		p->width = 8;
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
CNSTF4 1090519040
ASGNF4
line 1833
;1833:		p->height = 8;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
CNSTF4 1090519040
ASGNF4
line 1835
;1834:
;1835:		p->endheight = 16;
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
CNSTF4 1098907648
ASGNF4
line 1836
;1836:		p->endwidth = 16;
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
CNSTF4 1098907648
ASGNF4
line 1837
;1837:	}
LABELV $1595
line 1839
;1838:
;1839:	p->type = P_FLAT_SCALEUP;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 9
ASGNI4
line 1841
;1840:
;1841:	p->snum = 1.0;
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
CNSTI4 1
ASGNI4
line 1843
;1842:
;1843:	VectorCopy(cent->currentState.origin, p->org );
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 1845
;1844:	
;1845:	p->org[2]+= 0.55 + (crandom() * 0.5);
ADDRLP4 16
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 20
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
ASGNP4
ADDRLP4 20
INDIRP4
ADDRLP4 20
INDIRP4
INDIRF4
CNSTF4 1056964608
CNSTF4 1073741824
ADDRLP4 16
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1057803469
ADDF4
ADDF4
ASGNF4
line 1847
;1846:
;1847:	p->vel[0] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
CNSTF4 0
ASGNF4
line 1848
;1848:	p->vel[1] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTF4 0
ASGNF4
line 1849
;1849:	p->vel[2] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTF4 0
ASGNF4
line 1850
;1850:	VectorClear( p->accel );
ADDRLP4 28
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 28
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 28
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 28
INDIRF4
ASGNF4
line 1852
;1851:
;1852:	p->rotate = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 100
ADDP4
CNSTI4 0
ASGNI4
line 1854
;1853:
;1854:	p->roll = rand()%179;
ADDRLP4 32
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
ADDRLP4 32
INDIRI4
CNSTI4 179
MODI4
ASGNI4
line 1856
;1855:	
;1856:	p->alpha = 0.75;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1061158912
ASGNF4
line 1858
;1857:
;1858:}
LABELV $1583
endproc CG_Particle_OilSlick 36 4
export CG_OilSlickRemove
proc CG_OilSlickRemove 16 4
line 1861
;1859:
;1860:void CG_OilSlickRemove (centity_t *cent)
;1861:{
line 1865
;1862:	cparticle_t		*p, *next;
;1863:	int				id;
;1864:
;1865:	id = 1.0f;
ADDRLP4 8
CNSTI4 1
ASGNI4
line 1867
;1866:
;1867:	if (!id)
ADDRLP4 8
INDIRI4
CNSTI4 0
NEI4 $1598
line 1868
;1868:		CG_Printf ("CG_OilSlickRevove NULL id\n");
ADDRGP4 $1600
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $1598
line 1870
;1869:
;1870:	for (p=active_particles ; p ; p=next)
ADDRLP4 0
ADDRGP4 active_particles
INDIRP4
ASGNP4
ADDRGP4 $1604
JUMPV
LABELV $1601
line 1871
;1871:	{
line 1872
;1872:		next = p->next;
ADDRLP4 4
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 1874
;1873:		
;1874:		if (p->type == P_FLAT_SCALEUP)
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
CNSTI4 9
NEI4 $1605
line 1875
;1875:		{
line 1876
;1876:			if (p->snum == id)
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
INDIRI4
ADDRLP4 8
INDIRI4
NEI4 $1607
line 1877
;1877:			{
line 1878
;1878:				p->endtime = cg.time + 100;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+64
INDIRI4
CNSTI4 100
ADDI4
CVIF4 4
ASGNF4
line 1879
;1879:				p->startfade = p->endtime;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ASGNF4
line 1880
;1880:				p->type = P_FLAT_SCALEUP_FADE;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 10
ASGNI4
line 1882
;1881:
;1882:			}
LABELV $1607
line 1883
;1883:		}
LABELV $1605
line 1885
;1884:
;1885:	}
LABELV $1602
line 1870
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
LABELV $1604
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1601
line 1886
;1886:}
LABELV $1597
endproc CG_OilSlickRemove 16 4
export ValidBloodPool
proc ValidBloodPool 1220 28
line 1889
;1887:
;1888:qboolean ValidBloodPool (vec3_t start)
;1889:{
line 1900
;1890:#define EXTRUDE_DIST	0.5
;1891:
;1892:	vec3_t	angles;
;1893:	vec3_t	right, up;
;1894:	vec3_t	this_pos, x_pos, center_pos, end_pos;
;1895:	float	x, y;
;1896:	float	fwidth, fheight;
;1897:	trace_t	trace;
;1898:	vec3_t	normal;
;1899:
;1900:	fwidth = 16;
ADDRLP4 1176
CNSTF4 1098907648
ASGNF4
line 1901
;1901:	fheight = 16;
ADDRLP4 1144
CNSTF4 1098907648
ASGNF4
line 1903
;1902:
;1903:	VectorSet (normal, 0, 0, 1);
ADDRLP4 1192
CNSTF4 0
ASGNF4
ADDRLP4 1120
ADDRLP4 1192
INDIRF4
ASGNF4
ADDRLP4 1120+4
ADDRLP4 1192
INDIRF4
ASGNF4
ADDRLP4 1120+8
CNSTF4 1065353216
ASGNF4
line 1905
;1904:
;1905:	vectoangles (normal, angles);
ADDRLP4 1120
ARGP4
ADDRLP4 1180
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 1906
;1906:	AngleVectors (angles, NULL, right, up);
ADDRLP4 1180
ARGP4
CNSTP4 0
ARGP4
ADDRLP4 1164
ARGP4
ADDRLP4 1132
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 1908
;1907:
;1908:	VectorMA (start, EXTRUDE_DIST, normal, center_pos);
ADDRLP4 1196
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1200
CNSTF4 1056964608
ASGNF4
ADDRLP4 1152
ADDRLP4 1196
INDIRP4
INDIRF4
ADDRLP4 1200
INDIRF4
ADDRLP4 1120
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 1152+4
ADDRLP4 1196
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 1200
INDIRF4
ADDRLP4 1120+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 1152+8
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
CNSTF4 1056964608
ADDRLP4 1120+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 1910
;1909:
;1910:	for (x= -fwidth/2; x<fwidth; x+= fwidth)
ADDRLP4 1148
ADDRLP4 1176
INDIRF4
NEGF4
CNSTF4 1073741824
DIVF4
ASGNF4
ADDRGP4 $1620
JUMPV
LABELV $1617
line 1911
;1911:	{
line 1912
;1912:		VectorMA (center_pos, x, right, x_pos);
ADDRLP4 1108
ADDRLP4 1152
INDIRF4
ADDRLP4 1164
INDIRF4
ADDRLP4 1148
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 1108+4
ADDRLP4 1152+4
INDIRF4
ADDRLP4 1164+4
INDIRF4
ADDRLP4 1148
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 1108+8
ADDRLP4 1152+8
INDIRF4
ADDRLP4 1164+8
INDIRF4
ADDRLP4 1148
INDIRF4
MULF4
ADDF4
ASGNF4
line 1914
;1913:
;1914:		for (y= -fheight/2; y<fheight; y+= fheight)
ADDRLP4 12
ADDRLP4 1144
INDIRF4
NEGF4
CNSTF4 1073741824
DIVF4
ASGNF4
ADDRGP4 $1630
JUMPV
LABELV $1627
line 1915
;1915:		{
line 1916
;1916:			VectorMA (x_pos, y, up, this_pos);
ADDRLP4 0
ADDRLP4 1108
INDIRF4
ADDRLP4 1132
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 1108+4
INDIRF4
ADDRLP4 1132+4
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 1108+8
INDIRF4
ADDRLP4 1132+8
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ADDF4
ASGNF4
line 1917
;1917:			VectorMA (this_pos, -EXTRUDE_DIST*2, normal, end_pos);
ADDRLP4 1212
CNSTF4 3212836864
ASGNF4
ADDRLP4 16
ADDRLP4 0
INDIRF4
ADDRLP4 1212
INDIRF4
ADDRLP4 1120
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 16+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 1212
INDIRF4
ADDRLP4 1120+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 16+8
ADDRLP4 0+8
INDIRF4
CNSTF4 3212836864
ADDRLP4 1120+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 1919
;1918:			
;1919:			CG_Trace (&trace, this_pos, NULL, NULL, end_pos, -1, CONTENTS_SOLID);
ADDRLP4 28
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 1216
CNSTP4 0
ASGNP4
ADDRLP4 1216
INDIRP4
ARGP4
ADDRLP4 1216
INDIRP4
ARGP4
ADDRLP4 16
ARGP4
CNSTI4 -1
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 CG_Trace
CALLV
pop
line 1922
;1920:
;1921:			
;1922:			if (trace.entityNum < (MAX_ENTITIES - 1)) // may only land on world
ADDRLP4 28+52
INDIRI4
CNSTI4 1022
GEI4 $1643
line 1923
;1923:				return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $1610
JUMPV
LABELV $1643
line 1925
;1924:
;1925:			if (!(!trace.startsolid && trace.fraction < 1))
ADDRLP4 28+4
INDIRI4
CNSTI4 0
NEI4 $1650
ADDRLP4 28+8
INDIRF4
CNSTF4 1065353216
LTF4 $1646
LABELV $1650
line 1926
;1926:				return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $1610
JUMPV
LABELV $1646
line 1928
;1927:		
;1928:		}
LABELV $1628
line 1914
ADDRLP4 12
ADDRLP4 12
INDIRF4
ADDRLP4 1144
INDIRF4
ADDF4
ASGNF4
LABELV $1630
ADDRLP4 12
INDIRF4
ADDRLP4 1144
INDIRF4
LTF4 $1627
line 1929
;1929:	}
LABELV $1618
line 1910
ADDRLP4 1148
ADDRLP4 1148
INDIRF4
ADDRLP4 1176
INDIRF4
ADDF4
ASGNF4
LABELV $1620
ADDRLP4 1148
INDIRF4
ADDRLP4 1176
INDIRF4
LTF4 $1617
line 1931
;1930:
;1931:	return qtrue;
CNSTI4 1
RETI4
LABELV $1610
endproc ValidBloodPool 1220 28
export CG_BloodPool
proc CG_BloodPool 48 4
line 1935
;1932:}
;1933:
;1934:void CG_BloodPool (localEntity_t *le, qhandle_t pshader, trace_t *tr)
;1935:{	
line 1941
;1936:	cparticle_t	*p;
;1937:	qboolean	legit;
;1938:	vec3_t		start;
;1939:	float		rndSize;
;1940:	
;1941:	if (!pshader)
ADDRFP4 4
INDIRI4
CNSTI4 0
NEI4 $1652
line 1942
;1942:		CG_Printf ("CG_BloodPool pshader == ZERO!\n");
ADDRGP4 $1654
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $1652
line 1944
;1943:
;1944:	if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1655
line 1945
;1945:		return;
ADDRGP4 $1651
JUMPV
LABELV $1655
line 1947
;1946:	
;1947:	VectorCopy (tr->endpos, start);
ADDRLP4 8
ADDRFP4 8
INDIRP4
CNSTI4 12
ADDP4
INDIRB
ASGNB 12
line 1948
;1948:	legit = ValidBloodPool (start);
ADDRLP4 8
ARGP4
ADDRLP4 24
ADDRGP4 ValidBloodPool
CALLI4
ASGNI4
ADDRLP4 20
ADDRLP4 24
INDIRI4
ASGNI4
line 1950
;1949:
;1950:	if (!legit) 
ADDRLP4 20
INDIRI4
CNSTI4 0
NEI4 $1657
line 1951
;1951:		return;
ADDRGP4 $1651
JUMPV
LABELV $1657
line 1953
;1952:
;1953:	p = free_particles;
ADDRLP4 0
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1954
;1954:	free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 1955
;1955:	p->next = active_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 1956
;1956:	active_particles = p;
ADDRGP4 active_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1957
;1957:	p->time = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ASGNF4
line 1959
;1958:	
;1959:	p->endtime = cg.time + 3000;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+64
INDIRI4
CNSTI4 3000
ADDI4
CVIF4 4
ASGNF4
line 1960
;1960:	p->startfade = p->endtime;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ASGNF4
line 1962
;1961:
;1962:	p->alpha = 1.0;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1065353216
ASGNF4
line 1963
;1963:	p->alphavel = 0;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 1964
;1964:	p->roll = 0;
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
CNSTI4 0
ASGNI4
line 1966
;1965:
;1966:	p->pshader = pshader;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 4
INDIRI4
ASGNI4
line 1968
;1967:
;1968:	rndSize = 0.4 + random()*0.6;
ADDRLP4 32
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 4
CNSTF4 1058642330
ADDRLP4 32
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
CNSTF4 1053609165
ADDF4
ASGNF4
line 1970
;1969:
;1970:	p->width = 8*rndSize;
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
CNSTF4 1090519040
ADDRLP4 4
INDIRF4
MULF4
ASGNF4
line 1971
;1971:	p->height = 8*rndSize;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
CNSTF4 1090519040
ADDRLP4 4
INDIRF4
MULF4
ASGNF4
line 1973
;1972:
;1973:	p->endheight = 16*rndSize;
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
CNSTF4 1098907648
ADDRLP4 4
INDIRF4
MULF4
ASGNF4
line 1974
;1974:	p->endwidth = 16*rndSize;
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
CNSTF4 1098907648
ADDRLP4 4
INDIRF4
MULF4
ASGNF4
line 1976
;1975:	
;1976:	p->type = P_FLAT_SCALEUP;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 9
ASGNI4
line 1978
;1977:
;1978:	VectorCopy(start, p->org );
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRLP4 8
INDIRB
ASGNB 12
line 1980
;1979:	
;1980:	p->vel[0] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
CNSTF4 0
ASGNF4
line 1981
;1981:	p->vel[1] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTF4 0
ASGNF4
line 1982
;1982:	p->vel[2] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTF4 0
ASGNF4
line 1983
;1983:	VectorClear( p->accel );
ADDRLP4 40
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 40
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 40
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 40
INDIRF4
ASGNF4
line 1985
;1984:
;1985:	p->rotate = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 100
ADDP4
CNSTI4 0
ASGNI4
line 1987
;1986:
;1987:	p->roll = rand()%179;
ADDRLP4 44
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
ADDRLP4 44
INDIRI4
CNSTI4 179
MODI4
ASGNI4
line 1989
;1988:	
;1989:	p->alpha = 0.75;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1061158912
ASGNF4
line 1991
;1990:	
;1991:	p->color = BLOODRED;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 2
ASGNI4
line 1992
;1992:}
LABELV $1651
endproc CG_BloodPool 48 4
export CG_ParticleBloodCloud
proc CG_ParticleBloodCloud 84 16
line 1998
;1993:
;1994:#define NORMALSIZE	16
;1995:#define LARGESIZE	32
;1996:
;1997:void CG_ParticleBloodCloud (centity_t *cent, vec3_t origin, vec3_t dir)
;1998:{
line 2007
;1999:	float	length;
;2000:	float	dist;
;2001:	float	crittersize;
;2002:	vec3_t	angles, forward;
;2003:	vec3_t	point;
;2004:	cparticle_t	*p;
;2005:	int		i;
;2006:	
;2007:	dist = 0;
ADDRLP4 36
CNSTF4 0
ASGNF4
line 2009
;2008:
;2009:	length = VectorLength (dir);
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 56
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 40
ADDRLP4 56
INDIRF4
ASGNF4
line 2010
;2010:	vectoangles (dir, angles);
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 44
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 2011
;2011:	AngleVectors (angles, forward, NULL, NULL);
ADDRLP4 44
ARGP4
ADDRLP4 20
ARGP4
ADDRLP4 60
CNSTP4 0
ASGNP4
ADDRLP4 60
INDIRP4
ARGP4
ADDRLP4 60
INDIRP4
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 2013
;2012:
;2013:	crittersize = LARGESIZE;
ADDRLP4 16
CNSTF4 1107296256
ASGNF4
line 2015
;2014:
;2015:	if (length)
ADDRLP4 40
INDIRF4
CNSTF4 0
EQF4 $1662
line 2016
;2016:		dist = length / crittersize;
ADDRLP4 36
ADDRLP4 40
INDIRF4
ADDRLP4 16
INDIRF4
DIVF4
ASGNF4
LABELV $1662
line 2018
;2017:
;2018:	if (dist < 1)
ADDRLP4 36
INDIRF4
CNSTF4 1065353216
GEF4 $1664
line 2019
;2019:		dist = 1;
ADDRLP4 36
CNSTF4 1065353216
ASGNF4
LABELV $1664
line 2021
;2020:
;2021:	VectorCopy (origin, point);
ADDRLP4 4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 2023
;2022:
;2023:	for (i=0; i<dist; i++)
ADDRLP4 32
CNSTI4 0
ASGNI4
ADDRGP4 $1669
JUMPV
LABELV $1666
line 2024
;2024:	{
line 2025
;2025:		VectorMA (point, crittersize, forward, point);	
ADDRLP4 4
ADDRLP4 4
INDIRF4
ADDRLP4 20
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 4+4
ADDRLP4 4+4
INDIRF4
ADDRLP4 20+4
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 4+8
ADDRLP4 4+8
INDIRF4
ADDRLP4 20+8
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
line 2027
;2026:		
;2027:		if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1676
line 2028
;2028:			return;
ADDRGP4 $1661
JUMPV
LABELV $1676
line 2030
;2029:
;2030:		p = free_particles;
ADDRLP4 0
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 2031
;2031:		free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 2032
;2032:		p->next = active_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 2033
;2033:		active_particles = p;
ADDRGP4 active_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 2035
;2034:
;2035:		p->time = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ASGNF4
line 2036
;2036:		p->alpha = 1.0;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1065353216
ASGNF4
line 2037
;2037:		p->alphavel = 0;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 2038
;2038:		p->roll = 0;
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
CNSTI4 0
ASGNI4
line 2040
;2039:
;2040:		p->pshader = cgs.media.smokePuffShader;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRGP4 cgs+70296+252
INDIRI4
ASGNI4
line 2042
;2041:
;2042:		p->endtime = cg.time + 350 + (crandom() * 100);
ADDRLP4 68
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+64
INDIRI4
CNSTI4 350
ADDI4
CVIF4 4
CNSTF4 1120403456
CNSTF4 1073741824
ADDRLP4 68
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ASGNF4
line 2044
;2043:		
;2044:		p->startfade = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ASGNF4
line 2046
;2045:		
;2046:		p->width = LARGESIZE;
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
CNSTF4 1107296256
ASGNF4
line 2047
;2047:		p->height = LARGESIZE;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
CNSTF4 1107296256
ASGNF4
line 2048
;2048:		p->endheight = LARGESIZE;
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
CNSTF4 1107296256
ASGNF4
line 2049
;2049:		p->endwidth = LARGESIZE;
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
CNSTF4 1107296256
ASGNF4
line 2051
;2050:
;2051:		p->type = P_SMOKE;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 3
ASGNI4
line 2053
;2052:
;2053:		VectorCopy( origin, p->org );
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 2055
;2054:		
;2055:		p->vel[0] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
CNSTF4 0
ASGNF4
line 2056
;2056:		p->vel[1] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTF4 0
ASGNF4
line 2057
;2057:		p->vel[2] = -1;
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTF4 3212836864
ASGNF4
line 2059
;2058:		
;2059:		VectorClear( p->accel );
ADDRLP4 76
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 76
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 76
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 76
INDIRF4
ASGNF4
line 2061
;2060:
;2061:		p->rotate = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 100
ADDP4
CNSTI4 0
ASGNI4
line 2063
;2062:
;2063:		p->roll = rand()%179;
ADDRLP4 80
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
ADDRLP4 80
INDIRI4
CNSTI4 179
MODI4
ASGNI4
line 2065
;2064:		
;2065:		p->color = BLOODRED;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 2
ASGNI4
line 2067
;2066:		
;2067:		p->alpha = 0.75;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1061158912
ASGNF4
line 2069
;2068:		
;2069:	}
LABELV $1667
line 2023
ADDRLP4 32
ADDRLP4 32
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $1669
ADDRLP4 32
INDIRI4
CVIF4 4
ADDRLP4 36
INDIRF4
LTF4 $1666
line 2072
;2070:
;2071:	
;2072:}
LABELV $1661
endproc CG_ParticleBloodCloud 84 16
export CG_ParticleSparks
proc CG_ParticleSparks 60 0
line 2075
;2073:
;2074:void CG_ParticleSparks (vec3_t org, vec3_t vel, int duration, float x, float y, float speed)
;2075:{
line 2078
;2076:	cparticle_t	*p;
;2077:
;2078:	if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1684
line 2079
;2079:		return;
ADDRGP4 $1683
JUMPV
LABELV $1684
line 2080
;2080:	p = free_particles;
ADDRLP4 0
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 2081
;2081:	free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 2082
;2082:	p->next = active_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 2083
;2083:	active_particles = p;
ADDRGP4 active_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 2084
;2084:	p->time = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ASGNF4
line 2086
;2085:	
;2086:	p->endtime = cg.time + duration;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+64
INDIRI4
ADDRFP4 8
INDIRI4
ADDI4
CVIF4 4
ASGNF4
line 2087
;2087:	p->startfade = cg.time + duration/2;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
ADDRGP4 cg+64
INDIRI4
ADDRFP4 8
INDIRI4
CNSTI4 2
DIVI4
ADDI4
CVIF4 4
ASGNF4
line 2089
;2088:	
;2089:	p->color = EMISIVEFADE;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 3
ASGNI4
line 2090
;2090:	p->alpha = 0.4f;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1053609165
ASGNF4
line 2091
;2091:	p->alphavel = 0;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 2093
;2092:
;2093:	p->height = 0.5;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
CNSTF4 1056964608
ASGNF4
line 2094
;2094:	p->width = 0.5;
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
CNSTF4 1056964608
ASGNF4
line 2095
;2095:	p->endheight = 0.5;
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
CNSTF4 1056964608
ASGNF4
line 2096
;2096:	p->endwidth = 0.5;
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
CNSTF4 1056964608
ASGNF4
line 2098
;2097:
;2098:	p->pshader = cgs.media.tracerShader;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRGP4 cgs+70296+196
INDIRI4
ASGNI4
line 2100
;2099:
;2100:	p->type = P_SMOKE;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 3
ASGNI4
line 2102
;2101:	
;2102:	VectorCopy(org, p->org);
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 2104
;2103:
;2104:	p->org[0] += (crandom() * x);
ADDRLP4 4
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 8
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRF4
CNSTF4 1073741824
ADDRLP4 4
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
ADDRFP4 12
INDIRF4
MULF4
ADDF4
ASGNF4
line 2105
;2105:	p->org[1] += (crandom() * y);
ADDRLP4 12
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRF4
CNSTF4 1073741824
ADDRLP4 12
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
ADDRFP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
line 2107
;2106:
;2107:	p->vel[0] = vel[0];
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ADDRFP4 4
INDIRP4
INDIRF4
ASGNF4
line 2108
;2108:	p->vel[1] = vel[1];
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ASGNF4
line 2109
;2109:	p->vel[2] = vel[2];
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ASGNF4
line 2111
;2110:
;2111:	p->accel[0] = p->accel[1] = p->accel[2] = 0;
ADDRLP4 24
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 24
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 24
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 24
INDIRF4
ASGNF4
line 2113
;2112:
;2113:	p->vel[0] += (crandom() * 4);
ADDRLP4 28
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 32
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ASGNP4
ADDRLP4 32
INDIRP4
ADDRLP4 32
INDIRP4
INDIRF4
CNSTF4 1082130432
CNSTF4 1073741824
ADDRLP4 28
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ASGNF4
line 2114
;2114:	p->vel[1] += (crandom() * 4);
ADDRLP4 36
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 40
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
ASGNP4
ADDRLP4 40
INDIRP4
ADDRLP4 40
INDIRP4
INDIRF4
CNSTF4 1082130432
CNSTF4 1073741824
ADDRLP4 36
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ASGNF4
line 2115
;2115:	p->vel[2] += (20 + (crandom() * 10)) * speed;	
ADDRLP4 44
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 48
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 48
INDIRP4
ADDRLP4 48
INDIRP4
INDIRF4
CNSTF4 1092616192
CNSTF4 1073741824
ADDRLP4 44
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1101004800
ADDF4
ADDRFP4 20
INDIRF4
MULF4
ADDF4
ASGNF4
line 2117
;2116:
;2117:	p->accel[0] = crandom () * 4;
ADDRLP4 52
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
CNSTF4 1082130432
CNSTF4 1073741824
ADDRLP4 52
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 2118
;2118:	p->accel[1] = crandom () * 4;
ADDRLP4 56
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 1082130432
CNSTF4 1073741824
ADDRLP4 56
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 2120
;2119:	
;2120:}
LABELV $1683
endproc CG_ParticleSparks 60 0
export CG_ParticleDust
proc CG_ParticleDust 120 16
line 2123
;2121:
;2122:void CG_ParticleDust (centity_t *cent, vec3_t origin, vec3_t dir)
;2123:{
line 2132
;2124:	float	length;
;2125:	float	dist;
;2126:	float	crittersize;
;2127:	vec3_t	angles, forward;
;2128:	vec3_t	point;
;2129:	cparticle_t	*p;
;2130:	int		i;
;2131:	
;2132:	dist = 0;
ADDRLP4 40
CNSTF4 0
ASGNF4
line 2134
;2133:
;2134:	VectorNegate (dir, dir);
ADDRLP4 56
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 56
INDIRP4
ADDRLP4 56
INDIRP4
INDIRF4
NEGF4
ASGNF4
ADDRLP4 60
ADDRFP4 8
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 60
INDIRP4
ADDRLP4 60
INDIRP4
INDIRF4
NEGF4
ASGNF4
ADDRLP4 64
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 64
INDIRP4
ADDRLP4 64
INDIRP4
INDIRF4
NEGF4
ASGNF4
line 2135
;2135:	length = VectorLength (dir);
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 68
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 32
ADDRLP4 68
INDIRF4
ASGNF4
line 2136
;2136:	vectoangles (dir, angles);
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 44
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 2137
;2137:	AngleVectors (angles, forward, NULL, NULL);
ADDRLP4 44
ARGP4
ADDRLP4 20
ARGP4
ADDRLP4 72
CNSTP4 0
ASGNP4
ADDRLP4 72
INDIRP4
ARGP4
ADDRLP4 72
INDIRP4
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 2139
;2138:
;2139:	crittersize = LARGESIZE;
ADDRLP4 16
CNSTF4 1107296256
ASGNF4
line 2141
;2140:
;2141:	if (length)
ADDRLP4 32
INDIRF4
CNSTF4 0
EQF4 $1692
line 2142
;2142:		dist = length / crittersize;
ADDRLP4 40
ADDRLP4 32
INDIRF4
ADDRLP4 16
INDIRF4
DIVF4
ASGNF4
LABELV $1692
line 2144
;2143:
;2144:	if (dist < 1)
ADDRLP4 40
INDIRF4
CNSTF4 1065353216
GEF4 $1694
line 2145
;2145:		dist = 1;
ADDRLP4 40
CNSTF4 1065353216
ASGNF4
LABELV $1694
line 2147
;2146:
;2147:	VectorCopy (origin, point);
ADDRLP4 4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 2149
;2148:
;2149:	for (i=0; i<dist; i++)
ADDRLP4 36
CNSTI4 0
ASGNI4
ADDRGP4 $1699
JUMPV
LABELV $1696
line 2150
;2150:	{
line 2151
;2151:		VectorMA (point, crittersize, forward, point);	
ADDRLP4 4
ADDRLP4 4
INDIRF4
ADDRLP4 20
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 4+4
ADDRLP4 4+4
INDIRF4
ADDRLP4 20+4
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 4+8
ADDRLP4 4+8
INDIRF4
ADDRLP4 20+8
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
line 2153
;2152:				
;2153:		if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1706
line 2154
;2154:			return;
ADDRGP4 $1691
JUMPV
LABELV $1706
line 2156
;2155:
;2156:		p = free_particles;
ADDRLP4 0
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 2157
;2157:		free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 2158
;2158:		p->next = active_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 2159
;2159:		active_particles = p;
ADDRGP4 active_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 2161
;2160:
;2161:		p->time = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ASGNF4
line 2162
;2162:		p->alpha = 5.0;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1084227584
ASGNF4
line 2163
;2163:		p->alphavel = 0;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 2164
;2164:		p->roll = 0;
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
CNSTI4 0
ASGNI4
line 2166
;2165:
;2166:		p->pshader = cgs.media.smokePuffShader;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRGP4 cgs+70296+252
INDIRI4
ASGNI4
line 2169
;2167:
;2168:		// RF, stay around for long enough to expand and dissipate naturally
;2169:		if (length)
ADDRLP4 32
INDIRF4
CNSTF4 0
EQF4 $1711
line 2170
;2170:			p->endtime = cg.time + 4500 + (crandom() * 3500);
ADDRLP4 80
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+64
INDIRI4
CNSTI4 4500
ADDI4
CVIF4 4
CNSTF4 1163575296
CNSTF4 1073741824
ADDRLP4 80
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRGP4 $1712
JUMPV
LABELV $1711
line 2172
;2171:		else
;2172:			p->endtime = cg.time + 750 + (crandom() * 500);
ADDRLP4 84
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+64
INDIRI4
CNSTI4 750
ADDI4
CVIF4 4
CNSTF4 1140457472
CNSTF4 1073741824
ADDRLP4 84
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ASGNF4
LABELV $1712
line 2174
;2173:		
;2174:		p->startfade = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ASGNF4
line 2176
;2175:		
;2176:		p->width = LARGESIZE;
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
CNSTF4 1107296256
ASGNF4
line 2177
;2177:		p->height = LARGESIZE;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
CNSTF4 1107296256
ASGNF4
line 2180
;2178:
;2179:		// RF, expand while falling
;2180:		p->endheight = LARGESIZE*3.0;
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
CNSTF4 1119879168
ASGNF4
line 2181
;2181:		p->endwidth = LARGESIZE*3.0;
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
CNSTF4 1119879168
ASGNF4
line 2183
;2182:
;2183:		if (!length)
ADDRLP4 32
INDIRF4
CNSTF4 0
NEF4 $1716
line 2184
;2184:		{
line 2185
;2185:			p->width *= 0.2f;
ADDRLP4 88
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 88
INDIRP4
CNSTF4 1045220557
ADDRLP4 88
INDIRP4
INDIRF4
MULF4
ASGNF4
line 2186
;2186:			p->height *= 0.2f;
ADDRLP4 92
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 92
INDIRP4
CNSTF4 1045220557
ADDRLP4 92
INDIRP4
INDIRF4
MULF4
ASGNF4
line 2188
;2187:
;2188:			p->endheight = NORMALSIZE;
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
CNSTF4 1098907648
ASGNF4
line 2189
;2189:			p->endwidth = NORMALSIZE;
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
CNSTF4 1098907648
ASGNF4
line 2190
;2190:		}
LABELV $1716
line 2192
;2191:
;2192:		p->type = P_SMOKE;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 3
ASGNI4
line 2194
;2193:
;2194:		VectorCopy( point, p->org );
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRLP4 4
INDIRB
ASGNB 12
line 2196
;2195:		
;2196:		p->vel[0] = crandom()*6;
ADDRLP4 88
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
CNSTF4 1086324736
CNSTF4 1073741824
ADDRLP4 88
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 2197
;2197:		p->vel[1] = crandom()*6;
ADDRLP4 92
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTF4 1086324736
CNSTF4 1073741824
ADDRLP4 92
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 2198
;2198:		p->vel[2] = random()*20;
ADDRLP4 96
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTF4 1101004800
ADDRLP4 96
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ASGNF4
line 2201
;2199:
;2200:		// RF, add some gravity/randomness
;2201:		p->accel[0] = crandom()*3;
ADDRLP4 100
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
CNSTF4 1077936128
CNSTF4 1073741824
ADDRLP4 100
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 2202
;2202:		p->accel[1] = crandom()*3;
ADDRLP4 104
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 1077936128
CNSTF4 1073741824
ADDRLP4 104
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 2203
;2203:		p->accel[2] = -PARTICLE_GRAVITY*0.4;
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
CNSTF4 3246391296
ASGNF4
line 2205
;2204:
;2205:		VectorClear( p->accel );
ADDRLP4 112
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 112
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 112
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 112
INDIRF4
ASGNF4
line 2207
;2206:
;2207:		p->rotate = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 100
ADDP4
CNSTI4 0
ASGNI4
line 2209
;2208:
;2209:		p->roll = rand()%179;
ADDRLP4 116
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
ADDRLP4 116
INDIRI4
CNSTI4 179
MODI4
ASGNI4
line 2211
;2210:		
;2211:		p->alpha = 0.75;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1061158912
ASGNF4
line 2213
;2212:		
;2213:	}
LABELV $1697
line 2149
ADDRLP4 36
ADDRLP4 36
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $1699
ADDRLP4 36
INDIRI4
CVIF4 4
ADDRLP4 40
INDIRF4
LTF4 $1696
line 2216
;2214:
;2215:	
;2216:}
LABELV $1691
endproc CG_ParticleDust 120 16
export CG_ParticleMisc
proc CG_ParticleMisc 8 4
line 2219
;2217:
;2218:void CG_ParticleMisc (qhandle_t pshader, vec3_t origin, int size, int duration, float alpha)
;2219:{
line 2222
;2220:	cparticle_t	*p;
;2221:
;2222:	if (!pshader)
ADDRFP4 0
INDIRI4
CNSTI4 0
NEI4 $1719
line 2223
;2223:		CG_Printf ("CG_ParticleImpactSmokePuff pshader == ZERO!\n");
ADDRGP4 $1554
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $1719
line 2225
;2224:
;2225:	if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1721
line 2226
;2226:		return;
ADDRGP4 $1718
JUMPV
LABELV $1721
line 2228
;2227:
;2228:	p = free_particles;
ADDRLP4 0
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 2229
;2229:	free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 2230
;2230:	p->next = active_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 2231
;2231:	active_particles = p;
ADDRGP4 active_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 2232
;2232:	p->time = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ASGNF4
line 2233
;2233:	p->alpha = 1.0;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1065353216
ASGNF4
line 2234
;2234:	p->alphavel = 0;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 2235
;2235:	p->roll = rand()%179;
ADDRLP4 4
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
ADDRLP4 4
INDIRI4
CNSTI4 179
MODI4
ASGNI4
line 2237
;2236:
;2237:	p->pshader = pshader;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 0
INDIRI4
ASGNI4
line 2239
;2238:
;2239:	if (duration > 0)
ADDRFP4 12
INDIRI4
CNSTI4 0
LEI4 $1724
line 2240
;2240:		p->endtime = cg.time + duration;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+64
INDIRI4
ADDRFP4 12
INDIRI4
ADDI4
CVIF4 4
ASGNF4
ADDRGP4 $1725
JUMPV
LABELV $1724
line 2242
;2241:	else
;2242:		p->endtime = duration;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRFP4 12
INDIRI4
CVIF4 4
ASGNF4
LABELV $1725
line 2244
;2243:
;2244:	p->startfade = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ASGNF4
line 2246
;2245:
;2246:	p->width = size;
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
ADDRFP4 8
INDIRI4
CVIF4 4
ASGNF4
line 2247
;2247:	p->height = size;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
ADDRFP4 8
INDIRI4
CVIF4 4
ASGNF4
line 2249
;2248:
;2249:	p->endheight = size;
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
ADDRFP4 8
INDIRI4
CVIF4 4
ASGNF4
line 2250
;2250:	p->endwidth = size;
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
ADDRFP4 8
INDIRI4
CVIF4 4
ASGNF4
line 2252
;2251:
;2252:	p->type = P_SPRITE;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 15
ASGNI4
line 2254
;2253:
;2254:	VectorCopy( origin, p->org );
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 2256
;2255:
;2256:	p->rotate = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 100
ADDP4
CNSTI4 0
ASGNI4
line 2257
;2257:}
LABELV $1718
endproc CG_ParticleMisc 8 4
bss
export oldtime
align 4
LABELV oldtime
skip 4
export rup
align 4
LABELV rup
skip 12
export rright
align 4
LABELV rright
skip 12
export rforward
align 4
LABELV rforward
skip 12
export pvup
align 4
LABELV pvup
skip 12
export pvright
align 4
LABELV pvright
skip 12
export pvforward
align 4
LABELV pvforward
skip 12
export particles
align 4
LABELV particles
skip 126976
export free_particles
align 4
LABELV free_particles
skip 4
export active_particles
align 4
LABELV active_particles
skip 4
align 4
LABELV numShaderAnims
skip 4
align 4
LABELV shaderAnims
skip 8192
align 4
LABELV markTotal
skip 4
export cg_freeMarkPolys
align 4
LABELV cg_freeMarkPolys
skip 4
export cg_activeMarkPolys
align 4
LABELV cg_activeMarkPolys
skip 288
import g2WeaponInstances
import CG_CheckPlayerG2Weapons
import CG_CopyG2WeaponInstance
import CG_ShutDownG2Weapons
import CG_InitG2Weapons
import CG_CreateBBRefEnts
import CG_SetGhoul2Info
import CG_Init_CGents
import CG_Init_CG
import trap_G2API_SetNewOrigin
import trap_G2API_SetSurfaceOnOff
import trap_G2API_SetRootSurface
import trap_G2API_SetBoneAnim
import trap_G2API_GetGLAName
import trap_G2API_SetBoneAngles
import trap_G2API_CleanGhoul2Models
import trap_G2API_SetBoltInfo
import trap_G2API_AddBolt
import trap_G2API_RemoveGhoul2Model
import trap_G2API_HasGhoul2ModelOnIndex
import trap_G2API_DuplicateGhoul2Instance
import trap_G2API_CopySpecificGhoul2Model
import trap_G2API_CopyGhoul2Instance
import trap_G2API_GiveMeVectorFromMatrix
import trap_G2API_InitGhoul2Model
import trap_G2API_GetBoltMatrix_NoRecNoRot
import trap_G2API_GetBoltMatrix_NoReconstruct
import trap_G2API_GetBoltMatrix
import trap_G2_HaveWeGhoul2Models
import trap_G2_SetGhoul2ModelIndexes
import trap_G2_ListModelBones
import trap_G2_ListModelSurfaces
import trap_G2API_CollisionDetect
import FX_ForceDrained
import FX_BlasterWeaponHitPlayer
import FX_BlasterWeaponHitWall
import FX_BlasterAltFireThink
import FX_BlasterProjectileThink
import FX_BryarAltHitPlayer
import FX_BryarHitPlayer
import FX_BryarAltHitWall
import FX_BryarHitWall
import CG_Spark
import FX_TurretHitPlayer
import FX_TurretHitWall
import FX_TurretProjectileThink
import CG_GetStripEdString
import trap_ROFF_Purge_Ent
import trap_ROFF_Play
import trap_ROFF_Cache
import trap_ROFF_UpdateEntities
import trap_ROFF_Clean
import trap_CG_RegisterSharedMemory
import trap_SP_GetStringTextString
import trap_SP_Print
import trap_FX_AddSprite
import trap_FX_AddPrimitive
import trap_FX_AddBezier
import trap_FX_AddPoly
import trap_FX_AdjustTime
import trap_FX_FreeSystem
import trap_FX_InitSystem
import trap_FX_AddScheduledEffects
import trap_FX_PlayBoltedEffectID
import trap_FX_PlayEntityEffectID
import trap_FX_PlayEffectID
import trap_FX_PlaySimpleEffectID
import trap_FX_PlayEntityEffect
import trap_FX_PlayEffect
import trap_FX_PlaySimpleEffect
import trap_FX_RegisterEffect
import trap_R_inPVS
import trap_GetEntityToken
import trap_getCameraInfo
import trap_startCamera
import trap_loadCamera
import trap_SnapVector
import trap_CIN_SetExtents
import trap_CIN_DrawCinematic
import trap_CIN_RunCinematic
import trap_CIN_StopCinematic
import trap_CIN_PlayCinematic
import BG_CycleForce
import BG_ProperForceIndex
import BG_CycleInven
import trap_Key_GetKey
import trap_Key_SetCatcher
import trap_Key_GetCatcher
import trap_Key_IsDown
import trap_MemoryRemaining
import testPrintFloat
import testPrintInt
import trap_OpenUIMenu
import trap_SetClientTurnExtent
import trap_SetClientForceAngle
import trap_SetUserCmdValue
import trap_GetUserCmd
import trap_GetCurrentCmdNumber
import trap_GetServerCommand
import trap_GetSnapshot
import trap_GetCurrentSnapshotNumber
import trap_GetGameState
import trap_GetGlconfig
import trap_FX_AddLine
import trap_R_GetBModelVerts
import trap_R_SetLightStyle
import trap_R_GetLightStyle
import trap_R_RemapShader
import trap_R_DrawRotatePic2
import trap_R_DrawRotatePic
import trap_R_LerpTag
import trap_R_ModelBounds
import trap_R_DrawStretchPic
import trap_R_SetColor
import trap_R_RenderScene
import trap_R_LightForPoint
import trap_R_AddLightToScene
import trap_R_AddPolysToScene
import trap_R_AddPolyToScene
import trap_R_AddRefEntityToScene
import trap_R_ClearScene
import trap_AnyLanguage_ReadCharFromString
import trap_Language_UsesSpaces
import trap_Language_IsAsian
import trap_R_Font_DrawString
import trap_R_Font_HeightPixels
import trap_R_Font_StrLenChars
import trap_R_Font_StrLenPixels
import trap_R_RegisterFont
import trap_R_RegisterShaderNoMip
import trap_R_RegisterShader
import trap_R_RegisterSkin
import trap_R_RegisterModel
import trap_R_LoadWorldMap
import trap_S_StopBackgroundTrack
import trap_S_StartBackgroundTrack
import trap_S_RegisterSound
import trap_S_Respatialize
import trap_S_UpdateEntityPosition
import trap_S_AddRealLoopingSound
import trap_S_AddLoopingSound
import trap_S_ClearLoopingSounds
import trap_S_StartLocalSound
import trap_S_StopLoopingSound
import trap_S_StartSound
import trap_S_MuteSound
import trap_CM_MarkFragments
import trap_CM_TransformedBoxTrace
import trap_CM_BoxTrace
import trap_CM_TransformedPointContents
import trap_CM_PointContents
import trap_CM_TempBoxModel
import trap_CM_InlineModel
import trap_CM_NumInlineModels
import trap_CM_LoadMap
import trap_UpdateScreen
import trap_SendClientCommand
import trap_AddCommand
import trap_SendConsoleCommand
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Cvar_VariableStringBuffer
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_Milliseconds
import trap_Error
import trap_Print
import CG_SagaObjectiveCompleted
import CG_SagaRoundOver
import CG_InitSagaMode
import CG_CheckChangedPredictableEvents
import CG_TransitionPlayerState
import CG_Respawn
import CG_IsMindTricked
import CG_PlayBufferedVoiceChats
import CG_VoiceChatLocal
import CG_ShaderStateChanged
import CG_LoadVoiceChats
import CG_SetConfigValues
import CG_ParseServerinfo
import CG_ExecuteNewServerCommands
import CG_InitConsoleCommands
import CG_ConsoleCommand
import CG_DrawOldTourneyScoreboard
import CG_DrawOldScoreboard
import CG_DrawInformation
import CG_LoadingClient
import CG_LoadingItem
import CG_LoadingString
import CG_ProcessSnapshots
import CG_InitGlass
import CG_TestLine
import CG_SurfaceExplosion
import CG_MakeExplosion
import CG_Bleed
import CG_ScorePlum
import CG_CreateDebris
import CG_GlassShatter
import CG_BubbleTrail
import CG_SmokePuff
import CG_AddLocalEntities
import CG_AllocLocalEntity
import CG_InitLocalEntities
import CG_OutOfAmmoChange
import CG_DrawIconBackground
import CG_DrawWeaponSelect
import CG_AddPlayerWeapon
import CG_AddViewWeapon
import CG_MissileHitPlayer
import CG_MissileHitWall
import CG_FireWeapon
import CG_RegisterItemVisuals
import CG_RegisterWeapon
import CG_Weapon_f
import CG_PrevWeapon_f
import CG_NextWeapon_f
import CG_GetClientWeaponMuzzleBoltPoint
import TurretClientRun
import ScaleModelAxis
import CG_PositionRotatedEntityOnTag
import CG_PositionEntityOnTag
import CG_AdjustPositionForMover
import CG_Beam
import CG_ManualEntityRender
import CG_AddPacketEntities
import CG_SetEntitySoundPosition
import CG_ReattachLimb
import CG_PainEvent
import CG_EntityEvent
import CG_PlaceString
import CG_CheckEvents
import CG_LoadDeferredPlayers
import CG_PredictPlayerState
import CG_Trace
import CG_PointContents
import CG_BuildSolidList
import CG_PlayerShieldHit
import CG_CustomSound
import CG_NewClientInfo
import CG_AddRefEntityWithPowerups
import CG_ResetPlayerEntity
import CG_Player
import CG_StatusHandle
import CG_OtherTeamHasFlag
import CG_YourTeamHasFlag
import CG_GameTypeString
import CG_CheckOrderPending
import CG_Text_PaintChar
import CG_Draw3DModel
import CG_GetKillerText
import CG_GetGameStatusText
import CG_GetTeamColor
import CG_InitTeamChat
import CG_SetPrintString
import CG_ShowResponseHead
import CG_DeferMenuScript
import CG_RunMenuScript
import CG_OwnerDrawVisible
import CG_GetValue
import CG_SelectNextPlayer
import CG_SelectPrevPlayer
import CG_Text_Height
import CG_Text_Width
import CG_Text_Paint
import CG_OwnerDraw
import CG_DrawTeamBackground
import CG_DrawFlagModel
import CG_DrawActive
import CG_DrawHead
import CG_CenterPrint
import CG_AddLagometerSnapshotInfo
import CG_AddLagometerFrameInfo
import teamChat2
import teamChat1
import systemChat
import drawTeamOverlayModificationCount
import numSortedTeamPlayers
import sortedTeamPlayers
import CG_DrawTopBottom
import CG_DrawSides
import CG_DrawRect
import UI_DrawScaledProportionalString
import UI_DrawProportionalString
import CG_GetColorForHealth
import CG_ColorForHealth
import CG_TileClear
import CG_TeamColor
import CG_FadeColor
import CG_DrawStrlen
import CG_DrawSmallStringColor
import CG_DrawSmallString
import CG_DrawBigStringColor
import CG_DrawBigString
import CG_DrawStringExt
import CG_DrawNumField
import CG_DrawString
import CG_DrawRotatePic2
import CG_DrawRotatePic
import CG_DrawPic
import CG_FillRect
import CG_TestModelAnimate_f
import CG_TestModelSetAnglespost_f
import CG_TestModelSetAnglespre_f
import CG_ListModelBones_f
import CG_ListModelSurfaces_f
import CG_TestModelSurfaceOnOff_f
import CG_TestG2Model_f
import CG_DrawActiveFrame
import CG_AddBufferedSound
import CG_ZoomUp_f
import CG_ZoomDown_f
import CG_TestModelPrevSkin_f
import CG_TestModelNextSkin_f
import CG_TestModelPrevFrame_f
import CG_TestModelNextFrame_f
import CG_TestGun_f
import CG_TestModel_f
import CG_PrevForcePower_f
import CG_NextForcePower_f
import CG_PrevInventory_f
import CG_NextInventory_f
import CG_BuildSpectatorString
import CG_SetScoreSelection
import CG_RankRunFrame
import CG_EventHandling
import CG_MouseEvent
import CG_KeyEvent
import CG_LoadMenus
import CG_LastAttacker
import CG_CrosshairPlayer
import CG_UpdateCvars
import CG_StartMusic
import CG_Error
import CG_Printf
import CG_Argv
import CG_ConfigString
import cg_debugBB
import ui_myteam
import cg_recordSPDemoName
import cg_recordSPDemo
import cg_singlePlayerActive
import cg_enableBreath
import cg_enableDust
import cg_singlePlayer
import cg_currentSelectedPlayerName
import cg_currentSelectedPlayer
import cg_blueTeamName
import cg_redTeamName
import cg_trueLightning
import cg_noProjectileTrail
import cg_noTaunt
import cg_bigFont
import cg_smallFont
import cg_cameraMode
import cg_timescale
import cg_timescaleFadeSpeed
import cg_timescaleFadeEnd
import cg_cameraOrbitDelay
import cg_cameraOrbit
import pmove_msec
import pmove_fixed
import cg_smoothClients
import cg_hudFiles
import cg_scorePlum
import cg_noVoiceText
import cg_noVoiceChats
import cg_teamChatsOnly
import cg_drawFriend
import cg_deferPlayers
import cg_predictItems
import cg_blood
import cg_paused
import cg_buildScript
import cg_forceModel
import cg_stats
import cg_teamChatHeight
import cg_teamChatTime
import cg_synchronousClients
import cg_drawEnemyInfo
import cg_lagometer
import cg_stereoSeparation
import cg_thirdPersonHorzOffset
import cg_thirdPersonAlpha
import cg_thirdPersonTargetDamp
import cg_thirdPersonCameraDamp
import cg_thirdPersonVertOffset
import cg_thirdPersonPitchOffset
import cg_thirdPersonAngle
import cg_thirdPersonRange
import cg_thirdPerson
import cg_dismember
import cg_animBlend
import cg_auraShell
import cg_speedTrail
import cg_duelHeadAngles
import cg_saberTrail
import cg_saberContact
import cg_saberDynamicMarkTime
import cg_saberDynamicMarks
import cg_fpls
import cg_saberModelTraceEffect
import cg_oldPainSounds
import cg_swingAngles
import cg_zoomFov
import cg_fov
import cg_simpleItems
import cg_ignore
import cg_autoswitch
import cg_tracerLength
import cg_tracerWidth
import cg_tracerChance
import cg_viewsize
import cg_drawGun
import cg_gun_z
import cg_gun_y
import cg_gun_x
import cg_gun_frame
import cg_addMarks
import cg_footsteps
import cg_showmiss
import cg_noPlayerAnims
import cg_nopredict
import cg_errorDecay
import cg_debugEvents
import cg_debugPosition
import cg_debugAnim
import cg_animSpeed
import cg_draw2D
import cg_drawStatus
import cg_crosshairHealth
import cg_crosshairSize
import cg_crosshairY
import cg_crosshairX
import cg_teamOverlayUserinfo
import cg_drawTeamOverlay
import cg_drawRewards
import cg_dynamicCrosshair
import cg_drawScores
import cg_drawCrosshairNames
import cg_drawCrosshair
import cg_drawAmmoWarning
import cg_drawIcons
import cg_draw3dIcons
import cg_drawSnapshot
import cg_drawFPS
import cg_drawTimer
import cg_shadows
import cg_bobroll
import cg_bobpitch
import cg_bobup
import cg_runroll
import cg_runpitch
import cg_centertime
export cg_markPolys
align 4
LABELV cg_markPolys
skip 73728
import cg_items
import cg_weapons
import cg_entities
import cg
import cgs
import CGCam_SetMusicMult
import CGCam_Shake
import cgScreenEffects
import ammoTicPos
import forceTicPos
import forcePowerDarkLight
import WeaponAttackAnim
import WeaponReadyAnim
import BG_OutOfMemory
import BG_StringAlloc
import BG_TempFree
import BG_TempAlloc
import BG_AllocUnaligned
import BG_Alloc
import BG_CanUseFPNow
import BG_HasYsalamiri
import BG_GetItemIndexByTag
import BG_ParseAnimationFile
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityStateExtraPolate
import BG_PlayerStateToEntityState
import BG_TouchJumpPad
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_ForcePowerDrain
import BG_SaberStartTransAnim
import BG_InDeathAnim
import BG_InRoll
import BG_KnockawayForParry
import BG_BrokenParryForParry
import BG_BrokenParryForAttack
import BG_SaberInSpecialAttack
import BG_SpinningSaberAnim
import BG_FlippingAnim
import BG_SaberInIdle
import BG_SaberInSpecial
import BG_SaberInAttack
import BG_DirectFlippingAnim
import BG_InSaberStandAnim
import BG_InSpecialJump
import BG_LegalizedForcePowers
import saberMoveData
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindItem
import vectoyaw
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import pm
import bgForcePowerCost
import forceMasteryPoints
import forceMasteryLevels
import bgGlobalAnimations
import BGPAFtextLoaded
import forcePowerSorted
import WP_MuzzlePoint
import ammoData
import weaponData
import GetStringForID
import GetIDForString
import Q_irand
import irand
import flrand
import Rand_Init
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey_Big
import Info_SetValueForKey
import Info_RemoveKey_big
import Info_RemoveKey
import Info_ValueForKey
import va
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseVec4
import COM_ParseFloat
import COM_ParseInt
import COM_ParseString
import COM_ParseWarning
import COM_ParseError
import COM_Compress
import COM_ParseExt
import COM_Parse
import SkipWhitespace
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_acos
import Q_log2
import VectorRotate
import Vector4Scale
import VectorNormalize2
import VectorNormalize
import CrossProduct
import VectorInverse
import VectorNormalizeFast
import DistanceSquared
import Distance
import VectorLengthSquared
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import powf
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkBlue
import colorLtBlue
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import colorTable
import bytedirs
import Com_Memcpy
import Com_Memset
import Hunk_Alloc
import forceSpeedLevels
import FloatSwap
import LongSwap
import ShortSwap
import acos
import fabs
import abs
import tan
import atan2
import cos
import sin
import sqrt
import floor
import ceil
import memcpy
import memset
import memmove
import sscanf
import vsprintf
import _atoi
import atoi
import _atof
import atof
import toupper
import tolower
import strncpy
import strstr
import strchr
import strcmp
import strcpy
import strcat
import strlen
import rand
import srand
import qsort
lit
align 1
LABELV $1654
char 1 67
char 1 71
char 1 95
char 1 66
char 1 108
char 1 111
char 1 111
char 1 100
char 1 80
char 1 111
char 1 111
char 1 108
char 1 32
char 1 112
char 1 115
char 1 104
char 1 97
char 1 100
char 1 101
char 1 114
char 1 32
char 1 61
char 1 61
char 1 32
char 1 90
char 1 69
char 1 82
char 1 79
char 1 33
char 1 10
char 1 0
align 1
LABELV $1600
char 1 67
char 1 71
char 1 95
char 1 79
char 1 105
char 1 108
char 1 83
char 1 108
char 1 105
char 1 99
char 1 107
char 1 82
char 1 101
char 1 118
char 1 111
char 1 118
char 1 101
char 1 32
char 1 78
char 1 85
char 1 76
char 1 76
char 1 32
char 1 105
char 1 100
char 1 10
char 1 0
align 1
LABELV $1586
char 1 67
char 1 71
char 1 95
char 1 80
char 1 97
char 1 114
char 1 116
char 1 105
char 1 99
char 1 108
char 1 101
char 1 95
char 1 79
char 1 105
char 1 108
char 1 83
char 1 108
char 1 105
char 1 99
char 1 107
char 1 32
char 1 61
char 1 61
char 1 32
char 1 90
char 1 69
char 1 82
char 1 79
char 1 33
char 1 10
char 1 0
align 1
LABELV $1578
char 1 67
char 1 71
char 1 95
char 1 80
char 1 97
char 1 114
char 1 116
char 1 105
char 1 99
char 1 108
char 1 101
char 1 95
char 1 79
char 1 105
char 1 108
char 1 80
char 1 97
char 1 114
char 1 116
char 1 105
char 1 99
char 1 108
char 1 101
char 1 32
char 1 61
char 1 61
char 1 32
char 1 90
char 1 69
char 1 82
char 1 79
char 1 33
char 1 10
char 1 0
align 1
LABELV $1564
char 1 67
char 1 71
char 1 95
char 1 80
char 1 97
char 1 114
char 1 116
char 1 105
char 1 99
char 1 108
char 1 101
char 1 95
char 1 66
char 1 108
char 1 101
char 1 101
char 1 100
char 1 32
char 1 112
char 1 115
char 1 104
char 1 97
char 1 100
char 1 101
char 1 114
char 1 32
char 1 61
char 1 61
char 1 32
char 1 90
char 1 69
char 1 82
char 1 79
char 1 33
char 1 10
char 1 0
align 1
LABELV $1554
char 1 67
char 1 71
char 1 95
char 1 80
char 1 97
char 1 114
char 1 116
char 1 105
char 1 99
char 1 108
char 1 101
char 1 73
char 1 109
char 1 112
char 1 97
char 1 99
char 1 116
char 1 83
char 1 109
char 1 111
char 1 107
char 1 101
char 1 80
char 1 117
char 1 102
char 1 102
char 1 32
char 1 112
char 1 115
char 1 104
char 1 97
char 1 100
char 1 101
char 1 114
char 1 32
char 1 61
char 1 61
char 1 32
char 1 90
char 1 69
char 1 82
char 1 79
char 1 33
char 1 10
char 1 0
align 1
LABELV $1494
char 1 67
char 1 71
char 1 95
char 1 80
char 1 97
char 1 114
char 1 116
char 1 105
char 1 99
char 1 108
char 1 101
char 1 69
char 1 120
char 1 112
char 1 108
char 1 111
char 1 115
char 1 105
char 1 111
char 1 110
char 1 58
char 1 32
char 1 117
char 1 110
char 1 107
char 1 110
char 1 111
char 1 119
char 1 110
char 1 32
char 1 97
char 1 110
char 1 105
char 1 109
char 1 97
char 1 116
char 1 105
char 1 111
char 1 110
char 1 32
char 1 115
char 1 116
char 1 114
char 1 105
char 1 110
char 1 103
char 1 58
char 1 32
char 1 37
char 1 115
char 1 10
char 1 0
align 1
LABELV $1485
char 1 67
char 1 71
char 1 95
char 1 80
char 1 97
char 1 114
char 1 116
char 1 105
char 1 99
char 1 108
char 1 101
char 1 69
char 1 120
char 1 112
char 1 108
char 1 111
char 1 115
char 1 105
char 1 111
char 1 110
char 1 58
char 1 32
char 1 97
char 1 110
char 1 105
char 1 109
char 1 83
char 1 116
char 1 114
char 1 32
char 1 105
char 1 115
char 1 32
char 1 112
char 1 114
char 1 111
char 1 98
char 1 97
char 1 98
char 1 108
char 1 121
char 1 32
char 1 97
char 1 110
char 1 32
char 1 105
char 1 110
char 1 100
char 1 101
char 1 120
char 1 32
char 1 114
char 1 97
char 1 116
char 1 104
char 1 101
char 1 114
char 1 32
char 1 116
char 1 104
char 1 97
char 1 110
char 1 32
char 1 97
char 1 32
char 1 115
char 1 116
char 1 114
char 1 105
char 1 110
char 1 103
char 1 0
align 1
LABELV $1466
char 1 67
char 1 71
char 1 95
char 1 80
char 1 97
char 1 114
char 1 116
char 1 105
char 1 99
char 1 108
char 1 101
char 1 83
char 1 109
char 1 111
char 1 107
char 1 101
char 1 32
char 1 61
char 1 61
char 1 32
char 1 90
char 1 69
char 1 82
char 1 79
char 1 33
char 1 10
char 1 0
align 1
LABELV $1445
char 1 67
char 1 71
char 1 95
char 1 80
char 1 97
char 1 114
char 1 116
char 1 105
char 1 99
char 1 108
char 1 101
char 1 83
char 1 110
char 1 111
char 1 119
char 1 32
char 1 112
char 1 115
char 1 104
char 1 97
char 1 100
char 1 101
char 1 114
char 1 32
char 1 61
char 1 61
char 1 32
char 1 90
char 1 69
char 1 82
char 1 79
char 1 33
char 1 10
char 1 0
align 1
LABELV $1430
char 1 67
char 1 71
char 1 95
char 1 80
char 1 97
char 1 114
char 1 116
char 1 105
char 1 99
char 1 108
char 1 101
char 1 83
char 1 110
char 1 111
char 1 119
char 1 70
char 1 108
char 1 117
char 1 114
char 1 114
char 1 121
char 1 32
char 1 112
char 1 115
char 1 104
char 1 97
char 1 100
char 1 101
char 1 114
char 1 32
char 1 61
char 1 61
char 1 32
char 1 90
char 1 69
char 1 82
char 1 79
char 1 33
char 1 10
char 1 0
align 1
LABELV $305
char 1 37
char 1 115
char 1 37
char 1 105
char 1 0
align 1
LABELV $287
char 1 101
char 1 120
char 1 112
char 1 108
char 1 111
char 1 100
char 1 101
char 1 49
char 1 0
align 1
LABELV $148
char 1 67
char 1 71
char 1 95
char 1 73
char 1 109
char 1 112
char 1 97
char 1 99
char 1 116
char 1 77
char 1 97
char 1 114
char 1 107
char 1 32
char 1 99
char 1 97
char 1 108
char 1 108
char 1 101
char 1 100
char 1 32
char 1 119
char 1 105
char 1 116
char 1 104
char 1 32
char 1 60
char 1 61
char 1 32
char 1 48
char 1 32
char 1 114
char 1 97
char 1 100
char 1 105
char 1 117
char 1 115
char 1 0
align 1
LABELV $131
char 1 67
char 1 71
char 1 95
char 1 70
char 1 114
char 1 101
char 1 101
char 1 76
char 1 111
char 1 99
char 1 97
char 1 108
char 1 69
char 1 110
char 1 116
char 1 105
char 1 116
char 1 121
char 1 58
char 1 32
char 1 110
char 1 111
char 1 116
char 1 32
char 1 97
char 1 99
char 1 116
char 1 105
char 1 118
char 1 101
char 1 0
