﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Net.Sockets;

namespace ConnlessPacketTester
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        // ----------------
        // SendRecv
        // Send req to ip and port.
        // Returns the lenght of bytes received and saves the data into buffer
        // ----------------
        static int SendRecv(string ip, int port, string req, byte[] buffer, int timeout = 1500)
        {
            // Set Timout
            Socket sock = new Socket(AddressFamily.InterNetwork, SocketType.Dgram, ProtocolType.Udp);
            sock.ReceiveTimeout = timeout;
            sock.SendTimeout = timeout;

            try
            {
                // Connect and send the request
                sock.Connect(ip, port);
                byte[] realReq = System.Text.Encoding.Default.GetBytes(req);
                sock.Send(realReq, 0, req.Length, SocketFlags.None);

                // Receive the answere
                int count = sock.Receive(buffer, 0, buffer.Length, SocketFlags.None);
                return count;
            }
            catch { return 0; }
        }

        static string QueryJK2Server(string ip, int port, string qstr, int timeout)
        {
            byte[] rawRecv = new byte[4096];
            int count = SendRecv(ip, port, "ÿÿÿÿ" + qstr, rawRecv, timeout);

            string recvStr = Encoding.Default.GetString(rawRecv, 0, count);
            return recvStr;
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            txtIP.Text = Properties.Settings.Default.IP;
            txtPort.Text = Properties.Settings.Default.Port;
            txtQuery.Text = Properties.Settings.Default.Query;
            txtResult.Text = Properties.Settings.Default.Result;
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            Properties.Settings.Default.IP = txtIP.Text;
            Properties.Settings.Default.Port = txtPort.Text;
            Properties.Settings.Default.Query = txtQuery.Text;
            Properties.Settings.Default.Result = txtResult.Text;

            Properties.Settings.Default.Save();
        }

        private void buttQuery_Click(object sender, EventArgs e)
        {
            string res = QueryJK2Server(txtIP.Text, int.Parse(txtPort.Text), txtQuery.Text, 1000);

            if (res.Length == 0)
                res = "failed";

            txtResult.Text = res;
        }
    }
}
