# Version checker and autodownload updater.
# Part of server starter/restarter and crash checker for Jedi Knight:Jedi Academy.
# BUILD 19062010 / V4.0
# DO NOT CHANGE THIS FILE UNLESS YOU KNOW WHAT YOU ARE DOING.

# Updater functions.

rmcmd ()
{

  ./rm -f "$@" > /dev/null 2>&1

}

mvcmd ()
{

  ./mv "$@" > /dev/null 2>&1

}

wgetcmd ()
{

  ./wget -U JASUPDATERB19062010 -q "$@" > /dev/null 2>&1

}

removetempfilef ()
{

  for removetempfile in $tempfiles; do

    if [ -f "$removetempfile" ]; then

      rmcmd "$removetempfile"

    fi

  done

}

success ()
{

  echo "Press ENTER to continue."
  read

  exit 0

}

error ()
{

  echo "Quitting..."
  echo "Press ENTER to continue."
  read
    
  exit 100

}

# Updater variables.

source="http://www.zombiehugs.com/jascript/windows"
tempfiles="version.txt arithmetic.updater filecheck.updater"

if [ -f cfg/script.cfg ]; then

  . cfg/script.cfg # Configurarion call (new path).

elif [ -f script.cfg ]; then

  . script.cfg # Configurarion call (old path).

else

  echo "ERROR: Could not find script.cfg."
  echo "Please make sure script.cfg is located on the cfg folder within the script directory or on the script directory itself."
  echo "Also, the updater must be located at the script directory."

  error

fi

echo "Initializing Updater..."
echo

# Checking for the existance of the Master script.

echo -n "Checking for master.sh (Master script)..."

if [ -f master.sh ]; then

  echo "Found!"

else

  echo "Not found!"
  echo "WARNING: Please make sure the updater is running on the script directory."
  echo "WARNING: If you do not have a master.sh, your version is too old, and a full download is required."

  masternf="YES"

fi

# Autodownload value check.

if [ -n "$autodownload" ]; then

  case "$autodownload" in

    0)

      echo -n "Autodownload is disabled."

    ;;

    1)

      if [ -z "$masternf" ]; then

        echo -n "Autodownload is enabled."

        if [ -n "$cgipath" ]; then

          echo " CGI Script path is set to "$cgipath". Autodownload will check this file and update if necessary."
          ucgipath="$cgipath"

        else

          echo " CGI Script path is not set. Autodownload will use the default folder cgi-bin instead."
          ucgipath="cgi-bin/jkascript.cgi"

        fi

      else

        echo -n "WARNING: Autodownload has been forced to disabled because the master script could not be found."
        autodownload=0

      fi

    ;;

    *)

    echo "ERROR: Autodownload value is incorrect. Please check your script.cfg and set a value between 0 and 1."

    error

    ;;

  esac

else

  echo "ERROR: Autodownload value is not set. Please check your script.cfg and set a value between 0 and 1."

  error

fi

# Create cfg, old, and old/cfg folders if they do not exist, and if autodownload is enabled.

if [ "$autodownload" -eq 1 ]; then

  echo "Checking for cfg, old, and old/cfg folders..."

  if [ -d cfg ] && [ -d old ] && [ -d old/cfg ]; then

    echo "All checked, continuing with the updater."

  else

    echo "At least one folder does not exist. Making individual checks now, and creating them."
    echo -n "Checking for mkdir..."

    if [ -f mkdir.exe ]; then

      echo "Found!"

    else

      echo "Not found!"
      echo -n "Downloading mkdir.exe..."
      wgetcmd "$source"/mkdir.exe

      if [ -f mkdir.exe ]; then

        echo "DONE!"

      else

        echo
        echo "ERROR: Could not download mkdir.exe."
        echo "Please create the folders cfg, old, and old/cfg manually and re-run the script."

        error

      fi

    fi

    for folder in cfg old "old/cfg"; do

      echo -n "Checking "$folder"..."

      if [ -d "$folder" ]; then

        echo "EXIST!"

      else

        echo -n "Creating..."
        ./mkdir "$folder" > /dev/null 2>&1

        if [ -d "$folder" ]; then

          echo "DONE!"

        else

          echo
          echo "ERROR: Could not create "$folder"."
          echo "Please create folder "$folder" manually and re-run the script."

          error

        fi

      fi

    done

  fi

# Moving old and cfg files to their correct location.

  for movefile in *.cfg *.cfg.old *.old; do

    case "$movefile" in

      *.cfg)

        movedir="cfg"

      ;;

      *.cfg.old)

        movedir="old/cfg"

      ;;

      *.old)

        movedir="old"

      ;;

    esac

    if [ -f "$movefile" ]; then

      echo -n "Moving "$movefile" to "$movedir"..."

      mvcmd -fu "$movefile" "$movedir"

      if [ -f "$movedir"/"$movefile" ]; then

        echo "DONE!"

        if [ -f "$movefile" ]; then

          rmcmd "$movefile"

        fi

      else

        echo "NOT POSSIBLE." 
        echo "WARNING: You will need to move this file manually."

      fi

    fi

  done

else

  echo " Cfg, old, and old/cfg folders check disabled."

fi

# Deleting outdated temporary files, if they exist.

for dtempfile in $tempfiles; do

  if [ -f "$dtempfile" ]; then

    rmcmd "$dtempfile"

    if [ -f "$dtempfile" ]; then

      echo "WARNING: Temporary file "$dtempfile" was not deleted."

      if [ "$dtempfile" = version.txt ]; then

        echo "ERROR: version.txt is required to be deleted before continuing with the updater."
        echo "Please delete this file manually and re-run the updater."

        error

      fi

    fi

  fi

done

# Checking the current version.

. version.sh > /dev/null 2>&1 # Version call.

if [ -n "$version" ] && [ -n "$subversion" ]; then

  echo "Current version: "$version"."$subversion""
  echo
  versioncv="EXIST"

else

  echo "ERROR: Could not check the current version."
  echo
  versioncv="NOT"

fi

wgetcmd "$source"/version.txt # Downloading version check file.

. version.txt > /dev/null 2>&1 # Importing web version check file.

# Checking for WAN access with the check server.

if [ "$webconnectivity" = YES ]; then

# If current version exists, check for a new version.

  if [ "$versioncv" = EXIST ]; then

    echo "Checking for a new version..."
    echo "========================================================================"

    if [ "$version"."$subversion" = "$webversion"."$websubversion" ]; then

      echo "Lastest version in use, skipping update."
      echo
      removetempfilef

      success

    else

      echo "New version found!"
      echo "New version: "$webversion"."$websubversion""
      echo
      requpdate=YES

    fi

  fi

# Mirror list for no current version found or autodownload is disabled.

  if [ "$autodownload" -eq 0 ] && [ "$requpdate" = YES ] || [ "$versioncv" = NOT ] || [ "$masternf" = YES ]; then

    echo "You can download the full version from the following mirror(s) below."
    echo

    mirrorf=STARTMIRRORLOOP

    while [ -n "$mirrorf" ]; do

      if [ "$mirrorf" != STARTMIRRORLOOP ]; then
          
        echo "Mirror "$upari": "$mirrorf""

      else

        uparibase=0

      fi

      let upari="$uparibase"+1
      uparibase="$upari"

      echo 'mirrorf="$'mirror$upari'"' > arithmetic.updater

      . arithmetic.updater > /dev/null 2>&1

    done

    echo

# Autodownload if a new version is found.

  elif [ "$autodownload" -eq 1 ] && [ "$requpdate" = YES ] && [ -z "$masternf" ]; then

    if [ -f script.pid ]; then

      scriptstatus=`tasklist /V /NH /FI "IMAGENAME eq bash.exe" | ./grep -s "$user" | ./gawk '{print $2}' | ./grep -ws -f script.pid`

      if [ -n "$scriptstatus" ]; then

        echo "ERROR: Script is running."
        echo "You will need to shutdown the script before running autodownload."

        error

      fi

    fi

    echo "Initializing autodownload..."
    echo

# Delete outdated or files no longer used.

    echo "*** Deleting outdated files: ***"
    echo

    if [ -z "$dfile1" ]; then

      echo "No files to be deleted."

    else

      dfilef=STARTDFILELOOP

      while [ -n "$dfilef" ]; do

        if [ "$dfilef" != STARTDFILELOOP ]; then

          echo -n "Deleting "$dfilef"..."

          if [ -f "$dfilef" ]; then

            rmcmd "$dfilef"

            if [ ! -f "$dfilef" ]; then

              echo "DONE!"

            else

              echo
              echo "ERROR: File "$dfilef" was not deleted."
              echo "Please, delete this file manually, and re-run the updater."

              removetempfilef

              error

            fi


          else

            echo "DOES NOT EXIST."

          fi

        else

          uparibase=0

        fi

        let upari="$uparibase"+1
        uparibase="$upari"

        echo 'dfilef="$'dfile$upari'"' > arithmetic.updater

        . arithmetic.updater > /dev/null 2>&1

      done

    fi

# Download/Update bash scripts.
    
    echo
    echo "*** Checking bash script files: ***"
    echo

    if [ -z "$sfile1" ]; then

      echo "No new bash script to update."

    else

      sfilef=STARTSFILELOOP

      while [ -n "$sfilef" ]; do

        if [ "$sfilef" != STARTSFILELOOP ]; then

          echo -n "Checking "$sfilef"..."

          if [ -f "$sfilef" ]; then

            ./grep -ws "versionc=" "$sfilef" > filecheck.updater

            . filecheck.updater > /dev/null 2>&1

          else

            versionc=

          fi

          sfilec="$versionc"

          if [ "$sfilec" = "$websfilecf" ]; then

            echo "UP TO DATE."

          else

            if [ -f "$sfilef" ]; then

              echo "NOT UP TO DATE."
              echo -n "Updating "$sfilef"..."
              mvcmd -fu "$sfilef" old/"$sfilef".old

              if [ -f "$sfilef" ]; then

                rmcmd "$sfilef"

                if [ -f "$sfilef" ]; then

                  echo
                  echo "ERROR: Could not remove "$sfilef"."
                  echo "Please, remove this file manually, and re-run the script."

                  removetempfilef

                  error

                fi

              fi

            else

              echo "DOES NOT EXIST."
              echo -n "Downloading "$sfilef"..."

            fi

            wgetcmd "$source"/"$sfilef"

            if [ -f "$sfilef" ]; then

              echo "DONE!"

            else

              echo
              echo "ERROR: "$sfilef" was not downloaded."
              echo "Please, try running the updater again, or download the full version."

              if [ -f old/"$sfilef".old ]; then

                mvcmd -f old/"$sfilef".old "$sfilef"

              fi

              removetempfilef

              error

            fi

          fi

        else

          uparibase=0

        fi

        let upari="$uparibase"+1
        uparibase="$upari"

        echo 'sfilef="$'sfile$upari'"' > arithmetic.updater
        echo 'websfilecf="$'websfilec$upari'"' >> arithmetic.updater

        . arithmetic.updater > /dev/null 2>&1

      done

    fi

# Download/Update CFG files.
    
    echo
    echo "*** Checking CFG files: ***"
    echo

    if [ -z "$cfile1" ]; then

      echo "No new CFG file to update."

    else

      cfilef=STARTCFILELOOP

      while [ -n "$cfilef" ]; do

        if [ "$cfilef" != STARTCFILELOOP ]; then

          echo -n "Checking "$cfilef"..."

          if [ -f cfg/"$cfilef" ]; then

            ./grep -ws "versionc=" cfg/"$cfilef" > filecheck.updater

            . filecheck.updater > /dev/null 2>&1

          else

            versionc=

          fi

          cfilec="$versionc"

          if [ "$cfilec" = "$webcfilecf" ]; then

            echo "UP TO DATE."

          else

            if [ -f cfg/"$cfilef" ]; then

              echo "NOT UP TO DATE."
              echo -n "Updating "$cfilef"..."
              mvcmd -fu cfg/"$cfilef" old/cfg/"$cfilef".old

              if [ -f cfg/"$cfilef" ]; then

                rmcmd cfg/"$cfilef"

                if [ -f cfg/"$cfilef" ]; then

                  echo
                  echo "ERROR: Could not remove "$cfilef"."
                  echo "Please, remove this file manually, and re-run the script."

                  removetempfilef

                  error

                fi

              fi

            else

              echo "DOES NOT EXIST."
              echo -n "Downloading "$cfilef"..."

            fi

            wgetcmd "$source"/cfg/"$cfilef" -P cfg

            if [ -f cfg/"$cfilef" ]; then

              echo "DONE!"

            else

              echo
              echo "ERROR: "$cfilef" was not downloaded."
              echo "Please, try running the updater again or download the full version."

              if [ -f old/cfg/"$cfilef".old ]; then

                mvcmd -f old/cfg/"$cfilef".old cfg/"$cfilef"

              fi

              removetempfilef

              error

            fi

          fi

        else

          uparibase=0

        fi

        let upari="$uparibase"+1
        uparibase="$upari"

        echo 'cfilef="$'cfile$upari'"' > arithmetic.updater
        echo 'webcfilecf="$'webcfilec$upari'"' >> arithmetic.updater

        . arithmetic.updater > /dev/null 2>&1

      done

    fi

# Download non-script files.
    
    echo
    echo "*** Checking non-script files: ***"
    echo

    if [ -z "$nfile1" ]; then

      echo "No new non-script file to download."

    else

      nfilef=STARTNFILELOOP

      while [ -n "$nfilef" ]; do

        if [ "$nfilef" != STARTNFILELOOP ]; then

          echo -n "Checking "$nfilef"..."

          if [ -f "$nfilef" ]; then

            echo "EXIST!"

          else

            echo "DOES NOT EXIST."
            echo -n "Downloading "$nfilef"..."
            wgetcmd "$source"/"$nfilef"

            if [ -f "$nfilef" ]; then

              echo "DONE!"

            else

              echo
              echo "ERROR: "$nfilef" was not downloaded."
              echo "Please, try running the updater again, or download the full version."

              removetempfilef

              error

            fi

          fi

        else

          uparibase=0

        fi

        let upari="$uparibase"+1
        uparibase="$upari"

        echo 'nfilef="$'nfile$upari'"' > arithmetic.updater

        . arithmetic.updater > /dev/null 2>&1

      done

    fi

# Download/Update the CGI script.

    echo
    echo "*** Checking the CGI script: ***"
    echo

    if [ -z "$cgifile" ]; then

      echo "No new version of the CGI script to update."

    else

      echo -n "Checking "$ucgipath"..."

      if [ -f "$ucgipath" ]; then

        ./grep -ws "versionc=" "$ucgipath" > filecheck.updater

        . filecheck.updater > /dev/null 2>&1

      else

        versionc=

      fi

      cgifilec="$versionc"

      if [ "$cgifilec" = "$webcgifilec" ]; then

        echo "UP TO DATE."

      else

        if [ -f "$ucgipath" ]; then

          echo "NOT UP TO DATE."
          echo -n "Updating "$ucgipath"..."
          mvcmd -fu "$ucgipath" old/jkascript.cgi.old

          if [ -f "$ucgipath" ]; then

            rmcmd "$ucgipath"

            if [ -f "$ucgipath" ]; then

              echo
              echo "ERROR: Could not remove "$ucgipath"."
              echo "Please, remove this file manually, and re-run the script."

              removetempfilef

              error

            fi

          fi

        else

          echo "DOES NOT EXIST."
          echo -n "Downloading jkascript.cgi..."

        fi

        wgetcmd "$source"/cgi-bin/"$cgifile" -P cgi-bin

        mvcmd -f cgi-bin/"$cgifile" "$ucgipath"

        if [ -f "$ucgipath" ]; then

          echo "DONE!"

        else

          echo
          echo "ERROR: jkascript.cgi was not downloaded."
          echo "Please, try running the updater again or download the full version."

          if [ -f old/jkascript.cgi.old ]; then

            mvcmd -f old/jkascript.cgi.old "$ucgipath"

          fi

          removetempfilef

          error

        fi

      fi

    fi

# Download/Update mandatory files.

    echo
    echo "*** Checking mandatory files: ***"
    echo

    mfilef=STARTMFILELOOP

    while [ -n "$mfilef" ]; do

      if [ "$mfilef" != STARTMFILELOOP ]; then

        echo -n "Checking "$mfilef"..."

        if [ -f "$mfilef" ]; then

          echo "EXIST!"
          echo -n "Replacing "$mfilef"..."
          rmcmd "$mfilef"

          if [ -f "$mfilef" ]; then

            echo
            echo "ERROR: Could not remove "$mfilef"."
            echo "Please, remove this file manually and re-run the updater."

            removetempfilef

            error

          fi

        else

          echo "DOES NOT EXIST."
          echo -n "Downloading "$mfilef"..."

        fi

        wgetcmd "$source"/"$mfilef"

        if [ -f "$mfilef" ]; then

          echo "DONE!"

        else

          echo
          echo "ERROR: "$mfilef" was not downloaded."
          echo "Please, try running the updater again, or download the full version."

          removetempfilef

          error

        fi

      else

        uparibase=0

      fi

      let upari="$uparibase"+1
      uparibase="$upari"

      echo 'mfilef="$'mfile$upari'"' > arithmetic.updater

      . arithmetic.updater > /dev/null 2>&1

    done

    echo
    echo "*** The updater has completed its task successfully. ***"
    echo

  else

    echo "ERROR."

    error

  fi

# No WAN access with the check server.

else

  echo "ERROR: Could not contact the check server."
  echo "Please, check http://www.moviebattles.com/forums/showthread.php?t=32016 for the full version, bug reports, feedback, and if you need help."

  error

fi

# Deleting any temporary file left behind.

removetempfilef

# If the script made this far, exit with a code 0 success.

success