# Master script.
# Part of server starter/restarter and crash checker for Jedi Knight:Jedi Academy.
# DO NOT CHANGE THIS FILE UNLESS YOU KNOW WHAT YOU ARE DOING.

# Date code for autodownload.

versionc="19062010" # NEVER CHANGE THIS LINE OR AUTODOWNLOAD WILL BREAK.

errorcode=1 # Error code related to the script. DO NOT CHANGE.

# Script pid generated at every script run.

echo "$$" > script.pid

# Global Functions.

rmcmd ()
{

  if [ "$errorcode" -eq 3 ]; then

    "$scriptdir"/rm.exe -f "$@" > /dev/null 2>&1

  else

    ./rm.exe -f "$@" > /dev/null 2>&1

  fi

}

processstatus ()
{

  if [ "$errorcode" -eq 3 ]; then

    tasklist /V /NH /FI "IMAGENAME eq "$process"" | "$scriptdir"/grep -s "$user"

  else

    tasklist /V /NH /FI "IMAGENAME eq "$process"" | ./grep -s "$user"

  fi

}

killprocess ()
{

  taskkill /F /FI "USERNAME eq "$user"" /IM "$process" /T > /dev/null 2>&1

}

success ()
{

  echo 0 > exitcode
  return 0

}

error ()
{

  echo "ERROR CODE "$errorcode"."
  echo "Quitting..."

  if [ "$errorcode" -eq 3 ]; then

    if [ -f "$scriptdir"/serverstarter.pid ]; then

      errorppid=`"$scriptdir"/cat "$scriptdir"/serverstarter.pid`

    fi

    echo "$errorcode" > "$scriptdir"/exitcode

  else

    if [ -f serverstarter.pid ]; then

      errorppid=`./cat serverstarter.pid`

    fi

    echo "$errorcode" > exitcode

  fi

  if [ -n "$errorppid" ]; then

    taskkill /F /PID "$errorppid" /T > /dev/null 2>&1

  fi

  echo "Press ENTER to continue."
  read
    
  exit "$errorcode"

}

# Check for the exit code from the previous run and reset the exitcode if an error has been detected.

if [ -f exitcode ]; then

  exitcode=`./cat exitcode`

  if [ "$exitcode" -ne 0 ]; then

    echo "********** ATTENTION **********"
    echo "The script has detected ERROR CODE "$exitcode" from your previous run."
    echo "If the error persists, contact me for help with the exactly error code displayed above."
    echo "Information of how to contact me is included in the README.txt."
    echo "********** ATTENTION **********"
    echo 0 > exitcode
    echo

  fi

fi

echo "Starting server starter/restarter and crash checker for Jedi Knight:Jedi Academy..."
echo

. cfg/script.cfg # Configurarion call.

# Setting the script directory.

scriptdir=`pwd`

# Server binary file check.

echo -n "Checking the server binary file..."

if [ -n "$process" ]; then

  if [ -f "$dir"/"$process" ]; then

    echo ""$process" found."

  else

    echo
    echo "ERROR: Could not find the process(server binary file), please check if the file exists and/or if the DIR folder is set correctly in your script.cfg."
  
    error

  fi

else

  echo
  echo "ERROR: Process(server binary file) is not set, please check your script.cfg."

  error

fi

# Username check.

if [ -n "$user" ]; then

  echo "Username: "$user""

else

  echo "ERROR: Username is not set, please check your script.cfg."

  error

fi

# Dynamic Rotation value check.

if [ -n "$drotation" ]; then

  case "$drotation" in

    0)

      echo "Dynamic Rotation is disabled, skipping it."

    ;;

    1)

      echo -n "Dynamic Rotation is enabled."

      if [ -n "$drtype" ]; then

        case "$drtype" in

          1)

            echo " Daily mode."

          ;;

          2)

            echo " Monthly mode."

          ;;

          *)

            echo
            echo "ERROR: Dynamic Rotation type is incorrect, please check your script.cfg and set a value between 1 and 2."
            
            error

          ;;

        esac

      else

        echo
        echo "ERROR: Dynamic Rotation type is not set, please check your script.cfg and set a value between 1 and 2."

        error

      fi

    ;;

    *)

      echo "ERROR: Value for Dynamic Rotation is incorrect, please check your script.cfg and set a value between 0 and 1."

      error

    ;;

  esac

else

  echo "ERROR: Value for Dynamic Rotation is not set, please check your script.cfg and set a value between 0 and 1."

  error

fi

# Check method value check.

if [ -n "$check" ]; then

  case "$check" in

    1)

      echo -n "Check method set for normal Nmap UDP port check."

      if [ -n "$nip" ]; then

        echo -n " IP: "$nip""

      else

        echo
        echo "ERROR: Server IP for Nmap check is not set, please check your script.cfg."

        error

      fi

      if [ -n "$nport" ]; then

        if [ "$nport" -gt 0 ] && [ "$nport" -lt 65535 ]; then  
        
          echo " Port: "$nport""

        else

          echo
          echo "ERROR: Server port for Nmap is incorrect. Ports are numeric values only, and range from 1 to 65535."

          error

        fi

      else

        echo
        echo "ERROR: Server port for Nmap check is not set, please check your script.cfg."

        error

      fi

    ;;

    2)

      echo -n "Check method set for spoofed Nmap UDP port check."

      if [ -n "$nip" ]; then

        echo -n " IP: "$nip""

      else

        echo
        echo "ERROR: Server IP for Nmap check is not set, please check your script.cfg."

        error

      fi

      if [ -n "$nport" ]; then

        if [ "$nport" -gt 0 ] && [ "$nport" -lt 65535 ]; then 

          echo -n " Port: "$nport""

        else

          echo
          echo "ERROR: Server port for Nmap is incorrect. Ports are numeric values only, and range from 1 to 65535."

          error

        fi

      else

        echo
        echo "ERROR: Server port for Nmap check is not set, please check your script.cfg."

        error

      fi

      if [ -n "$device" ]; then

        echo -n " Device: "$device""

      else

        echo
        echo "ERROR: Device is not set, please check your script.cfg."

        error

      fi

      if [ -n "$ips" ]; then

        echo " Fake IP: "$ips""

      else

        echo
        echo "ERROR: Fake IP is not set, please check your script.cfg."

        error

      fi

    ;;

    3)

      echo -n "Check method set for Ncat UDP port check."

      if [ -n "$ncport" ]; then

        if [ "$ncport" -gt 0 ] && [ "$ncport" -lt 65535 ]; then 

          echo " Port: "$ncport""

        else

          echo
          echo "ERROR: Server port for Ncat is incorrect. Ports are numeric values only, and range from 1 to 65535."

          error

        fi

      else

        echo
        echo "ERROR: Server port for Ncat check is not set, please check your script.cfg."

        error

      fi

    ;;

    *)

      echo "ERROR: Value for the check method is incorrect, please check your script.cfg and set a value between 1 and 3."
      
      error

    ;;

  esac

else

  echo "ERROR: No check method is set, please check your script.cfg and set a value between 1 and 3."

  error

fi

# HTML values check.

if [ -n "$html" ]; then

  case "$html" in

    0)

      echo "HTML server status page generator is disabled, skipping it."

    ;;

    1)  

      echo "HTML server status page generator is enabled."
      echo -n "HTML Options:"

      if [ -n "$htmlfile" ]; then

        echo -n " HTML File: "$htmlfile""

      else

        echo
        echo "ERROR: HTML File is not set, please check your script.cfg and set a proper location/file."

        error

      fi

      if [ -n "$htmlshowdrotation" ]; then

        case "$htmlshowdrotation" in

          0)

            echo -n " Display Dynamic Rotation: NO"

          ;;

          1)

            if [ "$drotation" -eq 1 ]; then

              echo -n " Display Dynamic Rotation: YES"

            else

              echo -n " WARNING: Display Dynamic Rotation: YES (WILL NOT BE DISPLAYED BECAUSE DYNAMIC ROTATION IS NOT ENABLED)"

            fi

          ;;

          *)

            echo
            echo "ERROR: Value for display Dynamic Rotation is incorrect, please check your script.cfg and set a value between 0 and 1."

            error

          ;;

        esac

      else

        echo
        echo "ERROR: Value for display Dynamic Rotation is not set, please check your script.cfg and set a value between 0 and 1."

        error

      fi

      if [ -n "$displaystartlog" ]; then

        case "$displaystartlog" in

          0)

            echo -n " Display start log: NO"

          ;;

          1)

            if [ -n "$lognormal" ]; then

              echo -n " Display start log: YES"

            else

              echo -n " WARNING: Display start log: YES (LOG FILE NOT SET)"

            fi

          ;;      

          *)

            echo
            echo "ERROR: Value for display start log is incorrect, please check your script.cfg and set a value between 0 and 1."

            error

          ;;

        esac

      else

        echo
        echo "ERROR: Value for display start log is not set, please check your script.cfg and set a value between 0 and 1."

        error

      fi

      if [ -n "$displaycrashlog" ]; then

        case "$displaycrashlog" in

          0)

            echo -n " Display crash log: NO"

          ;;

          1)

            if [ -n "$logcrash" ]; then

              echo -n " Display crash log: YES"

            else

              echo -n " WARNING: Display crash log: YES (LOG FILE NOT SET)"

            fi

          ;;

          *)

            echo
            echo "ERROR: Value for display crash log is incorrect, please check your script.cfg and set a value between 0 and 1."

            error

          ;;

        esac

      else

        echo
        echo "ERROR: Value for display crash log is not set, please check your script.cfg and set a value between 0 and 1."

        error

      fi

      if [ -n "$useftp" ]; then

        case "$useftp" in

          0)

            echo " FTP: Disabled"

          ;;

          1)

            echo -n " FTP: Enabled"

            if [ -n "$ftphost" ]; then

              echo -n " FTP Host: "$ftphost""

            else

              echo
              echo "ERROR: FTP Host is not set, please check your script.cfg."

              error

            fi

            if [ -n "$ftpuser" ]; then

              echo -n " FTP User: "$ftpuser""

            else

              echo
              echo "ERROR: FTP User is not set, please check your script.cfg."

              error

            fi

            if [ -n "$ftppassword" ]; then

              echo -n " FTP Password: SET"

            else

              echo
              echo "ERROR: FTP Password is not set, please check your script.cfg."

              error

            fi

            if [ -n "$rhtmlfile" ]; then

              echo " FTP Remote location: "$rhtmlfile""

            else

              echo
              echo "ERROR: Remote location for the html file is not set, please check your script.cfg."

              error

            fi

          ;;

          *)

            echo
            echo "ERROR: Value for use FTP is incorrect, please check your script.cfg and set a value between 0 and 1."

            error

          ;;

        esac

      else

        echo
        echo "ERROR: Value for use FTP is not set, please check your script.cfg and set a value between 0 and 1."

        error

      fi

    ;;

    *)

      echo "ERROR: Value for HTML is incorrect, please check your script.cfg and set a value between 0 and 1."

      error

    ;;

  esac

else

  echo "ERROR: Value for HTML is not set, please check your script.cfg and set a value between 0 and 1."

  error

fi

# Time value check.

if [ -n "$time" ]; then

  if [ "$time" -ge 60 ]; then

    echo "Script restart time set for "$time" seconds."

  else

    echo "ERROR: Value for script restart time is incorrect, please check your script.cfg and set a value between 60 and above."
    echo "Time is limited to a minimum of 60 seconds to avoid overflow."

    error

  fi

else

  echo "ERROR: Value for script restart time is not set, please check your script.cfg and set a value between 60 and above."
  echo "Time is limited to a minimum of 60 seconds to avoid overflow."

  error

fi

# Declare server options.

if [ -n "$game" ]; then

  sgame="+set fs_game "$game""  

fi

if [ -n "$cfg" ]; then

  scfg="+exec "$cfg""

fi

if [ -n "$ip" ]; then

  sip="+set net_ip "$ip""

fi

if [ -n "$port" ]; then

  sport="+set net_port "$port""

fi

if [ -n "$logserver" ]; then

  slogserver='>> "'$logserver'" 2>&1'

fi

# Server starter script. Check and creation.

serverstarter="serverstarter.sh"

if [ -f "$serverstarter" ]; then

  echo -n "Updating "$serverstarter"..."

else

  echo -n "Creating "$serverstarter"..."

fi

echo '# Server Starter script.' > serverstarter.sh
echo '# THIS FILE WAS AUTO GENERATED.' >> serverstarter.sh
echo '# DO NOT EDIT.' >> serverstarter.sh
echo >> serverstarter.sh
echo 'echo "$$" > serverstarter.pid' >> serverstarter.sh
echo 'serverstarterf ()' >> serverstarter.sh
echo '{' >> serverstarter.sh 

if [ -n "$lognormal" ]; then

  echo 'echo "Server start/restart recorded at `./date`" >> "'$lognormal'"' >> serverstarter.sh

fi

echo 'cd "'$dir'"' >> serverstarter.sh
echo 'echo "Starting Server..."' >> serverstarter.sh
echo ''$process' "'$sgame' +set dedicated 2 '$scfg' '$sip' '$sport'" '$slogserver'' >> serverstarter.sh
echo "echo" >> serverstarter.sh
echo 'echo "Server process killed."' >> serverstarter.sh
echo "echo" >> serverstarter.sh
echo 'cd "'$scriptdir'"' >> serverstarter.sh
echo "serverstarterf" >> serverstarter.sh
echo '}' >> serverstarter.sh
echo "serverstarterf" >> serverstarter.sh

if [ -f "$serverstarter" ]; then

  echo "DONE!"

else

  echo
  echo "ERROR: Could not create/update "$serverstarter"."

  error

fi

# LOOPING FROM HERE.

while [ "$?" -eq 0 ]; do

# Dynamic Rotation call.

  if [ "$drotation" -eq 1 ]; then

    . drotation.sh

# Resetting error code for the Master script.

    errorcode=1

  fi

# Server starter process check.

  if [ -f serverstarter.pid ]; then

    palivestarter=`tasklist /V /NH /FI "IMAGENAME eq bash.exe" | ./grep -s "$user" | ./gawk '{print $2}' | ./grep -ws -f serverstarter.pid`

  else

    palivestarter=

  fi

  if [ -z "$palivestarter" ]; then

    echo -n "Initializing Server Starter..."
    . serverstarter.sh &
    sleep 5
    echo "DONE!"
    echo "========================================================================"

  fi

# Server status checker start.

  . ccheck.sh

# Resetting error code for the Master script.

  errorcode=1

# HTML Generator.

  if [ "$html" -eq 1 ]; then

    . html.sh

# Resetting error code for the Master script.

    errorcode=1

  fi

# Sleeping. (Script restart time)

  ./sleep "$time"

done

# END OF LOOP.

# The script will never reach this error exit, unless a problem has been detected.

error