# HTML server status generator script.
# Part of server starter/restarter and crash checker for Jedi Knight:Jedi Academy.
# DO NOT CHANGE THIS FILE UNLESS YOU KNOW WHAT YOU ARE DOING.

# Date code for autodownload.

versionc="19062010" # NEVER CHANGE THIS LINE OR AUTODOWNLOAD WILL BREAK.

errorcode=4 # Error code related to the script. DO NOT CHANGE.

echo "Initializing HTML server status generator..."
echo "========================================================================"

# Check if the HTML file exists.

if [ -f "$htmlfile" ]; then

  echo "Updating HTML server status page..."
 
else

  echo "Creating HTML server status page..."

fi

# HTML Initial code.

echo '<html>' > "$htmlfile"
echo '<head>' >> "$htmlfile"
echo '<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">' >> "$htmlfile"
echo '<meta http-equiv="refresh" content="'$time';URL=?">' >> "$htmlfile"
echo "<title>Server status page for "$htmlservername"</title>" >> "$htmlfile"
echo '</head>' >> "$htmlfile"
echo '<body bgcolor="#888888">' >> "$htmlfile"

  echo "Server status page generated on `./date`" >> "$htmlfile"
  echo "<br>" >> "$htmlfile"
  echo "<br>" >> "$htmlfile"
  echo '<b>Server:</b> <span style="color: #33CCFF">'$htmlservername'</span> (<span style="color: blue"><b>'$htmlserveraddress'</b></span>)' >> "$htmlfile"
  echo "<br>" >> "$htmlfile"
  echo "<br>" >> "$htmlfile"

# Server process status.

  echo -n "<b>JKA Server process status:</b> " >> "$htmlfile"

  palivehtml=`processstatus`

  if [ -n "$palivehtml" ]; then

    echo '<span style="color: #009900"><b>ON</b></span>' >> "$htmlfile"
    echo "<br>" >> "$htmlfile"

  else

    echo '<span style="color: red"><b>OFF</b></span>' >> "$htmlfile"
    echo "<br>" >> "$htmlfile"

  fi

# Dynamic Rotation status.

  echo -n "<b>Dynamic Rotation status:</b> " >> "$htmlfile"

  case "$drotation" in

    0)

      echo '<span style="color: red"><b>Disabled</b></span>' >> "$htmlfile"
      echo "<br>" >> "$htmlfile"

    ;;

    1)

      echo '<span style="color: #009900"><b>Enabled</b></span>' >> "$htmlfile"
      echo "<br>" >> "$htmlfile"

    ;;

    *)

      echo

      error

    ;;

  esac

# Dynamic Rotation display.

  if [ "$htmlshowdrotation" -eq 1 ]; then

    if [ "$drotation" -eq 1 ]; then

      case "$drtype" in

        1)

          . cfg/drotation_day.cfg # Daily Dynamic Rotation configurarion call.

          htmldrtypeshow="Day"
          htmldatedr=`./date +%A`

          case "$htmldatedr" in
 
            Sunday)

              htmlrxmap=r1map

            ;;

            Monday)

              htmlrxmap=r2map

            ;;

            Tuesday)

              htmlrxmap=r3map

            ;;

            Wednesday)

              htmlrxmap=r4map

            ;;

            Thursday)

              htmlrxmap=r5map

            ;;

            Friday)

              htmlrxmap=r6map

            ;;

            Saturday)

              htmlrxmap=r7map

            ;;

            *)

              error

            ;;

          esac

        ;;

        2)

          . cfg/drotation_month.cfg # Monthly Dynamic Rotation configurarion call.

          htmldrtypeshow="Month"
          htmldatedr=`./date +%B`

          case "$htmldatedr" in

            January)

              htmlrxmap=r1map

            ;;

            February)

              htmlrxmap=r2map

            ;;

            March)

              htmlrxmap=r3map

            ;;

            April)

              htmlrxmap=r4map

            ;;

            May)

              htmlrxmap=r5map

            ;;

            June)

              htmlrxmap=r6map

            ;;

            July)

              htmlrxmap=r7map

            ;;

            August)

              htmlrxmap=r8map

            ;;

            September)

              htmlrxmap=r9map

            ;;

            October)

              htmlrxmap=r10map

            ;;

            November)

              htmlrxmap=r11map

            ;;

            December)

              htmlrxmap=r12map

            ;;

            *)

              error

            ;;

          esac

        ;;

        *)

          error

        ;;

      esac

      echo "<br>" >> "$htmlfile"
      echo '<form>' >> "$htmlfile"
      echo '<fieldset>' >> "$htmlfile"
      echo "<legend><b>Dynamic Rotation: "$htmldrtypeshow"/"$htmldatedr"</b></legend>" >> "$htmlfile"
      echo '<table border="1">' >> "$htmlfile"
      echo '<tr>' >> "$htmlfile"
      echo '<th>VSTR</th>' >> "$htmlfile"
      echo '<th>Map Name</th>' >> "$htmlfile"
      echo '</tr>' >> "$htmlfile"

      htmlrxmapf=STARTDRLOOPHTML

      while [ -n "$htmlrxmapf" ]; do

        if [ "$htmlrxmapf" != STARTDRLOOPHTML ]; then

          echo '<tr>' >> "$htmlfile"
          echo '<td>' >> "$htmlfile"
          echo "$htmlrxmapf" | ./sed -e 's/^set//' -e 's/^ \+//' -e 's/ .*$//' >> "$htmlfile"
          echo '</td>' >> "$htmlfile"
          echo '<td>' >> "$htmlfile"
          echo "$htmlrxmapf" | ./sed -e 's/nextmap//g' -e 's/^.*map//' -e 's/;.*$//' -e 's/^ \+//' >> "$htmlfile"
          echo '</td>' >> "$htmlfile"
          echo '</tr>' >> "$htmlfile"

        else

          htmldraribase=0

        fi   

        let htmldrari="$htmldraribase"+1
        htmldraribase="$htmldrari"

        echo 'htmlrxmapf="$'$htmlrxmap$htmldrari'"' > htmldrmaplistcheck

        . htmldrmaplistcheck > /dev/null 2>&1

      done

      rmcmd htmldrmaplistcheck

      echo '</table>' >> "$htmlfile"
      echo '</fieldset>' >> "$htmlfile"
      echo '</form>' >> "$htmlfile"

    fi

  fi

# Server start/restart log display.

  if [ "$displaystartlog" -eq 1 ]; then

    echo "<br>" >> "$htmlfile"
    echo '<form>' >> "$htmlfile"
    echo '<fieldset>' >> "$htmlfile"

    if [ -n "$lognormal" ]; then

      echo "<legend><b>Server start/restart log:</b> "$lognormal"</legend>" >> "$htmlfile"
      echo '<div style="width: 972; height: 150; overflow: auto";>' >> "$htmlfile"
    
      if [ -f "$lognormal" ]; then

        ./sed -e 's/$/<br>/' "$lognormal" >> "$htmlfile"
    
      fi

      echo '</div>' >> "$htmlfile"

    else

      echo "<legend><b>Server start/restart log:</b> LOG FILE NOT SET</legend>" >> "$htmlfile"

    fi

    echo '</fieldset>' >> "$htmlfile"
    echo '</form>' >> "$htmlfile"

  fi

# Crash log display.

  if [ "$displaycrashlog" -eq 1 ]; then

    echo '<form>' >> "$htmlfile"
    echo '<fieldset>' >> "$htmlfile"

    if [ -n "$logcrash" ]; then

      echo "<legend><b>Crash log:</b> "$logcrash"</legend>" >> "$htmlfile"
      echo '<div style="width: 972; height: 150; overflow: auto";>' >> "$htmlfile"
    
      if [ -f "$logcrash" ]; then

        ./sed -e 's/$/<br>/' "$logcrash" >> "$htmlfile"

      fi

      echo '</div>' >> "$htmlfile"

    else

      echo "<legend><b>Crash log:</b> LOG FILE NOT SET</legend>" >> "$htmlfile"

    fi

    echo '</fieldset>' >> "$htmlfile"
    echo '</form>' >> "$htmlfile"

  fi

# HTML Final code.

echo '</body>' >> "$htmlfile"
echo '</html>' >> "$htmlfile"

# Check if file was created.

if [ -f "$htmlfile" ]; then

  echo "HTML Server status file generated."

else

  echo "ERROR: HTML Server status file was not generated."

  error

fi

# FTP command to send the generated HTML to a remote server.

if [ "$useftp" -eq 1 ]; then

  echo -n "Uploading via FTP..."

  echo "user "$ftpuser" "$ftppassword"" > ftpcommands
  echo 'put "'$htmlfile'" "'$rhtmlfile'"' >> ftpcommands
  echo "bye" >> ftpcommands

  ftp -inv "$ftphost" > /dev/null 2>&1 <ftpcommands
  rmcmd ftpcommands

  echo "Done!"

fi

echo

# If script ran properly.

success