# Dynamic Rotation script.
# Part of server starter/restarter and crash checker for Jedi Knight:Jedi Academy.
# DO NOT CHANGE THIS FILE UNLESS YOU KNOW WHAT YOU ARE DOING.

# Date code for autodownload.

versionc="19062010" # NEVER CHANGE THIS LINE OR AUTODOWNLOAD WILL BREAK.

errorcode=3 # Error code related to the script. DO NOT CHANGE.

# Local functions.

datefp ()
{

  "$scriptdir"/date "$@"

}

# Grep function for the Dynamic Rotation code on the CFG.

drexistgrep ()
{

  "$scriptdir"/grep -ws "(DR14061928-22041870)" "$cfg"

}

# Grep function for the Dynamic Rotation code on drotation.dr.

drcfgcheckgrep ()
{

  "$scriptdir"/grep -ws "$codedr""$rehashdr" drotation.dr

}

cd "$dir"/"$game"

# Check if the required Dynamic Rotation lines are present in the CFG and write it, if not.

if [ -f "$cfg" ]; then

  drexist=`drexistgrep`

  if [ -z "$drexist" ]; then

    echo "========================================================================"
    echo ""$cfg" does not contain the required lines for Dynamic Rotation."
    echo -n "Inserting the required Dynamic Rotation lines in your "$cfg"..."

    echo >> "$cfg"
    echo "// EXEC Line for Dynamic Rotation." >> "$cfg"
    echo "// *** CODE (DR14061928-22041870) ***" >> "$cfg"
    echo "// DO NOT EDIT OR REMOVE THESE LINES, UNLESS YOU PLAN ON REMOVING THE DYNAMIC ROTATION." >> "$cfg"
    echo >> "$cfg"
    echo "exec drotation.dr" >> "$cfg"

    drexistf=`drexistgrep`

    if [ -n "$drexistf" ]; then

      echo "DONE!"

    else

      echo
      echo "ERROR: Could not write the required Dynamic Rotation lines on "$cfg"."
      echo "Please check if "$cfg" is blocked or protected."

      error

    fi
    
  fi

else

  echo "ERROR: Could not find "$cfg". Please check if your CFG exists and/or your script.cfg."

  error

fi

echo "========================================================================"
echo "Checking Dynamic Rotation..."

# Declaring Day/Month variable set.

case "$drtype" in

  1)

    . "$scriptdir"/cfg/drotation_day.cfg # Daily Dynamic Rotation configurarion call.

    drtypeshow="Day"
    datedr=`datefp +%A`

    case "$datedr" in

      Sunday)

        codedr="code01sun"
        vstrx="$vstr1"
        rxmap=r1map

      ;;

      Monday)

        codedr="code02mon"
        vstrx="$vstr2"
        rxmap=r2map

      ;;

      Tuesday)  

        codedr="code03tue"
        vstrx="$vstr3"
        rxmap=r3map

      ;;

      Wednesday)

        codedr="code04wed"
        vstrx="$vstr4"
        rxmap=r4map

      ;;

      Thursday)

        codedr="code05thu"
        vstrx="$vstr5"
        rxmap=r5map

      ;;

      Friday)

        codedr="code06fri"
        vstrx="$vstr6"
        rxmap=r6map

      ;;

      Saturday)

        codedr="code07sat"
        vstrx="$vstr7"
        rxmap=r7map

      ;;

      *)

        error

      ;;

    esac

  ;;

  2)

    . "$scriptdir"/cfg/drotation_month.cfg # Monthly Dynamic Rotation configurarion call.

    drtypeshow="Month"
    datedr=`datefp +%B`

    case "$datedr" in  

      January)

        codedr="code01jan"
        vstrx="$vstr1"
        rxmap=r1map

      ;;

      February)

        codedr="code02feb"
        vstrx="$vstr2"
        rxmap=r2map

      ;;

      March)

        codedr="code03mar"
        vstrx="$vstr3"
        rxmap=r3map

      ;;

      April)

        codedr="code04april"
        vstrx="$vstr4"
        rxmap=r4map

      ;;

      May)

        codedr="code05may"
        vstrx="$vstr5"
        rxmap=r5map

      ;;

      June)

        codedr="code06jun"
        vstrx="$vstr6"
        rxmap=r6map

      ;;

      July)

        codedr="code07jul"
        vstrx="$vstr7"
        rxmap=r7map

      ;;

      August)

        codedr="code08aug"
        vstrx="$vstr8"
        rxmap=r8map

      ;;

      September)

        codedr="code09sep"
        vstrx="$vstr9"
        rxmap=r9map

      ;;

      October)

        codedr="code10oct"
        vstrx="$vstr10"
        rxmap=r10map

      ;;

      November)

        codedr="code11nov"
        vstrx="$vstr11"
        rxmap=r11map

      ;;

      December)

        codedr="code12dec"
        vstrx="$vstr12"
        rxmap=r12map

      ;;

      *)

        error

      ;;

    esac

  ;;

  *)

    error

  ;;

esac

# Declaring the existance or not existance of the Dynamic Rotation Daily/Monthly code on drotation.dr.

if [ -f drotation.dr ]; then

  drcfgcheck=`drcfgcheckgrep`

else

  drcfgcheck=

fi

# Setting Dynamic Rotation on drotation.dr, if the Dynamic Rotation Daily/Monthly code does not exist there.
# Otherwise will be skipped.

if [ -z "$drcfgcheck" ]; then

  echo "// Dynamic Rotation - "$drtypeshow"/"$datedr". *** "$codedr""$rehashdr" ***" > drotation.dr
  echo "// DO NOT EDIT THIS FILE." >> drotation.dr
  echo "// IF YOU WANT TO CHANGE THE ROTATION, DO SO BY EDITING THE DYNAMIC ROTATION CONFIGURARION FILE." >> drotation.dr
  echo "// IF YOU PLAN ON REMOVING THE DYNAMIC ROTATION, YOU MAY DELETE THIS FILE" >> drotation.dr
  echo >> drotation.dr

  rxmapf=STARTDRLOOP

  while [ -n "$rxmapf" ]; do

    if [ "$rxmapf" != STARTDRLOOP ]; then

      echo "$rxmapf" >> drotation.dr

    else

      draribase=0

    fi   

    let drari="$draribase"+1
    draribase="$drari"

    echo 'rxmapf="$'$rxmap$drari'"' > drmaplistcheck

    . drmaplistcheck > /dev/null 2>&1

  done

  rmcmd drmaplistcheck

  echo >> drotation.dr
  echo "// VSTR starting the first map." >> drotation.dr
  echo >> drotation.dr
  echo "vstr "$vstrx"" >> drotation.dr

  if [ -f drotation.dr ]; then

    drcfgcheckf=`drcfgcheckgrep`

    if [ -n "$drcfgcheckf" ]; then

      echo "Rotation set for "$drtypeshow"/"$datedr"."

    else

      echo "ERROR: Rotation was not set for "$drtypeshow"/"$datedr"."

      error

    fi

  else

    echo "ERROR: Dynamic Rotation file (drotation.dr) was not created."

    error

  fi

# Script will kill the server if it's running so it can load the new rotation.

  palivedr=`processstatus`
      
  if [ -n "$palivedr" ]; then

    echo -n "Server is currently running, sending kill command to restart it..."
    killprocess
    echo "DONE!"

  fi

  echo "========================================================================"
  echo

else

  echo "Rotation is already set for "$drtypeshow"/"$datedr", skipping it."
  echo "========================================================================"
  echo

fi

cd "$scriptdir"

# If script ran properly.

success