# Server status checker. 
# Part of server starter/restarter and crash checker for Jedi Knight:Jedi Academy.
# DO NOT CHANGE THIS FILE UNLESS YOU KNOW WHAT YOU ARE DOING.

# Date code for autodownload.

versionc="19062010" # NEVER CHANGE THIS LINE OR AUTODOWNLOAD WILL BREAK.

errorcode=2 # Error code related to the script. DO NOT CHANGE.

# Nmap/Ncat functions.

nmapcmd ()
{

  case "$check" in

    1)

      ./nmap -sU "$nip" -p "$nport" -n -PN -oN ccheckstatus > /dev/null 2>&1

    ;;

    2)

      ./nmap -S "$ips" -sU "$nip" -p "$nport" -e "$device" -n -PN -oN ccheckstatus > /dev/null 2>&1

    ;;

    *)

      error

    ;;

  esac

  ccheck=`./grep -ws filtered ccheckstatus`

}

ncatcmd ()
{

  ncatcheckmsg="ncatcheckmsg"
  echo SENDMSG > "$ncatcheckmsg"
  ./ncat -nu 127.0.0.1 "$ncport" -o ccheckstatus -i 300 > /dev/null 2>&1 <"$ncatcheckmsg"

  if [ `./grep -cs disconnect ccheckstatus` -eq 0 ]; then

    palivenc=`processstatus`

    if [ -n "$palivenc" ]; then

      ccheck="crashed"

    else

      ccheck=

    fi

  else

    ccheck=

  fi

}

# Sleep time between checks function.

sleepccheck ()
{

  ./sleep 10

}

# Remove temporary files for crash check function.

rmccheck ()
{

  rmcmd ccheckstatus "$ncatcheckmsg"

} 

echo "Initializing Crash checker..."
echo "========================================================================"

case "$check" in

# Non-spoofed Nmap or spoofed Nmap check method.

  1|2)

    checktype=nmapcmd

  ;;

# Ncat check method.

  3)

    checktype=ncatcmd

  ;;

  *)

    error

  ;;

esac

# First check to see if the server is responding.

$checktype

if [ -n "$ccheck" ]; then

  echo "Check 1/3 concluded without getting a response from the server. Starting check 2/3 in 10 seconds..."
  echo "========================================================================"
  sleepccheck

# Second check to see if the server is responding after failing to do in the first one.

  $checktype

  if [ -n "$ccheck" ]; then

    echo "Check 2/3 concluded without getting a response from the server. Starting check 3/3 in 10 seconds..."
    echo "========================================================================"
    sleepccheck

# Third and final check to see if the server is responding after failing to do in the first and second checks.
# Server will be killed for reinitialization if it fails to answer again.

    $checktype

    if [ -n "$ccheck" ]; then

      echo "Check 3/3 concluded without getting a response from the server. Server is crashed and the process was not ended."
      echo "Server is being killed for reinitialization... Crash recorded at `./date`"

      if [ -n "$logcrash" ]; then

        echo "Crash recorded at `./date`" >> "$logcrash"

      fi

      echo "========================================================================"
      killprocess
      echo "Kill command sent. Continuing..."
      rmccheck
      echo "========================================================================"

    else

      echo "(3RD CHECK) Server is responding (accepted/refused). Skipping it."
      rmccheck
      echo

    fi

  else

    echo "(2ND CHECK) Server is responding (accepted/refused). Skipping it."
    rmccheck
    echo

  fi

else

  echo "(1ST CHECK) Server is responding (accepted/refused). Skipping it."
  rmccheck
  echo

fi

# If script ran properly.

success