# Version checker and autodownload updater.
# DO NOT CHANGE THIS FILE UNLESS YOU KNOW WHAT YOU ARE DOING.

if [ -f script.cfg ]; then

  . script.cfg # Configurarion call (old path).

fi

if [ -f cfg/script.cfg ]; then

  . cfg/script.cfg # Configurarion call (new path).

fi

if [ -z "$filesdir" ]; then

  echo "The location of the script is not set, please check your script.cfg."
  echo "Press ENTER to continue."
  read
  exit

fi

if [ -d "$filesdir" ]; then

  echo "Script location set."

else

  echo "Script location is incorrect, please check your script.cfg."
  echo "Press ENTER to continue."
  read
  exit

fi

cd "$filesdir"

echo "Initializing Updater..."
echo ""

# Check if right value is set for autodownload.

if [ -n "$autodownload" ]; then

  if [ "$autodownload" -eq 0 ]; then

    echo "Autodownload is disabled."
    echo ""

  elif [ "$autodownload" -eq 1 ]; then

    echo "Autodownload is enabled."
    echo ""

  else

    echo "Autodownload value is set to a wrong value. Please check your script.cfg and set a value between 0 and 1."
    echo "Press ENTER to continue."
    read
    exit

  fi

else

  echo "Autodownload value isn't set. Please check your script.cfg and set a value between 0 and 1."
  echo "Press ENTER to continue."
  read
  exit

fi

# Crate cfg and old folder if they do not exist.

mkdirloc="http://www.zombiehugs.com/jascript/windows/mkdir.exe"

if [ "$autodownload" -eq 1 ]; then

  echo "Checking for cfg, old, and old/cfg folders..."

  if [ -d cfg ] && [ -d old ] && [ -d old/cfg ]; then

    echo "Folders cfg, old, and old/cfg exist, continuing with the updater..."

  else

    if [ -f mkdir.exe ]; then

      echo "Mkdir found."

      if [ -d cfg ]; then

        echo "Folder cfg exists, skipping its creation..."

      else

        echo "Creating folder cfg..."
        ./mkdir cfg > /dev/null 2>&1

        if [ -d cfg ]; then

          echo "cfg folder created."

        else

          echo "Could not create cfg folder, please create the folder cfg inside your script folder and re-run the updater."
          echo "The folder name is case sensitive, so make sure to create exacly as cfg."
          echo "Press ENTER to continue."
          read
          exit

        fi

      fi

      if [ -d old ]; then

        echo "Folder old exists, skipping its creation..."

      else

        echo "Creating folder old..."
        ./mkdir old > /dev/null 2>&1

        if [ -d old ]; then

          echo "old folder created."

        else

          echo "Could not create old folder, please create the folder old inside your script folder and re-run the updater."
          echo "The folder name is case sensitive, so make sure to create exacly as old."
          echo "Press ENTER to continue."
          read
          exit

        fi

      fi

      if [ -d old/cfg ]; then

        echo "Folder old/cfg exists, skipping its creation..."

      else

        echo "Creating folder old/cfg..."
        ./mkdir old/cfg > /dev/null 2>&1

        if [ -d old/cfg ]; then

          echo "old/cfg folder created."

        else

          echo "Could not create old/cfg folder, please create the folder old/cfg inside your script folder and re-run the updater."
          echo "The folder name is case sensitive, so make sure to create exacly as old/cfg."
          echo "Press ENTER to continue."
          read
          exit

        fi

      fi

    else

      echo -n "Downloading mkdir..."
      ./wget "$mkdirloc" > /dev/null 2>&1

      if [ -f mkdir.exe ]; then

        echo "Mkdir found."

        if [ -d cfg ]; then

          echo "Folder cfg exists, skipping its creation..."

        else

          echo "Creating folder cfg..."
          ./mkdir cfg > /dev/null 2>&1

          if [ -d cfg ]; then

            echo "cfg folder created."

          else

            echo "Could not create cfg folder, please create the folder cfg inside your script folder and re-run the updater."
            echo "The folder name is case sensitive, so make sure to create exacly as cfg."
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

        if [ -d old ]; then

          echo "Folder old exists, skipping its creation..."

        else

          echo "Creating folder old..."
          ./mkdir old > /dev/null 2>&1

          if [ -d old ]; then

            echo "old folder created."

          else

            echo "Could not create old folder, please create the folder old inside your script folder and re-run the updater."
            echo "The folder name is case sensitive, so make sure to create exacly as old."
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

        if [ -d old/cfg ]; then

          echo "Folder old/cfg exists, skipping its creation..."

        else

          echo "Creating folder old/cfg..."
          ./mkdir old/cfg > /dev/null 2>&1

          if [ -d old/cfg ]; then

            echo "old/cfg folder created."

          else

            echo "Could not create old/cfg folder, please create the folder old/cfg inside your script folder and re-run the updater."
            echo "The folder name is case sensitive, so make sure to create exacly as old/cfg."
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      else

        echo ""
        echo "Mkdir could not be downloaded, please create the folders cfg, old, and old/cfg inside your script folder and re-run the updater."
        echo "The folders names are case sensitive, so make sure to create exacly as cfg, old. and old/cfg."
        echo "Press ENTER to continue."
        read
        exit

      fi

    fi

  fi
    
# Moving cfg and old files if they exist.

  ./mv -fu *.cfg cfg > /dev/null 2>&1
  ./rm -rf *.cfg > /dev/null 2>&1

  ./mv -fu *.old old > /dev/null 2>&1
  ./rm -rf *.old > /dev/null 2>&1

  echo "========================================================================"
    
else

  echo "Autodownload is disabled, skipping folder check..."
  echo "========================================================================"

fi

# Deleting outdated files, if they exist.

if [ -f version.txt ]; then

  ./rm -rf version.txt > /dev/null 2>&1

fi

./rm -rf *check.txt > /dev/null 2>&1

. version.sh > /dev/null 2>&1 # Version call.

checkfile="http://www.zombiehugs.com/jascript/windows" # Version location.
filesd="http://www.zombiehugs.com/jascript/windows" # Updated files location.

./wget "$checkfile"/version.txt > /dev/null 2>&1 # Downloading version check file.

. version.txt > /dev/null 2>&1 # Importing check file.

# Checking for WAN access with the check server.

if [ "$webconnectivity" = YES ]; then

# Checking if current version exists.

  if [ -z "$version" ]; then

    echo "Could not check for the current version. You can download the full version from the mirror(s) below."
    echo ""

    if [ -n "$mirror1" ]; then
          
      echo "Mirror 1: "$mirror1""

    fi

    if [ -n "$mirror2" ]; then
          
        echo "Mirror 2: "$mirror2""

    fi

    if [ -n "$mirror3" ]; then
          
      echo "Mirror 3: "$mirror3""

    fi

    if [ -n "$mirror4" ]; then
          
      echo "Mirror 4: "$mirror4""

    fi

    if [ -n "$mirror5" ]; then
          
      echo "Mirror 5: "$mirror5""

    fi

    ./rm -rf version.txt > /dev/null 2>&1
    echo ""
    echo "Press ENTER to continue."
    read
    exit

  fi

  if [ -z "$subversion" ]; then

    echo "Could not check for the current subversion. You can download the full version from the mirror(s) below."
    echo ""

    if [ -n "$mirror1" ]; then
          
      echo "Mirror 1: "$mirror1""

    fi

    if [ -n "$mirror2" ]; then
          
        echo "Mirror 2: "$mirror2""

    fi

    if [ -n "$mirror3" ]; then
          
      echo "Mirror 3: "$mirror3""

    fi

    if [ -n "$mirror4" ]; then
          
      echo "Mirror 4: "$mirror4""

    fi

    if [ -n "$mirror5" ]; then
          
      echo "Mirror 5: "$mirror5""

    fi

    ./rm -rf version.txt > /dev/null 2>&1
    echo ""
    echo "Press ENTER to continue."
    read
    exit

  fi

  echo "Current version: "$version"."$subversion""
  echo "Checking for new versions..."
  echo "========================================================================"

# Comparing versions, download mirrors, and autodownload.

  if [ "$version"."$subversion" = "$webversion"."$websubversion" ]; then

    echo "Lastest version in use, skipping update."
    ./rm -rf version.txt > /dev/null 2>&1
    echo ""
    echo "Press ENTER to continue."
    read

  else

    if [ "$autodownload" -eq 0 ]; then
    
      echo "Your version is not up to date. You can download the full version from the mirror(s) below."
      echo ""

      if [ -n "$mirror1" ]; then
          
        echo "Mirror 1: "$mirror1""

      fi

      if [ -n "$mirror2" ]; then
          
        echo "Mirror 2: "$mirror2""

      fi

      if [ -n "$mirror3" ]; then
          
        echo "Mirror 3: "$mirror3""

      fi

      if [ -n "$mirror4" ]; then
          
        echo "Mirror 4: "$mirror4""

      fi

      if [ -n "$mirror5" ]; then
          
        echo "Mirror 5: "$mirror5""

      fi

      ./rm -rf version.txt > /dev/null 2>&1
      echo ""
      echo "Press ENTER to continue."
      read

    fi

    if [ "$autodownload" -eq 1 ]; then

      echo "New version found, autodownload initializing..."
      echo ""

      if [ -n "$file1" ]; then

        echo "Checking "$file1"..."
        
        if [ -f "$file1" ]; then

          ./cat "$file1" | ./grep "versionc=" >> "$file1"check.txt
          . "$file1"check.txt > /dev/null 2>&1

        fi
        
        file1d="$versionc"

        if [ "$file1d" = "$webfile1d" ]; then

          echo ""$file1" is up to date, skipping file update."
          echo ""
          ./rm -rf "$file1"check.txt > /dev/null 2>&1

        else

          if [ -f "$file1" ]; then

            echo "Updating "$file1"..."
             
            if [ -f old/"$file1".old ]; then

              ./rm -rf old/"$file1".old > /dev/null 2>&1

            fi

            ./mv "$file1" old/"$file1".old > /dev/null 2>&1
            ./wget "$filesd"/"$file1" > /dev/null 2>&1

          else

            echo "Downloading "$file1"..."
            ./wget "$filesd"/"$file1" > /dev/null 2>&1

          fi  
            
          if [ -f "$file1" ]; then

            echo ""$file1" has been downloaded and updated."
            echo ""
            
            if [ -f "$file1"check.txt ]; then

              ./rm -rf "$file1"check.txt > /dev/null 2>&1

            fi
            
          else

            echo "Could not update "$file1". Try running the updater again."
            
            if [ -f old/"$file1".old ]; then

              ./mv old/"$file1".old "$file1" > /dev/null 2>&1

            fi

            if [ -f "$file1"check.txt ]; then

              ./rm -rf "$file1"check.txt > /dev/null 2>&1

            fi

            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$file2" ]; then

        echo "Checking "$file2"..."

        if [ -f "$file2" ]; then

          ./cat "$file2" | ./grep "versionc=" >> "$file2"check.txt
          . "$file2"check.txt > /dev/null 2>&1

        fi

        file2d="$versionc"

        if [ "$file2d" = "$webfile2d" ]; then

          echo ""$file2" is up to date, skipping file update."
          echo ""
          ./rm -rf "$file2"check.txt > /dev/null 2>&1

        else

          if [ -f "$file2" ]; then

            echo "Updating "$file2"..."
             
            if [ -f old/"$file2".old ]; then

              ./rm -rf old/"$file2".old > /dev/null 2>&1

            fi

            ./mv "$file2" old/"$file2".old > /dev/null 2>&1
            ./wget "$filesd"/"$file2" > /dev/null 2>&1

          else

            echo "Downloading "$file2"..."
            ./wget "$filesd"/"$file2" > /dev/null 2>&1

          fi
            
          if [ -f "$file2" ]; then

            echo ""$file2" has been downloaded and updated."
            echo ""

            if [ -f "$file2"check.txt ]; then

              ./rm -rf "$file2"check.txt > /dev/null 2>&1

            fi
            
          else

            echo "Could not update "$file2". Try running the updater again."

            if [ -f old/"$file2".old ]; then

              ./mv old/"$file2".old "$file2" > /dev/null 2>&1

            fi

            if [ -f "$file2"check.txt ]; then

              ./rm -rf "$file2"check.txt > /dev/null 2>&1

            fi

            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$file3" ]; then

        echo "Checking "$file3"..."

        if [ -f "$file3" ]; then

          ./cat "$file3" | ./grep "versionc=" >> "$file3"check.txt
          . "$file3"check.txt > /dev/null 2>&1

        fi

        file3d="$versionc"

        if [ "$file3d" = "$webfile3d" ]; then

          echo ""$file3" is up to date, skipping file update."
          echo ""
          ./rm -rf "$file3"check.txt > /dev/null 2>&1

        else

          if [ -f "$file3" ]; then

            echo "Updating "$file3"..."
             
            if [ -f old/"$file3".old ]; then

              ./rm -rf old/"$file3".old > /dev/null 2>&1

            fi

            ./mv "$file3" old/"$file3".old > /dev/null 2>&1
            ./wget "$filesd"/"$file3" > /dev/null 2>&1

          else

            echo "Downloading "$file3"..."
            ./wget "$filesd"/"$file3" > /dev/null 2>&1

          fi
            
          if [ -f "$file3" ]; then

            echo ""$file3" has been downloaded and updated."
            echo ""

            if [ -f "$file3"check.txt ]; then

              ./rm -rf "$file3"check.txt > /dev/null 2>&1

            fi
            
          else

            echo "Could not update "$file3". Try running the updater again."

            if [ -f old/"$file3".old ]; then

              ./mv old/"$file3".old "$file3" > /dev/null 2>&1

            fi

            if [ -f "$file3"check.txt ]; then

              ./rm -rf "$file3"check.txt > /dev/null 2>&1

            fi

            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$file4" ]; then

        echo "Checking "$file4"..."

        if [ -f "$file4" ]; then

          ./cat "$file4" | ./grep "versionc=" >> "$file4"check.txt
          . "$file4"check.txt > /dev/null 2>&1

        fi

        file4d="$versionc"

        if [ "$file4d" = "$webfile4d" ]; then

          echo ""$file4" is up to date, skipping file update."
          echo ""
          ./rm -rf "$file4"check.txt > /dev/null 2>&1

        else

          if [ -f "$file4" ]; then

            echo "Updating "$file4"..."
             
            if [ -f old/"$file4".old ]; then

              ./rm -rf old/"$file4".old > /dev/null 2>&1

            fi

            ./mv "$file4" old/"$file4".old > /dev/null 2>&1
            ./wget "$filesd"/"$file4" > /dev/null 2>&1

          else

            echo "Downloading "$file4"..."
            ./wget "$filesd"/"$file4" > /dev/null 2>&1

          fi
            
          if [ -f "$file4" ]; then

            echo ""$file4" has been downloaded and updated."
            echo ""

            if [ -f "$file4"check.txt ]; then

              ./rm -rf "$file4"check.txt > /dev/null 2>&1

            fi
            
          else

            echo "Could not update "$file4". Try running the updater again."

            if [ -f old/"$file4".old ]; then

              ./mv old/"$file4".old "$file4" > /dev/null 2>&1

            fi

            if [ -f "$file4"check.txt ]; then

              ./rm -rf "$file4"check.txt > /dev/null 2>&1

            fi

            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$file5" ]; then

        echo "Checking "$file5"..."

        if [ -f "$file5" ]; then

          ./cat "$file5" | ./grep "versionc=" >> "$file5"check.txt
          . "$fil5"check.txt > /dev/null 2>&1

        fi

        file5d="$versionc"

        if [ "$file5d" = "$webfile5d" ]; then

          echo ""$file5" is up to date, skipping file update."
          echo ""
          ./rm -rf "$file5"check.txt > /dev/null 2>&1

        else

          if [ -f "$file5" ]; then

            echo "Updating "$file5"..."
             
            if [ -f old/"$file5".old ]; then

              ./rm -rf old/"$file5".old > /dev/null 2>&1

            fi

            ./mv "$file5" old/"$file5".old > /dev/null 2>&1
            ./wget "$filesd"/"$file5" > /dev/null 2>&1

          else

            echo "Downloading "$file5"..."
            ./wget "$filesd"/"$file5" > /dev/null 2>&1

          fi
            
          if [ -f "$file5" ]; then

            echo ""$file5" has been downloaded and updated."
            echo ""

            if [ -f "$file5"check.txt ]; then

              ./rm -rf "$file5"check.txt > /dev/null 2>&1

            fi
            
          else

            echo "Could not update "$file5". Try running the updater again."

            if [ -f old/"$file5".old ]; then

              ./mv old/"$file5".old "$file5" > /dev/null 2>&1

            fi

            if [ -f "$file5"check.txt ]; then

              ./rm -rf "$file5"check.txt > /dev/null 2>&1

            fi

            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$file6" ]; then

        echo "Checking "$file6"..."

        if [ -f "$file6" ]; then

          ./cat "$file6" | ./grep "versionc=" >> "$file6"check.txt
          . "$file6"check.txt > /dev/null 2>&1

        fi

        file6d="$versionc"

        if [ "$file6d" = "$webfile6d" ]; then

          echo ""$file6" is up to date, skipping file update."
          echo ""
          ./rm -rf "$file6"check.txt > /dev/null 2>&1

        else

          if [ -f "$file6" ]; then

            echo "Updating "$file6"..."
             
            if [ -f old/"$file6".old ]; then

              ./rm -rf old/"$file6".old > /dev/null 2>&1

            fi

            ./mv "$file6" old/"$file6".old > /dev/null 2>&1
            ./wget "$filesd"/"$file6" > /dev/null 2>&1

          else

            echo "Downloading "$file6"..."
            ./wget "$filesd"/"$file6" > /dev/null 2>&1

          fi
            
          if [ -f "$file6" ]; then

            echo ""$file6" has been downloaded and updated."
            echo ""

            if [ -f "$file6"check.txt ]; then

              ./rm -rf "$file6"check.txt > /dev/null 2>&1

            fi
            
          else

            echo "Could not update "$file6". Try running the updater again."

            if [ -f old/"$file6".old ]; then

              ./mv old/"$file6".old "$file6" > /dev/null 2>&1

            fi

            if [ -f "$file6"check.txt ]; then

              ./rm -rf "$file6"check.txt > /dev/null 2>&1

            fi

            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$file7" ]; then

        echo "Checking "$file7"..."

        if [ -f "$file7" ]; then

          ./cat "$file7" | ./grep "versionc=" >> "$file7"check.txt
          . "$file7"check.txt > /dev/null 2>&1

        fi

        file7d="$versionc"

        if [ "$file7d" = "$webfile7d" ]; then

          echo ""$file7" is up to date, skipping file update."
          echo ""
          ./rm -rf "$file7"check.txt > /dev/null 2>&1

        else

          if [ -f "$file7" ]; then

            echo "Updating "$file7"..."
             
            if [ -f old/"$file7".old ]; then

              ./rm -rf old/"$file7".old > /dev/null 2>&1

            fi

            ./mv "$file7" old/"$file7".old > /dev/null 2>&1
            ./wget "$filesd"/"$file7" > /dev/null 2>&1

          else

            echo "Downloading "$file7"..."
            ./wget "$filesd"/"$file7" > /dev/null 2>&1

          fi
            
          if [ -f "$file7" ]; then

            echo ""$file7" has been downloaded and updated."
            echo ""

            if [ -f "$file7"check.txt ]; then

              ./rm -rf "$file7"check.txt > /dev/null 2>&1

            fi
            
          else

            echo "Could not update "$file7". Try running the updater again."

            if [ -f old/"$file7".old ]; then

              ./mv old/"$file7".old "$file7" > /dev/null 2>&1

            fi

            if [ -f "$file7"check.txt ]; then

              ./rm -rf "$file7"check.txt > /dev/null 2>&1

            fi

            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$file8" ]; then

        echo "Checking "$file8"..."

        if [ -f "$file8" ]; then

          ./cat "$file8" | ./grep "versionc=" >> "$file8"check.txt
          . "$file8"check.txt > /dev/null 2>&1

        fi

        file8d="$versionc"

        if [ "$file8d" = "$webfile8d" ]; then

          echo ""$file8" is up to date, skipping file update."
          echo ""
          ./rm -rf "$file8"check.txt > /dev/null 2>&1

        else

          if [ -f "$file8" ]; then

            echo "Updating "$file8"..."
             
            if [ -f old/"$file8".old ]; then

              ./rm -rf old/"$file8".old > /dev/null 2>&1

            fi

            ./mv "$file8" old/"$file8".old > /dev/null 2>&1
            ./wget "$filesd"/"$file8" > /dev/null 2>&1

          else

            echo "Downloading "$file8"..."
            ./wget "$filesd"/"$file8" > /dev/null 2>&1

          fi
            
          if [ -f "$file8" ]; then

            echo ""$file8" has been downloaded and updated."
            echo ""

            if [ -f "$file8"check.txt ]; then

              ./rm -rf "$file8"check.txt > /dev/null 2>&1

            fi
            
          else

            echo "Could not update "$file8". Try running the updater again."

            if [ -f old/"$file8".old ]; then

              ./mv old/"$file8".old "$file8" > /dev/null 2>&1

            fi

            if [ -f "$file8"check.txt ]; then

              ./rm -rf "$file8"check.txt > /dev/null 2>&1

            fi

            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$file9" ]; then

        echo "Checking "$file9"..."

        if [ -f "$file9" ]; then

          ./cat "$file9" | ./grep "versionc=" >> "$file9"check.txt
          . "$file9"check.txt > /dev/null 2>&1

        fi

        file9d="$versionc"

        if [ "$file9d" = "$webfile9d" ]; then

          echo ""$file9" is up to date, skipping file update."
          echo ""
          ./rm -rf "$file9"check.txt > /dev/null 2>&1

        else

          if [ -f "$file9" ]; then

            echo "Updating "$file9"..."
             
            if [ -f old/"$file9".old ]; then

              ./rm -rf old/"$file9".old > /dev/null 2>&1

            fi

            ./mv "$file9" old/"$file9".old > /dev/null 2>&1
            ./wget "$filesd"/"$file9" > /dev/null 2>&1

          else

            echo "Downloading "$file9"..."
            ./wget "$filesd"/"$file9" > /dev/null 2>&1

          fi
            
          if [ -f "$file9" ]; then

            echo ""$file9" has been downloaded and updated."
            echo ""

            if [ -f "$file9"check.txt ]; then

              ./rm -rf "$file9"check.txt > /dev/null 2>&1

            fi
            
          else

            echo "Could not update "$file9". Try running the updater again."

            if [ -f old/"$file9".old ]; then

              ./mv old/"$file9".old "$file9" > /dev/null 2>&1

            fi

            if [ -f "$file9"check.txt ]; then

              ./rm -rf "$file9"check.txt > /dev/null 2>&1

            fi

            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$file10" ]; then

        echo "Checking "$file10"..."

        if [ -f "$file10" ]; then

          ./cat "$file10" | ./grep "versionc=" >> "$file10"check.txt
          . "$file10"check.txt > /dev/null 2>&1

        fi

        file10d="$versionc"

        if [ "$file10d" = "$webfile10d" ]; then

          echo ""$file10" is up to date, skipping file update."
          echo ""
          ./rm -rf "$file10"check.txt > /dev/null 2>&1

        else

          if [ -f "$file10" ]; then

            echo "Updating "$file10"..."
             
            if [ -f old/"$file10".old ]; then

              ./rm -rf old/"$file10".old > /dev/null 2>&1

            fi

            ./mv "$file10" old/"$file10".old > /dev/null 2>&1
            ./wget "$filesd"/"$file10" > /dev/null 2>&1

          else

            echo "Downloading "$file10"..."
            ./wget "$filesd"/"$file10" > /dev/null 2>&1

          fi
            
          if [ -f "$file10" ]; then

            echo ""$file10" has been downloaded and updated."
            echo ""

            if [ -f "$file10"check.txt ]; then

              ./rm -rf "$file10"check.txt > /dev/null 2>&1

            fi
            
          else

            echo "Could not update "$file10". Try running the updater again."

            if [ -f old/"$file10".old ]; then

              ./mv old/"$file10".old "$file10" > /dev/null 2>&1

            fi

            if [ -f "$file10"check.txt ]; then

              ./rm -rf "$file10"check.txt > /dev/null 2>&1

            fi

            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$file11" ]; then

        echo "Checking "$file11"..."

        if [ -f "$file11" ]; then

          ./cat "$file11" | ./grep "versionc=" >> "$file11"check.txt
          . "$file11"check.txt > /dev/null 2>&1

        fi

        file11d="$versionc"

        if [ "$file11d" = "$webfile11d" ]; then

          echo ""$file11" is up to date, skipping file update."
          echo ""
          ./rm -rf "$file11"check.txt > /dev/null 2>&1

        else

          if [ -f "$file11" ]; then

            echo "Updating "$file11"..."
             
            if [ -f old/"$file11".old ]; then

              ./rm -rf old/"$file11".old > /dev/null 2>&1

            fi

            ./mv "$file11" old/"$file11".old > /dev/null 2>&1
            ./wget "$filesd"/"$file11" > /dev/null 2>&1

          else

            echo "Downloading "$file11"..."
            ./wget "$filesd"/"$file11" > /dev/null 2>&1

          fi
            
          if [ -f "$file11" ]; then

            echo ""$file11" has been downloaded and updated."
            echo ""

            if [ -f "$file11"check.txt ]; then

              ./rm -rf "$file11"check.txt > /dev/null 2>&1

            fi
            
          else

            echo "Could not update "$file11". Try running the updater again."

            if [ -f old/"$file11".old ]; then

              ./mv old/"$file11".old "$file11" > /dev/null 2>&1

            fi

            if [ -f "$file11"check.txt ]; then

              ./rm -rf "$file11"check.txt > /dev/null 2>&1

            fi

            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$file12" ]; then

        echo "Checking "$file12"..."

        if [ -f "$file12" ]; then

          ./cat "$file12" | ./grep "versionc=" >> "$file12"check.txt
          . "$file12"check.txt > /dev/null 2>&1

        fi

        file12d="$versionc"

        if [ "$file12d" = "$webfile12d" ]; then

          echo ""$file12" is up to date, skipping file update."
          echo ""
          ./rm -rf "$file12"check.txt > /dev/null 2>&1

        else

          if [ -f "$file12" ]; then

            echo "Updating "$file12"..."
             
            if [ -f old/"$file12".old ]; then

              ./rm -rf old/"$file12".old > /dev/null 2>&1

            fi

            ./mv "$file12" old/"$file12".old > /dev/null 2>&1
            ./wget "$filesd"/"$file12" > /dev/null 2>&1

          else

            echo "Downloading "$file12"..."
            ./wget "$filesd"/"$file12" > /dev/null 2>&1

          fi
            
          if [ -f "$file12" ]; then

            echo ""$file12" has been downloaded and updated."
            echo ""

            if [ -f "$file12"check.txt ]; then

              ./rm -rf "$file12"check.txt > /dev/null 2>&1

            fi
            
          else

            echo "Could not update "$file12". Try running the updater again."

            if [ -f old/"$file12".old ]; then

              ./mv old/"$file12".old "$file12" > /dev/null 2>&1

            fi

            if [ -f "$file12"check.txt ]; then

              ./rm -rf "$file12"check.txt > /dev/null 2>&1

            fi

            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$file13" ]; then

        echo "Checking "$file13"..."

        if [ -f "$file13" ]; then

          ./cat "$file13" | ./grep "versionc=" >> "$file13"check.txt
          . "$file13"check.txt > /dev/null 2>&1

        fi

        file13d="$versionc"

        if [ "$file13d" = "$webfile13d" ]; then

          echo ""$file13" is up to date, skipping file update."
          echo ""
          ./rm -rf "$file13"check.txt > /dev/null 2>&1

        else

          if [ -f "$file13" ]; then

            echo "Updating "$file13"..."
             
            if [ -f old/"$file13".old ]; then

              ./rm -rf old/"$file13".old > /dev/null 2>&1

            fi

            ./mv "$file13" old/"$file13".old > /dev/null 2>&1
            ./wget "$filesd"/"$file13" > /dev/null 2>&1

          else

            echo "Downloading "$file13"..."
            ./wget "$filesd"/"$file13" > /dev/null 2>&1

          fi
            
          if [ -f "$file13" ]; then

            echo ""$file13" has been downloaded and updated."
            echo ""

            if [ -f "$file13"check.txt ]; then

              ./rm -rf "$file13"check.txt > /dev/null 2>&1

            fi
            
          else

            echo "Could not update "$file13". Try running the updater again."

            if [ -f old/"$file13".old ]; then

              ./mv old/"$file13".old "$file13" > /dev/null 2>&1

            fi

            if [ -f "$file13"check.txt ]; then

              ./rm -rf "$file13"check.txt > /dev/null 2>&1

            fi

            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$file14" ]; then

        echo "Checking "$file14"..."

        if [ -f "$file14" ]; then

          ./cat "$file14" | ./grep "versionc=" >> "$file14"check.txt
          . "$file14"check.txt > /dev/null 2>&1

        fi

        file14d="$versionc"

        if [ "$file14d" = "$webfile14d" ]; then

          echo ""$file14" is up to date, skipping file update."
          echo ""
          ./rm -rf "$file14"check.txt > /dev/null 2>&1

        else

          if [ -f "$file14" ]; then

            echo "Updating "$file14"..."
             
            if [ -f old/"$file14".old ]; then

              ./rm -rf old/"$file14".old > /dev/null 2>&1

            fi

            ./mv "$file14" old/"$file14".old > /dev/null 2>&1
            ./wget "$filesd"/"$file14" > /dev/null 2>&1

          else

            echo "Downloading "$file14"..."
            ./wget "$filesd"/"$file14" > /dev/null 2>&1

          fi
            
          if [ -f "$file14" ]; then

            echo ""$file14" has been downloaded and updated."
            echo ""

            if [ -f "$file14"check.txt ]; then

              ./rm -rf "$file14"check.txt > /dev/null 2>&1

            fi
            
          else

            echo "Could not update "$file14". Try running the updater again."

            if [ -f old/"$file14".old ]; then

              ./mv old/"$file14".old "$file14" > /dev/null 2>&1

            fi

            if [ -f "$file14"check.txt ]; then

              ./rm -rf "$file14"check.txt > /dev/null 2>&1

            fi

            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$file15" ]; then

        echo "Checking "$file15"..."

        if [ -f "$file15" ]; then

          ./cat "$file15" | ./grep "versionc=" >> "$file15"check.txt
          . "$file15"check.txt > /dev/null 2>&1

        fi

        file15d="$versionc"

        if [ "$file15d" = "$webfile15d" ]; then

          echo ""$file15" is up to date, skipping file update."
          echo ""
          ./rm -rf "$file15"check.txt > /dev/null 2>&1

        else

          if [ -f "$file15" ]; then

            echo "Updating "$file15"..."
             
            if [ -f old/"$file15".old ]; then

              ./rm -rf old/"$file15".old > /dev/null 2>&1

            fi

            ./mv "$file15" old/"$file15".old > /dev/null 2>&1
            ./wget "$filesd"/"$file15" > /dev/null 2>&1

          else

            echo "Downloading "$file15"..."
            ./wget "$filesd"/"$file15" > /dev/null 2>&1

          fi
            
          if [ -f "$file15" ]; then

            echo ""$file15" has been downloaded and updated."
            echo ""

            if [ -f "$file15"check.txt ]; then

              ./rm -rf "$file15"check.txt > /dev/null 2>&1

            fi
            
          else

            echo "Could not update "$file15". Try running the updater again."

            if [ -f old/"$file15".old ]; then

              ./mv old/"$file15".old "$file15" > /dev/null 2>&1

            fi

            if [ -f "$file15"check.txt ]; then

              ./rm -rf "$file15"check.txt > /dev/null 2>&1

            fi

            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$cfgfile1" ]; then

        echo "Checking CFG "$cfgfile1"..."

        if [ -f cfg/"$cfgfile1" ]; then

          ./cat cfg/"$cfgfile1" | ./grep "versionc=" >> "$cfgfile1"check.txt
          . "$cfgfile1"check.txt > /dev/null 2>&1

        fi

        cfgfile1d="$versionc"

        if [ "$cfgfile1d" = "$webcfgfile1d" ]; then

          echo "CFG "$cfgfile1" is up to date, skipping file update."
          echo ""
          ./rm -rf "$cfgfile1"check.txt > /dev/null 2>&1

        else

          if [ -f cfg/"$cfgfile1" ]; then

            echo "Updating CFG "$cfgfile1"..."
             
            if [ -f old/cfg/"$cfgfile1".old ]; then

              ./rm -rf old/cfg/"$cfgfile1".old > /dev/null 2>&1

            fi

            ./mv cfg/"$cfgfile1" old/cfg/"$cfgfile1".old > /dev/null 2>&1
            ./wget "$filesd"/cfg/"$cfgfile1" --directory-prefix="$filedir"/cfg > /dev/null 2>&1

          else

            echo "Downloading CFG "$cfgfile1"..."
            ./wget "$filesd"/cfg/"$cfgfile1" --directory-prefix="$filedir"/cfg > /dev/null 2>&1

          fi
            
          if [ -f cfg/"$cfgfile1" ]; then

            echo "CFG "$cfgfile1" has been downloaded and updated."
            echo ""

            if [ -f "$cfgfile1"check.txt ]; then

              ./rm -rf "$cfgfile1"check.txt > /dev/null 2>&1

            fi
            
          else

            echo "Could not update CFG "$cfgfile1". Try running the updater again."

            if [ -f old/cfg/"$cfgfile1".old ]; then

              ./mv old/cfg/"$cfgfile1".old cfg/"$cfgfile1" > /dev/null 2>&1

            fi

            if [ -f "$cfgfile1"check.txt ]; then

              ./rm -rf "$cfgfile1"check.txt > /dev/null 2>&1

            fi

            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$cfgfile2" ]; then

        echo "Checking CFG "$cfgfile2"..."

        if [ -f cfg/"$cfgfile2" ]; then

          ./cat cfg/"$cfgfile2" | ./grep "versionc=" >> "$cfgfile2"check.txt
          . "$cfgfile2"check.txt > /dev/null 2>&1

        fi

        cfgfile2d="$versionc"

        if [ "$cfgfile2d" = "$webcfgfile2d" ]; then

          echo "CFG "$cfgfile2" is up to date, skipping file update."
          echo ""
          ./rm -rf "$cfgfile2"check.txt > /dev/null 2>&1

        else

          if [ -f cfg/"$cfgfile2" ]; then

            echo "Updating CFG "$cfgfile2"..."
             
            if [ -f old/cfg/"$cfgfile2".old ]; then

              ./rm -rf old/cfg/"$cfgfile2".old > /dev/null 2>&1

            fi

            ./mv cfg/"$cfgfile2" old/cfg/"$cfgfile2".old > /dev/null 2>&1
            ./wget "$filesd"/cfg/"$cfgfile2" --directory-prefix="$filedir"/cfg > /dev/null 2>&1

          else

            echo "Downloading CFG "$cfgfile2"..."
            ./wget "$filesd"/cfg/"$cfgfile2" --directory-prefix="$filedir"/cfg > /dev/null 2>&1

          fi
            
          if [ -f cfg/"$cfgfile2" ]; then

            echo "CFG "$cfgfile2" has been downloaded and updated."
            echo ""

            if [ -f "$cfgfile2"check.txt ]; then

              ./rm -rf "$cfgfile2"check.txt > /dev/null 2>&1

            fi
            
          else

            echo "Could not update CFG "$cfgfile2". Try running the updater again."

            if [ -f old/cfg/"$cfgfile2".old ]; then

              ./mv old/cfg/"$cfgfile2".old cfg/"$cfgfile2" > /dev/null 2>&1

            fi

            if [ -f "$cfgfile2"check.txt ]; then

              ./rm -rf "$cfgfile2"check.txt > /dev/null 2>&1

            fi

            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$cfgfile3" ]; then

        echo "Checking CFG "$cfgfile3"..."

        if [ -f cfg/"$cfgfile3" ]; then

          ./cat cfg/"$cfgfile3" | ./grep "versionc=" >> "$cfgfile3"check.txt
          . "$cfgfile3"check.txt > /dev/null 2>&1

        fi

        cfgfile3d="$versionc"

        if [ "$cfgfile3d" = "$webcfgfile3d" ]; then

          echo "CFG "$cfgfile3" is up to date, skipping file update."
          echo ""
          ./rm -rf "$cfgfile3"check.txt > /dev/null 2>&1

        else

          if [ -f cfg/"$cfgfile3" ]; then

            echo "Updating CFG "$cfgfile3"..."
             
            if [ -f old/cfg/"$cfgfile3".old ]; then

              ./rm -rf old/cfg/"$cfgfile3".old > /dev/null 2>&1

            fi

            ./mv cfg/"$cfgfile3" old/cfg/"$cfgfile3".old > /dev/null 2>&1
            ./wget "$filesd"/cfg/"$cfgfile3" --directory-prefix="$filedir"/cfg > /dev/null 2>&1

          else

            echo "Downloading CFG "$cfgfile3"..."
            ./wget "$filesd"/cfg/"$cfgfile3" --directory-prefix="$filedir"/cfg > /dev/null 2>&1

          fi
            
          if [ -f cfg/"$cfgfile3" ]; then

            echo "CFG "$cfgfile3" has been downloaded and updated."
            echo ""

            if [ -f "$cfgfile3"check.txt ]; then

              ./rm -rf "$cfgfile3"check.txt > /dev/null 2>&1

            fi
            
          else

            echo "Could not update CFG "$cfgfile3". Try running the updater again."

            if [ -f old/cfg/"$cfgfile3".old ]; then

              ./mv old/cfg/"$cfgfile3".old cfg/"$cfgfile3" > /dev/null 2>&1

            fi

            if [ -f "$cfgfile3"check.txt ]; then

              ./rm -rf "$cfgfile3"check.txt > /dev/null 2>&1

            fi

            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$cfgfile4" ]; then

        echo "Checking CFG "$cfgfile4"..."

        if [ -f cfg/"$cfgfile4" ]; then

          ./cat cfg/"$cfgfile4" | ./grep "versionc=" >> "$cfgfile4"check.txt
          . "$cfgfile4"check.txt > /dev/null 2>&1

        fi

        cfgfile4d="$versionc"

        if [ "$cfgfile4d" = "$webcfgfile4d" ]; then

          echo "CFG "$cfgfile4" is up to date, skipping file update."
          echo ""
          ./rm -rf "$cfgfile4"check.txt > /dev/null 2>&1

        else

          if [ -f cfg/"$cfgfile4" ]; then

            echo "Updating CFG "$cfgfile4"..."
             
            if [ -f old/cfg/"$cfgfile4".old ]; then

              ./rm -rf old/cfg/"$cfgfile4".old > /dev/null 2>&1

            fi

            ./mv cfg/"$cfgfile4" old/cfg/"$cfgfile4".old > /dev/null 2>&1
            ./wget "$filesd"/cfg/"$cfgfile4" --directory-prefix="$filedir"/cfg > /dev/null 2>&1

          else

            echo "Downloading CFG "$cfgfile4"..."
            ./wget "$filesd"/cfg/"$cfgfile4" --directory-prefix="$filedir"/cfg > /dev/null 2>&1

          fi
            
          if [ -f cfg/"$cfgfile4" ]; then

            echo "CFG "$cfgfile4" has been downloaded and updated."
            echo ""

            if [ -f "$cfgfile4"check.txt ]; then

              ./rm -rf "$cfgfile4"check.txt > /dev/null 2>&1

            fi
            
          else

            echo "Could not update CFG "$cfgfile4". Try running the updater again."

            if [ -f old/cfg/"$cfgfile4".old ]; then

              ./mv old/cfg/"$cfgfile4".old cfg/"$cfgfile4" > /dev/null 2>&1

            fi

            if [ -f "$cfgfile4"check.txt ]; then

              ./rm -rf "$cfgfile4"check.txt > /dev/null 2>&1

            fi

            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$cfgfile5" ]; then

        echo "Checking CFG "$cfgfile5"..."

        if [ -f cfg/"$cfgfile5" ]; then

          ./cat cfg/"$cfgfile5" | ./grep "versionc=" >> "$cfgfile5"check.txt
          . "$cfgfile5"check.txt > /dev/null 2>&1

        fi

        cfgfile5d="$versionc"

        if [ "$cfgfile5d" = "$webcfgfile5d" ]; then

          echo "CFG "$cfgfile5" is up to date, skipping file update."
          echo ""
          ./rm -rf "$cfgfile5"check.txt > /dev/null 2>&1

        else

          if [ -f cfg/"$cfgfile5" ]; then

            echo "Updating CFG "$cfgfile5"..."
             
            if [ -f old/cfg/"$cfgfile5".old ]; then

              ./rm -rf old/cfg/"$cfgfile5".old > /dev/null 2>&1

            fi

            ./mv cfg/"$cfgfile5" old/cfg/"$cfgfile5".old > /dev/null 2>&1
            ./wget "$filesd"/cfg/"$cfgfile5" --directory-prefix="$filedir"/cfg > /dev/null 2>&1

          else

            echo "Downloading CFG "$cfgfile5"..."
            ./wget "$filesd"/cfg/"$cfgfile5" --directory-prefix="$filedir"/cfg > /dev/null 2>&1

          fi
            
          if [ -f cfg/"$cfgfile5" ]; then

            echo "CFG "$cfgfile5" has been downloaded and updated."
            echo ""

            if [ -f "$cfgfile5"check.txt ]; then

              ./rm -rf "$cfgfile5"check.txt > /dev/null 2>&1

            fi
            
          else

            echo "Could not update CFG "$cfgfile5". Try running the updater again."

            if [ -f old/cfg/"$cfgfile5".old ]; then

              ./mv old/cfg/"$cfgfile5".old cfg/"$cfgfile5" > /dev/null 2>&1

            fi

            if [ -f "$cfgfile5"check.txt ]; then

              ./rm -rf "$cfgfile5"check.txt > /dev/null 2>&1

            fi

            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$otherfile1" ]; then

        if [ -f "$otherfile1" ]; then

          echo "Non script file "$otherfile1" already exists. Skipping it."
          echo ""

        else

          echo "Downloading non script file "$otherfile1"..."
          ./wget "$filesd"/"$otherfile1" > /dev/null 2>&1

          if [ -f "$otherfile1" ]; then

            echo "Non script file "$otherfile1" has been downloaded."
            echo ""

          else

            echo "Could not download non script file "$otherfile1", try running the updater again."
            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$otherfile2" ]; then

        if [ -f "$otherfile2" ]; then

          echo "Non script file "$otherfile2" already exists. Skipping it."
          echo ""

        else

          echo "Downloading non script file "$otherfile2"..."
          ./wget "$filesd"/"$otherfile2" > /dev/null 2>&1

          if [ -f "$otherfile2" ]; then

            echo "Non script file "$otherfile2" has been downloaded."
            echo ""

          else

            echo "Could not download non script file "$otherfile2", try running the updater again."
            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$otherfile3" ]; then

        if [ -f "$otherfile3" ]; then

          echo "Non script file "$otherfile3" already exists. Skipping it."
          echo ""

        else

          echo "Downloading non script file "$otherfile3"..."
          ./wget "$filesd"/"$otherfile3" > /dev/null 2>&1

          if [ -f "$otherfile3" ]; then

            echo "Non script file "$otherfile3" has been downloaded."
            echo ""

          else

            echo "Could not download non script file "$otherfile3", try running the updater again."
            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$otherfile4" ]; then

        if [ -f "$otherfile4" ]; then

          echo "Non script file "$otherfile4" already exists. Skipping it."
          echo ""

        else

          echo "Downloading non script file "$otherfile4"..."
          ./wget "$filesd"/"$otherfile4" > /dev/null 2>&1

          if [ -f "$otherfile4" ]; then

            echo "Non script file "$otherfile4" has been downloaded."
            echo ""

          else

            echo "Could not download non script file "$otherfile4", try running the updater again."
            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$otherfile5" ]; then

        if [ -f "$otherfile5" ]; then

          echo "Non script file "$otherfile5" already exists. Skipping it."
          echo ""

        else

          echo "Downloading non script file "$otherfile5"..."
          ./wget "$filesd"/"$otherfile5" > /dev/null 2>&1

          if [ -f "$otherfile5" ]; then

            echo "Non script file "$otherfile5" has been downloaded."
            echo ""

          else

            echo "Could not download non script file "$otherfile5", try running the updater again."
            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$otherfile6" ]; then

        if [ -f "$otherfile6" ]; then

          echo "Non script file "$otherfile6" already exists. Skipping it."
          echo ""

        else

          echo "Downloading non script file "$otherfile6"..."
          ./wget "$filesd"/"$otherfile6" > /dev/null 2>&1

          if [ -f "$otherfile6" ]; then

            echo "Non script file "$otherfile6" has been downloaded."
            echo ""

          else

            echo "Could not download non script file "$otherfile6", try running the updater again."
            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$otherfile7" ]; then

        if [ -f "$otherfile7" ]; then

          echo "Non script file "$otherfile7" already exists. Skipping it."
          echo ""

        else

          echo "Downloading non script file "$otherfile7"..."
          ./wget "$filesd"/"$otherfile7" > /dev/null 2>&1

          if [ -f "$otherfile7" ]; then

            echo "Non script file "$otherfile7" has been downloaded."
            echo ""

          else

            echo "Could not download non script file "$otherfile7", try running the updater again."
            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$otherfile8" ]; then

        if [ -f "$otherfile8" ]; then

          echo "Non script file "$otherfile8" already exists. Skipping it."
          echo ""

        else

          echo "Downloading non script file "$otherfile8"..."
          ./wget "$filesd"/"$otherfile8" > /dev/null 2>&1

          if [ -f "$otherfile8" ]; then

            echo "Non script file "$otherfile8" has been downloaded."
            echo ""

          else

            echo "Could not download non script file "$otherfile8", try running the updater again."
            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$otherfile9" ]; then

        if [ -f "$otherfile9" ]; then

          echo "Non script file "$otherfile9" already exists. Skipping it."
          echo ""

        else

          echo "Downloading non script file "$otherfile9"..."
          ./wget "$filesd"/"$otherfile9" > /dev/null 2>&1

          if [ -f "$otherfile9" ]; then

            echo "Non script file "$otherfile9" has been downloaded."
            echo ""

          else

            echo "Could not download non script file "$otherfile9", try running the updater again."
            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$otherfile10" ]; then

        if [ -f "$otherfile10" ]; then

          echo "Non script file "$otherfile10" already exists. Skipping it."
          echo ""

        else

          echo "Downloading non script file "$otherfile10"..."
          ./wget "$filesd"/"$otherfile10" > /dev/null 2>&1

          if [ -f "$otherfile10" ]; then

            echo "Non script file "$otherfile10" has been downloaded."
            echo ""

          else

            echo "Could not download non script file "$otherfile10", try running the updater again."
            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$otherfile11" ]; then

        if [ -f "$otherfile11" ]; then

          echo "Non script file "$otherfile11" already exists. Skipping it."
          echo ""

        else

          echo "Downloading non script file "$otherfile11"..."
          ./wget "$filesd"/"$otherfile11" > /dev/null 2>&1

          if [ -f "$otherfile11" ]; then

            echo "Non script file "$otherfile11" has been downloaded."
            echo ""

          else

            echo "Could not download non script file "$otherfile11", try running the updater again."
            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$otherfile12" ]; then

        if [ -f "$otherfile12" ]; then

          echo "Non script file "$otherfile12" already exists. Skipping it."
          echo ""

        else

          echo "Downloading non script file "$otherfile12"..."
          ./wget "$filesd"/"$otherfile12" > /dev/null 2>&1

          if [ -f "$otherfile12" ]; then

            echo "Non script file "$otherfile12" has been downloaded."
            echo ""

          else

            echo "Could not download non script file "$otherfile12", try running the updater again."
            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$otherfile13" ]; then

        if [ -f "$otherfile13" ]; then

          echo "Non script file "$otherfile13" already exists. Skipping it."
          echo ""

        else

          echo "Downloading non script file "$otherfile13"..."
          ./wget "$filesd"/"$otherfile13" > /dev/null 2>&1

          if [ -f "$otherfile13" ]; then

            echo "Non script file "$otherfile13" has been downloaded."
            echo ""

          else

            echo "Could not download non script file "$otherfile13", try running the updater again."
            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$otherfile14" ]; then

        if [ -f "$otherfile14" ]; then

          echo "Non script file "$otherfile14" already exists. Skipping it."
          echo ""

        else

          echo "Downloading non script file "$otherfile14"..."
          ./wget "$filesd"/"$otherfile14" > /dev/null 2>&1

          if [ -f "$otherfile14" ]; then

            echo "Non script file "$otherfile14" has been downloaded."
            echo ""

          else

            echo "Could not download non script file "$otherfile14", try running the updater again."
            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$otherfile15" ]; then

        if [ -f "$otherfile15" ]; then

          echo "Non script file "$otherfile15" already exists. Skipping it."
          echo ""

        else

          echo "Downloading non script file "$otherfile15"..."
          ./wget "$filesd"/"$otherfile15" > /dev/null 2>&1

          if [ -f "$otherfile15" ]; then

            echo "Non script file "$otherfile15" has been downloaded."
            echo ""

          else

            echo "Could not download non script file "$otherfile15", try running the updater again."
            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$otherfile16" ]; then

        if [ -f "$otherfile16" ]; then

          echo "Non script file "$otherfile16" already exists. Skipping it."
          echo ""

        else

          echo "Downloading non script file "$otherfile16"..."
          ./wget "$filesd"/"$otherfile16" > /dev/null 2>&1

          if [ -f "$otherfile16" ]; then

            echo "Non script file "$otherfile16" has been downloaded."
            echo ""

          else

            echo "Could not download non script file "$otherfile16", try running the updater again."
            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$otherfile17" ]; then

        if [ -f "$otherfile17" ]; then

          echo "Non script file "$otherfile17" already exists. Skipping it."
          echo ""

        else

          echo "Downloading non script file "$otherfile17"..."
          ./wget "$filesd"/"$otherfile17" > /dev/null 2>&1

          if [ -f "$otherfile17" ]; then

            echo "Non script file "$otherfile17" has been downloaded."
            echo ""

          else

            echo "Could not download non script file "$otherfile17", try running the updater again."
            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$otherfile18" ]; then

        if [ -f "$otherfile18" ]; then

          echo "Non script file "$otherfile18" already exists. Skipping it."
          echo ""

        else

          echo "Downloading non script file "$otherfile18"..."
          ./wget "$filesd"/"$otherfile18" > /dev/null 2>&1

          if [ -f "$otherfile18" ]; then

            echo "Non script file "$otherfile18" has been downloaded."
            echo ""

          else

            echo "Could not download non script file "$otherfile18", try running the updater again."
            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$otherfile19" ]; then

        if [ -f "$otherfile19" ]; then

          echo "Non script file "$otherfile19" already exists. Skipping it."
          echo ""

        else

          echo "Downloading non script file "$otherfile19"..."
          ./wget "$filesd"/"$otherfile19" > /dev/null 2>&1

          if [ -f "$otherfile19" ]; then

            echo "Non script file "$otherfile19" has been downloaded."
            echo ""

          else

            echo "Could not download non script file "$otherfile19", try running the updater again."
            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$otherfile20" ]; then

        if [ -f "$otherfile20" ]; then

          echo "Non script file "$otherfile20" already exists. Skipping it."
          echo ""

        else

          echo "Downloading non script file "$otherfile20"..."
          ./wget "$filesd"/"$otherfile20" > /dev/null 2>&1

          if [ -f "$otherfile20" ]; then

            echo "Non script file "$otherfile20" has been downloaded."
            echo ""

          else

            echo "Could not download non script file "$otherfile20", try running the updater again."
            ./rm -rf version.txt > /dev/null 2>&1
            echo "Press ENTER to continue."
            read
            exit

          fi

        fi

      fi

      if [ -n "$mandfile1" ]; then

        if [ -f "$mandfile1" ]; then

          ./rm -rf "$mandfile1" > /dev/null 2>&1
          echo "Updating mandatory file "$mandfile1"..."
          ./wget "$filesd"/"$mandfile1" > /dev/null 2>&1

        else

          echo "Downloading mandatory file "$mandfile1"..."
          ./wget "$filesd"/"$mandfile1" > /dev/null 2>&1

        fi

        if [ -f "$mandfile1" ]; then

          echo "Mandatory file "$mandfile1" has been downloaded and updated."
          echo ""

        else

          echo "Could not download mandatory file "$mandfile1", try running the updater again."
          ./rm -rf version.txt > /dev/null 2>&1
          echo "Press ENTER to continue."
          read
          exit

        fi

      fi

      if [ -n "$mandfile2" ]; then

        if [ -f "$mandfile2" ]; then

          ./rm -rf "$mandfile2" > /dev/null 2>&1
          echo "Updating mandatory file "$mandfile2"..."
          ./wget "$filesd"/"$mandfile2" > /dev/null 2>&1

        else

          echo "Downloading mandatory file "$mandfile2"..."
          ./wget "$filesd"/"$mandfile2" > /dev/null 2>&1

        fi

        if [ -f "$mandfile2" ]; then

          echo "Mandatory file "$mandfile2" has been downloaded and updated."
          echo ""

        else

          echo "Could not download mandatory file "$mandfile2", try running the updater again."
          ./rm -rf version.txt > /dev/null 2>&1
          echo "Press ENTER to continue."
          read
          exit

        fi

      fi

      if [ -n "$mandfile3" ]; then

        if [ -f "$mandfile3" ]; then

          ./rm -rf "$mandfile3" > /dev/null 2>&1
          echo "Updating mandatory file "$mandfile3"..."
          ./wget "$filesd"/"$mandfile3" > /dev/null 2>&1

        else

          echo "Downloading mandatory file "$mandfile3"..."
          ./wget "$filesd"/"$mandfile3" > /dev/null 2>&1

        fi

        if [ -f "$mandfile3" ]; then

          echo "Mandatory file "$mandfile3" has been downloaded and updated."
          echo ""

        else

          echo "Could not download mandatory file "$mandfile3", try running the updater again."
          ./rm -rf version.txt > /dev/null 2>&1
          echo "Press ENTER to continue."
          read
          exit

        fi

      fi

      if [ -n "$mandfile4" ]; then

        if [ -f "$mandfile4" ]; then

          ./rm -rf "$mandfile4" > /dev/null 2>&1
          echo "Updating mandatory file "$mandfile4"..."
          ./wget "$filesd"/"$mandfile4" > /dev/null 2>&1

        else

          echo "Downloading mandatory file "$mandfile4"..."
          ./wget "$filesd"/"$mandfile4" > /dev/null 2>&1

        fi

        if [ -f "$mandfile4" ]; then

          echo "Mandatory file "$mandfile4" has been downloaded and updated."
          echo ""

        else

          echo "Could not download mandatory file "$mandfile4", try running the updater again."
          ./rm -rf version.txt > /dev/null 2>&1
          echo "Press ENTER to continue."
          read
          exit

        fi

      fi

      if [ -n "$mandfile5" ]; then

        if [ -f "$mandfile5" ]; then

          ./rm -rf "$mandfile5" > /dev/null 2>&1
          echo "Updating mandatory file "$mandfile5"..."
          ./wget "$filesd"/"$mandfile5" > /dev/null 2>&1

        else

          echo "Downloading mandatory file "$mandfile5"..."
          ./wget "$filesd"/"$mandfile5" > /dev/null 2>&1

        fi

        if [ -f "$mandfile5" ]; then

          echo "Mandatory file "$mandfile5" has been downloaded and updated."
          echo ""

        else

          echo "Could not download mandatory file "$mandfile5", try running the updater again."
          ./rm -rf version.txt > /dev/null 2>&1
          echo "Press ENTER to continue."
          read
          exit

        fi

      fi

      if [ -n "$mandfile6" ]; then

        if [ -f "$mandfile6" ]; then

          ./rm -rf "$mandfile6" > /dev/null 2>&1
          echo "Updating mandatory file "$mandfile6"..."
          ./wget "$filesd"/"$mandfile6" > /dev/null 2>&1

        else

          echo "Downloading mandatory file "$mandfile6"..."
          ./wget "$filesd"/"$mandfile6" > /dev/null 2>&1

        fi

        if [ -f "$mandfile6" ]; then

          echo "Mandatory file "$mandfile6" has been downloaded and updated."
          echo ""

        else

          echo "Could not download mandatory file "$mandfile6", try running the updater again."
          ./rm -rf version.txt > /dev/null 2>&1
          echo "Press ENTER to continue."
          read
          exit

        fi

      fi

      if [ -n "$mandfile7" ]; then

        if [ -f "$mandfile7" ]; then

          ./rm -rf "$mandfile7" > /dev/null 2>&1
          echo "Updating mandatory file "$mandfile7"..."
          ./wget "$filesd"/"$mandfile7" > /dev/null 2>&1

        else

          echo "Downloading mandatory file "$mandfile7"..."
          ./wget "$filesd"/"$mandfile7" > /dev/null 2>&1

        fi

        if [ -f "$mandfile7" ]; then

          echo "Mandatory file "$mandfile7" has been downloaded and updated."
          echo ""

        else

          echo "Could not download mandatory file "$mandfile7", try running the updater again."
          ./rm -rf version.txt > /dev/null 2>&1
          echo "Press ENTER to continue."
          read
          exit

        fi

      fi

      if [ -n "$mandfile8" ]; then

        if [ -f "$mandfile8" ]; then

          ./rm -rf "$mandfile8" > /dev/null 2>&1
          echo "Updating mandatory file "$mandfile8"..."
          ./wget "$filesd"/"$mandfile8" > /dev/null 2>&1

        else

          echo "Downloading mandatory file "$mandfile8"..."
          ./wget "$filesd"/"$mandfile8" > /dev/null 2>&1

        fi

        if [ -f "$mandfile8" ]; then

          echo "Mandatory file "$mandfile8" has been downloaded and updated."
          echo ""

        else

          echo "Could not download mandatory file "$mandfile8", try running the updater again."
          ./rm -rf version.txt > /dev/null 2>&1
          echo "Press ENTER to continue."
          read
          exit

        fi

      fi

      if [ -n "$mandfile9" ]; then

        if [ -f "$mandfile9" ]; then

          ./rm -rf "$mandfile9" > /dev/null 2>&1
          echo "Updating mandatory file "$mandfile9"..."
          ./wget "$filesd"/"$mandfile9" > /dev/null 2>&1

        else

          echo "Downloading mandatory file "$mandfile9"..."
          ./wget "$filesd"/"$mandfile9" > /dev/null 2>&1

        fi

        if [ -f "$mandfile9" ]; then

          echo "Mandatory file "$mandfile9" has been downloaded and updated."
          echo ""

        else

          echo "Could not download mandatory file "$mandfile9", try running the updater again."
          ./rm -rf version.txt > /dev/null 2>&1
          echo "Press ENTER to continue."
          read
          exit

        fi

      fi

      if [ -n "$mandfile10" ]; then

        if [ -f "$mandfile10" ]; then

          ./rm -rf "$mandfile10" > /dev/null 2>&1
          echo "Updating mandatory file "$mandfile10"..."
          ./wget "$filesd"/"$mandfile10" > /dev/null 2>&1

        else

          echo "Downloading mandatory file "$mandfile10"..."
          ./wget "$filesd"/"$mandfile10" > /dev/null 2>&1

        fi

        if [ -f "$mandfile10" ]; then

          echo "Mandatory file "$mandfile10" has been downloaded and updated."
          echo ""

        else

          echo "Could not download mandatory file "$mandfile10", try running the updater again."
          ./rm -rf version.txt > /dev/null 2>&1
          echo "Press ENTER to continue."
          read
          exit

        fi

      fi

      ./rm -rf version.txt > /dev/null 2>&1
      echo ""
      echo "The updater completed its task successfully."            
      echo "Press ENTER to continue."
      read

    fi

  fi

# Checking for WAN access with the check server.

else

  if [ -z "$version" ]; then

    echo "Could not check for the current version."
    echo ""

  elif [ -z "$subversion" ]; then

    echo "Could not check for the current subversion."
    echo ""
  
  else

    echo "Current version: "$version"."$subversion""
    echo ""

  fi

  echo "Could not contact the check server."
  echo "Please check http://www.moviebattles.com/forums/showthread.php?t=32016 for the full version, bug reports, feedback and if you need help."
  echo "Press ENTER to continue."
  read

fi