#include "server.h"
#include <SFML/Network.hpp>
#include <iostream>
#include <string>
#include <limits>
#include "version.h"
#include "game.h"

void Server()
{
    std::cout<<"You want to be a server. That's okay, I guess.\n";
    //ask for port
    std::cout<<"On what port will we listen for clients?\nTCP Port: "<<std::flush;
    unsigned short port;
    std::cin.sync();
    std::cin>>port;
    if(std::cin.fail())
    {
        std::cout<<"U mad bro? Invalid input!"<<std::endl;
        return;
    }
    //wait for client connection
    sf::SocketTCP listener;
    if(!listener.Listen(port))
    {
        std::cout<<"Can not listen at port "<<port<<"!"<<std::endl;
        return;
    }
    sf::IPAddress clientAddress;
    sf::SocketTCP client;
    if(listener.Accept(client, &clientAddress) != sf::Socket::Done)
    {
        //error? exit.
        std::cout<<"Error establishing connection to client."<<std::endl;
        return;
    }
    std::cout<<clientAddress.ToString()<<" connected. He'll soon tell us if he's valid. If he doesn't, the program will freeze - in that case: abort (ctrl+c)."<<std::endl;
    //let's see if the client is okay.
    {
        char buffer[128];
        std::size_t received;
        if(client.Receive(buffer, sizeof(buffer), received) != sf::Socket::Done)
        {
            std::cout<<"Could not tell client that we're a valid server."<<std::endl;
            client.Close();
            listener.Close();
            return;
        }
        std::string msg(buffer, received);
        if(msg.substr(0, 4) != "LDZ ")
        {
            std::cout<<"Something connected, but it was no LoveHateZombies client!"<<std::endl;
            client.Close();
            listener.Close();
            return;
        }
        if(msg.substr(4) != LDZ_VERSION)
        {
            std::cout<<"Client has the wrong LoveHateZombies version! ("<<msg.substr(4)<<" should be "<<LDZ_VERSION<<")"<<std::endl;
            client.Close();
            listener.Close();
            return;
        }
    }
    //let the client know this is a valid server.
    {
        std::string message = "LDZ " LDZ_VERSION;
        if(client.Send(message.c_str(), message.length()) != sf::Socket::Done)
        {
            std::cout<<"Could not tell client that we're a valid server."<<std::endl;
            client.Close();
            listener.Close();
            return;
        }
    }
    //accept?
    std::cout<<clientAddress.ToString()<<" seems to be a LoveHateZombies client of the right version. Accept his challenge?\n0/1: "<<std::flush;
    std::cin.sync();
    int choice;
    std::cin>>choice;
    if(std::cin.fail() || (choice != 1 && choice != 0))
    {
        //invalid input
        std::cout<<"U mad bro? Invalid choice!"<<std::endl;
        client.Close();
        listener.Close();
        return;
    }
    if(choice == 0)
    {
        //send "u mad bro?"
        std::string message = "U mad bro?";
        client.Send(message.c_str(), message.length()); // I don't really care whether this works, we'll close the connection anyway.
        client.Close();
        listener.Close();
        //no: exit.
        return;
    }
    {
        //send "you are accepted"
        char message[] = "Let's go!";
        if(client.Send(message, sizeof(message)) != sf::Socket::Done)
        {
            //error? exit.
            std::cout<<"Could not send accept message to client."<<std::endl;
            client.Close();
            listener.Close();
            return;
        }
    }
    //enter common main loop
    Game(client);
    client.Close();
    listener.Close();
}
