#include "client.h"
#include <SFML/Network.hpp>
#include <iostream>
#include <string>
#include <limits>
#include "version.h"
#include "game.h"

void Client()
{
    //ask for ip + port
    std::cout<<"What server would you like to connect to?\nIP: "<<std::flush;
    std::string ipStr;
    std::cin.sync();
    std::getline(std::cin, ipStr);
    sf::IPAddress ip(ipStr);
    if(!ip.IsValid())
    {
        std::cout<<"Invalid IP!"<<std::endl;
        return;
    }
    std::cout<<"What Port to use?\nPort: "<<std::flush;
    std::cin.sync();
    unsigned short port;
    std::cin>>port;
    if(std::cin.fail())
    {
        std::cout<<"U mad bro? Invalid input!"<<std::endl;
        return;
    }
    sf::SocketTCP client;
    std::cout<<"Trying to connect to " << ipStr << ":"<<port<<"..."<<std::endl;
    //try to connect
    if(client.Connect(port, ip, 10) != sf::Socket::Done)
    {
        //error? exit.
        std::cout<<"Could not connect!"<<std::endl;
        return;
    }
    std::cout<<"success!"<<std::endl;
    //tell the server we're a valid client
    {
        std::string message = "LDZ " LDZ_VERSION;
        if(client.Send(message.c_str(), message.length()) != sf::Socket::Done)
        {
            //error? exit.
            std::cout<<"Could not send version info client."<<std::endl;
            client.Close();
            return;
        }
    }
    //is the server valid?
    std::cout<<"Let's see if the server has the right version. May freeze, ctrl+c = stop program then."<<std::endl;
    {
        char buffer[128];
        std::size_t received;
        if(client.Receive(buffer, sizeof(buffer), received) != sf::Socket::Done)
        {
            std::cout<<"Got no info. Stopping."<<std::endl;
            client.Close();
            return;
        }
        std::string msg(buffer, received);
        if(msg.substr(0, 4) != "LDZ ")
        {
            std::cout<<"This is not a LoveHateZombies server!"<<std::endl;
            client.Close();
            return;
        }
        if(msg.substr(4) != LDZ_VERSION)
        {
            std::cout<<"Server has the wrong LoveHateZombies version! ("<<msg.substr(4)<<" should be "<<LDZ_VERSION<<")"<<std::endl;
            client.Close();
            return;
        }
    }
    //does the host accept us?
    std::cout<<"The server has the right version. Please wait while he chooses whether he'd like to play with you."<<std::endl;
    {
        char buffer[128];
        std::size_t received;
        if(client.Receive(buffer, sizeof(buffer), received) != sf::Socket::Done)
        {
            std::cout<<"Got no info. Stopping."<<std::endl;
            client.Close();
            return;
        }
        std::string msg(buffer, received-1);
        if(msg == "U mad bro?")
        {
            //no. exit.
            std::cout<<"Sorry, the host doesn't want to play with you!"<<std::endl;
            client.Close();
            return;
        }
        if(msg == "Let's go!")
        {
            Game(client);
            client.Close();
            return;
        }
        std::cout<<"Error: Unexpected message: "<<msg<<std::endl;
        client.Close();
        return;
    }
}
