#include "Game.h"
#include <SFML/Network.hpp>
#include <SFML/System.hpp>
#include <string>
#include <iostream>

/*
class ReceiveThread : public sf::Thread
{
public:
    ReceiveThread(sf::SocketTCP& socket) : mRunning(false), mNewMessage(false), mIsRunning(true), mSocket(socket) {}
    virtual void Run()
    {
        while(mRunning)
        {
            //Don't overwrite the message until it has been handled
            while(mNewMessage) sf::Sleep(0.05f);

            char buffer[128];
            std::size_t received;
            if(mSocket.Receive(buffer, sizeof(buffer), received) != sf::Socket::Done)
            {
                CoutMutex.Lock();
                std::cout<<"Could not receive enemy's message, possibly he disconnected. Goodbye."<<std::endl;
                CoutMutex.Unlock();
                break;
            }
            MessageMutex.Lock();
            mNewMessage = true;
            mLastMessage = std::string(buffer, received-1); //assuming buffer ends with \0
            if(mLastMessage == "Bye!")
            {
                CoutMutex.Lock();
                std::cout<<"Could not receive enemy's message, possibly he disconnected. Goodbye."<<std::endl;
                CoutMutex.Unlock();
                MessageMutex.Unlock();
                break;
            }
            MessageMutex.Unlock();
        }
        mIsRunning = false;
    }

    void Exit() {mRunning = false;}

    const bool HasNewMessage() const { return mNewMessage; }
    const bool IsRunning() const { return mIsRunning; }

    const std::string& GetLastMessage() { mNewMessage = false; return mLastMessage; }

    sf::Mutex CoutMutex;
    sf::Mutex MessageMutex;
private:
    bool mRunning;
    bool mNewMessage;
    bool mIsRunning;
    sf::SocketTCP& mSocket;
    std::string mLastMessage;
};
*/

void Draw(unsigned int& myPoints, unsigned int& hisPoints)
{
    std::cout<<"Draw!\nYour points: " << myPoints <<"\nEnemy's points: "<<hisPoints<<std::endl;
}

void Victory(unsigned int& myPoints, unsigned int& hisPoints)
{
    std::cout<<"Victory!\nYour points: " << ++myPoints <<"\nEnemy's points: "<<hisPoints<<std::endl;
}

void Defeat(unsigned int& myPoints, unsigned int& hisPoints)
{
    std::cout<<"Defeat!\nYour points: " << myPoints <<"\nEnemy's points: "<<++hisPoints<<std::endl;
}

void Game(sf::SocketTCP& socket)
{
    /*
    ReceiveThread t(socket);
    t.Launch();
    */
    enum CHOICE
    {
        C_NONE = 0,
        C_LOVE,
        C_DEATH,
        C_ZOMBIES,
    };
    CHOICE myChoice = C_NONE;
    CHOICE hisChoice = C_NONE;
    unsigned int myPoints = 0;
    unsigned int hisPoints = 0;
    while(true)
    {
        //get my choice
        std::cout<<"Choose: \n1 Love (beats Zombies)\n2 Death (beats Love)\n3 Zombies (beat Death)\n0 Exit\nYour choice: "<<std::flush;
        int choice;
        do
        {
            std::cin.sync();
            std::cin>>choice;
        }
        while(std::cin.fail() || choice < 0 || choice > 3);
        std::string msg;
        if(choice == 0)
        {
            msg = "Bye!";
        }
        else if(choice == 1)
        {
            myChoice = C_LOVE;
            msg = "C_LOVE";
            std::cout<<"You chose LOVE!"<<std::endl;
        }
        else if(choice == 2)
        {
            myChoice = C_DEATH;
            msg = "C_DEATH";
            std::cout<<"You chose DEATH!"<<std::endl;
        }
        else if(choice == 3)
        {
            myChoice = C_ZOMBIES;
            msg = "C_ZOMBIES";
            std::cout<<"You chose ZOMBIES!"<<std::endl;
        }
        else
        {
            std::cout<<"Woops! Invalid input, but I didn't catch it?"<<std::endl;
            continue;
        }

        //send my choice
        if(socket.Send(msg.c_str(), msg.length()) != sf::Socket::Done)
        {
            std::cout<<"Could not send choice to enemy! Maybe he left."<<std::endl;
            break;
        }

        //Did the player choose to quit?
        if(choice == 0) break;

        //receive his choice
        {
            char buffer[128];
            std::size_t received;
            std::cout<<"Waiting for enemy to choose..."<<std::endl;
            if(socket.Receive(buffer, sizeof(buffer), received) != sf::Socket::Done)
            {
                std::cout<<"Did not receive enemy's choice! He probably left."<<std::endl;
                break;
            }
            msg = std::string(buffer, received);
        }
        if(msg == "Bye!")
        {
            std::cout<<"Your enemy left!"<<std::endl;
            break;
        }
        else if(msg == "C_LOVE") hisChoice = C_LOVE;
        else if(msg == "C_DEATH") hisChoice = C_DEATH;
        else if(msg == "C_ZOMBIES") hisChoice = C_ZOMBIES;
        else
        {
            std::cout<<"Got invalid message \"" << msg << "\" from enemy, aborting!"<<std::endl;
            break;
        }

        //who won?
        switch(myChoice)
        {
            case C_LOVE:
            {
                if(hisChoice == C_LOVE)
                {
                    std::cout<<"LOVE + LOVE = TRUE LOVE! Everybody wins!"<<std::endl;
                    Draw(myPoints, hisPoints);
                }
                else if(hisChoice == C_DEATH)
                {
                    std::cout<<"Your enemy overcomes your LOVE with the power of DEATH!"<<std::endl;
                    Defeat(myPoints, hisPoints);
                }
                else if(hisChoice == C_ZOMBIES)
                {
                    std::cout<<"You charm your enemy's ZOMBIES with your LOVE!"<<std::endl;
                    Victory(myPoints, hisPoints);
                }
                else
                {
                    std::cout<<"WTF?!? ERROR! BYE!"<<std::endl;
                    return;
                }
                break;
            }
            case C_DEATH:
            {
                if(hisChoice == C_LOVE)
                {
                    std::cout<<"Your DEATH makes your enemy's LOVE obsolete!"<<std::endl;
                    Victory(myPoints, hisPoints);
                }
                else if(hisChoice == C_DEATH)
                {
                    std::cout<<"DEATH, DEATH, DEATH! Everybody's dead!"<<std::endl;
                    Draw(myPoints, hisPoints);
                }
                else if(hisChoice == C_ZOMBIES)
                {
                    std::cout<<"You chose DEATH? ZOMBIES don't know DEATH!"<<std::endl;
                    Defeat(myPoints, hisPoints);
                }
                else
                {
                    std::cout<<"WTF?!? ERROR! BYE!"<<std::endl;
                    return;
                }
                break;
            }
            case C_ZOMBIES:
            {
                if(hisChoice == C_LOVE)
                {
                    std::cout<<"Your ZOMBIES are defeated by the power of LOVE!"<<std::endl;
                    Defeat(myPoints, hisPoints);
                }
                else if(hisChoice == C_DEATH)
                {
                    std::cout<<"Your ZOMBIES are unaffected by DEATH!"<<std::endl;
                    Victory(myPoints, hisPoints);
                }
                else if(hisChoice == C_ZOMBIES)
                {
                    std::cout<<"ZOMBIES + ZOMBIES = Apocalypse!"<<std::endl;
                    Draw(myPoints, hisPoints);
                }
                else
                {
                    std::cout<<"WTF?!? ERROR! BYE!"<<std::endl;
                    return;
                }
                break;
            }
            default:
            {
                std::cout<<"Invalid choice! What the heck?\nBye!"<<std::endl;
                return;
            }
        }
    }

    std::cout<<"Bye!"<<std::endl;
}
